/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.irdstudio.allinflow.console.application.service.task.GitRepoPushTask;
import com.irdstudio.allinflow.console.application.service.utils.JGitUtil;
import com.irdstudio.allinflow.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoService;
import com.irdstudio.allinflow.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserProfileService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserProfileDTO;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiRepoPushTaskImpl
implements GitRepoPushTask {
    private static Logger logger = LoggerFactory.getLogger(WikiRepoPushTaskImpl.class);
    private String subsId = null;
    private String loginUserId = null;
    private File file = null;
    private String repoPath = null;
    private String commitComment = null;

    public WikiRepoPushTaskImpl(String subsId, String loginUserId, File file, String repoPath, String commitComment) {
        this.subsId = subsId;
        this.loginUserId = loginUserId;
        this.file = file;
        this.repoPath = repoPath;
        this.commitComment = commitComment;
    }

    @Override
    public void execute() {
        if (StringUtils.isBlank((CharSequence)this.subsId)) {
            return;
        }
        Connection conn = null;
        try {
            DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
            conn = dataSource.getConnection();
            String gitUserName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.username").getParamValue();
            String gitPassword = paasEnvParamService.queryEnvParamByCodeReturnValue("git.password").getParamValue();
            String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue();
            String pushUrl = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.remote.path").getParamValue();
            if (!pushUrl.endsWith("/")) {
                pushUrl = pushUrl + "/";
            }
            String remotePath = String.format("%s%s.git", pushUrl, SdEnvUtil.wrapperAppCode(this.subsId));
            String repoName = this.subsId;
            String access_token = paasEnvParamService.queryEnvParamByCodeReturnValue("git.open.api.access_token").getParamValue();
            if (gitUserName == null) {
                throw new RuntimeException("\u672a\u8bfb\u53d6\u5230Git\u914d\u7f6e!");
            }
            SSubsInfoDTO sysInfoParam = new SSubsInfoDTO();
            sysInfoParam.setSubsId(this.subsId);
            SSubsInfoDTO sysInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)sysInfoParam);
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            envParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            boolean checkResult = false;
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                String subsGitGroup = String.format("%s/%s", gitHostUrl, sysInfo.getSubsCode());
                logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                checkResult = this.gitlabHandler(sysInfo.getSubsCode(), this.loginUserId, gitHostUrl, accessToken, sysInfo.getSubsName() + "wiki");
            }
            if (!checkResult) {
                throw new RuntimeException(this.subsId + " wiki\u6587\u6863\u4ed3\u5e93\u68c0\u67e5\u521b\u5efa\u7ed3\u679c\u5931\u8d25");
            }
            this.commit();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }

    private boolean gitlabHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, String desc) throws Exception {
        boolean result;
        block25: {
            result = true;
            try {
                SUserService sUserService = (SUserService)SpringContextUtils.getBean(SUserService.class);
                SUserProfileService sUserProfileService = (SUserProfileService)SpringContextUtils.getBean(SUserProfileService.class);
                String group = subsGitGroup;
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUserDTO userParam = new SUserDTO();
                    userParam.setActorno(currentUserId);
                    SUserDTO user = (SUserDTO)sUserService.queryByPk((Object)userParam);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(user.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                String projectName = subsGitGroup + "-wiki";
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block25;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block25;
                    }
                    logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block25;
                }
                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u5df2\u5b58\u5728");
                result = true;
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.addAll();
            jGitUtil.commit(this.commitComment + "");
            jGitUtil.push(remotePath, false);
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            return false;
        }
        jGitUtil.close();
        return true;
    }

    private boolean commit() throws Exception {
        SUserService sUserService = (SUserService)SpringContextUtils.getBean(SUserService.class);
        SUserProfileService sUserProfileService = (SUserProfileService)SpringContextUtils.getBean(SUserProfileService.class);
        SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String currentUserId = this.loginUserId;
        SUserProfileDTO userProfileParam = new SUserProfileDTO();
        userProfileParam.setActorno(currentUserId);
        SUserProfileDTO userProfile = (SUserProfileDTO)sUserProfileService.queryByPk((Object)userProfileParam);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            return false;
        }
        String userEmail = "";
        SUserDTO userParam = new SUserDTO();
        userParam.setActorno(currentUserId);
        SUserDTO user = (SUserDTO)sUserService.queryByPk((Object)userParam);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        SSubsInfoDTO sysInfoParam = new SSubsInfoDTO();
        sysInfoParam.setSubsId(this.subsId);
        SSubsInfoDTO sysInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)sysInfoParam);
        String gitUserName = userProfile.getGitUsername();
        String gitPassword = userProfile.getGitAccessToken();
        gitPassword = StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken()) ? userProfile.getGitAccessToken() : userProfile.getGitPassword();
        String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue();
        String gitHostUrl = paasEnvParamService.queryEnvParamByCodeReturnValue("git.host.url").getParamValue();
        String remoteUrl = String.format("%s/%s/%s-wiki.git", gitHostUrl, sysInfo.getSubsCode(), sysInfo.getSubsCode());
        if (StringUtils.isBlank((CharSequence)remoteUrl)) {
            return false;
        }
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        boolean flag = true;
        String suffix = "-remote";
        String gitLocalPath = docsRootPath + File.separator + this.subsId;
        String remoteRepoPath = gitLocalPath + suffix;
        try {
            flag = this.repositoryCreate(remoteRepoPath, remoteUrl, gitUserName, gitPassword, branchName);
            if (!flag) {
                logger.info("\u8fdc\u7a0b\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c \u8def\u5f84\u4e3a\uff1a" + remoteUrl);
                return flag;
            }
            if (StringUtils.isBlank((CharSequence)this.repoPath)) {
                this.repoPath = "";
            }
            File remoteRepoDir = new File(remoteRepoPath, this.repoPath);
            File targetFile = new File(remoteRepoDir, this.file.getName());
            FileUtils.copyFile((File)this.file, (File)targetFile);
            flag = this.repositoryPush(remoteRepoPath, remoteUrl, gitUserName, gitPassword, branchName);
            if (flag) {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remoteUrl);
            } else {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remoteUrl);
            }
            return flag;
        }
        catch (Exception e) {
            flag = false;
            return flag;
        }
    }
}

