/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.BatBatchInfoConfigRepository;
import com.irdstudio.allinflow.deliver.console.acl.repository.BatBatchValidateRepository;
import com.irdstudio.allinflow.deliver.console.acl.repository.BatTaskUnitConfigRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.BatBatchInfoConfigDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.BatBatchValidateDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.BatTaskUnitConfigDO;
import com.irdstudio.allinflow.deliver.console.facade.BatBatchValidateService;
import com.irdstudio.allinflow.deliver.console.facade.dto.BatBatchValidateDTO;
import com.irdstudio.allinflow.deliver.console.types.BatchState;
import com.irdstudio.allinflow.deliver.console.types.CheckResult;
import com.irdstudio.allinflow.executor.facade.PluginExecutorService;
import com.irdstudio.allinflow.executor.facade.dto.PluginExecutorDTO;
import com.irdstudio.allinflow.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batBatchValidateServiceImpl")
public class BatBatchValidateServiceImpl
extends BaseServiceImpl<BatBatchValidateDTO, BatBatchValidateDO, BatBatchValidateRepository>
implements BatBatchValidateService {
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();
    @Autowired
    private BatBatchInfoConfigRepository batBatchInfoConfigRepository;
    @Autowired
    private BatTaskUnitConfigRepository batTaskUnitConfigRepository;
    @Autowired
    private PluginExecutorService pluginExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String batchId, String userId) {
        BatBatchValidateService selfService = (BatBatchValidateService)SpringContextUtils.getBean(BatBatchValidateService.class);
        BatBatchValidateDTO delParam = new BatBatchValidateDTO();
        delParam.setBatchId(batchId);
        selfService.deleteByPk((Object)delParam);
        BatTaskUnitConfigDO taskParam = new BatTaskUnitConfigDO();
        taskParam.setBatchId(batchId);
        List taskList = this.batTaskUnitConfigRepository.queryList((Object)taskParam);
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            taskDebounce.put(batchId, true);
            try {
                BatBatchValidateDTO valid;
                boolean validFlag = true;
                String now = CurrentDateUtil.getTodayDateEx2();
                ArrayList<BatBatchValidateDTO> validate = new ArrayList<BatBatchValidateDTO>(taskList.size());
                for (BatTaskUnitConfigDO task : taskList) {
                    valid = new BatBatchValidateDTO();
                    valid.setBatchId(batchId);
                    valid.setTaskId(task.getTaskId());
                    valid.setValidTime(now);
                    valid.setCreateTime(now);
                    valid.setCreateUser(userId);
                    validate.add(valid);
                }
                selfService.batchInsert(validate);
                for (int i = 0; i < taskList.size(); ++i) {
                    BatTaskUnitConfigDO task;
                    task = (BatTaskUnitConfigDO)taskList.get(i);
                    valid = (BatBatchValidateDTO)validate.get(i);
                    PluginExecutorDTO validateParam = new PluginExecutorDTO();
                    validateParam.setBatchId(batchId);
                    validateParam.setTaskId(task.getTaskId());
                    validateParam.setPluginClass(task.getPluginClass());
                    ResponseData resp = this.pluginExecutorService.validate(validateParam);
                    if (resp.isSuccess()) {
                        valid.setValidRe(CheckResult.Pass.getCode());
                        valid.setValidMsg("\u6821\u9a8c\u6210\u529f");
                    } else {
                        validFlag = false;
                        valid.setValidRe(CheckResult.Fail.getCode());
                        if (resp.getRows() != null) {
                            valid.setValidMsg(String.format("%s%s", StringUtils.join((Iterable)((ValidateRtnDTO)resp.getRows()).getMessage(), (String)","), ((ValidateRtnDTO)resp.getRows()).getErrorMsgSuffix()));
                        } else {
                            valid.setValidMsg(resp.getMessage());
                        }
                    }
                    valid.setValidTime(CurrentDateUtil.getTodayDateEx2());
                    this.insert((BaseInfo)valid);
                }
                if (validFlag) {
                    BatBatchInfoConfigDO batchUpdate = new BatBatchInfoConfigDO();
                    batchUpdate.setBatchId(batchId);
                    batchUpdate.setBatchState(BatchState.Validated.getCode());
                    this.batBatchInfoConfigRepository.updateByPk((Object)batchUpdate);
                }
                boolean bl = validFlag;
                return bl;
            }
            finally {
                taskDebounce.put(batchId, false);
            }
        }
        return false;
    }

    public boolean validateStat(String batchId) {
        return (Boolean)taskDebounce.get(batchId);
    }
}

