/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.PaasAppsBatrefRepository;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEnvInfoRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasAppsBatrefDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEnvInfoDO;
import com.irdstudio.allinflow.deliver.console.facade.BatBatchInfoConfigService;
import com.irdstudio.allinflow.deliver.console.facade.BatBatchSourceService;
import com.irdstudio.allinflow.deliver.console.facade.BatBatchStageConfigService;
import com.irdstudio.allinflow.deliver.console.facade.BatTaskUnitConfigService;
import com.irdstudio.allinflow.deliver.console.facade.PaasAppsBatrefService;
import com.irdstudio.allinflow.deliver.console.facade.dto.BatBatchInfoConfigDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.BatBatchSourceDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.BatBatchStageConfigDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.BatTaskUnitConfigDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasAppsBatrefDTO;
import com.irdstudio.allinflow.deliver.console.types.BatchMgrType;
import com.irdstudio.allinflow.deliver.console.types.BatchState;
import com.irdstudio.allinflow.deliver.console.types.YesOrNO;
import com.irdstudio.allinflow.executor.facade.PluginExecutorService;
import com.irdstudio.allinflow.executor.facade.dto.PluginExecutorDTO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasAppsBatrefServiceImpl")
public class PaasAppsBatrefServiceImpl
extends BaseServiceImpl<PaasAppsBatrefDTO, PaasAppsBatrefDO, PaasAppsBatrefRepository>
implements PaasAppsBatrefService {
    @Autowired
    private PaasEnvInfoRepository paasEnvInfoRepository;
    @Autowired
    private BatBatchInfoConfigService batBatchInfoConfigService;
    @Autowired
    private BatBatchStageConfigService batBatchStageConfigService;
    @Autowired
    private BatTaskUnitConfigService batTaskUnitConfigService;
    @Autowired
    private BatBatchSourceService batBatchSourceService;
    @Autowired
    private PluginExecutorService pluginExecutorService;
    @Autowired
    private SeqInstInfoService seqService;

    public Integer deleteByCond(PaasAppsBatrefDTO param) {
        return ((PaasAppsBatrefRepository)this.getRepository()).deleteByCond((PaasAppsBatrefDO)this.beanCopy(param, PaasAppsBatrefDO.class));
    }

    public int insert(PaasAppsBatrefDTO paramDTO) {
        PaasEnvInfoDO envInfo = new PaasEnvInfoDO();
        envInfo.setEnvId(paramDTO.getEnvId());
        envInfo = (PaasEnvInfoDO)this.paasEnvInfoRepository.queryByPk((Object)envInfo);
        BatBatchStageConfigDTO stageParam = new BatBatchStageConfigDTO();
        stageParam.setBatchId(paramDTO.getBatchId());
        List stageList = this.batBatchStageConfigService.queryList((Object)stageParam);
        BatTaskUnitConfigDTO taskParam = new BatTaskUnitConfigDTO();
        taskParam.setBatchId(paramDTO.getBatchId());
        List taskList = this.batTaskUnitConfigService.queryList((Object)taskParam);
        String batchId = paramDTO.getBatchId();
        String subsId = paramDTO.getSubsId();
        String envId = paramDTO.getEnvId();
        String newBatchId = this.seqService.nextSequence("PAAS-BATCH-ID", StringUtils.join(Arrays.asList(subsId, envId), (String)","));
        BatBatchInfoConfigDTO batchInfo = (BatBatchInfoConfigDTO)this.beanCopy(paramDTO, BatBatchInfoConfigDTO.class);
        batchInfo.setBatchId(newBatchId.toUpperCase());
        batchInfo.setBatchName(String.format("%s-%s-\u6d41\u6c34\u7ebf", paramDTO.getAppName(), envInfo.getEnvName()));
        batchInfo.setBatchMgrType(BatchMgrType.Instance.getCode());
        batchInfo.setBatchState(BatchState.Draft.getCode());
        batchInfo.setSubsId(paramDTO.getSubsId());
        batchInfo.setAppId(paramDTO.getAppId());
        batchInfo.setEnvId(paramDTO.getEnvId());
        batchInfo.setCbaCode(paramDTO.getCbaCode());
        batchInfo.setEcsId(paramDTO.getEcsId());
        batchInfo.setCreateUser(paramDTO.getLoginUserId());
        batchInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        batchInfo.setLastModifyUser(paramDTO.getLoginUserId());
        batchInfo.setLastModifyTime(batchInfo.getCreateTime());
        this.batBatchInfoConfigService.insert((Object)batchInfo);
        BatBatchSourceDTO batSource = new BatBatchSourceDTO();
        batSource.setBatchId(batchInfo.getBatchId());
        batSource.setConfigType("A");
        batSource.setNeedRepo(YesOrNO.YES.getCode());
        batSource.setRepoType("git");
        batSource.setRepoUrl(paramDTO.getAppGitUrl());
        batSource.setUserName(paramDTO.getLoginUserId());
        this.batBatchSourceService.insert((Object)batSource);
        HashMap<String, String> stageMap = new HashMap<String, String>();
        for (BatBatchStageConfigDTO stage : stageList) {
            String newStageId = StringUtils.substring((String)UUIDUtil.getUUID(), (int)8);
            stageMap.put(stage.getStageId(), newStageId);
            stage.setBatchId(batchInfo.getBatchId());
            stage.setStageId(newStageId);
        }
        this.batBatchStageConfigService.batchInsert(stageList);
        for (BatTaskUnitConfigDTO task : taskList) {
            task.setBatchId(batchInfo.getBatchId());
            String oldTaskId = task.getTaskId();
            task.setTaskId(StringUtils.replace((String)task.getTaskId(), (String)paramDTO.getBatchId(), (String)batchInfo.getBatchId()));
            task.setStageId((String)stageMap.get(task.getStageId()));
            if (StringUtils.isNotBlank((CharSequence)task.getPreviousTaskId())) {
                task.setPreviousTaskId(StringUtils.replace((String)task.getPreviousTaskId(), (String)paramDTO.getBatchId(), (String)batchInfo.getBatchId()));
            }
            PluginExecutorDTO validateParam = new PluginExecutorDTO();
            validateParam.setBatchId(task.getBatchId());
            validateParam.setTaskId(oldTaskId);
            validateParam.setNewTaskId(task.getTaskId());
            validateParam.setPluginClass(task.getPluginClass());
            ResponseData responseData = this.pluginExecutorService.copyConfig(validateParam);
        }
        this.batTaskUnitConfigService.batchInsert(taskList);
        PaasAppsBatrefDO batref = (PaasAppsBatrefDO)this.beanCopy(paramDTO, PaasAppsBatrefDO.class);
        batref.setBatchId(batchInfo.getBatchId());
        return ((PaasAppsBatrefRepository)this.getRepository()).insert((Object)batref);
    }

    public int deleteByPk(PaasAppsBatrefDTO paramDTO) {
        BatBatchStageConfigDTO stageParam = new BatBatchStageConfigDTO();
        stageParam.setBatchId(paramDTO.getBatchId());
        this.batBatchStageConfigService.deleteByBatchId(stageParam);
        BatTaskUnitConfigDTO taskParam = new BatTaskUnitConfigDTO();
        taskParam.setBatchId(paramDTO.getBatchId());
        this.batTaskUnitConfigService.deleteByBatchId(taskParam);
        BatBatchSourceDTO deleteSource = new BatBatchSourceDTO();
        deleteSource.setBatchId(paramDTO.getBatchId());
        this.batBatchSourceService.deleteByPk((Object)deleteSource);
        BatBatchInfoConfigDTO oldData = new BatBatchInfoConfigDTO();
        oldData.setBatchId(paramDTO.getBatchId());
        oldData = (BatBatchInfoConfigDTO)this.batBatchInfoConfigService.queryByPk((Object)oldData);
        this.batBatchInfoConfigService.deleteByPk((Object)oldData);
        return super.deleteByPk((BaseInfo)paramDTO);
    }
}

