/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.PaasDuSysinfoRepository;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasDuSysinfoDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEnvInfoSummaryDO;
import com.irdstudio.allinflow.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEcsInfoSummaryDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEcsInfoWorkerSummaryDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvInfoSummaryDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasEcsInfoService")
public class PaasEcsInfoServiceImpl
extends BaseServiceImpl<PaasEcsInfoDTO, PaasEcsInfoDO, PaasEcsInfoRepository>
implements PaasEcsInfoService {
    @Autowired
    private PaasDuSysinfoRepository paasDuSysinfoRepository;

    public int deleteByPaasDuId(PaasEcsInfoDTO inPaasEcsInfoDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inPaasEcsInfoDTO);
        int num = 0;
        PaasEcsInfoDO paasEcsInfo = new PaasEcsInfoDO();
        this.beanCopy(inPaasEcsInfoDTO, paasEcsInfo);
        num = ((PaasEcsInfoRepository)this.getRepository()).deleteByPaasDuId(paasEcsInfo);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inPaasEcsInfoDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<PaasEcsInfoDTO> queryAllWithEnvInfoByPage(PaasEcsInfoDTO paasEcsInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfoDTO, paasEcsInfoDO);
        List paasEcsInfos = ((PaasEcsInfoRepository)this.getRepository()).queryAllWithEnvInfoByPage(paasEcsInfoDO);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + paasEcsInfos.size());
        list = this.beansCopy(paasEcsInfos, PaasEcsInfoDTO.class);
        return list;
    }

    public List<PaasEcsInfoSummaryDTO> queryPaasEcsInfoSummaryList(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasDuSysinfoDO sysinfoParam = new PaasDuSysinfoDO();
        sysinfoParam.setSubsId(paasEcsInfo.getSubsCode());
        List sysList = this.paasDuSysinfoRepository.queryList((Object)sysinfoParam);
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        if (CollectionUtils.isEmpty((Collection)sysList)) {
            paasEcsInfoDO.setModuleCode("apopaas");
            paasEcsInfoDO.setSubsCode(null);
            List doList = ((PaasEcsInfoRepository)this.getRepository()).queryCatalogEcsSummaryList(paasEcsInfoDO);
            return this.beansCopy(doList, PaasEcsInfoSummaryDTO.class);
        }
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryPaasEcsInfoSummaryList(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoSummaryDTO.class);
    }

    public List<PaasEcsInfoSummaryDTO> queryCatalogEcsSummaryList(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryCatalogEcsSummaryList(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoSummaryDTO.class);
    }

    public List<PaasEcsInfoWorkerSummaryDTO> queryTdpWorkerSummary(PaasEcsInfoDTO paasEcsInfo) {
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfo, paasEcsInfoDO);
        List summarys = ((PaasEcsInfoRepository)this.getRepository()).queryTdpWorkerSummary(paasEcsInfoDO);
        logger.debug("\u4ea4\u4ed8\u73af\u5883\u670d\u52a1\u5668\u7ba1\u7406\u603b\u89c8\u9875\u9762\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + summarys.size());
        return this.beansCopy(summarys, PaasEcsInfoWorkerSummaryDTO.class);
    }

    public String queryEcsInfoParamValue(String paramValue) {
        return null;
    }

    public String getTestEcsUrl(String paramValue) {
        String urlString = "";
        String ecsIpString = this.queryEcsInfoParamValue(paramValue + ".ECS_IP");
        if (ecsIpString.isEmpty()) {
            return null;
        }
        String ecsPortString = this.queryEcsInfoParamValue(paramValue + ".ECS_PORT");
        if (ecsPortString.isEmpty()) {
            return null;
        }
        urlString = "http://" + ecsIpString + ":" + ecsPortString;
        return urlString;
    }

    public String getPaasConsoleRequestUrl(PaasEcsInfoDTO paasEcsInfoVO) {
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(paasEcsInfoVO, paasEcsInfoDO);
        List ecsInfos = ((PaasEcsInfoRepository)this.getRepository()).queryListByPage((Object)paasEcsInfoDO);
        String urlString = "";
        if (CollectionUtils.isNotEmpty((Collection)ecsInfos)) {
            PaasEcsInfoDO ecs = (PaasEcsInfoDO)ecsInfos.get(0);
            String ecsOutIpString = ecs.getEcsOutIp();
            String ecsIpString = ecs.getEcsIp();
            if (StringUtils.isBlank((CharSequence)ecsOutIpString)) {
                ecsOutIpString = ecsIpString;
            }
            if (StringUtils.isBlank((CharSequence)ecsOutIpString)) {
                return null;
            }
            String ecsPortString = ecs.getEcsPort();
            if (StringUtils.isBlank((CharSequence)ecsPortString)) {
                return null;
            }
            urlString = "http://" + ecsOutIpString + ":" + ecsPortString;
        }
        return urlString;
    }

    public PaasEnvInfoSummaryDTO queryEcsSummaryByEnvId(String envId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + envId);
        try {
            PaasEnvInfoSummaryDO paasEnvInfoSummaryDO = new PaasEnvInfoSummaryDO();
            paasEnvInfoSummaryDO.setEnvId(envId);
            PaasEnvInfoSummaryDO doObj = ((PaasEcsInfoRepository)this.getRepository()).queryEcsSummaryByEnvId(paasEnvInfoSummaryDO);
            if (Objects.nonNull(doObj)) {
                PaasEnvInfoSummaryDTO outputDTO = (PaasEnvInfoSummaryDTO)this.beanCopy(doObj, new PaasEnvInfoSummaryDTO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outputDTO.toString());
                return outputDTO;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<Map<String, Object>> paasEnvDuEcsListByPage(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paramDO = (PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class);
        List list = ((PaasEcsInfoRepository)this.getRepository()).paasEnvDuEcsListByPage(paramDO);
        return list;
    }

    public List<Map<String, Object>> paasEnvSubsEcsListByPage(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paramDO = (PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class);
        List list = ((PaasEcsInfoRepository)this.getRepository()).paasEnvSubsEcsListByPage(paramDO);
        return list;
    }

    public Integer deleteByCond(PaasEcsInfoDTO param) {
        return ((PaasEcsInfoRepository)this.getRepository()).deleteByCond((PaasEcsInfoDO)this.beanCopy(param, PaasEcsInfoDO.class));
    }

    public Integer countAppEcsNum(PaasEcsInfoDTO param) {
        PaasEcsInfoDO paasEcsInfoDO = new PaasEcsInfoDO();
        this.beanCopy(param, paasEcsInfoDO);
        return ((PaasEcsInfoRepository)this.getRepository()).countAppEcsNum(paasEcsInfoDO);
    }

    private String wrapperCode(String code) {
        return code.replaceAll("-|\\.|\\(|\\)|\\+|\\!", "_");
    }

    private String getEcsVal(PaasEcsInfoDTO ecsInfo, String key) {
        switch (key) {
            case "ip": {
                return ecsInfo.getEcsIp();
            }
            case "outIp": {
                return ecsInfo.getEcsOutIp();
            }
            case "port": {
                return ecsInfo.getEcsPort();
            }
            case "user": {
                return ecsInfo.getEcsLoginUser();
            }
            case "password": {
                return ecsInfo.getEcsLoginPwd();
            }
        }
        return "";
    }
}

