/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.console.types.YesOrNO;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEnvConfRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEnvConfDO;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvConfPortalService;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvConfDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinflow.deliver.console.types.EnvMode;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SModuleInfoService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SModuleInfoDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.FilterItem;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasEnvConfPortalServiceImpl")
public class PaasEnvConfPortalServiceImpl
extends BaseServiceImpl<PaasEnvConfDTO, PaasEnvConfDO, PaasEnvConfRepository>
implements PaasEnvConfPortalService {
    @Autowired
    private PaasEnvInfoService paasEnvInfoService;
    @Autowired
    private SModuleInfoService sModuleInfoService;
    private final String paasEnvId = "pedestal";
    private final List<String> paasModuleList = Arrays.asList("manager", "dev", "design", "quality", "deliver", "ops");

    public int insert(PaasEnvConfDTO paramDTO) {
        this.deleteByPk((BaseInfo)paramDTO);
        PaasEnvInfoDTO envParam = new PaasEnvInfoDTO();
        List envList = this.paasEnvInfoService.queryList((Object)envParam);
        SModuleInfoDTO allinpaas = new SModuleInfoDTO();
        FilterItem moduleCodeItem = new FilterItem();
        moduleCodeItem.setOp(FilterItem.FilterOpEnum.In.getCode());
        moduleCodeItem.setKey("moduleCode");
        moduleCodeItem.setValues(this.paasModuleList);
        allinpaas.setFilterCond(JSON.toJSONString(Arrays.asList(moduleCodeItem)));
        List paasModuleList = this.sModuleInfoService.queryList((Object)allinpaas);
        if (StringUtils.equals((CharSequence)EnvMode.Single.getCode(), (CharSequence)paramDTO.getEnvMode())) {
            for (PaasEnvInfoDTO env : envList) {
                if (StringUtils.equalsAny((CharSequence)env.getEnvId(), (CharSequence[])new CharSequence[]{paramDTO.getEnvId(), "pedestal"})) {
                    env.setEnvState(YesOrNO.YES.getCode());
                } else {
                    env.setEnvState(YesOrNO.NO.getCode());
                }
                this.paasEnvInfoService.updateByPk((Object)env);
            }
            for (SModuleInfoDTO paas : paasModuleList) {
                SModuleInfoDTO allinpaasUpdate = new SModuleInfoDTO();
                allinpaasUpdate.setModuleCode(paas.getModuleCode());
                allinpaasUpdate.setModuleUrl(StringUtils.replace((String)paas.getModuleUrl(), (String)"index.html", (String)"single.html"));
                this.sModuleInfoService.updateByPk((Object)allinpaasUpdate);
            }
            SModuleInfoDTO allinsaas = new SModuleInfoDTO();
            allinsaas.setModuleCode("saas");
            allinsaas.setModuleUrl("/allinflow-console/saas/console/single.html");
            allinsaas.setModuleOpen("Y");
            this.sModuleInfoService.updateByPk((Object)allinsaas);
        } else {
            for (PaasEnvInfoDTO env : envList) {
                env.setEnvState(YesOrNO.YES.getCode());
                this.paasEnvInfoService.updateByPk((Object)env);
            }
            for (SModuleInfoDTO paas : paasModuleList) {
                SModuleInfoDTO allinpaasUpdate = new SModuleInfoDTO();
                allinpaasUpdate.setModuleCode(paas.getModuleCode());
                allinpaasUpdate.setModuleUrl(StringUtils.replace((String)paas.getModuleUrl(), (String)"single.html", (String)"index.html"));
                this.sModuleInfoService.updateByPk((Object)allinpaasUpdate);
            }
            SModuleInfoDTO allinsaas = new SModuleInfoDTO();
            allinsaas.setModuleCode("saas");
            allinsaas.setModuleUrl("/allinflow-console/saas/console/index.html");
            allinsaas.setModuleOpen("N");
            this.sModuleInfoService.updateByPk((Object)allinsaas);
        }
        return ((PaasEnvConfRepository)this.getRepository()).insert(this.beanCopy(paramDTO, PaasEnvConfDO.class));
    }
}

