/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.irdstudio.allinflow.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinflow.design.console.facade.TemplateGenAppCodeService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.util.ProjectGenerateUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateGenAppCodeService
implements TemplateGenAppCodeService {
    static final Logger logger = LoggerFactory.getLogger(AbstractTemplateGenAppCodeService.class);
    Formatter javaFormatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());

    public boolean copyTemplateProjectGen(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        AppTemplateRepoPullTask templatePullTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
        templatePullTask.syncRun();
        logger.info("\u8c03\u7528\u521d\u59cb\u5316\u5e94\u7528\u539f\u578b\u5de5\u7a0b\u63d2\u4ef6,\u590d\u5236\u5e76\u66ff\u6362\u5e94\u7528\u6a21\u677f\uff0c\u751f\u6210{}\u5de5\u7a0b" + appInfo.getAppCode());
        String appId = appInfo.getAppId();
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        String outFilePath = SdEnvUtil.PROJECT_PATH + appId;
        if (MyFileUtil.checkFileExist((String)outFilePath).booleanValue()) {
            try {
                FileUtils.forceDelete((File)new File(outFilePath));
            }
            catch (IOException e) {
                logger.error("\u5220\u9664\u539f\u6587\u4ef6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            }
        }
        String appTemplateId = appInfo.getAppTemplateId();
        String srcStr = appTemplateId + "-template";
        String srcFilePath = SdEnvUtil.TEMPLATE_PATH + File.separator + appTemplateId + "-template" + File.separator + appTemplateId + "-project";
        String replaceStr = appCode;
        ProjectGenerateUtil.copyAndRenameProject((String)srcFilePath, (String)outFilePath, (String)srcStr, (String)replaceStr);
        try {
            FileUtils.deleteDirectory((File)new File(outFilePath + File.separator + ".git"));
        }
        catch (IOException e) {
            logger.error("\u590d\u5236\u76ee\u5f55\u5f02\u5e38 " + outFilePath, (Throwable)e);
            return false;
        }
        return true;
    }
}

