/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.irdstudio.allinflow.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinflow.design.console.application.service.impl.AbstractTemplateGenAppCodeService;
import com.irdstudio.allinflow.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.util.bean.FileReplacePattern;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.util.bean.ReplaceDirAndFileBean;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="backendX03AppGenCodeServiceImpl")
public class BackendX03AppGenCodeServiceImpl
extends AbstractTemplateGenAppCodeService {
    private static final Logger logger = LoggerFactory.getLogger(BackendX03AppGenCodeServiceImpl.class);

    public void execute(PaasAppsInfoDTO appInfo) {
        boolean flag = this.copyTemplateProjectGen(appInfo);
        if (!flag) {
            return;
        }
        flag = this.genStartCode(appInfo);
        if (!flag) {
            return;
        }
    }

    @Override
    public boolean copyTemplateProjectGen(PaasAppsInfoDTO appInfo) {
        logger.info("\u8c03\u7528\u521d\u59cb\u5316\u5e94\u7528\u539f\u578b\u5de5\u7a0b\u63d2\u4ef6,\u590d\u5236\u5e76\u66ff\u6362\u5e94\u7528\u6a21\u677f\uff0c\u751f\u6210{}\u5de5\u7a0b" + appInfo.getAppCode());
        AppTemplateRepoPullTask templatePullTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
        templatePullTask.syncRun();
        String appId = appInfo.getAppId();
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        String outFilePath = SdEnvUtil.PROJECT_PATH + File.separator + appId;
        if (MyFileUtil.checkFileExist((String)outFilePath).booleanValue()) {
            try {
                FileUtils.forceDelete((File)new File(outFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        String appTemplateId = appInfo.getAppTemplateId();
        String srcStr = appTemplateId + "-template" + File.separator + appTemplateId + "-project";
        String srcFilePath = SdEnvUtil.TEMPLATE_PATH + File.separator + srcStr;
        String replaceStr = appCode;
        Map<String, Object> appParams = null;
        try {
            appParams = this.wrapAppsParam(appInfo.getAppId());
            String package_prefix = MapUtils.getString(appParams, (Object)"package_prefix", (String)"com.irdstudio");
            String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
            String replacePackage = package_prefix + "." + newAppCode;
            logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s...", srcFilePath, outFilePath));
            srcFilePath = new File(srcFilePath).getAbsolutePath();
            outFilePath = new File(outFilePath).getAbsolutePath();
            ReplaceDirAndFileBean rdfb = new ReplaceDirAndFileBean(srcFilePath, outFilePath, srcStr, replaceStr);
            rdfb.addFileReplacePattern(new FileReplacePattern("*", appTemplateId + "-template".replace(".", "-"), replaceStr.replaceAll("_|\\.", "-")));
            rdfb.addFileReplacePattern(new FileReplacePattern("*", "xxxxx", replacePackage, "fileContent"));
            rdfb.setIgnorePostfix("html,css,js");
            rdfb.execute();
            logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s\u5b8c\u6210!", srcFilePath, outFilePath));
            String newDirPath = StringUtils.replace((String)replacePackage, (String)".", (String)File.separator);
            File targetFile = new File(outFilePath);
            this.replaceMultipleDir(targetFile, "xxxxx", newDirPath);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            FileUtils.deleteDirectory((File)new File(outFilePath + File.separator + ".git"));
        }
        catch (IOException e) {
            logger.error("\u590d\u5236\u76ee\u5f55\u5f02\u5e38 " + outFilePath, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean genStartCode(PaasAppsInfoDTO appInfo) {
        return false;
    }

    private void replaceMultipleDir(File root, String srcStr, String targetStr) throws Exception {
        if (root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git") || !subFile.isDirectory()) continue;
                if (StringUtils.equals((String)srcStr, (String)subFile.getName())) {
                    File[] list;
                    File newDir = new File(root, targetStr);
                    newDir.mkdirs();
                    for (File f : list = subFile.listFiles()) {
                        FileUtils.moveDirectoryToDirectory((File)f, (File)newDir, (boolean)false);
                    }
                    FileUtils.deleteQuietly((File)subFile);
                    subFile = newDir;
                }
                this.replaceMultipleDir(subFile, srcStr, targetStr);
            }
        }
    }

    private Map<String, Object> wrapAppsParam(String appId) {
        PaasAppsParamService paasAppsParamService = (PaasAppsParamService)SpringContextUtils.getBean(PaasAppsParamService.class);
        PaasAppsParamDTO param = new PaasAppsParamDTO();
        param.setAppId(appId);
        List paramList = paasAppsParamService.queryList((Object)param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (PaasAppsParamDTO p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        return appsParam;
    }
}

