/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.irdstudio.allinflow.console.acl.repository.PaasAppsInfoPortalRepository;
import com.irdstudio.allinflow.console.application.service.impl.apptype.DefaultPaasAppTypeServiceImpl;
import com.irdstudio.allinflow.console.application.service.impl.apptype.PaasAppsTypeClazzServiceImpl;
import com.irdstudio.allinflow.console.application.service.impl.apptype.PaasAppsTypeUrlServiceImpl;
import com.irdstudio.allinflow.console.application.service.task.InvokeModuleInitTask;
import com.irdstudio.allinflow.console.application.service.task.PaasAppInitTask;
import com.irdstudio.allinflow.console.facade.PaasAppTypeService;
import com.irdstudio.allinflow.console.types.AppCreateWay;
import com.irdstudio.allinflow.console.types.BizDbOption;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasAppsDuRepository;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasTemplateDuRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasAppsDuDO;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasTemplateDuDO;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsActionRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsParamRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsSqlRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasApptypeInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateActionRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateComRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateParamRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateSqlRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsActionDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsParamDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsSqlDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasApptypeInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasTemplateActionDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasTemplateInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasTemplateParamDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasTemplateSqlDO;
import com.irdstudio.allinflow.design.console.facade.PaasAppsInfoPortalService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsActionDTO;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinflow.design.console.types.AppCategory;
import com.irdstudio.allinflow.design.console.types.AppType;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.audit.AuditOperate;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasAppsInfoPortalServiceImpl")
public class PaasAppsInfoPortalServiceImpl
extends BaseServiceImpl<PaasAppsInfoDTO, PaasAppsInfoDO, PaasAppsInfoRepository>
implements PaasAppsInfoPortalService {
    private static Logger logger = LoggerFactory.getLogger(PaasAppsInfoPortalServiceImpl.class);
    @Autowired
    private PaasAppsInfoPortalRepository paasAppsInfoPortalRepository;
    @Autowired
    private PaasAppsParamRepository paasAppsParamRepository;
    @Autowired
    private PaasAppsSqlRepository paasAppsSqlRepository;
    @Autowired
    private PaasAppsDuRepository paasAppsDuRepository;
    @Autowired
    private PaasAppsActionRepository paasAppsActionRepository;
    @Autowired
    private PaasTemplateInfoRepository paasTemplateInfoRepository;
    @Autowired
    private PaasTemplateParamRepository paasTemplateParamRepository;
    @Autowired
    private PaasTemplateSqlRepository paasTemplateSqlRepository;
    @Autowired
    private PaasTemplateDuRepository paasTemplateDuRepository;
    @Autowired
    private PaasTemplateActionRepository paasTemplateActionRepository;
    @Autowired
    private PaasTemplateComRepository paasTemplateComRepository;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private PaasApptypeInfoRepository paasApptypeInfoRepository;
    @Autowired
    private SeqInstInfoService seqService;
    private static final String DEFAULT_DEL_SERVICE_NAME = DefaultPaasAppTypeServiceImpl.class.getSimpleName();
    private static final String DEL_SERVICE_NAME = "PaasAppsType%sServiceImpl";

    @AuditOperate(action=AuditOperate.Action.Add, auditType="S", bizKey="${args[0].appId}", bizName="${args[0].appName}(${args[0].appCode})", text="${dynamicLog.action().getName()}\u4e86 #${args[0].appId} ${args[0].appName}(${args[0].appCode})")
    public int insert(PaasAppsInfoDTO inPaasAppsInfoDTO) {
        PaasTemplateInfoDO templateInfo;
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inPaasAppsInfoDTO.toString());
        if (StringUtils.isBlank((CharSequence)inPaasAppsInfoDTO.getAppId())) {
            String appId = this.seqService.nextSequence("PAAS-APP-ID", StringUtils.join(Arrays.asList(inPaasAppsInfoDTO.getSubsId(), inPaasAppsInfoDTO.getAppCategory()), (String)","));
            inPaasAppsInfoDTO.setAppId(appId);
            if (inPaasAppsInfoDTO.getAppOrder() == null) {
                inPaasAppsInfoDTO.setAppOrder(Integer.valueOf(NumberUtils.toInt((String)StringUtils.substring((String)appId, (int)(appId.length() - 3), (int)appId.length()))));
            }
        }
        String appType = inPaasAppsInfoDTO.getAppType();
        String archType = inPaasAppsInfoDTO.getArchType();
        String subsId = inPaasAppsInfoDTO.getSubsId();
        if (StringUtils.isNotBlank((CharSequence)inPaasAppsInfoDTO.getAppTemplateId())) {
            templateInfo = new PaasTemplateInfoDO();
            templateInfo.setAppTemplateId(inPaasAppsInfoDTO.getAppTemplateId());
            templateInfo = (PaasTemplateInfoDO)this.paasTemplateInfoRepository.queryByPk((Object)templateInfo);
            if (templateInfo != null) {
                inPaasAppsInfoDTO.setAppTemplateId(templateInfo.getAppTemplateId());
                inPaasAppsInfoDTO.setAppTemplateName(templateInfo.getAppTemplateName());
                inPaasAppsInfoDTO.setArchType(templateInfo.getArchType());
                if (StringUtils.isBlank((CharSequence)inPaasAppsInfoDTO.getAppGitUrl())) {
                    inPaasAppsInfoDTO.setAppGitUrl(templateInfo.getAppTemplateGitUrl());
                }
                if (StringUtils.isBlank((CharSequence)inPaasAppsInfoDTO.getAppCreateWay())) {
                    inPaasAppsInfoDTO.setAppCreateWay(AppCreateWay.TemplateCreate.getCode());
                }
            }
        } else {
            templateInfo = new PaasTemplateInfoDO();
            templateInfo.setAppTemplateId(appType + archType);
            templateInfo = (PaasTemplateInfoDO)this.paasTemplateInfoRepository.queryByPk((Object)templateInfo);
            if (templateInfo != null) {
                inPaasAppsInfoDTO.setAppTemplateId(appType + archType);
                inPaasAppsInfoDTO.setAppTemplateName(templateInfo.getAppTemplateName());
            } else if (appType.equals(AppType.A10.getCode())) {
                templateInfo = new PaasTemplateInfoDO();
                templateInfo.setAppType(appType);
                templateInfo.setAppTemplateId(null);
                List templates = this.paasTemplateInfoRepository.queryListByPage((Object)templateInfo);
                if (CollectionUtils.isNotEmpty((Collection)templates)) {
                    templateInfo = (PaasTemplateInfoDO)templates.get(0);
                    inPaasAppsInfoDTO.setAppTemplateId(templateInfo.getAppTemplateId());
                    inPaasAppsInfoDTO.setAppTemplateName(templateInfo.getAppTemplateName());
                }
            }
        }
        if (inPaasAppsInfoDTO.getAppOrder() == null) {
            PaasAppsInfoDO appParam = new PaasAppsInfoDO();
            appParam.setSubsId(subsId);
            appParam = ((PaasAppsInfoRepository)this.getRepository()).querySysCodeAppOrder(appParam);
            if (appParam != null) {
                Integer order = appParam.getAppOrder();
                if (order == null) {
                    order = 0;
                }
                inPaasAppsInfoDTO.setAppOrder(Integer.valueOf(order + 1));
            } else {
                inPaasAppsInfoDTO.setAppOrder(Integer.valueOf(1));
            }
        }
        int num = 0;
        PaasAppsInfoDO paasAppsInfo = new PaasAppsInfoDO();
        this.beanCopy(inPaasAppsInfoDTO, paasAppsInfo);
        PaasAppsInfoDO repeatParam = new PaasAppsInfoDO();
        repeatParam.setSubsId(paasAppsInfo.getSubsId());
        repeatParam.setAppCode(paasAppsInfo.getAppCode());
        List repeatList = ((PaasAppsInfoRepository)this.getRepository()).queryListByPage((Object)repeatParam);
        if (CollectionUtils.isNotEmpty((Collection)repeatList)) {
            throw new RuntimeException("\u5e94\u7528\u7cfb\u7edf\u4e0b\u5b58\u5728\u76f8\u540c\u5e94\u7528\u4ee3\u7801\u7684\u5e94\u7528" + paasAppsInfo.getAppCode());
        }
        num = ((PaasAppsInfoRepository)this.getRepository()).insert((Object)paasAppsInfo);
        if (StringUtils.isNotBlank((CharSequence)inPaasAppsInfoDTO.getAppTemplateId())) {
            PaasTemplateParamDO templateParam = new PaasTemplateParamDO();
            templateParam.setAppTemplateId(inPaasAppsInfoDTO.getAppTemplateId());
            List paramsList = this.paasTemplateParamRepository.queryList((Object)templateParam);
            if (StringUtils.isNotBlank((CharSequence)inPaasAppsInfoDTO.getAppTemplateId()) && CollectionUtils.isNotEmpty((Collection)paramsList)) {
                ArrayList<PaasAppsParamDO> appParamList = new ArrayList<PaasAppsParamDO>();
                for (PaasTemplateParamDO param : paramsList) {
                    PaasAppsParamDO appParam = new PaasAppsParamDO();
                    this.beanCopy(param, appParam);
                    appParam.setAppId(inPaasAppsInfoDTO.getAppId());
                    appParamList.add(appParam);
                }
                this.paasAppsParamRepository.batchInsert(appParamList);
            }
            PaasTemplateDuDO duParam = new PaasTemplateDuDO();
            duParam.setAppTemplateId(inPaasAppsInfoDTO.getAppTemplateId());
            List<PaasTemplateDuDO> duList = this.paasTemplateDuRepository.queryList((Object)duParam);
            if (CollectionUtils.isEmpty((Collection)duList)) {
                duList = Collections.emptyList();
            }
            PaasEnvInfoDTO envParam = new PaasEnvInfoDTO();
            PaasEnvInfoService paasEnvInfoService = (PaasEnvInfoService)SpringContextUtils.getBean(PaasEnvInfoService.class);
            List envList = paasEnvInfoService.queryList((Object)envParam);
            if (CollectionUtils.isNotEmpty((Collection)envList)) {
                for (PaasEnvInfoDTO env : envList) {
                    for (PaasTemplateDuDO du : duList) {
                        PaasAppsDuDO appDu = new PaasAppsDuDO();
                        this.beanCopy(du, appDu);
                        appDu.setAppId(inPaasAppsInfoDTO.getAppId());
                        appDu.setEnvId(env.getEnvId());
                        appDu.setEnvName(env.getEnvName());
                        appDu.setCreateUser(inPaasAppsInfoDTO.getCreateUser());
                        appDu.setCreateTime(inPaasAppsInfoDTO.getCreateTime());
                        appDu.setLastUpdateUser(inPaasAppsInfoDTO.getCreateUser());
                        appDu.setLastUpdateTime(inPaasAppsInfoDTO.getCreateTime());
                        this.paasAppsDuRepository.insert((Object)appDu);
                    }
                }
            }
            PaasTemplateActionDO actionParam = new PaasTemplateActionDO();
            actionParam.setAppTemplateId(inPaasAppsInfoDTO.getAppTemplateId());
            List<PaasTemplateActionDO> actionList = this.paasTemplateActionRepository.queryList((Object)actionParam);
            if (CollectionUtils.isEmpty((Collection)actionList)) {
                actionList = Collections.emptyList();
            }
            for (PaasTemplateActionDO action : actionList) {
                PaasAppsActionDO appAction = new PaasAppsActionDO();
                this.beanCopy(action, appAction);
                appAction.setAppId(inPaasAppsInfoDTO.getAppId());
                appAction.setCreateUser(inPaasAppsInfoDTO.getCreateUser());
                appAction.setCreateTime(inPaasAppsInfoDTO.getCreateTime());
                appAction.setLastUpdateUser(inPaasAppsInfoDTO.getCreateUser());
                appAction.setLastUpdateTime(inPaasAppsInfoDTO.getCreateTime());
                this.paasAppsActionRepository.insert((Object)appAction);
            }
            List<PaasTemplateSqlDO> sqlList = this.paasTemplateSqlRepository.queryAllByAppTemplateId(inPaasAppsInfoDTO.getAppTemplateId());
            if (CollectionUtils.isEmpty((Collection)sqlList)) {
                sqlList = Collections.emptyList();
            }
            ArrayList<PaasAppsSqlDO> appSqlList = new ArrayList<PaasAppsSqlDO>(sqlList.size());
            for (PaasTemplateSqlDO sql : sqlList) {
                PaasAppsSqlDO appSql = new PaasAppsSqlDO();
                this.beanCopy(sql, appSql);
                appSql.setRecordKeyid(UUIDUtil.getUUID());
                appSql.setAppId(inPaasAppsInfoDTO.getAppId());
                appSqlList.add(appSql);
            }
            this.paasAppsSqlRepository.batchInsert(appSqlList);
            InvokeModuleInitTask initTask = new InvokeModuleInitTask(paasAppsInfo, appSqlList);
            this.applicationThreadPool.add((Callable)initTask);
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        PaasAppInitTask projectRepoInitTask = new PaasAppInitTask(paasAppsInfo);
        this.applicationThreadPool.add((Callable)projectRepoInitTask);
        return num;
    }

    private PaasAppTypeService getDeleteService(PaasAppsInfoDTO paramDTO) {
        try {
            String appType = paramDTO.getAppType();
            if (StringUtils.isBlank((CharSequence)appType)) {
                paramDTO = (PaasAppsInfoDTO)this.queryByPk((BaseInfo)paramDTO);
                appType = paramDTO.getAppType();
            }
            PaasApptypeInfoDO paasApptypeInfoDO = new PaasApptypeInfoDO();
            paasApptypeInfoDO.setAppTypeId(appType);
            paasApptypeInfoDO = (PaasApptypeInfoDO)this.paasApptypeInfoRepository.queryByPk((Object)paasApptypeInfoDO);
            if (paasApptypeInfoDO != null && StringUtils.isNotBlank((CharSequence)paasApptypeInfoDO.getAppTypeDelinf())) {
                String delInterface = paasApptypeInfoDO.getAppTypeDelinf();
                if (StringUtils.startsWithAny((CharSequence)delInterface, (CharSequence[])new CharSequence[]{"http"})) {
                    PaasAppsTypeUrlServiceImpl delService = new PaasAppsTypeUrlServiceImpl(delInterface);
                    return delService;
                }
                PaasAppsTypeClazzServiceImpl delService = new PaasAppsTypeClazzServiceImpl(delInterface);
                return delService;
            }
            String beanId = StringUtils.uncapitalize((String)String.format(DEL_SERVICE_NAME, appType));
            PaasAppTypeService delService = (PaasAppTypeService)SpringContextUtils.getBean((String)beanId);
            return delService;
        }
        catch (BeansException e) {
            String beanId = StringUtils.uncapitalize((String)DEFAULT_DEL_SERVICE_NAME);
            PaasAppTypeService delService = (PaasAppTypeService)SpringContextUtils.getBean((String)beanId);
            return delService;
        }
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="S", bizKey="${args[0].appId}", bizName="${args[0].appName}(${args[0].appCode})", text="${dynamicLog.action().getName()}\u4e86 #${args[0].appId} ${args[0].appName}(${args[0].appCode})")
    public int deleteByPk(PaasAppsInfoDTO paramDTO) {
        PaasAppTypeService deleteService = this.getDeleteService(paramDTO);
        deleteService.deletePaasAppsInfo(paramDTO);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="S", bizKey="${args[0].appId}", bizName="${args[0].appName}(${args[0].appCode})", text="${dynamicLog.action().getName()}\u4e86 #${args[0].appId} ${args[0].appName}(${args[0].appCode})")
    public int deleteByCond(PaasAppsInfoDTO inPaasAppsInfoDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inPaasAppsInfoDTO);
        int num = 0;
        PaasAppTypeService deleteService = this.getDeleteService(inPaasAppsInfoDTO);
        deleteService.deletePaasAppsInfo(inPaasAppsInfoDTO);
        PaasAppsInfoDO paasAppsInfo = new PaasAppsInfoDO();
        this.beanCopy(inPaasAppsInfoDTO, paasAppsInfo);
        num = ((PaasAppsInfoRepository)this.getRepository()).deleteByCond(paasAppsInfo);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inPaasAppsInfoDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @AuditOperate(action=AuditOperate.Action.Update, auditType="S", bizKey="${args[0].appId}", bizName="${args[0].appName}(${args[0].appCode})")
    public int updateByPk(PaasAppsInfoDTO paramDTO) {
        PaasAppsInfoDTO oldData = (PaasAppsInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        if (!(BizDbOption.None.getCode().equals(paramDTO.getBizDbOption()) || StringUtils.equals((CharSequence)oldData.getBizDbName(), (CharSequence)paramDTO.getBizDbName()) && StringUtils.equals((CharSequence)oldData.getBizDbCnname(), (CharSequence)paramDTO.getBizDbCnname()))) {
            PaasAppsInfoDO updateParam = new PaasAppsInfoDO();
            updateParam.setSubsId(oldData.getSubsId());
            updateParam.setBizDbCnname(paramDTO.getBizDbCnname());
            updateParam.setBizDbName(paramDTO.getBizDbName());
            updateParam.setBizDbDbms(paramDTO.getBizDbDbms());
            updateParam.setAppName(oldData.getBizDbName());
            updateParam.setBizDbOption(BizDbOption.ShareDB.getCode());
            ((PaasAppsInfoRepository)this.getRepository()).updateByDbName(updateParam);
        }
        if (StringUtils.equals((CharSequence)AppCategory.DBApp.getCode(), (CharSequence)oldData.getAppCategory())) {
            PaasAppsInfoDO refAppUpdate = new PaasAppsInfoDO();
            refAppUpdate.setRefDbAppid(paramDTO.getAppId());
            refAppUpdate.setRefDbAppcode(paramDTO.getAppCode());
            refAppUpdate.setRefDbAppname(paramDTO.getAppName());
            refAppUpdate.setBizDbName(paramDTO.getBizDbName());
            ((PaasAppsInfoRepository)this.getRepository()).updateRefDbAppByRefDbAppid(refAppUpdate);
        }
        return super.updateByPk((BaseInfo)paramDTO);
    }

    public List<PaasAppsInfoDTO> queryAppByReferencedByPage(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
            this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
            List paasAppsInfos = this.paasAppsInfoPortalRepository.queryAppByReferencedByPage(paasAppsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + paasAppsInfos.size());
            list = this.beansCopy(paasAppsInfos, PaasAppsInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<PaasAppsInfoDTO> queryAppsInfoData(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u67e5\u8be2 \u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:");
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
        List list = this.paasAppsInfoPortalRepository.queryAppsInfoData(paasAppsInfoDO);
        logger.debug("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:" + list.size());
        return this.beansCopy(list, PaasAppsInfoDTO.class);
    }

    public List<PaasAppsInfoDTO> queryAppsInfoDataByPage(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u67e5\u8be2 \u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:");
        List list = Collections.emptyList();
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
        List doList = this.paasAppsInfoPortalRepository.queryAppsInfoDataByPage(paasAppsInfoDO);
        list = this.beansCopy(doList, PaasAppsInfoDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)doList) && StringUtils.isBlank((CharSequence)paasAppsInfoDTO.getGroupBy())) {
            PaasAppsActionDO actionParam = new PaasAppsActionDO();
            for (PaasAppsInfoDTO app : list) {
                actionParam.setAppId(app.getAppId());
                actionParam.setActionGroup(paasAppsInfoDTO.getActionGroup());
                List actionList = this.paasAppsActionRepository.queryList((Object)actionParam);
                if (!CollectionUtils.isNotEmpty((Collection)actionList)) continue;
                try {
                    app.setActionList(this.beansCopy(actionList, PaasAppsActionDTO.class));
                }
                catch (Exception e) {
                    logger.error("\u52a0\u8f7d\u5e94\u7528\u64cd\u4f5c\u5217\u8868\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        logger.debug("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:" + list.size());
        return list;
    }

    public List<PaasAppsInfoDTO> queryDDspaasAppsInfoDataByPage(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u67e5\u8be2 \u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:");
        List list = Collections.emptyList();
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
        List doList = this.paasAppsInfoPortalRepository.queryDDspaasAppsInfoDataByPage(paasAppsInfoDO);
        list = this.beansCopy(doList, PaasAppsInfoDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)doList) && StringUtils.isBlank((CharSequence)paasAppsInfoDTO.getGroupBy())) {
            PaasAppsActionDO actionParam = new PaasAppsActionDO();
            for (PaasAppsInfoDTO app : list) {
                actionParam.setAppId(app.getAppId());
                List actionList = this.paasAppsActionRepository.queryList((Object)actionParam);
                if (!CollectionUtils.isNotEmpty((Collection)actionList)) continue;
                try {
                    app.setActionList(this.beansCopy(actionList, PaasAppsActionDTO.class));
                }
                catch (Exception e) {
                    logger.error("\u52a0\u8f7d\u5e94\u7528\u64cd\u4f5c\u5217\u8868\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        logger.debug("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:" + list.size());
        return list;
    }

    public List<PaasAppsInfoDTO> queryComponentApp(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u67e5\u8be2 \u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:");
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
        List list = this.paasAppsInfoPortalRepository.queryComponentApp(paasAppsInfoDO);
        logger.debug("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:" + list.size());
        return this.beansCopy(list, PaasAppsInfoDTO.class);
    }

    public List<PaasAppsInfoDTO> queryAppReferenceComponentsByPage(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
            this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
            List paasAppsInfos = this.paasAppsInfoPortalRepository.queryAppReferenceComponentsByPage(paasAppsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + paasAppsInfos.size());
            list = this.beansCopy(paasAppsInfos, PaasAppsInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<PaasAppsInfoDTO> queryPlatformComponentAppByPage(PaasAppsInfoDTO paasAppsInfoDTO) {
        logger.debug("\u67e5\u8be2 \u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:");
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfoDTO, paasAppsInfoDO);
        List list = this.paasAppsInfoPortalRepository.queryPlatformComponentAppByPage(paasAppsInfoDO);
        logger.debug("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u7684\u5e94\u7528\u9996\u9875\u4fe1\u606f:" + list.size());
        return this.beansCopy(list, PaasAppsInfoDTO.class);
    }

    public int appIdReset(String appId, String newAppId) {
        int result = 0;
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        try {
            result = this.paasAppsInfoPortalRepository.appIdReset(appId, newAppId);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public List<PaasAppsInfoDTO> queryReferenceApp(PaasAppsInfoDTO paasAppsInfo) {
        PaasAppsInfoDO paasAppsInfoDO = new PaasAppsInfoDO();
        this.beanCopy(paasAppsInfo, paasAppsInfoDO);
        List poList = this.paasAppsInfoPortalRepository.queryReferenceApp(paasAppsInfoDO);
        return this.beansCopy(poList, PaasAppsInfoDTO.class);
    }
}

