/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsParamRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsParamDO;
import com.irdstudio.allinflow.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinflow.design.console.types.ParamSource;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.TmModelUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasAppsParamPortalServiceImpl")
public class PaasAppsParamPortalServiceImpl
implements PaasAppsParamPortalService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(PaasAppsParamPortalServiceImpl.class);
    @Autowired
    private PaasAppsParamRepository paasAppsParamRepository;
    @Autowired
    private PaasAppsInfoRepository paasAppsInfoRepository;
    @Autowired
    private PaasEcsInfoRepository paasEcsInfoRepository;

    public Map<String, Object> queryAppParamMap(String appId, String envId) {
        PaasAppsParamDO param = new PaasAppsParamDO();
        param.setAppId(appId);
        List paramList = this.paasAppsParamRepository.queryList((Object)param);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (PaasAppsParamDO p : paramList) {
                paramMap.put(p.getParamCode(), this.parseParamValue(appId, p.getParamSource(), p.getParamValue(), envId));
            }
        }
        return paramMap;
    }

    public Map<String, Object> loadEcsParam(String appId, String envId) {
        HashMap<String, Object> ecsMap = new HashMap<String, Object>();
        try {
            ecsMap = new HashMap();
            PaasEnvInfoService paasEnvInfoService = (PaasEnvInfoService)SpringContextUtils.getBean(PaasEnvInfoService.class);
            PaasEnvInfoDTO envInfo = new PaasEnvInfoDTO();
            envInfo.setEnvId(envId);
            envInfo = (PaasEnvInfoDTO)paasEnvInfoService.queryByPk((Object)envInfo);
            ecsMap.put("env", BeanUtility.bean2Map((Object)envInfo));
            PaasAppsInfoDO appParam = new PaasAppsInfoDO();
            appParam.setAppId(appId);
            PaasAppsInfoDO appInfo = (PaasAppsInfoDO)this.paasAppsInfoRepository.queryByPk((Object)appParam);
            PaasEcsInfoDO envEcsParam = new PaasEcsInfoDO();
            envEcsParam.setEnvId(envId);
            envEcsParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            List notAppEcsList = this.paasEcsInfoRepository.queryListByPage((Object)envEcsParam);
            envEcsParam.setSubsId(appInfo.getSubsId());
            List subsEcsList = this.paasEcsInfoRepository.queryListByPage((Object)envEcsParam);
            notAppEcsList.addAll(subsEcsList);
            envEcsParam.setAppId(appId);
            List ecsList = this.paasEcsInfoRepository.queryListByPage((Object)envEcsParam);
            notAppEcsList.addAll(ecsList);
            ecsList = notAppEcsList;
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                for (PaasEcsInfoDO ecs : ecsList) {
                    Map ecsObjMap = BeanUtility.bean2Map((Object)ecs);
                    HashMap ecsParamMap = new HashMap();
                    for (Map.Entry entry : ecsObjMap.entrySet()) {
                        String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                        ecsParamMap.put(key, entry.getValue());
                    }
                    ecsMap.put(ecs.getPaasDuId(), ecsParamMap);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf \u52a0\u8f7d\u670d\u52a1\u5668\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return ecsMap;
    }

    public String parseParamValue(String appId, String paramSource, String paramValue, String envId) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        Map<String, Object> ecsMap = this.loadEcsParam(appId, envId);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return "";
        }
        try {
            String value = ExpressionUtil.parse((String)paramValue, ecsMap);
            return value;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

