/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.design.console.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.admin.console.acl.repository.PaasCbaInfoRepository;
import com.irdstudio.allinflow.admin.console.acl.repository.PaasSubsCbaRepository;
import com.irdstudio.allinflow.admin.console.acl.repository.PaasSubsUserRepository;
import com.irdstudio.allinflow.admin.console.domain.entity.PaasCbaInfoDO;
import com.irdstudio.allinflow.admin.console.domain.entity.PaasSubsCbaDO;
import com.irdstudio.allinflow.admin.console.domain.entity.PaasSubsUserDO;
import com.irdstudio.allinflow.console.acl.repository.PaasAppsInfoPortalRepository;
import com.irdstudio.allinflow.console.acl.repository.SSubsInfoPortalRepository;
import com.irdstudio.allinflow.console.application.service.utils.JGitUtil;
import com.irdstudio.allinflow.console.types.YesOrNO;
import com.irdstudio.allinflow.deliver.console.facade.PaasDuSysinfoService;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasDuSysinfoDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasSubsEnvRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasSubsGroupRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasSubsEnvDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasSubsGroupDO;
import com.irdstudio.allinflow.design.console.domain.entity.SSubsInfoDO;
import com.irdstudio.allinflow.design.console.facade.PaasAppsAdjustService;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsAdjustDTO;
import com.irdstudio.allinflow.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinflow.design.console.types.SubsRole;
import com.irdstudio.allinflow.manager.console.facade.PaasAppsDocumentService;
import com.irdstudio.allinflow.manager.console.facade.dto.PaasAppsDocumentDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRolesubsService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRoleuserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserProfileService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SRolesubsDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SRoleuserDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserProfileDTO;
import com.irdstudio.framework.beans.core.audit.AuditOperate;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="sSubsInfoPortalServiceImpl")
public class SSubsInfoPortalServiceImpl
extends BaseServiceImpl<SSubsInfoDTO, SSubsInfoDO, SSubsInfoPortalRepository>
implements SSubsInfoPortalService {
    @Autowired
    private PaasAppsInfoRepository paasAppsInfoRepository;
    @Autowired
    private PaasAppsInfoPortalRepository paasAppsInfoPortalRepository;
    @Autowired
    private PaasSubsCbaRepository paasSubsCbaRepository;
    @Autowired
    private PaasCbaInfoRepository paasCbaInfoRepository;
    @Autowired
    private PaasSubsUserRepository paasSubsUserRepository;
    @Value(value="${tdp.project.path:}")
    private String projectTmpDirPath;
    @Value(value="${cas.client-host-url:}")
    private String clientHostUrl;
    private HttpClient httpClient = HttpClients.createDefault();
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private PaasAppsAdjustService paasAppsAdjustService;
    @Autowired
    private PaasAppsDocumentService paasAppsDocumentService;
    @Autowired
    private PaasDuSysinfoService paasDuSysinfoService;
    @Autowired
    private PaasSubsEnvRepository paasSubsEnvRepository;
    @Autowired
    private PaasSubsGroupRepository paasSubsGroupRepository;
    @Autowired
    private SUserService sUserService;
    @Autowired
    private SUserProfileService sUserProfileService;
    @Autowired
    private SRolesubsService sRolesubsService;
    @Autowired
    private SRoleuserService sRoleuserService;
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    @AuditOperate(action=AuditOperate.Action.Add, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].subsId} ${args[0].subsName}")
    public int insert(SSubsInfoDTO inSSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSSubsInfoDTO.toString());
        int num = 0;
        try {
            SSubsInfoDO sSubsInfo = new SSubsInfoDO();
            this.beanCopy(inSSubsInfoDTO, sSubsInfo);
            num = ((SSubsInfoPortalRepository)this.getRepository()).insert((Object)sSubsInfo);
            this.saveSubGroupRef(inSSubsInfoDTO);
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getCbaCodes())) {
                String[] cbaA = StringUtils.split((String)inSSubsInfoDTO.getCbaCodes(), (String)",");
                ArrayList<PaasSubsCbaDO> cbaList = new ArrayList<PaasSubsCbaDO>();
                for (String cba : cbaA) {
                    PaasSubsCbaDO cbaDO = new PaasSubsCbaDO();
                    cbaDO.setSubsId(inSSubsInfoDTO.getSubsId());
                    cbaDO.setCbaCode(cba);
                    cbaList.add(cbaDO);
                }
                this.paasSubsCbaRepository.batchInsert(cbaList);
                this.paasCbaCreateDefaultApp(inSSubsInfoDTO.getSubsId());
            }
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getRolenos())) {
                this.paasSubsUserRepository.updateSubsId(inSSubsInfoDTO.getSubsId(), inSSubsInfoDTO.getRolenos());
            }
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getEnvs())) {
                String subsId = inSSubsInfoDTO.getSubsId();
                String[] envs = StringUtils.split((String)inSSubsInfoDTO.getEnvs(), (String)",");
                if (envs != null & envs.length > 0) {
                    ArrayList<PaasSubsEnvDO> envList = new ArrayList<PaasSubsEnvDO>();
                    for (String envId : envs) {
                        PaasSubsEnvDO envInfo = new PaasSubsEnvDO();
                        envInfo.setEnvId(envId);
                        envInfo.setSubsId(subsId);
                        envList.add(envInfo);
                    }
                    this.paasSubsEnvRepository.batchInsert(envList);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getChargeMan())) {
                SUserDTO userParam = new SUserDTO();
                userParam.setActorno(inSSubsInfoDTO.getChargeMan());
                SUserDTO inchargeUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                if (inchargeUser != null) {
                    PaasSubsUserDO managerMem = new PaasSubsUserDO();
                    managerMem.setUserId(inchargeUser.getActorno());
                    managerMem.setUserName(inchargeUser.getActorname());
                    managerMem.setPhone(inchargeUser.getTelnum());
                    managerMem.setEmail(inchargeUser.getUsermail());
                    managerMem.setUserRole(SubsRole.Admin.getCode());
                    managerMem.setSubsId(inSSubsInfoDTO.getSubsId());
                    managerMem.setCreateUser(inSSubsInfoDTO.getLoginUserId());
                    managerMem.setLastModifyUser(inSSubsInfoDTO.getLoginUserId());
                    String now = CurrentDateUtil.getTodayDateEx2();
                    managerMem.setCreateTime(now);
                    managerMem.setLastModifyTime(now);
                    this.paasSubsUserRepository.insert((Object)managerMem);
                }
            }
            if (StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)inSSubsInfoDTO.getCreateGitGroup())) {
                PaasEnvParamDTO envParam = new PaasEnvParamDTO();
                envParam.setEnvId("paas");
                envParam.setParamGroup("git.user");
                envParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
                List gitParamList = paasEnvParamService.queryList((Object)envParam);
                if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                    String subsGitGroup;
                    String gitType = this.getEnvParamByCode("git.type", gitParamList);
                    String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                    String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                    if (gitHostUrl.endsWith("/")) {
                        gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                    }
                    if (StringUtils.isBlank((CharSequence)(subsGitGroup = sSubsInfo.getSubsGitGroup()))) {
                        subsGitGroup = String.format("%s/%s", gitHostUrl, sSubsInfo.getSubsCode());
                    }
                    sSubsInfo.setSubsGitGroup(subsGitGroup);
                    ((SSubsInfoPortalRepository)this.getRepository()).updateByPk((Object)sSubsInfo);
                    subsGitGroup = subsGitGroup.substring(subsGitGroup.lastIndexOf("/") + 1);
                    logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                    boolean result = true;
                    SRolesubsDTO sysRightParam = new SRolesubsDTO();
                    sysRightParam.setSubsId(inSSubsInfoDTO.getSubsId());
                    List roleList = this.sRolesubsService.queryRoleWithSubsListByPage(sysRightParam);
                    ArrayList<String> userIds = new ArrayList<String>();
                    roleList.stream().forEach(r -> {
                        SRoleuserDTO rUser = new SRoleuserDTO();
                        rUser.setRoleno(r.getRoleno());
                        List userList = this.sRoleuserService.queryList((Object)rUser);
                        if (CollectionUtils.isNotEmpty((Collection)userList)) {
                            userList.stream().forEach(u -> userIds.add(u.getActorno()));
                        }
                    });
                    result = this.gitlabHandler(subsGitGroup, inSSubsInfoDTO.getLoginUserId(), gitHostUrl, accessToken, userIds, sSubsInfo.getSubsName());
                }
            }
        }
        catch (DataAccessException dataAccessException) {
            throw new RuntimeException("\u8be5\u5e94\u7528\u7cfb\u7edf\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728", dataAccessException);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e382", e);
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }

    @AuditOperate(action=AuditOperate.Action.Update, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}")
    public int updateByPk(SSubsInfoDTO inSSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSSubsInfoDTO.toString());
        int num = 0;
        SSubsInfoDTO oldData = (SSubsInfoDTO)this.queryByPk((BaseInfo)inSSubsInfoDTO);
        inSSubsInfoDTO.setOldData((Object)oldData);
        SSubsInfoDO sSubsInfo = new SSubsInfoDO();
        this.beanCopy(inSSubsInfoDTO, sSubsInfo);
        num = ((SSubsInfoPortalRepository)this.getRepository()).updateByPk((Object)sSubsInfo);
        if (StringUtils.isNotBlank((CharSequence)inSSubsInfoDTO.getCbaCodes())) {
            this.paasSubsCbaRepository.deleteBySubsId(inSSubsInfoDTO.getSubsId());
            String[] cbaA = StringUtils.split((String)inSSubsInfoDTO.getCbaCodes(), (String)",");
            ArrayList<PaasSubsCbaDO> cbaList = new ArrayList<PaasSubsCbaDO>();
            for (String cba : cbaA) {
                PaasSubsCbaDO cbaDO = new PaasSubsCbaDO();
                cbaDO.setSubsId(inSSubsInfoDTO.getSubsId());
                cbaDO.setCbaCode(cba);
                cbaList.add(cbaDO);
            }
            this.paasSubsCbaRepository.batchInsert(cbaList);
            this.paasCbaCreateDefaultApp(inSSubsInfoDTO.getSubsId());
        }
        this.saveSubGroupRef(inSSubsInfoDTO);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inSSubsInfoDTO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="S", bizKey="${args[0].subsId}", bizName="${args[0].subsName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].subsId} ${args[0].subsName}")
    public int deleteByPk(SSubsInfoDTO paramDTO) {
        String userId = paramDTO.getLoginUserId();
        String userName = paramDTO.getLoginUserName();
        this.paasSubsCbaRepository.deleteBySubsId(paramDTO.getSubsId());
        String subsId = paramDTO.getSubsId();
        PaasAppsAdjustDTO paasAppsAdjustDTO = (PaasAppsAdjustDTO)this.beanCopy(paramDTO, PaasAppsAdjustDTO.class, true);
        this.paasAppsAdjustService.deleteByCond(paasAppsAdjustDTO);
        PaasAppsDocumentDTO paasAppsDocumentDTO = (PaasAppsDocumentDTO)this.beanCopy(paramDTO, PaasAppsDocumentDTO.class, true);
        this.paasAppsDocumentService.deleteByCond(paasAppsDocumentDTO);
        PaasDuSysinfoDTO paasDuSysinfoDTO = (PaasDuSysinfoDTO)this.beanCopy(paramDTO, PaasDuSysinfoDTO.class, true);
        this.paasDuSysinfoService.deleteByCond(paasDuSysinfoDTO);
        SRolesubsDTO sRolesubsDTO = (SRolesubsDTO)this.beanCopy(paramDTO, SRolesubsDTO.class, true);
        this.sRolesubsService.deleteByCond(sRolesubsDTO);
        PaasSubsGroupDO deleteGroupDO = (PaasSubsGroupDO)this.beanCopy(paramDTO, PaasSubsGroupDO.class, true);
        this.paasSubsGroupRepository.deleteByCond(deleteGroupDO);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public Integer querySSubsInfoMaxOrder() {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        Integer result = null;
        try {
            result = ((SSubsInfoPortalRepository)this.getRepository()).querySSubsInfoMaxOrder();
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public String querySSubsInfoMaxOrderWithPrefix(String solutionType) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        String result = null;
        try {
            result = ((SSubsInfoPortalRepository)this.getRepository()).querySSubsInfoMaxOrderWithPrefix(solutionType);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public boolean updateGitRoleWithSubs(String subsCode) {
        try {
            logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + subsCode.toString());
            SSubsInfoDO sSubsInfo = new SSubsInfoDO();
            sSubsInfo.setSubsCode(subsCode);
            sSubsInfo = (SSubsInfoDO)((SSubsInfoPortalRepository)this.getRepository()).queryByPk((Object)sSubsInfo);
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String subsGitGroup;
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                if (StringUtils.isBlank((CharSequence)(subsGitGroup = sSubsInfo.getSubsGitGroup()))) {
                    subsGitGroup = String.format("%s/%s", gitHostUrl, sSubsInfo.getSubsCode());
                }
                subsGitGroup = subsGitGroup.substring(subsGitGroup.lastIndexOf("/") + 1);
                logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                boolean result = true;
                SRolesubsDTO sysRightParam = new SRolesubsDTO();
                sysRightParam.setSubsId(sSubsInfo.getSubsId());
                List roleList = this.sRolesubsService.queryRoleWithSubsListByPage(sysRightParam);
                ArrayList<String> userIds = new ArrayList<String>();
                roleList.stream().forEach(r -> {
                    SRoleuserDTO rUser = new SRoleuserDTO();
                    rUser.setRoleno(r.getRoleno());
                    List userList = this.sRoleuserService.queryList((Object)rUser);
                    if (CollectionUtils.isNotEmpty((Collection)userList)) {
                        userList.stream().forEach(u -> userIds.add(u.getActorno()));
                    }
                });
                if (CollectionUtils.isNotEmpty(userIds)) {
                    result = this.gitlabHandler(subsGitGroup, (String)userIds.get(0), gitHostUrl, accessToken, userIds, sSubsInfo.getSubsName());
                }
            }
        }
        catch (DataAccessException dataAccessException) {
            logger.error("\u8be5\u5e94\u7528\u7cfb\u7edf\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728!", (Throwable)dataAccessException);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e382!", (Throwable)e);
        }
        return true;
    }

    public int saveSubsInfoImportList(List<SSubsInfoDTO> list) {
        int num = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (SSubsInfoDTO subs : list) {
                SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
                this.beanCopy(subs, sSubsInfoDO);
                SSubsInfoDO checkObj = (SSubsInfoDO)((SSubsInfoPortalRepository)this.getRepository()).queryByPk((Object)sSubsInfoDO);
                if (checkObj != null) {
                    this.beanCopy(subs, checkObj);
                    num += ((SSubsInfoPortalRepository)this.getRepository()).updateByPk((Object)checkObj);
                    continue;
                }
                num += ((SSubsInfoPortalRepository)this.getRepository()).insert((Object)sSubsInfoDO);
            }
        }
        return num;
    }

    public List<Map<String, Object>> queryDdspaasSummaryByPage(SSubsInfoDTO sSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
            this.beanCopy(sSubsInfoDTO, sSubsInfoDO);
            list = ((SSubsInfoPortalRepository)this.getRepository()).queryDdspaasSummaryByPage(sSubsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
            sSubsInfoDTO.setTotal(sSubsInfoDO.getTotal());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<Map<String, Object>> querySubsSummary(SSubsInfoDTO sSubsInfoDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            SSubsInfoDO sSubsInfoDO = new SSubsInfoDO();
            this.beanCopy(sSubsInfoDTO, sSubsInfoDO);
            list = ((SSubsInfoPortalRepository)this.getRepository()).querySubsSummary(sSubsInfoDO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public boolean gitlabHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, List<String> userIds, String desc) throws Exception {
        boolean result;
        block46: {
            result = true;
            try {
                String group = subsGitGroup;
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUserDTO userParam = new SUserDTO();
                    userParam.setActorno(currentUserId);
                    SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(sUser.getActorno());
                    if (SSubsInfoPortalServiceImpl.validate(sUser.getUsermail())) {
                        gitUserInfo.setEmail(sUser.getUsermail());
                    } else {
                        gitUserInfo.setEmail(String.format("%s@%s.com", currentUserId, "irdstudio"));
                    }
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                if (CollectionUtils.isNotEmpty(userIds)) {
                    for (String userId : userIds) {
                        User tmpUserInfo = null;
                        try {
                            tmpUserInfo = gitLabApi.getUserApi().getUser(userId);
                        }
                        catch (GitLabApiException gitLabApiException) {
                            // empty catch block
                        }
                        if (tmpUserInfo == null) {
                            SUserDTO userParam = new SUserDTO();
                            userParam.setActorno(userId);
                            SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                            tmpUserInfo = new User();
                            tmpUserInfo.setName(userId);
                            tmpUserInfo.setUsername(sUser.getActorno());
                            if (SSubsInfoPortalServiceImpl.validate(sUser.getUsermail())) {
                                tmpUserInfo.setEmail(sUser.getUsermail());
                            } else {
                                tmpUserInfo.setEmail(String.format("%s@%s.com", sUser.getActorno(), "irdstudio"));
                            }
                            try {
                                tmpUserInfo = gitLabApi.getUserApi().createUser(tmpUserInfo, (CharSequence)(userId + userId), false);
                            }
                            catch (GitLabApiException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (tmpUserInfo.getId() == null) continue;
                        try {
                            groupApi.addMember((Object)group, tmpUserInfo.getId(), AccessLevel.MAINTAINER);
                        }
                        catch (GitLabApiException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                String projectName = subsGitGroup + "-wiki";
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException e) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException sUser) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    } else {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                        result = false;
                    }
                } else {
                    logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u5df2\u5b58\u5728");
                    result = true;
                }
                if (!CollectionUtils.isNotEmpty(userIds)) break block46;
                for (String userId : userIds) {
                    User tmpUserInfo = null;
                    try {
                        tmpUserInfo = gitLabApi.getUserApi().getUser(userId);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    try {
                        prjApi.addMember((Object)prj, tmpUserInfo.getId(), AccessLevel.MAINTAINER);
                    }
                    catch (GitLabApiException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public boolean gitlabRepoHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, List<String> userIds, String desc) throws Exception {
        boolean result;
        block28: {
            result = true;
            try {
                logger.info("\u5f53\u524d\u7528\u6237\uff1a " + currentUserId);
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                String projectName = subsGitGroup.substring(subsGitGroup.lastIndexOf("/") + 1);
                String group = StringUtils.replaceOnce((String)subsGitGroup, (String)projectName, (String)"");
                projectName = StringUtils.replaceOnce((String)projectName, (String)".git", (String)"");
                group = group.substring(0, group.lastIndexOf("/"));
                group = group.substring(group.lastIndexOf("/") + 1);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUserDTO userParam = new SUserDTO();
                    userParam.setActorno(currentUserId);
                    SUserDTO sUser = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(sUser.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block28;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block28;
                    }
                    logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block28;
                }
                logger.info("\u4ed3\u5e93\u5df2\u5b58\u5728");
                try {
                    Member member = prjApi.addMember((Object)prj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                result = true;
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public Integer countSubsInfoTbNum(String subsId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + subsId);
        Integer count = ((SSubsInfoPortalRepository)this.getRepository()).countSubsInfoTbNum(subsId);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + count);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean insertWikiDocumentWithFile(HttpServletRequest request, MultipartFile file) {
        try {
            String docTitle = request.getParameter("docTitle");
            String docType = request.getParameter("docType");
            String subsCode = request.getParameter("subsId");
            String dirId = request.getParameter("dirId");
            String dirName = request.getParameter("dirName");
            String content = request.getParameter("content");
            String hasFileUpload = request.getParameter("hasFileUpload");
            String loginUserId = request.getParameter("loginUserId");
            SSubsInfoDO subsInfo = new SSubsInfoDO();
            subsInfo.setSubsCode(subsCode);
            subsInfo = (SSubsInfoDO)((SSubsInfoPortalRepository)this.getRepository()).queryByPk((Object)subsInfo);
            boolean createRepoFlag = true;
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            String gitHostUrl = null;
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                createRepoFlag = this.gitlabHandler(subsInfo.getSubsCode(), loginUserId, gitHostUrl, accessToken, null, subsInfo.getSubsName());
            }
            File subsDir = new File(this.projectTmpDirPath, subsInfo.getSubsCode() + "-wiki");
            String repoUrl = String.format("%s/%s/%s.git", gitHostUrl, subsInfo.getSubsCode(), subsInfo.getSubsCode() + "-wiki");
            SUserProfileDTO userProfileParam = new SUserProfileDTO();
            userProfileParam.setActorno(loginUserId);
            SUserProfileDTO userProfile = (SUserProfileDTO)this.sUserProfileService.queryByPk((Object)userProfileParam);
            if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                return false;
            }
            String userEmail = "";
            SUserDTO userParam = new SUserDTO();
            userParam.setActorno(loginUserId);
            SUserDTO user = (SUserDTO)this.sUserService.queryByPk((Object)userParam);
            userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", loginUserId, "irdstudio");
            String gitUser = userProfile.getGitUsername();
            String gitPwd = userProfile.getGitAccessToken();
            gitPwd = StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken()) ? userProfile.getGitAccessToken() : userProfile.getGitPassword();
            String branchName = "master";
            String localPath = subsDir.getAbsolutePath();
            try (JGitUtil jGitUtil = null;){
                jGitUtil = new JGitUtil(localPath, repoUrl, gitUser, gitPwd);
                try {
                    jGitUtil.pull(branchName);
                }
                catch (Exception e) {
                    try {
                        FileUtils.forceDelete((File)subsDir);
                        jGitUtil.cloneBranch(branchName);
                    }
                    catch (Exception e12) {
                        jGitUtil.close();
                        File localRepoFile = new File(localPath);
                        if (localRepoFile.exists()) {
                            FileUtils.deleteQuietly((File)localRepoFile);
                        }
                        try {
                            jGitUtil = new JGitUtil(localPath, repoUrl, gitUser, gitPwd);
                            jGitUtil.cloneBranch(branchName);
                            if (jGitUtil != null) {
                                jGitUtil.close();
                            }
                        }
                        catch (Exception e2) {
                            try {
                                logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                                e2.printStackTrace();
                                boolean bl = false;
                                if (jGitUtil != null) {
                                    jGitUtil.close();
                                }
                                if (jGitUtil != null) {
                                    jGitUtil.close();
                                }
                                return bl;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (jGitUtil != null) {
                                        jGitUtil.close();
                                    }
                                    throw throwable;
                                }
                                catch (Exception delExcep) {
                                    logger.error("\u6e05\u7a7a\u77e5\u8bc6\u5e93\u672c\u5730\u4ed3\u5e93\u5931\u8d25 ", (Throwable)delExcep);
                                    boolean e12 = false;
                                    return e12;
                                }
                                finally {
                                }
                            }
                        }
                    }
                }
            }
            if (createRepoFlag) {
                File targetDir = null;
                targetDir = StringUtils.isBlank((CharSequence)dirName) ? subsDir : new File(subsDir, dirName);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                File targetFile = new File(targetDir, docTitle + ("." + docType).toLowerCase());
                Boolean hasFile = Boolean.valueOf(hasFileUpload);
                if (StringUtils.equals((CharSequence)docType, (CharSequence)"md")) {
                    FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
                } else if (hasFile.booleanValue()) {
                    file.transferTo(targetFile);
                }
                jGitUtil = new JGitUtil(localPath, repoUrl, gitUser, gitPwd);
                try {
                    jGitUtil.addAll();
                    jGitUtil.commit(loginUserId, userEmail, String.format("\u63d0\u4ea4\u77e5\u8bc6\u5e93\u6587\u6863 %s", docTitle));
                    jGitUtil.push(repoUrl, false);
                }
                catch (Exception e) {
                    logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (jGitUtil != null) {
                        jGitUtil.close();
                    }
                }
            } else {
                return createRepoFlag;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406wiki\u77e5\u8bc6\u5e93\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean validate(String emailStr) {
        if (emailStr == null) {
            return false;
        }
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public List<Map<String, Object>> querySummary(Map<String, Object> param) {
        return ((SSubsInfoPortalRepository)this.getRepository()).querySummary(param);
    }

    public List<Map<String, Object>> querySubsInfoSummaryByPage(SSubsInfoDTO param) {
        SSubsInfoDO doParam = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List outputVO = ((SSubsInfoPortalRepository)this.getRepository()).querySubsInfoSummaryByPage(doParam);
        param.setTotal(doParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySummaryBySolutionTypeGroup(SSubsInfoDTO param) {
        SSubsInfoDO doParam = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List outputVO = ((SSubsInfoPortalRepository)this.getRepository()).querySummaryBySolutionTypeGroup(doParam);
        param.setTotal(doParam.getTotal());
        return outputVO;
    }

    public List<Map<String, Object>> querySubsCbaSummary(Map<String, Object> params) {
        return ((SSubsInfoPortalRepository)this.getRepository()).querySubsCbaSummary(params);
    }

    public List<SSubsInfoDTO> queryWithEnvListByPage(SSubsInfoDTO param) {
        SSubsInfoDO paramDO = (SSubsInfoDO)this.beanCopy(param, SSubsInfoDO.class);
        List poList = ((SSubsInfoPortalRepository)this.getRepository()).queryWithEnvListByPage(paramDO);
        return this.beansCopy(poList, SSubsInfoDTO.class);
    }

    private void paasCbaCreateDefaultApp(final String subsId) {
        PaasCbaInfoDO cbaInfo = new PaasCbaInfoDO();
        cbaInfo.setSubsId(subsId);
        cbaInfo.setCbaCreateAppFlag(YesOrNO.YES.getCode());
        List cbaList = this.paasCbaInfoRepository.queryList((Object)cbaInfo);
        if (CollectionUtils.isNotEmpty((Collection)cbaList)) {
            for (PaasCbaInfoDO cba : cbaList) {
                final String url = cba.getCbaAppInterface();
                if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                this.applicationThreadPool.add((Callable)new Callable<ExecuteRtnInfo>(){

                    @Override
                    public ExecuteRtnInfo call() throws Exception {
                        try {
                            HttpPost post = new HttpPost(SSubsInfoPortalServiceImpl.this.clientHostUrl + url);
                            PaasAppsInfoDO appInfo = new PaasAppsInfoDO();
                            appInfo.setSubsId(subsId);
                            StringEntity createEntity = new StringEntity(JSON.toJSONString((Object)appInfo), "UTF-8");
                            post.setHeader("Content-Type", "application/json;charset=UTF-8");
                            post.setEntity((HttpEntity)createEntity);
                            HttpResponse response = SSubsInfoPortalServiceImpl.this.httpClient.execute((HttpUriRequest)post);
                            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                            BaseServiceImpl.logger.debug("\u521b\u5efa\u5e94\u7528\u8fd4\u56de\u62a5\u6587: {}", (Object)json);
                        }
                        catch (Exception e) {
                            BaseServiceImpl.logger.error("\u521b\u5efa\u9ed8\u8ba4\u5e94\u7528\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private void saveSubGroupRef(SSubsInfoDTO subsInfo) {
        String[] groups;
        if (StringUtils.isNotBlank((CharSequence)subsInfo.getSubsGroupId()) && (groups = StringUtils.split((String)subsInfo.getSubsGroupId())) != null) {
            ArrayList<PaasSubsGroupDO> groupMapList = new ArrayList<PaasSubsGroupDO>(groups.length);
            for (String groupId : groups) {
                PaasSubsGroupDO groupDO = new PaasSubsGroupDO();
                groupDO.setSubsId(subsInfo.getSubsId());
                groupDO.setGroupId(groupId);
                groupMapList.add(groupDO);
            }
            if (CollectionUtils.isNotEmpty(groupMapList)) {
                this.paasSubsGroupRepository.batchInsert(groupMapList);
            }
        }
    }
}

