/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.quality.console.application.service.check.scheme.impl;

import com.irdstudio.allinflow.console.types.YesOrNO;
import com.irdstudio.allinflow.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinflow.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinflow.quality.console.types.CheckResult;
import com.irdstudio.allinflow.quality.console.types.RuleResult;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRule
implements CheckJavaRule {
    private static final Logger logger = LoggerFactory.getLogger(SqlRule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String serialNo, SCheckRuleDTO rule, Map<String, Object> param, IConnPool connTool) {
        SCheckResultDTO ruleResult = new SCheckResultDTO();
        ruleResult.setSerialNo(serialNo);
        ruleResult.setSchemeNo(rule.getSchemeNo());
        ruleResult.setRuleId(rule.getRuleId());
        ruleResult.setRuleName(rule.getRuleName());
        RuleResult flag = RuleResult.Pass;
        ArrayList<SCheckResultDtlDTO> ruleResultDtlList = new ArrayList<SCheckResultDtlDTO>();
        List<Map<String, Object>> sqlRs = null;
        try {
            sqlRs = this.executeSql(param, rule.getRuleContent(), connTool);
        }
        catch (Exception e) {
            ruleResult.setRuleResult(flag.getCode());
            ruleResult.setCreateUser(rule.getLoginUserId());
            ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            ruleResult.setRuleResult(RuleResult.Error.getCode());
            Connection conn = null;
            try {
                conn = connTool.getConnection();
                SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
                sCheckResultService.insert((Object)ruleResult);
            }
            catch (Exception e1) {
                logger.error("sql\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e1.getMessage(), (Object)e1);
            }
            finally {
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
            return false;
        }
        boolean genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        String testExp = rule.getRuleSucCondition();
        String errorMsgExp = rule.getRuleErrDesc();
        for (Map<String, Object> re : sqlRs) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.putAll(param);
            root.put("$result", re);
            String testRe = ExpressionUtil.parse((String)testExp, root);
            CheckResult cr = CheckResult.getCheckResult((String)testRe);
            if (cr == CheckResult.Pass) continue;
            flag = RuleResult.Fail;
            if (!genDtl) continue;
            SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
            dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            dtl.setCheckResult(cr.getCode());
            String checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
            dtl.setCheckDesc(checkDesc);
            String objectId = MapUtils.getString(re, (Object)"objectId");
            String objectCode = MapUtils.getString(re, (Object)"objectCode");
            String objectName = MapUtils.getString(re, (Object)"objectName");
            if (StringUtils.isNotBlank((CharSequence)objectId)) {
                dtl.setObjectId(objectId);
            }
            if (StringUtils.isNotBlank((CharSequence)objectCode)) {
                dtl.setObjectCode(objectCode);
            }
            if (StringUtils.isNotBlank((CharSequence)objectName)) {
                dtl.setObjectName(objectName);
            }
            ruleResultDtlList.add(dtl);
        }
        ruleResult.setRuleResult(flag.getCode());
        ruleResult.setCreateUser(rule.getLoginUserId());
        ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
            SCheckResultDtlService sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
            sCheckResultService.insert((Object)ruleResult);
            if (CollectionUtils.isNotEmpty(ruleResultDtlList)) {
                for (SCheckResultDtlDTO dtl : ruleResultDtlList) {
                    String subsId = MapUtils.getString(param, (Object)"subsId");
                    String subsCode = MapUtils.getString(param, (Object)"subsCode");
                    String subsName = MapUtils.getString(param, (Object)"subsName");
                    String appId = MapUtils.getString(param, (Object)"appId");
                    String appCode = MapUtils.getString(param, (Object)"appCode");
                    String appName = MapUtils.getString(param, (Object)"appName");
                    String appType = MapUtils.getString(param, (Object)"appType");
                    String objectId = MapUtils.getString(param, (Object)"objectId");
                    String objectCode = MapUtils.getString(param, (Object)"objectCode");
                    String objectName = MapUtils.getString(param, (Object)"objectName");
                    String dtlId = UUIDUtil.getUUID();
                    dtl.setSerialNo(serialNo);
                    dtl.setRuleId(rule.getRuleId());
                    dtl.setRuleName(rule.getRuleName());
                    dtl.setDtlId(dtlId);
                    dtl.setAppId(appId);
                    dtl.setAppCode(appCode);
                    dtl.setAppName(appName);
                    dtl.setSubsId(subsId);
                    dtl.setSubsCode(subsCode);
                    dtl.setSubsName(subsName);
                    dtl.setAppType(appType);
                    if (StringUtils.isBlank((CharSequence)dtl.getObjectId())) {
                        dtl.setObjectId(objectId);
                    }
                    if (StringUtils.isBlank((CharSequence)dtl.getObjectCode())) {
                        dtl.setObjectCode(objectCode);
                    }
                    if (StringUtils.isBlank((CharSequence)dtl.getObjectName())) {
                        dtl.setObjectName(objectName);
                    }
                    dtl.setCreateUser(rule.getLoginUserId());
                }
                sCheckResultDtlService.batchInsert(ruleResultDtlList);
            }
        }
        catch (Exception e) {
            logger.error("sql\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return flag == RuleResult.Pass;
    }

    private List<Map<String, Object>> executeSql(Map<String, Object> paramRoot, String sqlTemplate, IConnPool connTool) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        try {
            conn = connTool.getConnection(conn);
            ArrayList<String> param = new ArrayList<String>();
            Pattern paramRegex = Pattern.compile("(\\$\\{\\S+\\})");
            Matcher m = paramRegex.matcher(sqlTemplate);
            ArrayList<String> finds = new ArrayList<String>();
            while (m.find()) {
                finds.add(m.group(1));
            }
            String sql = m.replaceAll("?");
            for (String f : finds) {
                String val = ExpressionUtil.parse((String)f, paramRoot);
                param.add(val);
            }
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < param.size(); ++i) {
                    ps.setObject(i + 1, param.get(i));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    Map obj = POJOUtils.generateMap((ResultSet)rs);
                    resultList.add(obj);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("executeSql is wrong {}", e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("sql\u6821\u9a8c\u63d2\u4ef6\u6267\u884c {} \u5f02\u5e38 {}", new Object[]{sqlTemplate, e.getMessage(), e});
            throw new RuntimeException(String.format("sql\u6821\u9a8c\u63d2\u4ef6\u6267\u884c %s \u5f02\u5e38 %s", sqlTemplate, e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return resultList;
    }
}

