/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.FlowConfSourceRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.FlowConfSourceDO;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfSourceService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfSourceDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.Project;
import org.springframework.stereotype.Service;

@Service(value="flowConfSourceServiceImpl")
public class FlowConfSourceServiceImpl
extends BaseServiceImpl<FlowConfSourceDTO, FlowConfSourceDO, FlowConfSourceRepository>
implements FlowConfSourceService {
    public List<String> fetchRepoBranches(FlowConfSourceDTO param) {
        if (StringUtils.equals((CharSequence)param.getRepoType(), (CharSequence)"git")) {
            String repoUrl = param.getRepoUrl();
            String userName = param.getUserName();
            String userPwd = param.getUserPwd();
            String gitHostUrl = repoUrl.substring(0, repoUrl.indexOf("/", 8));
            GitLabApi gitLabApi = new GitLabApi(gitHostUrl, userPwd);
            ProjectApi prjApi = gitLabApi.getProjectApi();
            RepositoryApi repositoryApi = gitLabApi.getRepositoryApi();
            try {
                String projectPath = repoUrl.replace(gitHostUrl, "").replace(".git", "");
                String group = projectPath.substring(projectPath.indexOf("/") + 1, projectPath.lastIndexOf("/"));
                String projectName = projectPath.substring(projectPath.lastIndexOf("/") + 1);
                Project prj = prjApi.getProject(group, projectName);
                List branchList = repositoryApi.getBranches((Object)prj);
                return branchList.stream().map(Branch::getName).collect(Collectors.toList());
            }
            catch (GitLabApiException e) {
                throw new RuntimeException("\u83b7\u53d6\u4ed3\u5e93\u5206\u652f\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), e);
            }
        }
        return Collections.emptyList();
    }
}

