/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.web.controller.api;

import com.irdstudio.allinflow.deliver.console.facade.FlowConfStageService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfStageDTO;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FlowConfStageController
extends BaseController<FlowConfStageDTO, FlowConfStageService> {
    @RequestMapping(value={"/api/flow/conf/stages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowConfStageDTO>> queryFlowConfStageAll(FlowConfStageDTO dto) {
        List outputVo = ((FlowConfStageService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stages/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowConfStageDTO>> queryList(FlowConfStageDTO dto) {
        List outputVo = ((FlowConfStageService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stage/{stageId}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FlowConfStageDTO> queryByPk(@PathVariable(value="stageId") String stageId, @PathVariable(value="batchId") String batchId) {
        FlowConfStageDTO inVo = new FlowConfStageDTO();
        inVo.setStageId(stageId);
        inVo.setBatchId(batchId);
        FlowConfStageDTO outputVo = (FlowConfStageDTO)((FlowConfStageService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stage"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FlowConfStageDTO inFlowConfStageDTO) {
        int outputVo = ((FlowConfStageService)this.getService()).deleteByPk((Object)inFlowConfStageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stage"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FlowConfStageDTO inFlowConfStageDTO) {
        int outputVo = ((FlowConfStageService)this.getService()).updateByPk((Object)inFlowConfStageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFlowConfStage(@RequestBody FlowConfStageDTO inFlowConfStageDTO) {
        if (StringUtils.isBlank((CharSequence)inFlowConfStageDTO.getStageId())) {
            inFlowConfStageDTO.setStageId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((FlowConfStageService)this.getService()).insert((Object)inFlowConfStageDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/conf/stage/saveStage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveStage(@RequestBody List<FlowConfStageDTO> input) {
        int output = 0;
        if (CollectionUtils.isNotEmpty(input)) {
            for (int i = 0; i < input.size(); ++i) {
                FlowConfStageDTO stage = input.get(i);
                this.setUserInfoToVO(input);
                stage.setStageOrder(Integer.valueOf(i + 1));
                if (StringUtils.isBlank((CharSequence)stage.getStageId())) {
                    stage.setStageId(UUIDUtil.getShortUUID());
                    output += ((FlowConfStageService)this.getService()).insert((Object)stage);
                    continue;
                }
                int re = ((FlowConfStageService)this.getService()).updateByPk((Object)stage);
                if (re != 0) continue;
                output += ((FlowConfStageService)this.getService()).insert((Object)stage);
            }
        }
        return this.getResponseData(output);
    }
}

