/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.consolse.web.controller.util;

import com.irdstudio.allinflow.flow.console.facade.dto.gram.FlowDocumentJson;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.FlowNodeJson;
import com.irdstudio.allinflow.flow.console.facade.dto.gram.WorkflowEdgeJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSheetHandle {
    public static Logger logger = LoggerFactory.getLogger(FlowSheetHandle.class);
    public static final String START = "start";
    public static final String END = "end";

    private FlowSheetHandle() {
    }

    public static String analyzeAndVerify(FlowDocumentJson flowDocumentJson) {
        FlowNodeJson flowNodeJson;
        if (CollectionUtils.isEmpty((Collection)flowDocumentJson.getNodes())) {
            return "\u8282\u70b9\u6570\u636e\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)flowDocumentJson.getEdges())) {
            return "\u8fde\u7ebf\u6570\u636e\u4e3a\u7a7a";
        }
        long startCount = flowDocumentJson.getNodes().stream().filter(node -> START.equals(node.getType())).count();
        if (startCount == 0L) {
            return "\u4e0d\u5b58\u5728\u5f00\u59cb\u8282\u70b9";
        }
        long endCount = flowDocumentJson.getNodes().stream().filter(node -> END.equals(node.getType())).count();
        if (endCount == 0L) {
            return "\u4e0d\u5b58\u5728\u7ed3\u675f\u8282\u70b9";
        }
        if (flowDocumentJson.getNodes().size() == 2) {
            return "\u4e0d\u5b58\u5728\u7ec4\u4ef6\u8282\u70b9";
        }
        HashSet nodeIds = new HashSet();
        HashMap nodesMap = new HashMap();
        flowDocumentJson.getNodes().forEach(node -> {
            nodeIds.add(node.getId());
            nodesMap.put(node.getId(), node);
        });
        HashSet sourceNodeIds = new HashSet();
        HashSet targetNodeIds = new HashSet();
        flowDocumentJson.getEdges().forEach(edge -> {
            sourceNodeIds.add(edge.getSourceNodeID());
            targetNodeIds.add(edge.getTargetNodeID());
        });
        for (String nodeId : nodeIds) {
            if (sourceNodeIds.contains(nodeId)) continue;
            flowNodeJson = (FlowNodeJson)nodesMap.get(nodeId);
            if (START.equals(flowNodeJson.getType())) {
                return "\u5f00\u59cb\u8282\u70b9\u6ca1\u6709\u8fde\u7ebf";
            }
            if (END.equals(flowNodeJson.getType())) continue;
            String preTip = null;
            if (flowNodeJson.getData() != null) {
                String string = preTip = StringUtils.isNotBlank((String)flowNodeJson.getData().getTitle()) ? flowNodeJson.getData().getTitle() : flowNodeJson.getData().getContent();
            }
            if (StringUtils.isNotBlank(preTip)) {
                return "\u8282\u70b9\u3010" + preTip + "\u3011\u6ca1\u6709\u8fde\u7ebf";
            }
            return "\u5b58\u5728\u6ca1\u6709\u8fde\u7ebf\u7684\u8282\u70b9";
        }
        for (String nodeId : nodeIds) {
            if (targetNodeIds.contains(nodeId) || START.equals((flowNodeJson = (FlowNodeJson)nodesMap.get(nodeId)).getType())) continue;
            if (END.equals(flowNodeJson.getType())) {
                return "\u7ed3\u675f\u8282\u70b9\u6ca1\u6709\u88ab\u8fde\u7ebf";
            }
            String preTip = null;
            if (flowNodeJson.getData() != null) {
                String string = preTip = StringUtils.isNotBlank((String)flowNodeJson.getData().getTitle()) ? flowNodeJson.getData().getTitle() : flowNodeJson.getData().getContent();
            }
            if (StringUtils.isNotBlank(preTip)) {
                return "\u8282\u70b9\u3010" + preTip + "\u3011\u6ca1\u6709\u88ab\u8fde\u7ebf";
            }
            return "\u5b58\u5728\u6ca1\u6709\u88ab\u8fde\u7ebf\u7684\u8282\u70b9";
        }
        return null;
    }

    public static String isSettingCpn(FlowDocumentJson flowDocumentJson) {
        for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
            boolean b1 = !START.equals(flowNodeJson.getType()) && !END.equals(flowNodeJson.getType());
            if (!b1 || !StringUtils.isBlank((String)flowNodeJson.getData().getCpnId())) continue;
            return "\u8282\u70b9\u3010" + flowNodeJson.getData().getTitle() + "\u3011\u6ca1\u6709\u8bbe\u7f6e\u7ec4\u4ef6";
        }
        return null;
    }

    public static void nodeToOrder(FlowDocumentJson flowDocumentJson) {
        HashMap<String, List<String>> graph = new HashMap<String, List<String>>();
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        for (FlowNodeJson flowNodeJson : flowDocumentJson.getNodes()) {
            graph.put(flowNodeJson.getId(), new ArrayList());
            inDegree.put(flowNodeJson.getId(), 0);
        }
        for (WorkflowEdgeJson edge : flowDocumentJson.getEdges()) {
            String from = edge.getSourceNodeID();
            String to = edge.getTargetNodeID();
            ((List)graph.get(from)).add(to);
            inDegree.put(to, (Integer)inDegree.get(to) + 1);
        }
        List<String> sortedNodes = FlowSheetHandle.topologicalSort(graph, inDegree);
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        int n = 0;
        for (String id : sortedNodes) {
            orderMap.put(id, n++);
        }
        flowDocumentJson.getNodes().forEach(node -> {
            if (!START.equals(node.getType()) && !END.equals(node.getType())) {
                node.getData().setNodeOrder((Integer)orderMap.get(node.getId()));
            }
        });
    }

    public static List<String> topologicalSort(Map<String, List<String>> graph, Map<String, Integer> inDegree) {
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : inDegree.entrySet()) {
            if (entry.getValue() != 0) continue;
            queue.add(entry.getKey());
        }
        while (!queue.isEmpty()) {
            String current = (String)queue.poll();
            result.add(current);
            for (String next : graph.get(current)) {
                inDegree.put(next, inDegree.get(next) - 1);
                if (inDegree.get(next) != 0) continue;
                queue.add(next);
            }
        }
        if (result.size() != graph.size()) {
            logger.error("\u8be5\u56fe\u5177\u6709\u5faa\u73af\uff0c\u65e0\u6cd5\u8fdb\u884c\u62d3\u6251\u6392\u5e8f\u3002");
        }
        return result;
    }

    public static String newSheetVsOldSheet(FlowDocumentJson newJson, FlowDocumentJson oldJson) {
        if (newJson.getNodes().size() != oldJson.getNodes().size()) {
            return "\u65b0\u65e7\u6d41\u7a0b\u56fe\u8282\u70b9\u6570\u91cf\u4e0d\u4e00\u81f4\uff01";
        }
        if (newJson.getEdges().size() != oldJson.getEdges().size()) {
            return "\u65b0\u65e7\u6d41\u7a0b\u56fe\u8fde\u7ebf\u6570\u91cf\u4e0d\u4e00\u81f4\uff01";
        }
        HashMap oldMap = new HashMap();
        oldJson.getNodes().forEach(node -> oldMap.put(node.getId(), node));
        for (FlowNodeJson newJsonNode : newJson.getNodes()) {
            if (START.equals(newJsonNode.getType()) || END.equals(newJsonNode.getType())) continue;
            FlowNodeJson oldNode = (FlowNodeJson)oldMap.get(newJsonNode.getId());
            if (oldNode == null) {
                return "\u65e7\u6d41\u7a0b\u56fe\u4e0d\u5b58\u5728\u8282\u70b9\u3010" + newJsonNode.getId() + "\u3011\uff01";
            }
            if (newJsonNode.getData().getCpnId().equals(oldNode.getData().getCpnId())) continue;
            return "\u8282\u70b9\u3010" + newJsonNode.getData().getTitle() + "\u3011\u7ec4\u4ef6\u5df2\u53d8\u66f4\uff01";
        }
        HashSet edgesSet = new HashSet();
        oldJson.getEdges().forEach(node -> edgesSet.add(node.getSourceNodeID() + node.getTargetNodeID()));
        for (WorkflowEdgeJson newEdge : newJson.getEdges()) {
            String s = newEdge.getSourceNodeID() + newEdge.getTargetNodeID();
            if (edgesSet.contains(s)) continue;
            return "\u8fde\u7ebf\u51fa\u73b0\u53d8\u66f4";
        }
        return null;
    }
}

