/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.cpn.web.operation;

import com.irdstudio.allinflow.cpn.facade.operation.CpnConfNodeService;
import com.irdstudio.allinflow.cpn.facade.operation.PluginConfRouteBranchService;
import com.irdstudio.allinflow.cpn.facade.operation.dto.CpnConfNodeDTO;
import com.irdstudio.allinflow.cpn.facade.operation.dto.PluginConfRouteBranchDTO;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfNodeService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfNodeDTO;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PluginConfRouteBranchController
extends BaseController<PluginConfRouteBranchDTO, PluginConfRouteBranchService> {
    @Autowired
    private PluginConfRouteBranchService pluginConfRouteBranchService;
    @Autowired
    private FlowConfNodeService flowConfNodeService;
    @Autowired
    private CpnConfNodeService cpnConfNodeService;

    @RequestMapping(value={"/api/CpnConfRouteBranch/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginConfRouteBranchDTO>> queryList(PluginConfRouteBranchDTO input) {
        List output = this.pluginConfRouteBranchService.queryByCondition(input);
        if ("cpn".equals(input.getFlagType()) && CollectionUtils.isNotEmpty((Collection)output)) {
            for (PluginConfRouteBranchDTO pluginConfRouteBranchDTO : output) {
                CpnConfNodeDTO cpnConfNodeDTO = new CpnConfNodeDTO();
                cpnConfNodeDTO.setNodeId(pluginConfRouteBranchDTO.getTargetNodeId());
                if ((cpnConfNodeDTO = (CpnConfNodeDTO)this.cpnConfNodeService.queryByPk((Object)cpnConfNodeDTO)) == null) continue;
                pluginConfRouteBranchDTO.setTargetNodeName(cpnConfNodeDTO.getNodeName());
            }
        }
        if ("busi".equals(input.getFlagType()) && CollectionUtils.isNotEmpty((Collection)output)) {
            for (PluginConfRouteBranchDTO pluginConfRouteBranchDTO : output) {
                FlowConfNodeDTO flowConfNodeDTO = this.flowConfNodeService.queryByTaskId(pluginConfRouteBranchDTO.getTargetNodeId());
                if (flowConfNodeDTO == null) continue;
                pluginConfRouteBranchDTO.setTargetNodeName(flowConfNodeDTO.getTaskName());
            }
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnConfRouteBranch/getBranchId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> getBranchId() {
        String branchId = UUIDUtil.getShortUUID();
        return this.getResponseData(branchId);
    }

    @RequestMapping(value={"/api/CpnConfRouteBranch/queryByInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PluginConfRouteBranchDTO> queryByInfo(@RequestBody PluginConfRouteBranchDTO input) {
        PluginConfRouteBranchDTO output = this.pluginConfRouteBranchService.queryByInfo(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnConfRouteBranch/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insert(@RequestBody PluginConfRouteBranchDTO input) {
        int output = this.pluginConfRouteBranchService.insertInfo(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnConfRouteBranch/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> update(@RequestBody PluginConfRouteBranchDTO input) {
        int output = this.pluginConfRouteBranchService.updateInfo(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/CpnConfRouteBranch/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PluginConfRouteBranchDTO input) {
        int outputVo = this.pluginConfRouteBranchService.deleteCpnConfRouteBranch(input);
        return this.getResponseData(outputVo);
    }
}

