/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.ModelUmlInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelUmlNodeRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelUmlInfoDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelUmlNodeDO;
import com.irdstudio.allinrdm.dam.console.facade.ModelUmlInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelUmlInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allintcp.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelUmlInfoServiceImpl")
public class ModelUmlInfoServiceImpl
extends BaseServiceImpl<ModelUmlInfoDTO, ModelUmlInfoDO, ModelUmlInfoRepository>
implements ModelUmlInfoService {
    @Autowired
    private ModelUmlNodeRepository modelUmlNodeRepository;
    @Autowired
    private SeqInstInfoRepository seqInstInfoRepository;

    public int insert(ModelUmlInfoDTO paramDTO) {
        if (StringUtils.isBlank((CharSequence)paramDTO.getUmlModelId())) {
            String umlModelId = this.seqInstInfoRepository.nextSequence("UML-MODEL-SEQ", new String[]{paramDTO.getSubsId()});
            if (paramDTO.getOrderValue() == null) {
                paramDTO.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)StringUtils.substring((String)umlModelId, (int)(umlModelId.length() - 5)))));
            }
            paramDTO.setUmlModelId(umlModelId);
        }
        return super.insert((BaseInfo)paramDTO);
    }

    public int batchInsert(List<ModelUmlInfoDTO> paramDTOList) {
        if (CollectionUtils.isNotEmpty(paramDTOList)) {
            for (ModelUmlInfoDTO model : paramDTOList) {
                if (!StringUtils.isBlank((CharSequence)model.getUmlModelId())) continue;
                String umlModelId = this.seqInstInfoRepository.nextSequence("UML-MODEL-SEQ", new String[]{model.getSubsId()});
                if (model.getOrderValue() == null) {
                    model.setOrderValue(Integer.valueOf(NumberUtils.toInt((String)StringUtils.substring((String)umlModelId, (int)(umlModelId.length() - 5)))));
                }
                model.setUmlModelId(umlModelId);
            }
        }
        return super.batchInsert(paramDTOList);
    }

    public int deleteByPk(ModelUmlInfoDTO paramDTO) {
        ModelUmlNodeDO delNode = new ModelUmlNodeDO();
        delNode.setUmlModelId(paramDTO.getUmlModelId());
        this.modelUmlNodeRepository.deleteByCond(delNode);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public boolean validate(ModelUmlInfoDTO paramDTO) {
        boolean flag = true;
        paramDTO.setModelStat(ModelStat.Validated.getCode());
        this.updateByPk((BaseInfo)paramDTO);
        return flag;
    }
}

