/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.AppModelTreeRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.AppModelTreeDO;
import com.irdstudio.allinrdm.dev.console.facade.AppModelTreeService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppModelTreeDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="appModelTreeService")
public class AppModelTreeServiceImpl
extends BaseServiceImpl<AppModelTreeDTO, AppModelTreeDO, AppModelTreeRepository>
implements AppModelTreeService {
    public EasyUITreeData queryTreeData(String appId, AppModelTreeDTO appModelTreeVo) {
        EasyUITreeData treeData = null;
        String parentId = "0";
        try {
            appModelTreeVo.setAppId(appId);
            appModelTreeVo.setSize(Integer.valueOf(Integer.MAX_VALUE));
            AppModelTreeDO queryAppModelTree = new AppModelTreeDO();
            queryAppModelTree.setAppId(appId);
            this.beanCopy(appModelTreeVo, queryAppModelTree);
            List dataList = ((AppModelTreeRepository)this.getRepository()).queryList((Object)queryAppModelTree);
            if (dataList != null && dataList.size() > 0) {
                List resultList = this.beansCopy(dataList, AppModelTreeDTO.class);
                treeData = new EasyUITreeData();
                treeData.setId(parentId);
                treeData.setText("\u5e94\u7528\u4e1a\u52a1\u6a21\u578b");
                treeData.setState("open");
                treeData.setAttributes(new HashMap());
                this.getChildrenTreeData(treeData, resultList);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u76ee\u5f55\u6811\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01{}", (Throwable)e);
        }
        return treeData;
    }

    public List<EasyUITreeData> queryTreeDataWithSingle(String appId, AppModelTreeDTO appModelTreeVo) {
        try {
            List<Object> dataList = new ArrayList<AppModelTreeDTO>();
            if (StringUtils.isNotEmpty((CharSequence)appModelTreeVo.getAppModelCatalogs())) {
                String[] catalogs;
                for (String catalog : catalogs = StringUtils.split((String)appModelTreeVo.getAppModelCatalogs(), (String)",")) {
                    appModelTreeVo.setAppModelCatalog(catalog);
                    appModelTreeVo.setAppId(appId);
                    AppModelTreeDO queryAppModelTree = new AppModelTreeDO();
                    this.beanCopy(appModelTreeVo, queryAppModelTree);
                    queryAppModelTree.setAppId(appId);
                    List list = ((AppModelTreeRepository)this.getRepository()).queryList((Object)queryAppModelTree);
                    if (list == null) continue;
                    List resultList = this.beansCopy(list, AppModelTreeDTO.class);
                    dataList.addAll(resultList);
                }
            } else {
                appModelTreeVo.setAppId(appId);
                AppModelTreeDO queryAppModelTree = new AppModelTreeDO();
                this.beanCopy(appModelTreeVo, queryAppModelTree);
                List list = ((AppModelTreeRepository)this.getRepository()).queryList((Object)queryAppModelTree);
                dataList = this.beansCopy(list, AppModelTreeDTO.class);
            }
            return this.getChildrenTreeData(null, dataList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u76ee\u5f55\u6811\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01{}", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Integer deleteByCond(AppModelTreeDTO param) {
        return ((AppModelTreeRepository)this.getRepository()).deleteByCond((AppModelTreeDO)this.beanCopy(param, AppModelTreeDO.class));
    }

    private List<EasyUITreeData> getChildrenTreeData(EasyUITreeData treeData, List<AppModelTreeDTO> dataList) {
        HashMap<String, EasyUITreeData> nodeMap = new HashMap<String, EasyUITreeData>(dataList.size());
        for (AppModelTreeDTO treeVo : dataList) {
            EasyUITreeData easyUITreeData = new EasyUITreeData();
            easyUITreeData.setId(treeVo.getPackageId());
            easyUITreeData.setText(treeVo.getPackageName());
            easyUITreeData.setpId(treeVo.getPackageAbvId());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("package_code", treeVo.getPackageCode());
            attributes.put("app_model_catalog", treeVo.getAppModelCatalog());
            attributes.put("pType", "page");
            easyUITreeData.setAttributes(attributes);
            nodeMap.put(easyUITreeData.getId(), easyUITreeData);
        }
        if (treeData != null) {
            nodeMap.put(treeData.getId(), treeData);
        }
        EasyUITreeData child = null;
        ArrayList<EasyUITreeData> root = new ArrayList<EasyUITreeData>();
        for (AppModelTreeDTO treeVo : dataList) {
            EasyUITreeData parent = (EasyUITreeData)nodeMap.get(treeVo.getPackageAbvId());
            if (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList());
                }
                child = (EasyUITreeData)nodeMap.get(treeVo.getPackageId());
                parent.getChildren().add(child);
                parent.getAttributes().put("pType", "dir");
                parent.setState("closed");
                continue;
            }
            child = (EasyUITreeData)nodeMap.get(treeVo.getPackageId());
            root.add(child);
        }
        if (root.size() > 0) {
            ((EasyUITreeData)root.get(0)).setState("open");
        }
        return root;
    }
}

