/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.SrvModelConditionRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.SrvModelConditionDO;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelConditionService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelConditionDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="srvModelConditionServiceImpl")
public class SrvModelConditionServiceImpl
extends BaseServiceImpl<SrvModelConditionDTO, SrvModelConditionDO, SrvModelConditionRepository>
implements SrvModelConditionService {
    public int deleteByRefId(SrvModelConditionDTO inSrvModelConditionDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inSrvModelConditionDTO);
        int num = 0;
        try {
            SrvModelConditionDO srvModelCondition = new SrvModelConditionDO();
            this.beanCopy(inSrvModelConditionDTO, srvModelCondition);
            num = ((SrvModelConditionRepository)this.getRepository()).deleteByRefId(srvModelCondition);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inSrvModelConditionDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int saveCondList(List<SrvModelConditionDTO> condList, String userId) {
        logger.debug("\u5f53\u524d\u6570\u636e:" + condList.size());
        int num = 0;
        try {
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            if (CollectionUtils.isNotEmpty(condList)) {
                for (SrvModelConditionDTO cond : condList) {
                    if (StringUtils.isBlank((CharSequence)cond.getCondId())) {
                        cond.setCondId(UUIDUtil.getUUID());
                    }
                    cond.setCreateUser(userId);
                    cond.setCreateTime(nowTime);
                    SrvModelConditionDO srvModelCondition = new SrvModelConditionDO();
                    this.beanCopy(cond, srvModelCondition);
                    SrvModelConditionDO checkObj = (SrvModelConditionDO)((SrvModelConditionRepository)this.getRepository()).queryByPk((Object)srvModelCondition);
                    if (checkObj == null) {
                        num += ((SrvModelConditionRepository)this.getRepository()).insert((Object)srvModelCondition);
                        continue;
                    }
                    num += ((SrvModelConditionRepository)this.getRepository()).updateByPk((Object)srvModelCondition);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return num;
    }
}

