/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectUserRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTaskAttachRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTaskInfoRepository;
import com.irdstudio.allinrdm.project.console.application.service.utils.Pinyin4jUtil;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectUserDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmRelationInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTaskInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ProjectRole;
import com.irdstudio.allinrdm.project.console.types.RdmPriority;
import com.irdstudio.allinrdm.project.console.types.TaskCategory;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnBaseInfoDO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SUserDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.DateUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmTaskInfoServiceImpl")
public class RdmTaskInfoServiceImpl
extends BaseServiceImpl<RdmTaskInfoDTO, RdmTaskInfoDO, RdmTaskInfoRepository>
implements RdmTaskInfoService {
    @Autowired
    AllinCloudPortalClient portalClient;
    @Autowired
    protected RdmProjectUserRepository rdmProjectUserRepository;
    @Autowired
    protected FnBaseInfoRepository fnBaseInfoRepository;
    @Autowired
    protected RdmTaskAttachRepository rdmTaskAttachRepository;
    @Autowired
    protected RdmRelationInfoRepository rdmRelationInfoRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Task, moduleCode="rdm", bizKey="${args[0].taskId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TaskCategory', dynamicLog.moduleCode(), args[0].taskCategory)} #${args[0].taskId} ${args[0].taskName}")
    public int insert(RdmTaskInfoDTO inRdmTaskInfoDTO) {
        if (StringUtils.isNotBlank((CharSequence)inRdmTaskInfoDTO.getIncharge()) && StringUtils.isBlank((CharSequence)inRdmTaskInfoDTO.getDispatcher())) {
            inRdmTaskInfoDTO.setDispatcher(inRdmTaskInfoDTO.getLoginUserId());
            inRdmTaskInfoDTO.setDispatcherName(inRdmTaskInfoDTO.getLoginUserName());
        }
        if (inRdmTaskInfoDTO.getTaskEstWorkload() != null) {
            inRdmTaskInfoDTO.setTaskEstAvgWorkload(this.calcAvgWorkload(inRdmTaskInfoDTO.getTaskStarted(), inRdmTaskInfoDTO.getTaskDeadline(), inRdmTaskInfoDTO.getTaskEstWorkload()));
        }
        if (inRdmTaskInfoDTO.getTaskRealWorkload() != null) {
            inRdmTaskInfoDTO.setTaskRealAvgWorkload(this.calcAvgWorkload(inRdmTaskInfoDTO.getTaskStarted(), inRdmTaskInfoDTO.getTaskFinished(), inRdmTaskInfoDTO.getTaskRealWorkload()));
        }
        this.rdmTaskAttachRepository.updateRefIdToNew(inRdmTaskInfoDTO.getAll(), inRdmTaskInfoDTO.getTaskId());
        this.rdmRelationInfoRepository.updateByRelationId("taskId", inRdmTaskInfoDTO.getAll(), inRdmTaskInfoDTO.getTaskId());
        return super.insert((BaseInfo)inRdmTaskInfoDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Task, moduleCode="rdm", bizKey="${args[0].taskId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TaskCategory', dynamicLog.moduleCode(), args[0].taskCategory)} #${args[0].taskId} ${args[0].taskName}")
    public int deleteByPk(RdmTaskInfoDTO inRdmTaskInfoDTO) {
        return super.deleteByPk((BaseInfo)inRdmTaskInfoDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Task, moduleCode="rdm", bizKey="${args[0].taskId}")
    public int updateByPk(RdmTaskInfoDTO inRdmTaskInfoDTO) {
        RdmTaskInfoDTO oldData = (RdmTaskInfoDTO)this.queryByPk((BaseInfo)inRdmTaskInfoDTO);
        inRdmTaskInfoDTO.setOldData((Object)oldData);
        if (StringUtils.isNotBlank((CharSequence)inRdmTaskInfoDTO.getIncharge()) && StringUtils.isBlank((CharSequence)inRdmTaskInfoDTO.getDispatcher())) {
            inRdmTaskInfoDTO.setDispatcher(inRdmTaskInfoDTO.getLoginUserId());
            inRdmTaskInfoDTO.setDispatcherName(inRdmTaskInfoDTO.getLoginUserName());
        }
        if (inRdmTaskInfoDTO.getTaskEstWorkload() != null) {
            inRdmTaskInfoDTO.setTaskEstAvgWorkload(this.calcAvgWorkload(inRdmTaskInfoDTO.getTaskStarted(), inRdmTaskInfoDTO.getTaskDeadline(), inRdmTaskInfoDTO.getTaskEstWorkload()));
        }
        if (inRdmTaskInfoDTO.getTaskRealWorkload() != null) {
            inRdmTaskInfoDTO.setTaskRealAvgWorkload(this.calcAvgWorkload(inRdmTaskInfoDTO.getTaskStarted(), inRdmTaskInfoDTO.getTaskFinished(), inRdmTaskInfoDTO.getTaskRealWorkload()));
        }
        return super.updateByPk((BaseInfo)inRdmTaskInfoDTO);
    }

    private BigDecimal calcAvgWorkload(String startDate, String endDate, BigDecimal workload) {
        BigDecimal avgWorkload = null;
        try {
            int days = DateUtility.getBetweenDays((String)startDate, (String)endDate);
            avgWorkload = workload.divide(new BigDecimal(days), RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u644a\u9500\u5de5\u65f6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        return avgWorkload;
    }

    public String queryMaxId() {
        return ((RdmTaskInfoRepository)this.getRepository()).queryMaxId();
    }

    public List<Map<String, Object>> queryTaskSummary(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        return ((RdmTaskInfoRepository)this.getRepository()).queryTaskSummary(paramDO);
    }

    public List<Map<String, Object>> queryRdmTaskSummaryByPage(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        return ((RdmTaskInfoRepository)this.getRepository()).queryRdmTaskSummaryByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmTaskInchargeGroupByPage(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        List result = ((RdmTaskInfoRepository)this.getRepository()).queryRdmTaskInchargeGroupByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }

    public List<Map<String, Object>> queryHomeTaskSummary(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        return ((RdmTaskInfoRepository)this.getRepository()).queryHomeTaskSummary(paramDO);
    }

    public List<Map<String, Object>> queryRdmTaskWorkloadTimeByPage(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        List result = ((RdmTaskInfoRepository)this.getRepository()).queryRdmTaskWorkloadTimeByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }

    public List<Map<String, Object>> queryRdmTaskWorkloadUserByPage(RdmTaskInfoDTO paramDTO) {
        RdmTaskInfoDO paramDO = (RdmTaskInfoDO)this.beanCopy(paramDTO, RdmTaskInfoDO.class);
        List result = ((RdmTaskInfoRepository)this.getRepository()).queryRdmTaskWorkloadUserByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }

    public int batchUpdateTask(String userId, String subsId, String projectId, List<RdmTaskInfoDTO> taskUpdateList) {
        if (CollectionUtils.isEmpty(taskUpdateList)) {
            return 0;
        }
        int outputVo = 0;
        SUserDTO userParam = new SUserDTO();
        List userList = this.portalClient.querySUserList(userParam);
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        userList.forEach(user -> {
            userNameMap.put(user.getActorname(), user.getActorno());
            userNameMap.put(user.getActorno(), user.getActorno());
        });
        HashMap<String, RdmProjectUserDO> teamMap = new HashMap<String, RdmProjectUserDO>();
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            RdmProjectUserDO teamParam = new RdmProjectUserDO();
            teamParam.setProjectId(projectId);
            List teamList = this.rdmProjectUserRepository.queryList((Object)teamParam);
            if (CollectionUtils.isNotEmpty((Collection)teamList)) {
                teamList.forEach(member -> teamMap.put(member.getUserId(), (RdmProjectUserDO)member));
            }
        }
        String now = CurrentDateUtil.getTodayDateEx2();
        ArrayList<SUserDTO> needAddUserList = new ArrayList<SUserDTO>();
        ArrayList<RdmProjectUserDO> needAddMemberList = new ArrayList<RdmProjectUserDO>();
        ArrayList<FnBaseInfoDO> fnBaseList = new ArrayList<FnBaseInfoDO>();
        for (RdmTaskInfoDTO task : taskUpdateList) {
            this.checkTeamMemberUserAndCreate(task, projectId, userId, now, userNameMap, teamMap, needAddUserList, needAddMemberList);
            if (StringUtils.isNotBlank((CharSequence)task.getFpId())) {
                FnBaseInfoDO fn = new FnBaseInfoDO();
                fn.setFpId(task.getFpId());
                if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_B.getCode())) {
                    fn.setDesignRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                } else if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_C.getCode())) {
                    fn.setDevRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                }
                fnBaseList.add(fn);
            }
            task.setTaskCategory(null);
            int re = this.updateByPk(task);
            if (re <= 0) continue;
            ++outputVo;
        }
        if (CollectionUtils.isNotEmpty(needAddUserList)) {
            this.portalClient.batchSUserList(needAddUserList);
        }
        if (CollectionUtils.isNotEmpty(needAddMemberList)) {
            this.rdmProjectUserRepository.batchInsert(needAddMemberList);
        }
        if (CollectionUtils.isNotEmpty(fnBaseList)) {
            this.fnBaseInfoRepository.batchUpdate(fnBaseList);
        }
        return outputVo;
    }

    public String createTaskFromFp(RdmTaskInfoDTO param) {
        FnBaseInfoDO fnParam = new FnBaseInfoDO();
        fnParam.setProjectId(param.getProjectId());
        fnParam.setSubsId(param.getSubsId());
        fnParam.setFilterCond(param.getFilterCond());
        List fnList = this.fnBaseInfoRepository.queryList((Object)fnParam);
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            String projectId = param.getProjectId();
            String planId = param.getPlanId();
            String taskCategory = param.getTaskCategory();
            String taskType = param.getTaskType();
            String taskStarted = param.getTaskStarted();
            String taskDeadline = param.getTaskDeadline();
            String incharge = param.getIncharge();
            String inchargeName = param.getInchargeName();
            String userId = param.getLoginUserId();
            String userName = param.getLoginUserName();
            String now = CurrentDateUtil.getTodayDateEx2();
            String workloadType = param.getWorkloadType();
            ArrayList relationList = new ArrayList();
            List taskList = fnList.stream().map(fn -> {
                RdmTaskInfoDO task = new RdmTaskInfoDO();
                task.setProjectId(projectId);
                task.setTaskId(seqService.nextSequence("RDM-TSK-SEQ", projectId));
                task.setTaskCategory(taskCategory);
                task.setTaskType(taskType);
                task.setPlanId(planId);
                task.setTaskStarted(taskStarted);
                task.setTaskDeadline(taskDeadline);
                task.setIncharge(incharge);
                task.setInchargeName(inchargeName);
                task.setCreateUser(userId);
                task.setCreateTime(now);
                task.setLastUpdateUser(userId);
                task.setLastUpdateTime(now);
                task.setTaskName(fn.getFpName());
                task.setTaskContent(fn.getFpDesc());
                task.setFpId(fn.getFpId());
                if (StringUtils.equals((CharSequence)workloadType, (CharSequence)"designWorkload")) {
                    task.setTaskEstWorkload(fn.getDesignWorkload());
                    task.setTaskState(fn.getDesignState());
                } else if (StringUtils.equals((CharSequence)workloadType, (CharSequence)"devWorkload")) {
                    task.setTaskEstWorkload(fn.getDevWorkload());
                    task.setTaskState(fn.getDevState());
                } else if (StringUtils.equals((CharSequence)workloadType, (CharSequence)"testingWorkload")) {
                    task.setTaskEstWorkload(fn.getTestingWorkload());
                    task.setTaskState(fn.getTestingState());
                } else if (StringUtils.equals((CharSequence)workloadType, (CharSequence)"testingWorkload")) {
                    task.setTaskEstWorkload(fn.getTestingWorkload());
                    task.setTaskState(fn.getTestingState());
                }
                task.setTaskRemark(fn.getRemark());
                if (StringUtils.isNotBlank((CharSequence)task.getIncharge()) && StringUtils.isBlank((CharSequence)task.getDispatcher())) {
                    task.setDispatcher(userId);
                    task.setDispatcherName(userName);
                }
                if (task.getTaskEstWorkload() != null) {
                    task.setTaskEstAvgWorkload(this.calcAvgWorkload(task.getTaskStarted(), task.getTaskDeadline(), task.getTaskEstWorkload()));
                }
                if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_A.getCode())) {
                    fn.setDesignRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                } else if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_B.getCode())) {
                    fn.setDevRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                }
                RdmRelationInfoDO relation = new RdmRelationInfoDO();
                relation.setRelId(UUIDUtil.getShortUUID());
                relation.setTaskId(task.getTaskId());
                relation.setFpId(fn.getFpId());
                relationList.add(relation);
                return task;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(taskList)) {
                ((RdmTaskInfoRepository)this.getRepository()).batchInsert(taskList);
            }
            if (CollectionUtils.isNotEmpty((Collection)fnList)) {
                this.fnBaseInfoRepository.batchUpdate(fnList);
            }
            if (CollectionUtils.isNotEmpty(relationList)) {
                this.rdmRelationInfoRepository.batchInsert(relationList);
            }
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Task, moduleCode="rdm")
    public Integer deleteByCond(RdmTaskInfoDTO param) {
        return ((RdmTaskInfoRepository)this.getRepository()).deleteByCond((RdmTaskInfoDO)this.beanCopy(param, RdmTaskInfoDO.class));
    }

    public boolean saveExcel(String userId, String subsId, String projectId, String objectiveId, List<RdmTaskInfoDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            SUserDTO userParam = new SUserDTO();
            List userList = this.portalClient.querySUserList(userParam);
            HashMap<String, String> userNameMap = new HashMap<String, String>();
            userList.forEach(user -> {
                userNameMap.put(user.getActorname(), user.getActorno());
                userNameMap.put(user.getActorno(), user.getActorno());
            });
            HashMap<String, RdmProjectUserDO> teamMap = new HashMap<String, RdmProjectUserDO>();
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                RdmProjectUserDO teamParam = new RdmProjectUserDO();
                teamParam.setTeamId(projectId);
                List teamList = this.rdmProjectUserRepository.queryList((Object)teamParam);
                if (CollectionUtils.isNotEmpty((Collection)teamList)) {
                    teamList.forEach(member -> teamMap.put(member.getUserId(), (RdmProjectUserDO)member));
                }
            }
            String now = CurrentDateUtil.getTodayDateEx2();
            String nowDay = CurrentDateUtil.getTodayDate();
            ArrayList<SUserDTO> needAddUserList = new ArrayList<SUserDTO>();
            ArrayList<RdmProjectUserDO> needAddMemberList = new ArrayList<RdmProjectUserDO>();
            ArrayList<FnBaseInfoDO> fnBaseList = new ArrayList<FnBaseInfoDO>();
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            for (RdmTaskInfoDTO task : list) {
                this.checkTeamMemberUserAndCreate(task, projectId, userId, now, userNameMap, teamMap, needAddUserList, needAddMemberList);
                task.setTaskPriority(RdmPriority.Normal.getCode());
                if (StringUtils.equalsAny((CharSequence)task.getTaskState(), (CharSequence[])new CharSequence[]{TaskState.Done.getCode(), TaskState.OverdueDone.getCode()}) && StringUtils.isBlank((CharSequence)task.getTaskFinished())) {
                    task.setTaskFinished(task.getTaskDeadline());
                }
                task.setSubsId(subsId);
                task.setProjectId(projectId);
                task.setPlanId(objectiveId);
                task.setTaskId(seqService.nextSequence("RDM-TSK-SEQ", task.getProjectId()));
                if (!StringUtils.isNotBlank((CharSequence)task.getFpId())) continue;
                FnBaseInfoDO fn = new FnBaseInfoDO();
                fn.setFpId(task.getFpId());
                if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_B.getCode())) {
                    fn.setDesignRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                } else if (StringUtils.equals((CharSequence)task.getTaskCategory(), (CharSequence)TaskCategory.Task_C.getCode())) {
                    fn.setDevRef(YesOrNO.YES.getCode());
                    fn.setUpdateUser(userId);
                    fn.setUpdateTime(now);
                }
                fnBaseList.add(fn);
            }
            this.batchInsert(list);
            if (CollectionUtils.isNotEmpty(needAddUserList)) {
                this.portalClient.batchSUserList(needAddUserList);
            }
            if (CollectionUtils.isNotEmpty(needAddMemberList)) {
                this.rdmProjectUserRepository.batchInsert(needAddMemberList);
            }
            if (CollectionUtils.isNotEmpty(fnBaseList)) {
                this.fnBaseInfoRepository.batchUpdate(fnBaseList);
            }
        }
        return true;
    }

    private void checkTeamMemberUserAndCreate(RdmTaskInfoDTO task, String projectId, String userId, String now, Map<String, String> userNameMap, Map<String, RdmProjectUserDO> teamMap, List<SUserDTO> needAddUserList, List<RdmProjectUserDO> needAddMemberList) {
        RdmProjectUserDO devMember;
        SUserDTO addUser;
        String newactorno;
        int addition;
        String actorno;
        if (userNameMap.get(task.getInchargeName()) != null) {
            task.setIncharge(userNameMap.get(task.getInchargeName()));
        } else if (StringUtils.isNotBlank((CharSequence)task.getInchargeName())) {
            actorno = Pinyin4jUtil.getFirstSpellPinYin(task.getInchargeName(), false);
            addition = 1;
            newactorno = actorno;
            while (userNameMap.get(newactorno) != null) {
                newactorno = actorno + addition;
                ++addition;
            }
            actorno = newactorno;
            addUser = new SUserDTO();
            addUser.setActorname(task.getInchargeName());
            addUser.setActorno(actorno);
            needAddUserList.add(addUser);
            task.setIncharge(actorno);
            userNameMap.put(addUser.getActorname(), addUser.getActorno());
            userNameMap.put(addUser.getActorno(), addUser.getActorno());
        }
        if (userNameMap.get(task.getCollaboratorName()) != null) {
            task.setCollaborator(userNameMap.get(task.getCollaboratorName()));
        } else if (StringUtils.isNotBlank((CharSequence)task.getCollaboratorName())) {
            actorno = Pinyin4jUtil.getFirstSpellPinYin(task.getCollaboratorName(), false);
            addition = 1;
            newactorno = actorno;
            while (userNameMap.get(newactorno) != null) {
                newactorno = actorno + addition;
                ++addition;
            }
            actorno = newactorno;
            addUser = new SUserDTO();
            addUser.setActorname(task.getCollaboratorName());
            addUser.setActorno(actorno);
            needAddUserList.add(addUser);
            task.setCollaborator(actorno);
            userNameMap.put(addUser.getActorname(), addUser.getActorno());
            userNameMap.put(addUser.getActorno(), addUser.getActorno());
        }
        if (teamMap.get(task.getIncharge()) == null && StringUtils.isNotBlank((CharSequence)task.getIncharge())) {
            devMember = new RdmProjectUserDO();
            devMember.setUserId(task.getIncharge());
            devMember.setUserName(task.getInchargeName());
            devMember.setTeamId(projectId);
            devMember.setProjectId(projectId);
            devMember.setCreateUser(userId);
            devMember.setCreateTime(now);
            devMember.setUserRole(ProjectRole.Normal.getCode());
            devMember.setBlockFlag(YesOrNO.NO.getCode());
            devMember.setJoinDate(task.getTaskStarted());
            needAddMemberList.add(devMember);
            teamMap.put(devMember.getUserId(), devMember);
        }
        if (teamMap.get(task.getCollaborator()) == null && StringUtils.isNotBlank((CharSequence)task.getCollaborator())) {
            devMember = new RdmProjectUserDO();
            devMember.setUserId(task.getCollaborator());
            devMember.setUserName(task.getCollaboratorName());
            devMember.setTeamId(projectId);
            devMember.setProjectId(projectId);
            devMember.setCreateUser(userId);
            devMember.setCreateTime(now);
            devMember.setUserRole(ProjectRole.Normal.getCode());
            devMember.setBlockFlag(YesOrNO.NO.getCode());
            devMember.setJoinDate(task.getTaskStarted());
            needAddMemberList.add(devMember);
            teamMap.put(devMember.getUserId(), devMember);
        }
    }
}

