/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmTeamInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTeamInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmTeamInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTeamInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.ssm.web.audit.AuditOperate;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmTeamInfoServiceImpl")
public class RdmTeamInfoServiceImpl
extends BaseServiceImpl<RdmTeamInfoDTO, RdmTeamInfoDO, RdmTeamInfoRepository>
implements RdmTeamInfoService {
    private Pattern pattern = Pattern.compile("\\w+?(\\d++)");

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].teamId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TeamType', dynamicLog.moduleCode(), args[0].teamType)} #${args[0].teamId} ${args[0].teamName}")
    @AuditOperate(action=AuditOperate.Action.Add, auditType="T", bizKey="${args[0].teamId}", bizName="${args[0].teamName}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TeamType', dynamicLog.moduleCode(), args[0].teamType)} #${args[0].teamId} ${args[0].teamName}")
    public int insert(RdmTeamInfoDTO paramDO) {
        if (StringUtils.isBlank((CharSequence)paramDO.getTeamId())) {
            SeqInstInfoRepository seqInstInfoRepository = (SeqInstInfoRepository)SpringContextUtils.getBean(SeqInstInfoRepository.class);
            paramDO.setTeamId(seqInstInfoRepository.nextSequence("TEAM-ID", new String[0]));
        }
        return super.insert((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].teamId}")
    @AuditOperate(action=AuditOperate.Action.Update, auditType="T", bizKey="${args[0].teamId}", bizName="${args[0].teamName}")
    public int updateByPk(RdmTeamInfoDTO paramDO) {
        RdmTeamInfoDTO oldData = (RdmTeamInfoDTO)this.queryByPk((BaseInfo)paramDO);
        paramDO.setOldData((Object)oldData);
        return super.updateByPk((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].teamId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TeamType', dynamicLog.moduleCode(), args[0].teamType)} #${args[0].teamId} ${args[0].teamName}")
    @AuditOperate(action=AuditOperate.Action.Delete, auditType="T", bizKey="${args[0].teamId}", bizName="${args[0].teamName}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('TeamType', dynamicLog.moduleCode(), args[0].teamType)} #${args[0].teamId} ${args[0].teamName}")
    public int deleteByPk(RdmTeamInfoDTO paramDO) {
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public String queryMaxId(String teamType) {
        String id = ((RdmTeamInfoRepository)this.getRepository()).queryMaxId(teamType);
        if (StringUtils.isBlank((CharSequence)id)) {
            return String.format("%s%s", teamType, StringUtils.leftPad((String)"1", (int)4, (String)"0"));
        }
        Matcher m = this.pattern.matcher(id);
        String numStr = "";
        numStr = m.matches() ? m.group(1) : StringUtils.substring((String)id, (int)(id.length() - 4));
        int num = NumberUtils.toInt((String)numStr, (int)0);
        return String.format("%s%s", teamType, StringUtils.leftPad((String)(++num + ""), (int)4, (String)"0"));
    }

    public List<Map<String, Object>> querySummary(RdmTeamInfoDTO paramDTO) {
        RdmTeamInfoDO paramDO = (RdmTeamInfoDO)this.beanCopy(paramDTO, RdmTeamInfoDO.class);
        return ((RdmTeamInfoRepository)this.getRepository()).querySummary(paramDO);
    }

    public List<Map<String, Object>> queryWXTeamSummary(RdmTeamInfoDTO paramDTO) {
        RdmTeamInfoDO paramDO = (RdmTeamInfoDO)this.beanCopy(paramDTO, RdmTeamInfoDO.class);
        return ((RdmTeamInfoRepository)this.getRepository()).queryWXTeamSummary(paramDO);
    }

    public List<Map<String, Object>> queryTeamGroupByPage(RdmTeamInfoDTO paramDTO) {
        RdmTeamInfoDO paramDO = (RdmTeamInfoDO)this.beanCopy(paramDTO, RdmTeamInfoDO.class);
        return ((RdmTeamInfoRepository)this.getRepository()).queryTeamGroupByPage(paramDO);
    }
}

