/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.utils;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Pinyin4jUtil {
    public static String getFirstSpellPinYin(String src, boolean isFullSpell) {
        String targetStr = Pinyin4jUtil.makeStringByStringSet(Pinyin4jUtil.getPinyin(src, isFullSpell));
        String[] split = targetStr.split(",");
        if (split.length > 1) {
            targetStr = split[0];
        }
        return targetStr;
    }

    public static String makeStringByStringSet(Set<String> stringSet) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        if (stringSet.size() > 0) {
            for (String s : stringSet) {
                if (i == stringSet.size() - 1) {
                    str.append(s);
                } else {
                    str.append(s + ",");
                }
                ++i;
            }
        }
        return str.toString().toLowerCase();
    }

    public static Set<String> getPinyin(String src, boolean isFullSpell) {
        if (src != null && !src.trim().equalsIgnoreCase("")) {
            char[] srcChar = src.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            String[][] temp = new String[src.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)srcChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                        if (isFullSpell) continue;
                        if (i == 0) {
                            temp[i] = temp[i];
                            continue;
                        }
                        String[] tTemps = new String[temp[i].length];
                        for (int j = 0; j < temp[i].length; ++j) {
                            char t = temp[i][j].charAt(0);
                            tTemps[j] = Character.toString(t);
                        }
                        temp[i] = tTemps;
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
            }
            String[] pingyinArray = Pinyin4jUtil.exchange(temp);
            HashSet<String> pinyinSet = new HashSet<String>();
            for (int i = 0; i < pingyinArray.length; ++i) {
                pinyinSet.add(pingyinArray[i]);
            }
            return pinyinSet;
        }
        return null;
    }

    public static String[] exchange(String[][] strJaggedArray) {
        String[][] temp = Pinyin4jUtil.doExchange(strJaggedArray);
        return temp[0];
    }

    private static String[][] doExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int Index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[Index] = strJaggedArray[0][i] + strJaggedArray[1][j];
                    ++Index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return Pinyin4jUtil.doExchange(newArray);
        }
        return strJaggedArray;
    }

    public static void main(String[] args) {
        String first1 = Pinyin4jUtil.getFirstSpellPinYin("\u6d4b\u8bd5\u4e2d\u6587", true);
        String first2 = Pinyin4jUtil.getFirstSpellPinYin("\u6d4b\u8bd5\u4e2d\u6587", false);
        System.out.println(first1);
        System.out.println(first2);
    }
}

