/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableFieldRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableFieldDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.DictItemInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictItemInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.allinrdm.dam.console.types.DataMarkFlag;
import com.irdstudio.allinrdm.dam.console.types.DataStdFlag;
import com.irdstudio.allinrdm.dev.console.facade.SrvFieldFlagService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvFieldFlagDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelTableFieldService")
public class ModelTableFieldServiceImpl
extends BaseServiceImpl<ModelTableFieldDTO, ModelTableFieldDO, ModelTableFieldRepository>
implements ModelTableFieldService {
    @Autowired
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    private DictItemInfoService dictItemInfoService;
    @Autowired
    private SrvFieldFlagService srvFieldFlagService;
    private static final Integer JAVA_DBMS_ID = 901;

    public int updateByPk(ModelTableFieldDTO inModelTableFieldDTO, boolean updateFieldName) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inModelTableFieldDTO.toString());
        int num = 0;
        try {
            ModelTableFieldDO modelTableField = new ModelTableFieldDO();
            this.beanCopy(inModelTableFieldDTO, modelTableField);
            ModelTableFieldDO oldField = (ModelTableFieldDO)((ModelTableFieldRepository)this.getRepository()).queryByPk((Object)modelTableField);
            num = ((ModelTableFieldRepository)this.getRepository()).updateByPk((Object)modelTableField);
            if (modelTableField.getMiddleDataType() != null && modelTableField.getMiddleDataType() > 0 && oldField.getMiddleDataType() != modelTableField.getMiddleDataType()) {
                PubDbmsDatatypeDTO dbmsDataParam = new PubDbmsDatatypeDTO();
                dbmsDataParam.setDbmsId(JAVA_DBMS_ID);
                dbmsDataParam.setDatatypeId(modelTableField.getMiddleDataType());
                List javaDatas = this.pubDbmsDatatypeService.queryListByPage((Object)dbmsDataParam);
                if (CollectionUtils.isNotEmpty((Collection)javaDatas)) {
                    PubDbmsDatatypeDTO javaData = (PubDbmsDatatypeDTO)javaDatas.get(0);
                    modelTableField.setJavaDataType(javaData.getDbmsDatatypeCode());
                }
            }
            if (StringUtils.isNotBlank((String)inModelTableFieldDTO.getSrvModelCatalog()) && StringUtils.isNotBlank((String)inModelTableFieldDTO.getSrvModelType())) {
                SrvFieldFlagDTO fieldFlag = new SrvFieldFlagDTO();
                fieldFlag.setFieldId(modelTableField.getFieldId());
                fieldFlag.setObjectId(modelTableField.getObjectId());
                fieldFlag.setSrvModelType(inModelTableFieldDTO.getSrvModelType());
                fieldFlag.setSrvModelCatalog(inModelTableFieldDTO.getSrvModelCatalog());
                fieldFlag.setFieldFlag(inModelTableFieldDTO.getFieldFlag());
                this.srvFieldFlagService.insert((Object)fieldFlag);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inModelTableFieldDTO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateOsrvEvalIsrvFieldCode(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).updateOsrvEvalIsrvFieldCode(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int updateIsrvValidateRuleFieldCode(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).updateIsrvValidateRuleFieldCode(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int updateOsrvEvalIsrvFieldName(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).updateOsrvEvalIsrvFieldName(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int updateIsrvValidateRuleFieldName(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisurlFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).updateIsrvValidateRuleFieldName(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int updateBatchFieldInfo(List<ModelTableFieldDTO> list) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u6570\u91cf\u4e3a:" + list.size());
        int num = 0;
        try {
            List doList = this.beansCopy(list, ModelTableFieldDO.class);
            num = ((ModelTableFieldRepository)this.getRepository()).updateBatchFieldInfo(doList);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateBatchFieldInfoOnly(List<ModelTableFieldDTO> list) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u6570\u91cf\u4e3a:" + list.size());
        int num = 0;
        try {
            List doList = this.beansCopy(list, ModelTableFieldDO.class);
            num = ((ModelTableFieldRepository)this.getRepository()).updateBatchFieldInfoOnly(doList);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateFieldByPk(ModelTableFieldDTO inModelTableFieldDTO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inModelTableFieldDTO.toString());
        int num = 0;
        try {
            ModelTableFieldDO modelTableField = new ModelTableFieldDO();
            this.beanCopy(inModelTableFieldDTO, modelTableField);
            num = ((ModelTableFieldRepository)this.getRepository()).updateByPk((Object)modelTableField);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<ModelTableFieldDTO> queryFieldBySysCodeByPage(ModelTableInfoDTO modelTableInfo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO tableParamDO = new ModelTableInfoDO();
            this.beanCopy(modelTableInfo, tableParamDO);
            List modelTableFields = ((ModelTableFieldRepository)this.getRepository()).queryFieldBySysCodeByPage(tableParamDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableFieldDTO> batchQueryInoutPkFieldList(List<String> inoutObjectIds, String fieldFlag, String isPk) {
        List list = null;
        try {
            List modelTableFields = ((ModelTableFieldRepository)this.getRepository()).batchQueryInoutPkFieldList(inoutObjectIds, fieldFlag, isPk);
            list = this.beansCopy(modelTableFields, ModelTableFieldDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableFieldDTO> queryInoutFieldsByPage(ModelTableFieldDTO fieldParam) {
        List doList = ((ModelTableFieldRepository)this.getRepository()).queryInoutFieldsByPage((ModelTableFieldDO)this.beanCopy(fieldParam, ModelTableFieldDO.class));
        return this.beansCopy(doList, ModelTableFieldDTO.class);
    }

    public List<ModelTableFieldDTO> queryModelTableFieldAllOptions(String appId) {
        List list = ((ModelTableFieldRepository)this.getRepository()).queryModelTableFieldAllOptions(appId);
        return this.beansCopy(list, ModelTableFieldDTO.class);
    }

    public int getCurrentOrderValue(String objectId) {
        int maxValue = ((ModelTableFieldRepository)this.getRepository()).getCurrentOrderValue(objectId);
        return maxValue + 1;
    }

    public int fieldSortUp(String fieldId) {
        return ((ModelTableFieldRepository)this.getRepository()).fieldSortUp(fieldId);
    }

    public int doExchange(String sourceId, String targetId) {
        int num = 0;
        ModelTableFieldDO modelTableField = new ModelTableFieldDO();
        try {
            modelTableField.setFieldId(sourceId);
            ModelTableFieldDO source = (ModelTableFieldDO)((ModelTableFieldRepository)this.getRepository()).queryByPk((Object)modelTableField);
            modelTableField.setFieldId(targetId);
            ModelTableFieldDO target = (ModelTableFieldDO)((ModelTableFieldRepository)this.getRepository()).queryByPk((Object)modelTableField);
            int mid = source.getFieldOrder();
            source.setFieldOrder(target.getFieldOrder());
            target.setFieldOrder(Integer.valueOf(mid));
            ((ModelTableFieldRepository)this.getRepository()).updateByPk((Object)source);
            ((ModelTableFieldRepository)this.getRepository()).updateByPk((Object)target);
            num = 2;
        }
        catch (Exception e) {
            logger.error("\u4ea4\u6362\u987a\u5e8f\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int fieldSortDown(String fieldId) {
        return ((ModelTableFieldRepository)this.getRepository()).fieldSortDown(fieldId);
    }

    public int updateFieldInfoWithItem(String appId, int projectDbms) {
        logger.debug("\u66f4\u65b0\u8868\u6a21\u578b\u5e93\u4e0b\u6240\u6709\u5b57\u6bb5\u7c7b\u578b\u76f8\u5173\u7684\u4fe1\u606f:{},{}", (Object)appId, (Object)projectDbms);
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).updateFieldInfoWithItem(appId, projectDbms);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u66f4\u65b0\u8868\u6a21\u578b\u5e93\u4e0b\u6240\u6709\u5b57\u6bb5\u7c7b\u578b\u76f8\u5173\u7684\u4fe1\u606f\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByObjectId(String objectId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + objectId);
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).deleteByObjectId(objectId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + objectId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByObjectIds(List<String> objectIds) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + objectIds);
        int num = 0;
        try {
            num = ((ModelTableFieldRepository)this.getRepository()).deleteByObjectIds(objectIds);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + objectIds + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int copyModelTableField(String objectId, String targetObjectId) {
        int num = ((ModelTableFieldRepository)this.getRepository()).copyModelTableField(objectId, targetObjectId);
        return num;
    }

    public int mergeModelTableField(String objectId, String srcObjectId) {
        return ((ModelTableFieldRepository)this.getRepository()).mergeModelTableField(objectId, srcObjectId);
    }

    public List<ModelTableFieldDTO> queryByItemId(String itemId) {
        logger.debug("\u67e5\u8be2\u6570\u636e\u6761\u76ee{}\u6240\u5f15\u7528\u7684\u5b57\u6bb5\u4fe1\u606f!", (Object)itemId);
        List list = Collections.emptyList();
        try {
            List modelTableFields = ((ModelTableFieldRepository)this.getRepository()).queryByItemId(itemId);
            logger.debug("\u67e5\u8be2\u6570\u636e\u6761\u76ee{}\u6240\u5f15\u7528\u7684\u5b57\u6bb5\u6570\u91cf\u4e3a{}" + itemId, (Object)modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public Integer fieldRefactorByObjectId(String objectId, String dataMarkFlag, String dslId, String userId) {
        try {
            String now = CurrentDateUtil.getTodayDateEx2();
            ModelTableFieldDTO modelTableFieldPO = new ModelTableFieldDTO();
            modelTableFieldPO.setObjectId(objectId);
            modelTableFieldPO.setItemIdNotNull(Boolean.valueOf(true));
            ArrayList newList = new ArrayList();
            DataMarkFlag markFlag = DataMarkFlag.getByCode((String)dataMarkFlag);
            if (markFlag == null) {
                markFlag = DataMarkFlag.TypeToPrecision;
            }
            int num = 0;
            List list = this.queryList((BaseInfo)modelTableFieldPO);
            if (list.size() > 0) {
                List pubDbmsDatatypeDOS = this.pubDbmsDatatypeService.queryDbmsTypeByModelTableInfoObjectId(objectId);
                HashMap<String, String> pubDbmsDatMap = new HashMap<String, String>();
                for (PubDbmsDatatypeDTO pd : pubDbmsDatatypeDOS) {
                    pubDbmsDatMap.put(String.valueOf(pd.getDatatypeId()), pd.getDbmsDatatypeCode());
                }
                for (ModelTableFieldDTO field : list) {
                    if (StringUtils.equals((String)field.getDataStdFlag(), (String)DataStdFlag.NOT.getCode())) continue;
                    if (StringUtils.isEmpty((String)field.getDataMarkFlag()) || "\u672a\u843d\u6807".equals(field.getDataMarkFlag())) {
                        field.setPreFieldCode(field.getFieldCode());
                        field.setPreFieldLength(field.getFieldLength());
                        field.setPreFieldName(field.getFieldName());
                        field.setPreFieldType(field.getFieldType());
                        field.setPreFieldPrecision(field.getFieldPrecision());
                        field.setPreDictId(field.getDictId());
                    }
                    boolean needUpdate = false;
                    String fieldName = field.getFieldName();
                    DictItemInfoDTO matchItemInfo = new DictItemInfoDTO();
                    matchItemInfo.setItemId(field.getItemId());
                    matchItemInfo.setSubsId(dslId);
                    matchItemInfo = (DictItemInfoDTO)this.dictItemInfoService.queryByPk((Object)matchItemInfo);
                    if (matchItemInfo != null) {
                        String fieldType;
                        field.setItemCode(matchItemInfo.getItemCode());
                        field.setItemName(matchItemInfo.getItemName());
                        field.setItemId(matchItemInfo.getItemId());
                        field.setItemDslId(matchItemInfo.getSubsId());
                        field.setMiddleDataType(matchItemInfo.getItemDataType());
                        if (DataMarkFlag.NameToOption == markFlag) {
                            field.setFieldName(matchItemInfo.getItemName());
                        }
                        if (StringUtils.isNotBlank((String)(fieldType = (String)pubDbmsDatMap.get(String.valueOf(matchItemInfo.getItemDataType()))))) {
                            field.setFieldType(fieldType);
                        }
                        field.setFieldLength(matchItemInfo.getItemDataLength());
                        field.setFieldPrecision(matchItemInfo.getItemDataPrecision());
                        if ((DataMarkFlag.NameToOption == markFlag || DataMarkFlag.TypeToOption == markFlag) && StringUtils.isNotBlank((String)matchItemInfo.getDictId())) {
                            field.setDictId(matchItemInfo.getDictId());
                            field.setFieldOption(matchItemInfo.getDictCode());
                        }
                        field.setDataMarkFlag(markFlag.getCode());
                        needUpdate = true;
                    } else {
                        field.setItemId("");
                        field.setItemCode("");
                        field.setItemName("");
                        field.setDataMarkFlag("");
                        needUpdate = true;
                    }
                    if (!needUpdate) continue;
                    field.setFieldSelectFlag(Integer.valueOf(1));
                    field.setLastModifyUser(userId);
                    field.setLastModifyTime(now);
                    this.updateByPk(field, DataMarkFlag.NameToOption == markFlag);
                }
            }
            return num;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public List<ModelTableFieldDTO> queryExistsFieldByPage(ModelTableFieldDTO modelTableFieldDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableFieldDO modelTableFieldDO = new ModelTableFieldDO();
            this.beanCopy(modelTableFieldDTO, modelTableFieldDO);
            List modelTableFields = ((ModelTableFieldRepository)this.getRepository()).queryExistsFieldByPage(modelTableFieldDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableFieldDTO> queryFieldWithFieldFlag(String objectId, String srvModelCatalog, String srvModelType) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            List modelTableFields = ((ModelTableFieldRepository)this.getRepository()).queryFieldWithFieldFlag(objectId, srvModelCatalog, srvModelType);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int insert(ModelTableFieldDTO paramDTO) {
        if (paramDTO.getMiddleDataType() != null && paramDTO.getMiddleDataType() > 0) {
            PubDbmsDatatypeDTO dbmsDataParam = new PubDbmsDatatypeDTO();
            dbmsDataParam.setDbmsId(JAVA_DBMS_ID);
            dbmsDataParam.setDatatypeId(paramDTO.getMiddleDataType());
            List javaDatas = this.pubDbmsDatatypeService.queryListByPage((Object)dbmsDataParam);
            if (CollectionUtils.isNotEmpty((Collection)javaDatas)) {
                PubDbmsDatatypeDTO javaData = (PubDbmsDatatypeDTO)javaDatas.get(0);
                paramDTO.setJavaDataType(javaData.getDbmsDatatypeCode());
            }
        }
        if (StringUtils.isNotBlank((String)paramDTO.getSrvModelCatalog()) && StringUtils.isNotBlank((String)paramDTO.getSrvModelType())) {
            SrvFieldFlagDTO fieldFlag = new SrvFieldFlagDTO();
            fieldFlag.setFieldId(paramDTO.getFieldId());
            fieldFlag.setObjectId(paramDTO.getObjectId());
            fieldFlag.setSrvModelType(paramDTO.getSrvModelType());
            fieldFlag.setSrvModelCatalog(paramDTO.getSrvModelCatalog());
            fieldFlag.setFieldFlag(paramDTO.getFieldFlag());
            this.srvFieldFlagService.insert((Object)fieldFlag);
        }
        return ((ModelTableFieldRepository)this.getRepository()).insert((Object)((ModelTableFieldDO)this.beanCopy(paramDTO, ModelTableFieldDO.class)));
    }

    public String queryObjectCodeByFieldId(String fieldId) {
        return ((ModelTableFieldRepository)this.getRepository()).queryObjectCodeByFieldId(fieldId);
    }
}

