/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocExecutorService;
import com.irdstudio.allinapaas.portal.console.types.PubStdSwitchEnum;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelFolderInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableFieldRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableIndexRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableInfoRepository;
import com.irdstudio.allinrdm.dam.console.application.service.utils.CommonFields;
import com.irdstudio.allinrdm.dam.console.domain.entity.AnalysisIndexExcelDataDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableFieldDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableIndexDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisFieldExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisIndexExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisTableExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.allinrdm.dam.console.types.DataStdFlag;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.enums.PubStdYnEnum;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.db.enums.IndexType;
import com.irdstudio.sdk.beans.db.util.MyJdbcUtil;
import com.irdstudio.sdk.beans.db.vo.DBImportTableFieldVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableIndexVO;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelTableInfoService")
public class ModelTableInfoServiceImpl
extends BaseServiceImpl<ModelTableInfoDTO, ModelTableInfoDO, ModelTableInfoRepository>
implements ModelTableInfoService {
    @Autowired
    private ModelTableFieldRepository modelTableFieldRepository;
    @Autowired
    private ModelTableIndexRepository modelTableIndexRepository;
    @Autowired
    private ModelFolderInfoRepository projectTmPackageRepository;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private PaasEcsInfoService paasEcsInfoService;
    @Autowired
    private PaasDocExecutorService paasDocExecutorService;

    public int deleteByTableModelIds(List<String> tableModelIds) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + tableModelIds);
        int num = 0;
        try {
            num = ((ModelTableInfoRepository)this.getRepository()).deleteByTableModelIds(tableModelIds);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + tableModelIds + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<ModelTableInfoDTO> queryAllIsolateTableByPage(ModelTableInfoDTO modelTableInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(modelTableInfoDTO, modelTableInfoDO);
            List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllIsolateTable(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableInfoDTO> queryAllIsolateTable(ModelTableInfoDTO modelTableInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(modelTableInfoDTO, modelTableInfoDO);
            List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllIsolateTable(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableInfoDTO> queryListWithSrvByPage(ModelTableInfoDTO modelTableInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(modelTableInfoDTO, modelTableInfoDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryListWithSrvByPage(modelTableInfoDO);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        return list;
    }

    public List<ModelTableInfoDTO> queryAllByProject(String appId) {
        logger.debug("\u6839\u636e\u5de5\u7a0b\u6807\u8bc6[{}]\u67e5\u8be2\u5de5\u7a0b\u4e0b\u6240\u6709\u8868\u6a21\u578b\u4fe1\u606f...", (Object)appId);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllByProject(appId);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableFieldDTO> queryAllByItemId(ModelTableFieldDTO paramVO) {
        logger.debug("\u6839\u636e\u6761\u76ee\u6807\u8bc6[{}]\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f...", (Object)paramVO.getItemId());
        ModelTableFieldDO modelTableFieldDO = new ModelTableFieldDO();
        this.beanCopy(paramVO, modelTableFieldDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllByItemId(modelTableFieldDO);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        return this.beansCopy(modelTableInfos, ModelTableFieldDTO.class);
    }

    public List<ModelTableInfoDTO> queryAllByDictId(String dictId) {
        logger.debug("\u6839\u636e\u9009\u9879\u6807\u8bc6[{}]\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f...", (Object)dictId);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllByDictId(dictId);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        for (ModelTableInfoDO mti : modelTableInfos) {
            mti.setTotal(Integer.valueOf(modelTableInfos.size()));
        }
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableInfoDTO> queryAllByObjectCode(String objectCode) {
        List list = Collections.emptyList();
        logger.debug("\u6839\u636e\u5bf9\u8c61code\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f..." + objectCode);
        try {
            List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllByObjectCode(objectCode);
            logger.debug("\u67e5\u8be2\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<ModelTableInfoDTO> queryAllByTableInfo(ModelTableInfoDTO modelTableInfoVO) {
        logger.debug("\u6839\u636e\u5de5\u7a0b\u6807\u8bc6[{}]\u67e5\u8be2\u5de5\u7a0b\u4e0b\u6240\u6709\u8868\u6a21\u578b\u4fe1\u606f...", (Object)modelTableInfoVO.getAppId());
        ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(modelTableInfoVO, modelTableInfoDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllByTableInfo(modelTableInfoDO);
        logger.debug("\u3010 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public ModelTableInfoDTO copyModelTableInfo(ModelTableInfoDTO copyTable) {
        ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(copyTable, modelTableInfoDO);
        ModelTableInfoDO modelTable = ((ModelTableInfoRepository)this.getRepository()).copyModelTableInfo(modelTableInfoDO);
        return (ModelTableInfoDTO)this.beanCopy(modelTable, ModelTableInfoDTO.class);
    }

    private String trimBackquote(String str) {
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeStart((String)str, (String)"`");
        }
        if (StringUtils.endsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeEnd((String)str, (String)"`");
        }
        return str.toLowerCase();
    }

    public ModelTableInfoDTO createModelTableInfoBySQL(String subsId, String baAppId, String projectId, String packageId, String objectType, String userId, String sql) {
        String createTime = CurrentDateUtil.getTodayDateEx2();
        String createUser = userId;
        if (StringUtils.isBlank((CharSequence)sql)) {
            return null;
        }
        sql = sql.replaceFirst("##", "--");
        try {
            net.sf.jsqlparser.statement.Statement sqlParse = CCJSqlParserUtil.parse((String)sql);
            if (sqlParse instanceof CreateTable) {
                CreateTable createTb = (CreateTable)sqlParse;
                ModelTableInfoDTO newTable = new ModelTableInfoDTO();
                newTable.setObjectId(UUIDUtil.getUUID());
                newTable.setSubsId(subsId);
                newTable.setBaAppId(baAppId);
                newTable.setAppId(projectId);
                newTable.setFolderId(packageId);
                newTable.setObjectType(Integer.valueOf(objectType));
                newTable.setCreateUser(createUser);
                newTable.setCreateTime(createTime);
                newTable.setLastModifyUser(createUser);
                newTable.setLastModifyTime(createTime);
                newTable.setObjectCode(this.trimBackquote(createTb.getTable().getName()));
                if (createTb.getTableOptionsStrings() != null) {
                    for (int i = 0; i < createTb.getTableOptionsStrings().size(); ++i) {
                        String val = (String)createTb.getTableOptionsStrings().get(i);
                        if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 2 >= createTb.getTableOptionsStrings().size()) continue;
                        String comment = "";
                        comment = StringUtils.equals((CharSequence)((CharSequence)createTb.getTableOptionsStrings().get(i + 1)), (CharSequence)"=") ? (String)createTb.getTableOptionsStrings().get(i + 2) : (String)createTb.getTableOptionsStrings().get(i + 1);
                        comment = comment.replaceAll("'", "");
                        newTable.setObjectName(comment);
                        break;
                    }
                }
                if (StringUtils.isBlank((CharSequence)newTable.getObjectName())) {
                    newTable.setObjectName(newTable.getObjectCode());
                }
                this.insert((BaseInfo)newTable);
                ModelTableIndexDO primaryKey = null;
                if (createTb.getIndexes() != null) {
                    for (Index index : createTb.getIndexes()) {
                        ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                        modelTableIndex.setObjectId(newTable.getObjectId());
                        modelTableIndex.setCreateTime(createTime);
                        modelTableIndex.setCreateUser(createUser);
                        modelTableIndex.setIndexName(index.getName());
                        ArrayList indexCols = new ArrayList();
                        for (String col : index.getColumnsNames()) {
                            indexCols.add(this.trimBackquote(col));
                        }
                        modelTableIndex.setIndexFields(StringUtils.join((Iterable)indexCols, (String)",").toLowerCase());
                        if (index.getType().toUpperCase().startsWith("PRIMARY ")) {
                            modelTableIndex.setIndexTypePrimary("Y");
                            modelTableIndex.setIndexTypeUnique("N");
                            modelTableIndex.setIndexName(String.format("PK_%s", newTable.getObjectCode()).toUpperCase());
                            primaryKey = modelTableIndex;
                        } else if (index.getType().toUpperCase().startsWith("UNIQUE ")) {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("Y");
                            if (StringUtils.isBlank((CharSequence)index.getName())) {
                                modelTableIndex.setIndexName(String.format("UK_%s_%s", newTable.getObjectCode(), StringUtils.join((Iterable)indexCols, (String)"_")).toUpperCase());
                            }
                        } else {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("N");
                        }
                        this.modelTableIndexRepository.insert((Object)modelTableIndex);
                    }
                }
                if (createTb.getColumnDefinitions() != null) {
                    int order = 1;
                    ArrayList<ModelTableFieldDO> primaryKeys = new ArrayList<ModelTableFieldDO>();
                    ArrayList<ModelTableFieldDO> uniqueKeys = new ArrayList<ModelTableFieldDO>();
                    for (ColumnDefinition col : createTb.getColumnDefinitions()) {
                        ModelTableFieldDO field = new ModelTableFieldDO();
                        field.setFieldId(UUIDUtil.getUUID());
                        field.setObjectId(newTable.getObjectId());
                        field.setCreateUser(createUser);
                        field.setCreateTime(createTime);
                        field.setFieldCode(this.trimBackquote(col.getColumnName()));
                        field.setFieldOrder(Integer.valueOf(order++));
                        field.setIsAllowNull("Y");
                        if (col.getColumnSpecs() != null) {
                            for (int i = 0; i < col.getColumnSpecs().size(); ++i) {
                                String val = (String)col.getColumnSpecs().get(i);
                                if (val != null && val.equalsIgnoreCase("NOT") && ((String)col.getColumnSpecs().get(i + 1)).equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("N");
                                    ++i;
                                    continue;
                                }
                                if (val != null && val.equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("Y");
                                    continue;
                                }
                                if (val != null && val.equalsIgnoreCase("COMMENT") && i + 1 < col.getColumnSpecs().size()) {
                                    val = (String)col.getColumnSpecs().get(i + 1);
                                    val = val.replaceAll("'", "");
                                    field.setFieldName(val);
                                    field.setFieldDesc(val);
                                    ++i;
                                    continue;
                                }
                                if (StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"primary") && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)col.getColumnSpecs().get(i + 1)), (CharSequence)"key")) {
                                    field.setIsPk("Y");
                                    primaryKeys.add(field);
                                    continue;
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"unique") || !StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)col.getColumnSpecs().get(i + 1)), (CharSequence)"key")) continue;
                                uniqueKeys.add(field);
                            }
                        }
                        field.setFieldType(col.getColDataType().getDataType());
                        if (col.getColDataType().getArgumentsStringList() != null && col.getColDataType().getArgumentsStringList().size() > 0) {
                            String len = (String)col.getColDataType().getArgumentsStringList().get(0);
                            field.setFieldLength(Integer.valueOf(len));
                            if (col.getColDataType().getArgumentsStringList().size() > 1) {
                                field.setFieldPrecision(Integer.valueOf((String)col.getColDataType().getArgumentsStringList().get(1)));
                            }
                        }
                        if (primaryKey != null && primaryKey.getIndexFields().contains(field.getFieldCode().toLowerCase())) {
                            field.setIsPk("Y");
                        } else if (StringUtils.isBlank((CharSequence)field.getIsPk())) {
                            field.setIsPk("N");
                        }
                        field.setDataStdFlag(DataStdFlag.Auto.getCode());
                        this.modelTableFieldRepository.insert((Object)field);
                    }
                    if (CollectionUtils.isNotEmpty(primaryKeys)) {
                        ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                        modelTableIndex.setObjectId(newTable.getObjectId());
                        modelTableIndex.setCreateTime(createTime);
                        modelTableIndex.setCreateUser(createUser);
                        modelTableIndex.setIndexTypePrimary("Y");
                        modelTableIndex.setIndexTypeUnique("N");
                        modelTableIndex.setIndexFields(StringUtils.join((Iterable)primaryKeys.stream().map(ModelTableFieldDO::getFieldCode).collect(Collectors.toList()), (String)","));
                        modelTableIndex.setIndexName(String.format("PK_%s", newTable.getObjectCode()).toUpperCase());
                        this.modelTableIndexRepository.insert((Object)modelTableIndex);
                    }
                    if (CollectionUtils.isNotEmpty(uniqueKeys)) {
                        for (ModelTableFieldDO field : uniqueKeys) {
                            ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                            modelTableIndex.setObjectId(newTable.getObjectId());
                            modelTableIndex.setCreateTime(createTime);
                            modelTableIndex.setCreateUser(createUser);
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("Y");
                            modelTableIndex.setIndexFields(field.getFieldCode());
                            modelTableIndex.setIndexName(String.format("UK_%s_%S", newTable.getObjectCode(), field.getFieldCode()).toUpperCase());
                            this.modelTableIndexRepository.insert((Object)modelTableIndex);
                        }
                    }
                }
                return newTable;
            }
            logger.error("sql \u4e0d\u662fcreate table\u8bed\u6cd5 {}", (Object)sql);
            return null;
        }
        catch (JSQLParserException e) {
            logger.error("sql \u89e3\u6790\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql \u89e3\u6790\u5f02\u5e38", e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public ModelTableInfoDTO updateModelTableInfoBySQL(String appId, String objectId, String userId, String sql) {
        String createTime = CurrentDateUtil.getTodayDateEx2();
        String createUser = userId;
        if (StringUtils.isBlank((CharSequence)sql)) {
            return null;
        }
        sql = sql.replaceFirst("##", "--");
        try {
            net.sf.jsqlparser.statement.Statement sqlParse = CCJSqlParserUtil.parse((String)sql);
            if (sqlParse instanceof CreateTable) {
                CreateTable createTb = (CreateTable)sqlParse;
                ModelTableInfoDTO tableModel = new ModelTableInfoDTO();
                tableModel.setObjectId(objectId);
                tableModel = (ModelTableInfoDTO)this.queryByPk((BaseInfo)tableModel);
                if (tableModel == null) {
                    throw new RuntimeException("\u8868\u6a21\u578b\u67e5\u8be2\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
                }
                tableModel.setObjectCode(this.trimBackquote(createTb.getTable().getName()));
                if (createTb.getTableOptionsStrings() != null) {
                    for (int i = 0; i < createTb.getTableOptionsStrings().size(); ++i) {
                        String val = (String)createTb.getTableOptionsStrings().get(i);
                        if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 2 >= createTb.getTableOptionsStrings().size()) continue;
                        String comment = "";
                        comment = StringUtils.equals((CharSequence)((CharSequence)createTb.getTableOptionsStrings().get(i + 1)), (CharSequence)"=") ? (String)createTb.getTableOptionsStrings().get(i + 2) : (String)createTb.getTableOptionsStrings().get(i + 1);
                        comment = comment.replaceAll("'", "");
                        tableModel.setObjectName(comment);
                        break;
                    }
                }
                if (StringUtils.isBlank((CharSequence)tableModel.getObjectName())) {
                    tableModel.setObjectName(tableModel.getObjectCode());
                }
                this.updateByPk((BaseInfo)tableModel);
                ModelTableIndexDO primaryKey = null;
                if (createTb.getIndexes() != null) {
                    for (Index index : createTb.getIndexes()) {
                        int re;
                        ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                        modelTableIndex.setObjectId(tableModel.getObjectId());
                        modelTableIndex.setCreateTime(createTime);
                        modelTableIndex.setCreateUser(createUser);
                        modelTableIndex.setIndexName(index.getName());
                        ArrayList<String> indexCols = new ArrayList<String>();
                        for (String col : index.getColumnsNames()) {
                            indexCols.add(this.trimBackquote(col));
                        }
                        modelTableIndex.setIndexFields(StringUtils.join(indexCols, (String)",").toLowerCase());
                        if (index.getType().toUpperCase().startsWith("PRIMARY ")) {
                            modelTableIndex.setIndexTypePrimary("Y");
                            modelTableIndex.setIndexTypeUnique("N");
                            modelTableIndex.setIndexName(String.format("PK_%s", tableModel.getObjectCode()).toUpperCase());
                            primaryKey = modelTableIndex;
                        } else if (index.getType().toUpperCase().startsWith("UNIQUE ")) {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("Y");
                            if (StringUtils.isBlank((CharSequence)index.getName())) {
                                modelTableIndex.setIndexName(String.format("UK_%s_%s", tableModel.getObjectCode(), StringUtils.join(indexCols, (String)"_")).toUpperCase());
                            }
                        } else {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("N");
                        }
                        if ((re = this.modelTableIndexRepository.updateByPk((Object)modelTableIndex)) != 0) continue;
                        this.modelTableIndexRepository.insert((Object)modelTableIndex);
                    }
                }
                if (createTb.getColumnDefinitions() != null) {
                    int re;
                    ModelTableFieldDO fieldParam = new ModelTableFieldDO();
                    fieldParam.setObjectId(objectId);
                    List fieldList = this.modelTableFieldRepository.queryList((Object)fieldParam);
                    Map fieldMap = fieldList.stream().collect(Collectors.toMap(ModelTableFieldDO::getFieldCode, Function.identity()));
                    int order = 1;
                    ArrayList<ModelTableFieldDO> primaryKeys = new ArrayList<ModelTableFieldDO>();
                    ArrayList<ModelTableFieldDO> uniqueKeys = new ArrayList<ModelTableFieldDO>();
                    for (ColumnDefinition col : createTb.getColumnDefinitions()) {
                        ModelTableFieldDO field = new ModelTableFieldDO();
                        field.setFieldId(UUIDUtil.getUUID());
                        field.setObjectId(tableModel.getObjectId());
                        field.setCreateUser(createUser);
                        field.setCreateTime(createTime);
                        field.setFieldCode(this.trimBackquote(col.getColumnName()));
                        if (fieldMap.get(field.getFieldCode()) != null) {
                            field.setFieldId(((ModelTableFieldDO)fieldMap.get(field.getFieldCode())).getFieldId());
                        }
                        field.setFieldOrder(Integer.valueOf(order++));
                        field.setIsAllowNull("Y");
                        if (col.getColumnSpecs() != null) {
                            for (int i = 0; i < col.getColumnSpecs().size(); ++i) {
                                String val = (String)col.getColumnSpecs().get(i);
                                if (val != null && val.equalsIgnoreCase("NOT") && ((String)col.getColumnSpecs().get(i + 1)).equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("N");
                                    ++i;
                                    continue;
                                }
                                if (val != null && val.equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("Y");
                                    continue;
                                }
                                if (val != null && val.equalsIgnoreCase("COMMENT") && i + 1 < col.getColumnSpecs().size()) {
                                    val = (String)col.getColumnSpecs().get(i + 1);
                                    val = val.replaceAll("'", "");
                                    field.setFieldName(val);
                                    field.setFieldDesc(val);
                                    ++i;
                                    continue;
                                }
                                if (StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"primary") && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)col.getColumnSpecs().get(i + 1)), (CharSequence)"key")) {
                                    field.setIsPk("Y");
                                    primaryKeys.add(field);
                                    continue;
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"unique") || !StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)col.getColumnSpecs().get(i + 1)), (CharSequence)"key")) continue;
                                uniqueKeys.add(field);
                            }
                        }
                        field.setFieldType(col.getColDataType().getDataType());
                        if (col.getColDataType().getArgumentsStringList() != null && col.getColDataType().getArgumentsStringList().size() > 0) {
                            String len = (String)col.getColDataType().getArgumentsStringList().get(0);
                            field.setFieldLength(Integer.valueOf(len));
                            if (col.getColDataType().getArgumentsStringList().size() > 1) {
                                field.setFieldPrecision(Integer.valueOf((String)col.getColDataType().getArgumentsStringList().get(1)));
                            }
                        }
                        if (primaryKey != null && primaryKey.getIndexFields().contains(field.getFieldCode().toLowerCase())) {
                            field.setIsPk("Y");
                        } else if (StringUtils.isBlank((CharSequence)field.getIsPk())) {
                            field.setIsPk("N");
                        }
                        field.setDataStdFlag(DataStdFlag.Auto.getCode());
                        re = this.modelTableFieldRepository.updateByPk((Object)field);
                        if (re != 0) continue;
                        this.modelTableFieldRepository.insert((Object)field);
                    }
                    if (CollectionUtils.isNotEmpty(primaryKeys)) {
                        ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                        modelTableIndex.setObjectId(tableModel.getObjectId());
                        modelTableIndex.setCreateTime(createTime);
                        modelTableIndex.setCreateUser(createUser);
                        modelTableIndex.setIndexTypePrimary("Y");
                        modelTableIndex.setIndexTypeUnique("N");
                        modelTableIndex.setIndexFields(StringUtils.join((Iterable)primaryKeys.stream().map(ModelTableFieldDO::getFieldCode).collect(Collectors.toList()), (String)","));
                        modelTableIndex.setIndexName(String.format("PK_%s", tableModel.getObjectCode()).toUpperCase());
                        int re2 = this.modelTableIndexRepository.updateByPk((Object)modelTableIndex);
                        if (re2 == 0) {
                            this.modelTableIndexRepository.insert((Object)modelTableIndex);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(uniqueKeys)) {
                        for (ModelTableFieldDO field : uniqueKeys) {
                            ModelTableIndexDO modelTableIndex = new ModelTableIndexDO();
                            modelTableIndex.setObjectId(tableModel.getObjectId());
                            modelTableIndex.setCreateTime(createTime);
                            modelTableIndex.setCreateUser(createUser);
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("Y");
                            modelTableIndex.setIndexFields(field.getFieldCode());
                            modelTableIndex.setIndexName(String.format("UK_%s_%S", tableModel.getObjectCode(), field.getFieldCode()).toUpperCase());
                            re = this.modelTableIndexRepository.updateByPk((Object)modelTableIndex);
                            if (re != 0) continue;
                            this.modelTableIndexRepository.insert((Object)modelTableIndex);
                        }
                    }
                }
                return tableModel;
            }
            logger.error("sql \u4e0d\u662fcreate table\u8bed\u6cd5 {}", (Object)sql);
            return null;
        }
        catch (JSQLParserException e) {
            logger.error("sql \u89e3\u6790\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql \u89e3\u6790\u5f02\u5e38", e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public int mergeAppByProjectId(String originAppId, String targetAppId, List<Map<String, Object>> adjustContentList) {
        PaasAppsInfoDTO originProj = new PaasAppsInfoDTO();
        originProj.setAppId(originAppId);
        originProj = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)originProj);
        PaasAppsInfoDTO targetProj = new PaasAppsInfoDTO();
        targetProj.setAppId(targetAppId);
        targetProj = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)targetProj);
        return ((ModelTableInfoRepository)this.getRepository()).mergeAppByProjectId(originAppId, targetAppId);
    }

    public List<ModelTableInfoDTO> queryAllSubsModelTableInfoByPage(ModelTableInfoDTO modelTableInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(modelTableInfoDTO, modelTableInfoDO);
            List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryAllSubsModelTableInfoByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public AnalysisIndexExcelDataDTO querySysAnalysisIndexData(String subsId, String appId) {
        AnalysisIndexExcelDataDO data = ((ModelTableInfoRepository)this.getRepository()).querySysAnalysisIndexData(subsId, appId);
        return (AnalysisIndexExcelDataDTO)this.beanCopy(data, AnalysisIndexExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public List<AnalysisTableExcelDataDTO> querySysTableCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysTableCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisTableExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldMissNameCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldMissNameCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffNameCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldDiffNameCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffENCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldDiffENCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldDiffLenCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldDiffLenCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public List<AnalysisFieldExcelDataDTO> querySysFieldMessyNameCheckByPage(ModelTableInfoDTO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
            this.beanCopy(paramVO, modelTableInfoDO);
            list = ((ModelTableInfoRepository)this.getRepository()).querySysFieldMessyNameCheckByPage(modelTableInfoDO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return this.beansCopy(list, AnalysisFieldExcelDataDTO.class);
    }

    public int updateTableOrder(ModelTableInfoDTO tableInfo, boolean upFlag) {
        ModelTableInfoDO modelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(tableInfo, modelTableInfoDO);
        return ((ModelTableInfoRepository)this.getRepository()).updateTableOrder(modelTableInfoDO, upFlag);
    }

    public List<ModelTableInfoDTO> queryDsTableListByPage(ModelTableInfoDTO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            ModelTableInfoDO queryModelTableInfo = new ModelTableInfoDO();
            this.beanCopy(modelTableInfoVo, queryModelTableInfo);
            List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryDsTableListByPage(queryModelTableInfo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int deleteByAppId(ModelTableInfoDTO paramDTO) {
        return ((ModelTableInfoRepository)this.getRepository()).deleteByAppId((ModelTableInfoDO)this.beanCopy(paramDTO, ModelTableInfoDO.class));
    }

    public int updateModelTableInfoRefComId(ModelTableInfoDTO param) {
        return ((ModelTableInfoRepository)this.getRepository()).updateModelTableInfoRefComId((ModelTableInfoDO)this.beanCopy(param, ModelTableInfoDO.class));
    }

    public ModelTableInfoDTO checkCommonTableModel(String appId, String commonTableName) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO table = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, commonTableName);
        return (ModelTableInfoDTO)this.beanCopy(table, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generateIsrvRspInfo(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO isrvRsp = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "IsrvRspInfo");
        if (isrvRsp != null) {
            return (ModelTableInfoDTO)this.beanCopy(isrvRsp, new ModelTableInfoDTO());
        }
        isrvRsp = new ModelTableInfoDO();
        isrvRsp.setObjectCode("IsrvRspInfo");
        isrvRsp.setObjectName("\u670d\u52a1\u6267\u884c\u72b6\u6001\u5bf9\u8c61");
        isrvRsp.setObjectDesc("\u670d\u52a1\u6267\u884c\u72b6\u6001\u5bf9\u8c61");
        isrvRsp.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        isrvRsp.setAppId(appId);
        isrvRsp.setFolderId(appId);
        isrvRsp.setCreateUser("system");
        isrvRsp.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        isrvRsp.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)isrvRsp);
        ModelTableFieldDO rspCnt = new ModelTableFieldDO();
        rspCnt.setObjectId(isrvRsp.getObjectId());
        rspCnt.setFieldCode("rsp_cnt");
        rspCnt.setFieldName("\u5f71\u54cd\u8bb0\u5f55\u6761\u6570");
        rspCnt.setIsAllowNull(PubStdSwitchEnum.ON.getCode());
        rspCnt.setFieldDesc("\u5f71\u54cd\u8bb0\u5f55\u6761\u6570");
        rspCnt.setFieldType("300");
        this.modelTableFieldInsert(rspCnt);
        ModelTableFieldDO rspCode = new ModelTableFieldDO();
        rspCode.setObjectId(isrvRsp.getObjectId());
        rspCode.setFieldCode("rsp_code");
        rspCode.setFieldName("\u54cd\u5e94\u7801");
        rspCode.setIsAllowNull(PubStdSwitchEnum.ON.getCode());
        rspCode.setFieldDesc("\u54cd\u5e94\u7801");
        rspCode.setFieldType("100");
        rspCode.setFieldLength(Integer.valueOf(6));
        this.modelTableFieldInsert(rspCode);
        ModelTableFieldDO rspMsg = new ModelTableFieldDO();
        rspMsg.setObjectId(isrvRsp.getObjectId());
        rspMsg.setFieldCode("rsp_msg");
        rspMsg.setFieldName("\u54cd\u5e94\u4fe1\u606f");
        rspMsg.setIsAllowNull(PubStdSwitchEnum.ON.getCode());
        rspMsg.setFieldDesc("\u54cd\u5e94\u4fe1\u606f");
        rspMsg.setFieldType("200");
        rspMsg.setFieldLength(Integer.valueOf(128));
        this.modelTableFieldInsert(rspMsg);
        return (ModelTableInfoDTO)this.beanCopy(isrvRsp, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generateUserTokenInfo(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO userTokenInfo = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "UserTokenInfo");
        if (userTokenInfo != null) {
            return (ModelTableInfoDTO)this.beanCopy(userTokenInfo, new ModelTableInfoDTO());
        }
        userTokenInfo = new ModelTableInfoDO();
        userTokenInfo.setObjectCode("UserTokenInfo");
        userTokenInfo.setObjectName("\u4f1a\u8bdd\u4fe1\u606f\u5bf9\u8c61");
        userTokenInfo.setObjectDesc("\u4f1a\u8bdd\u4fe1\u606f\u5bf9\u8c61");
        userTokenInfo.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        userTokenInfo.setAppId(appId);
        userTokenInfo.setFolderId(appId);
        userTokenInfo.setCreateUser("system");
        userTokenInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        userTokenInfo.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)userTokenInfo);
        ModelTableFieldDO loginUserId = new ModelTableFieldDO();
        loginUserId.setObjectId(userTokenInfo.getObjectId());
        loginUserId.setFieldCode("loginUserId");
        loginUserId.setFieldName("\u5f53\u524d\u7528\u6237ID");
        loginUserId.setFieldDesc("\u5f53\u524d\u7528\u6237ID");
        loginUserId.setFieldType("200");
        loginUserId.setFieldLength(Integer.valueOf(100));
        loginUserId.setIsPk(YesOrNO.NO.getCode());
        loginUserId.setIsAllowNull(YesOrNO.YES.getCode());
        loginUserId.setFieldOrder(Integer.valueOf(1));
        this.modelTableFieldInsert(loginUserId);
        ModelTableFieldDO loginUserOrgCode = new ModelTableFieldDO();
        loginUserOrgCode.setObjectId(userTokenInfo.getObjectId());
        loginUserOrgCode.setFieldCode("loginUserOrgCode");
        loginUserOrgCode.setFieldName("\u5f53\u524d\u7528\u6237\u673a\u6784");
        loginUserOrgCode.setFieldDesc("\u5f53\u524d\u7528\u6237\u673a\u6784");
        loginUserOrgCode.setFieldType("200");
        loginUserOrgCode.setFieldLength(Integer.valueOf(100));
        loginUserOrgCode.setIsPk(YesOrNO.NO.getCode());
        loginUserOrgCode.setIsAllowNull(YesOrNO.YES.getCode());
        loginUserOrgCode.setFieldOrder(Integer.valueOf(2));
        this.modelTableFieldInsert(loginUserOrgCode);
        ModelTableFieldDO loginUserLeageOrgCode = new ModelTableFieldDO();
        loginUserLeageOrgCode.setObjectId(userTokenInfo.getObjectId());
        loginUserLeageOrgCode.setFieldCode("loginUserLeageOrgCode");
        loginUserLeageOrgCode.setFieldName("\u5f53\u524d\u7528\u6237\u6240\u5c5e\u673a\u6784");
        loginUserLeageOrgCode.setFieldDesc("\u5f53\u524d\u7528\u6237\u6240\u5c5e\u673a\u6784");
        loginUserLeageOrgCode.setFieldType("200");
        loginUserLeageOrgCode.setFieldLength(Integer.valueOf(100));
        loginUserLeageOrgCode.setIsPk(YesOrNO.NO.getCode());
        loginUserLeageOrgCode.setIsAllowNull(YesOrNO.YES.getCode());
        loginUserLeageOrgCode.setFieldOrder(Integer.valueOf(3));
        this.modelTableFieldInsert(loginUserLeageOrgCode);
        ModelTableFieldDO loginUserOrgLocation = new ModelTableFieldDO();
        loginUserOrgLocation.setObjectId(userTokenInfo.getObjectId());
        loginUserOrgLocation.setFieldCode("loginUserOrgLocation");
        loginUserOrgLocation.setFieldName("\u5f53\u524d\u7528\u6237\u673a\u6784\u4f4d\u7f6e");
        loginUserOrgLocation.setFieldDesc("\u5f53\u524d\u7528\u6237\u673a\u6784\u4f4d\u7f6e");
        loginUserOrgLocation.setFieldType("200");
        loginUserOrgLocation.setFieldLength(Integer.valueOf(100));
        loginUserOrgLocation.setIsPk(YesOrNO.NO.getCode());
        loginUserOrgLocation.setIsAllowNull(YesOrNO.YES.getCode());
        loginUserOrgLocation.setFieldOrder(Integer.valueOf(4));
        this.modelTableFieldInsert(loginUserOrgLocation);
        return (ModelTableInfoDTO)this.beanCopy(userTokenInfo, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generatePageInfo(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO pageInfo = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "PageInfo");
        if (pageInfo != null) {
            return (ModelTableInfoDTO)this.beanCopy(pageInfo, new ModelTableInfoDTO());
        }
        pageInfo = new ModelTableInfoDO();
        pageInfo.setObjectCode("PageInfo");
        pageInfo.setObjectName("\u5206\u9875\u53c2\u6570\u4fe1\u606f");
        pageInfo.setObjectDesc("\u5206\u9875\u53c2\u6570\u4fe1\u606f");
        pageInfo.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        pageInfo.setAppId(appId);
        pageInfo.setFolderId(appId);
        pageInfo.setCreateUser("system");
        pageInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        pageInfo.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)pageInfo);
        ModelTableFieldDO page = new ModelTableFieldDO();
        page.setObjectId(pageInfo.getObjectId());
        page.setFieldCode("page");
        page.setFieldName("\u5f53\u524d\u9875");
        page.setFieldDesc("\u5f53\u524d\u9875");
        page.setFieldType("300");
        page.setFieldLength(Integer.valueOf(11));
        page.setIsPk(YesOrNO.NO.getCode());
        page.setIsAllowNull(YesOrNO.YES.getCode());
        page.setFieldOrder(Integer.valueOf(1));
        this.modelTableFieldInsert(page);
        ModelTableFieldDO size = new ModelTableFieldDO();
        size.setObjectId(pageInfo.getObjectId());
        size.setFieldCode("size");
        size.setFieldName("\u5206\u9875\u5927\u5c0f");
        size.setFieldDesc("\u5206\u9875\u5927\u5c0f");
        size.setFieldType("300");
        size.setFieldLength(Integer.valueOf(11));
        size.setIsPk(YesOrNO.NO.getCode());
        size.setIsAllowNull(YesOrNO.YES.getCode());
        size.setFieldOrder(Integer.valueOf(2));
        this.modelTableFieldInsert(size);
        ModelTableFieldDO total = new ModelTableFieldDO();
        total.setObjectId(pageInfo.getObjectId());
        total.setFieldCode("total");
        total.setFieldName("\u603b\u6570");
        total.setFieldDesc("\u603b\u6570");
        total.setFieldType("300");
        total.setFieldLength(Integer.valueOf(11));
        total.setIsPk(YesOrNO.NO.getCode());
        total.setIsAllowNull(YesOrNO.YES.getCode());
        total.setFieldOrder(Integer.valueOf(3));
        this.modelTableFieldInsert(total);
        return (ModelTableInfoDTO)this.beanCopy(pageInfo, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generateDateData(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO dateData = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "DateData");
        if (dateData != null) {
            return (ModelTableInfoDTO)this.beanCopy(dateData, new ModelTableInfoDTO());
        }
        dateData = new ModelTableInfoDO();
        dateData.setObjectCode("DateData");
        dateData.setObjectName("\u65e5\u671f\u6570\u636e\u5bf9\u8c61");
        dateData.setObjectDesc("\u65e5\u671f\u6570\u636e\u5bf9\u8c61");
        dateData.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        dateData.setAppId(appId);
        dateData.setFolderId(appId);
        dateData.setCreateUser("system");
        dateData.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        dateData.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)dateData);
        ModelTableFieldDO currentDate = new ModelTableFieldDO();
        this.beanCopy(CommonFields.currentDate, currentDate);
        currentDate.setObjectId(dateData.getObjectId());
        currentDate.setFieldOrder(Integer.valueOf(1));
        currentDate.setFieldType("200");
        this.modelTableFieldInsert(currentDate);
        ModelTableFieldDO currentDatePlusOne = new ModelTableFieldDO();
        this.beanCopy(CommonFields.currentDatePlusOne, currentDatePlusOne);
        currentDatePlusOne.setObjectId(dateData.getObjectId());
        currentDatePlusOne.setFieldOrder(Integer.valueOf(2));
        currentDatePlusOne.setFieldType("200");
        this.modelTableFieldInsert(currentDatePlusOne);
        ModelTableFieldDO currentTime = new ModelTableFieldDO();
        this.beanCopy(CommonFields.currentTime, currentTime);
        currentTime.setObjectId(dateData.getObjectId());
        currentTime.setFieldOrder(Integer.valueOf(3));
        currentTime.setFieldType("200");
        this.modelTableFieldInsert(currentTime);
        ModelTableFieldDO currentDateYYYYMMDD = new ModelTableFieldDO();
        this.beanCopy(CommonFields.currentDateYYYYMMDD, currentDateYYYYMMDD);
        currentDateYYYYMMDD.setObjectId(dateData.getObjectId());
        currentDateYYYYMMDD.setFieldOrder(Integer.valueOf(4));
        currentDateYYYYMMDD.setFieldType("200");
        this.modelTableFieldInsert(currentDateYYYYMMDD);
        ModelTableFieldDO currentTimeHHMMSS = new ModelTableFieldDO();
        this.beanCopy(CommonFields.currentTimeHHMMSS, currentTimeHHMMSS);
        currentTimeHHMMSS.setObjectId(dateData.getObjectId());
        currentTimeHHMMSS.setFieldOrder(Integer.valueOf(5));
        currentTimeHHMMSS.setFieldType("200");
        this.modelTableFieldInsert(currentTimeHHMMSS);
        return (ModelTableInfoDTO)this.beanCopy(dateData, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generateGivenData(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO givenData = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "GivenData");
        if (givenData != null) {
            return (ModelTableInfoDTO)this.beanCopy(givenData, new ModelTableInfoDTO());
        }
        givenData = new ModelTableInfoDO();
        givenData.setObjectCode("GivenData");
        givenData.setObjectName("\u7279\u5b9a\u6570\u636e\u5bf9\u8c61");
        givenData.setObjectDesc("\u7279\u5b9a\u6570\u636e\u5bf9\u8c61");
        givenData.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        givenData.setAppId(appId);
        givenData.setFolderId(appId);
        givenData.setCreateUser("system");
        givenData.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        givenData.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)givenData);
        ModelTableFieldDO emptyStr = new ModelTableFieldDO();
        this.beanCopy(CommonFields.emptyStr, emptyStr);
        emptyStr.setObjectId(givenData.getObjectId());
        emptyStr.setFieldOrder(Integer.valueOf(1));
        emptyStr.setFieldType("200");
        this.modelTableFieldInsert(emptyStr);
        ModelTableFieldDO emptyVal = new ModelTableFieldDO();
        this.beanCopy(CommonFields.emptyVal, emptyVal);
        emptyVal.setObjectId(givenData.getObjectId());
        emptyVal.setFieldOrder(Integer.valueOf(2));
        emptyVal.setFieldType("200");
        this.modelTableFieldInsert(emptyVal);
        return (ModelTableInfoDTO)this.beanCopy(givenData, new ModelTableInfoDTO());
    }

    public ModelTableInfoDTO generateRandomData(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        ModelTableInfoDO randomData = ((ModelTableInfoRepository)this.getRepository()).checkCommonTableModel(appId, "RandomData");
        if (randomData != null) {
            return (ModelTableInfoDTO)this.beanCopy(randomData, new ModelTableInfoDTO());
        }
        randomData = new ModelTableInfoDO();
        randomData.setObjectCode("RandomData");
        randomData.setObjectName("\u968f\u673a\u6570\u636e\u5bf9\u8c61");
        randomData.setObjectDesc("\u968f\u673a\u6570\u636e\u5bf9\u8c61");
        randomData.setObjectType(Integer.valueOf(Integer.parseInt(ObjectType.Common.getCode())));
        randomData.setAppId(appId);
        randomData.setFolderId(appId);
        randomData.setCreateUser("system");
        randomData.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        randomData.setObjectId(UUIDUtil.getUUID());
        ((ModelTableInfoRepository)this.getRepository()).insert((Object)randomData);
        ModelTableFieldDO uuid = new ModelTableFieldDO();
        this.beanCopy(CommonFields.uuid, uuid);
        uuid.setObjectId(randomData.getObjectId());
        uuid.setFieldOrder(Integer.valueOf(1));
        uuid.setFieldType("200");
        this.modelTableFieldInsert(uuid);
        ModelTableFieldDO random = new ModelTableFieldDO();
        this.beanCopy(CommonFields.random, random);
        random.setObjectId(randomData.getObjectId());
        random.setFieldOrder(Integer.valueOf(2));
        random.setFieldType("300");
        this.modelTableFieldInsert(random);
        return (ModelTableInfoDTO)this.beanCopy(randomData, new ModelTableInfoDTO());
    }

    public List<ModelTableInfoDTO> queryListWithTmpGenByPage(ModelTableInfoDTO modelTableInfoDTO) {
        ModelTableInfoDO queryModelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(modelTableInfoDTO, queryModelTableInfoDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryListWithTmpGenByPage(queryModelTableInfoDO);
        List list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        return list;
    }

    public List<ModelTableInfoDTO> queryListWithFnByPage(ModelTableInfoDTO modelTableInfoDTO) {
        ModelTableInfoDO queryModelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(modelTableInfoDTO, queryModelTableInfoDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryListWithFnByPage(queryModelTableInfoDO);
        List list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        return list;
    }

    public List<ModelTableInfoDTO> queryListWithFnFormsByPage(ModelTableInfoDTO modelTableInfoDTO) {
        ModelTableInfoDO queryModelTableInfoDO = new ModelTableInfoDO();
        this.beanCopy(modelTableInfoDTO, queryModelTableInfoDO);
        List modelTableInfos = ((ModelTableInfoRepository)this.getRepository()).queryListWithFnFormsByPage(queryModelTableInfoDO);
        List list = this.beansCopy(modelTableInfos, ModelTableInfoDTO.class);
        return list;
    }

    private String modelTableFieldInsert(ModelTableFieldDO inModelTableFieldDTO) {
        String fieldType = inModelTableFieldDTO.getFieldType();
        if (inModelTableFieldDTO.getFieldOrder() != null) {
            int orderValue = this.modelTableFieldRepository.getCurrentOrderValue(inModelTableFieldDTO.getObjectId());
            inModelTableFieldDTO.setFieldOrder(Integer.valueOf(orderValue));
        }
        PubDbmsDatatypeService pubDbmsDatatypeService = (PubDbmsDatatypeService)SpringContextUtils.getBean(PubDbmsDatatypeService.class);
        PubDbmsDatatypeDTO dbmsType = pubDbmsDatatypeService.queryDbmsType(inModelTableFieldDTO.getObjectId(), inModelTableFieldDTO.getFieldType());
        inModelTableFieldDTO.setFieldType(dbmsType.getDbmsDatatypeCode());
        inModelTableFieldDTO.setFieldId(UUIDUtil.getUUID());
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldDTO.getIsPk())) {
            inModelTableFieldDTO.setIsPk(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldDTO.setIsPk(PubStdYnEnum.N.getCode());
        }
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldDTO.getIsAllowNull())) {
            inModelTableFieldDTO.setIsAllowNull(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldDTO.setIsAllowNull(PubStdYnEnum.N.getCode());
        }
        inModelTableFieldDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        this.modelTableFieldRepository.insert((Object)inModelTableFieldDTO);
        return inModelTableFieldDTO.getFieldId();
    }

    public boolean syncAppTable2RealDB(String appId, String ecsId, String conflict) {
        boolean flag;
        block47: {
            List modelTableList;
            String dbUrl;
            DBImportPlugin readPlugin;
            PaasEcsInfoDTO dbEcs;
            PaasAppsInfoDTO dbAppInfo;
            block46: {
                flag = true;
                PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
                appParam.setAppId(appId);
                dbAppInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appParam);
                if (dbAppInfo == null) {
                    throw new RuntimeException("\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u540c\u6b65");
                }
                if (!StringUtils.equals((CharSequence)AppCategory.DBApp.getCode(), (CharSequence)dbAppInfo.getAppCategory())) {
                    String refDbAppid = dbAppInfo.getRefDbAppid();
                    if (StringUtils.isBlank((CharSequence)refDbAppid)) {
                        throw new RuntimeException("\u5e94\u7528\u672a\u5173\u8054\u6570\u636e\u5e93\u5e94\u7528\uff0c\u65e0\u6cd5\u540c\u6b65");
                    }
                    appParam.setAppId(refDbAppid);
                    dbAppInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appParam);
                    if (dbAppInfo == null) {
                        throw new RuntimeException("\u5173\u8054\u6570\u636e\u5e93\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u540c\u6b65");
                    }
                }
                dbEcs = new PaasEcsInfoDTO();
                dbEcs.setEcsId(ecsId);
                dbEcs = (PaasEcsInfoDTO)this.paasEcsInfoService.queryByPk((Object)dbEcs);
                if (dbEcs == null) {
                    throw new RuntimeException("\u6570\u636e\u5e93\u670d\u52a1\u5668\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u540c\u6b65");
                }
                readPlugin = DBImportPlugin.Factory.getInstance((int)Integer.valueOf(dbAppInfo.getBizDbDbms()));
                dbUrl = "";
                switch (Integer.valueOf(dbAppInfo.getBizDbDbms())) {
                    case 425: {
                        dbUrl = String.format("jdbc:mysql://%s:%s/%s", dbEcs.getEcsIp(), dbEcs.getEcsPort(), dbAppInfo.getAppCode().replaceAll("[\\.-]", "_"));
                        break;
                    }
                    case 125: {
                        dbUrl = String.format("jdbc:oracle:thin:@%s:%s:%s", dbEcs.getEcsIp(), dbEcs.getEcsPort(), dbAppInfo.getAppCode().replaceAll("[\\.-]", "_"));
                        break;
                    }
                }
                ModelTableInfoDO tableParam = new ModelTableInfoDO();
                tableParam.setAppId(appId);
                tableParam.setObjectType(ObjectType.Table.getIntCode());
                modelTableList = ((ModelTableInfoRepository)this.getRepository()).queryList((Object)tableParam);
                DBInfoVO db = readPlugin.readDBInfo(dbUrl, dbEcs.getEcsLoginUser(), dbEcs.getEcsLoginPwd());
                if (db == null) break block46;
                ArrayList<ModelTableInfoBo> existsTableList = new ArrayList<ModelTableInfoBo>();
                HashMap<String, DBImportTableIndexVO> dbIndexList = new HashMap<String, DBImportTableIndexVO>();
                HashMap<String, ModelTableInfoBo> existsBoMap = new HashMap<String, ModelTableInfoBo>();
                HashMap<Object, Boolean> existsMap = new HashMap<Object, Boolean>();
                Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
                for (Object tb : db.getTables()) {
                    ModelTableInfoBo modelTb = new ModelTableInfoBo();
                    modelTb.setTableCode(tb.getTable_name());
                    modelTb.setTableName(tb.getTable_comment());
                    modelTb.setFieldList(new ArrayList());
                    modelTb.setFieldMap(new HashMap());
                    existsTableList.add(modelTb);
                    existsMap.put(modelTb.getTableCode(), true);
                    existsBoMap.put(modelTb.getTableCode(), modelTb);
                    DBImportTableIndexVO pkKey = null;
                    for (DBImportTableIndexVO ii : tb.getIndexes()) {
                        ModelTableIndexDO index = new ModelTableIndexDO();
                        index.setIndexFields(ii.getColumns());
                        if (IndexType.Primary.getCode().equals(ii.getIndex_type())) {
                            index.setIndexTypePrimary("Y");
                            index.setIndexTypeUnique("N");
                            index.setIndexName(ii.getIndex_name());
                            pkKey = ii;
                        } else {
                            index.setIndexTypePrimary("N");
                            index.setIndexName(ii.getIndex_name());
                        }
                        dbIndexList.put(ii.getIndex_name(), ii);
                    }
                    for (DBImportTableFieldVO ff : tb.getFields()) {
                        ModelTableFieldBo field = new ModelTableFieldBo();
                        field.setFieldCode(ff.getColumn_name());
                        if (StringUtils.isNotBlank((CharSequence)ff.getIs_nullable()) && ff.getIs_nullable().equals("YES")) {
                            field.setIsAllowNull("Y");
                        } else {
                            field.setIsAllowNull("N");
                        }
                        field.setFieldDesc(ff.getColumn_comment());
                        field.setFieldName(ff.getColumn_comment());
                        field.setDefValue(ff.getColumn_default());
                        field.setFieldType(ff.getData_type());
                        if (pkKey != null) {
                            if (pkKey.getColumns().contains(ff.getColumn_name())) {
                                field.setIsPk("Y");
                            } else {
                                field.setIsPk("N");
                            }
                        } else {
                            field.setIsPk("N");
                        }
                        Matcher matcher = pattern.matcher(ff.getColumn_type());
                        if (matcher.matches()) {
                            field.setFieldLength(Integer.valueOf(matcher.group(1)));
                            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                                field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                            }
                        }
                        modelTb.getFieldList().add(field);
                        modelTb.getFieldMap().put(field.getFieldCode(), field);
                        existsMap.put(modelTb.getTableCode() + "-" + field.getFieldCode(), true);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)modelTableList)) break block47;
                ArrayList<String> sqlList = new ArrayList<String>();
                for (Object tb : modelTableList) {
                    ModelTableInfoBo tbBo = this.generateTableBO((ModelTableInfoDO)tb);
                    if (existsMap.get(tbBo.getTableCode()) != null && ((Boolean)existsMap.get(tbBo.getTableCode())).booleanValue()) {
                        for (ModelTableFieldBo field : tbBo.getFieldList()) {
                            String fieldCode = field.getFieldCode();
                            String key = tbBo.getTableCode() + "-" + fieldCode;
                            StringBuffer type = new StringBuffer(field.getFieldType());
                            if (field.getFieldLength() != null && field.getFieldLength() > 0) {
                                type.append("(").append(field.getFieldLength());
                                if (field.getFieldPrecision() != null && field.getFieldPrecision() > 0) {
                                    type.append(",").append(field.getFieldPrecision());
                                }
                                type.append(")");
                            }
                            if (existsMap.get(key) != null && ((Boolean)existsMap.get(key)).booleanValue()) {
                                ModelTableInfoBo dbTbBo = (ModelTableInfoBo)existsBoMap.get(tbBo.getTableCode());
                                ModelTableFieldBo dbField = (ModelTableFieldBo)dbTbBo.getFieldMap().get(field.getFieldCode());
                                if (StringUtils.equals((CharSequence)dbField.getFieldType(), (CharSequence)field.getFieldType()) && (!StringUtils.equals((CharSequence)dbField.getFieldType(), (CharSequence)field.getFieldType()) || dbField.getFieldLength().compareTo(field.getFieldLength()) == 0)) continue;
                                String sql = String.format("alter table %s modify column %s %s ;", tbBo.getTableCode(), field.getFieldCode(), type);
                                sqlList.add(sql);
                                continue;
                            }
                            String allowNull = "default null";
                            if (StringUtils.equals((CharSequence)field.getIsAllowNull(), (CharSequence)YesOrNO.NO.getCode())) {
                                allowNull = "not null";
                            }
                            String sql = String.format("alter table %s add column %s %s %s comment '%s';", tbBo.getTableCode(), field.getFieldCode(), type.toString(), allowNull, field.getFieldName());
                            sqlList.add(sql);
                        }
                        continue;
                    }
                    String script = this.paasDocExecutorService.generateDDL(tb.getObjectId());
                    sqlList.add(script);
                }
                if (sqlList.isEmpty()) break block47;
                Connection deployConn = readPlugin.getDBConnection(dbUrl, dbEcs.getEcsLoginUser(), dbEcs.getEcsLoginPwd());
                for (String sql : sqlList) {
                    logger.info(String.format("\u540c\u6b65\u53d8\u66f4\u811a\u672c %s", sql));
                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                    ScriptRunner sr = new ScriptRunner(deployConn);
                    BufferedReader reader = new BufferedReader(new StringReader(sql));
                    sr.runScript((Reader)reader);
                }
                break block47;
            }
            String noDbNameUrl = "";
            switch (Integer.valueOf(dbAppInfo.getBizDbDbms())) {
                case 425: {
                    noDbNameUrl = String.format("jdbc:mysql://%s:%s", dbEcs.getEcsIp(), dbEcs.getEcsPort());
                    break;
                }
                case 125: {
                    noDbNameUrl = String.format("jdbc:oracle:thin:@%s:%s:%s", dbEcs.getEcsIp(), dbEcs.getEcsPort(), dbAppInfo.getAppCode().replaceAll("[\\.-]", "_"));
                    break;
                }
            }
            Connection noDbConn = null;
            try {
                noDbConn = readPlugin.getDBConnection(noDbNameUrl, dbEcs.getEcsLoginUser(), dbEcs.getEcsLoginPwd());
                String dbName = dbAppInfo.getAppCode().replaceAll("[\\.-]", "_");
                Statement st = MyJdbcUtil.createStatement((Connection)noDbConn);
                String createDB = "CREATE DATABASE `" + dbName + "`";
                MyJdbcUtil.executeSql((Statement)st, (String)createDB);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8fde\u63a5\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38 " + e.getMessage(), e);
            }
            finally {
                if (noDbConn != null) {
                    IOUtils.closeQuietly((Closeable[])new Closeable[0]);
                    try {
                        noDbConn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            Connection deployConn = readPlugin.getDBConnection(dbUrl, dbEcs.getEcsLoginUser(), dbEcs.getEcsLoginPwd());
            for (ModelTableInfoDO tableInfo : modelTableList) {
                if (!tableInfo.getObjectType().equals(ObjectType.Table.getIntCode())) continue;
                logger.info(String.format("\u521b\u5efa%s...", tableInfo.getObjectCode()));
                String script = this.paasDocExecutorService.generateDDL(tableInfo.getObjectId());
                logger.info(String.format("\u5efa\u8868\u8bed\u53e5:\n%s", script));
                if (!StringUtils.isNotBlank((CharSequence)script)) continue;
                ScriptRunner sr = new ScriptRunner(deployConn);
                BufferedReader reader = new BufferedReader(new StringReader(script));
                sr.runScript((Reader)reader);
            }
        }
        return flag;
    }

    public ModelTableInfoBo generateTableBO(ModelTableInfoDO table) {
        try {
            ModelTableFieldDO fieldParam = new ModelTableFieldDO();
            fieldParam.setObjectId(table.getObjectId());
            List fields = this.modelTableFieldRepository.queryList((Object)fieldParam);
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
            HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                for (ModelTableFieldDO field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)field, (Object)fieldBo);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldCode(), fieldBo);
                }
            }
            tableBo.setFieldList(fieldBos);
            tableBo.setFieldMap(fieldMap);
            return tableBo;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

