/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.acl.repository.FnTypeInfoRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormAddEvalRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormAddFieldRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormImportFieldRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormListFieldRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormListGroupRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormListQueryRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormListSettingRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormListSortRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelApiRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelButtonRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelFieldRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelInfoRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelPageRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelRefactorRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelSubformRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelValidateRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormSubformItemRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormSubformStepRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormSubformTabRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormSubformTreeRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormUpdEvalRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormUpdFieldRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.FormViewFieldRepository;
import com.irdstudio.allinrdm.dev.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.domain.entity.FnTypeInfoDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormAddFieldDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormListFieldDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormModelFieldDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormModelInfoDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormModelRefactorDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormModelSubformDO;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.DevtypeInfoExecService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateData;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateField;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelRefactorDTO;
import com.irdstudio.allinrdm.dev.console.types.FormCategory;
import com.irdstudio.allinrdm.dev.console.types.FormState;
import com.irdstudio.allinrdm.dev.console.types.FormType;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.dev.console.types.RefactorType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="formModelInfoServiceImpl")
public class FormModelInfoServiceImpl
extends BaseServiceImpl<FormModelInfoDTO, FormModelInfoDO, FormModelInfoRepository>
implements FormModelInfoService {
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private FnTypeInfoRepository fnTypeInfoRepository;
    @Autowired
    private DevtypeInfoExecService devtypeInfoExecService;
    @Autowired
    private FnModelInfoService fnModelInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private ComBaseInfoService comBaseInfoService;
    @Autowired
    private RdmModuleInfoService rdmModuleInfoService;
    @Autowired
    private CodeProduceInfoService codeProduceInfoService;
    @Autowired
    private FormModelFieldRepository formModelFieldRepository;
    @Autowired
    private FormAddFieldRepository formAddFieldRepository;
    @Autowired
    private FormAddEvalRepository formAddEvalRepository;
    @Autowired
    private FormListFieldRepository formListFieldRepository;
    @Autowired
    private FormListGroupRepository formListGroupRepository;
    @Autowired
    private FormListQueryRepository formListQueryRepository;
    @Autowired
    private FormListSettingRepository formListSettingRepository;
    @Autowired
    private FormListSortRepository formListSortRepository;
    @Autowired
    private FormImportFieldRepository formImportFieldRepository;
    @Autowired
    private FormModelButtonRepository formModelButtonRepository;
    @Autowired
    private FormModelValidateRepository formModelValidateRepository;
    @Autowired
    private FormUpdFieldRepository formUpdFieldRepository;
    @Autowired
    private FormUpdEvalRepository formUpdEvalRepository;
    @Autowired
    private FormViewFieldRepository formViewFieldRepository;
    @Autowired
    private FormModelPageRepository formModelPageRepository;
    @Autowired
    private FormModelApiRepository formModelApiRepository;
    @Autowired
    private FormModelSubformRepository formModelSubformRepository;
    @Autowired
    private FormSubformTreeRepository formSubformTreeRepository;
    @Autowired
    private FormSubformStepRepository formSubformStepRepository;
    @Autowired
    private FormSubformTabRepository formSubformTabRepository;
    @Autowired
    private FormSubformItemRepository formSubformItemRepository;
    @Autowired
    private FormModelRefactorRepository formModelRefactorRepository;
    @Autowired
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    private DictOptionEnumService dictOptionEnumService;
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");

    public Integer queryMaxOrder() {
        return ((FormModelInfoRepository)this.getRepository()).queryMaxOrder();
    }

    public int insert(FormModelInfoDTO paramDTO) {
        String comId = paramDTO.getComId();
        if (StringUtils.isNotBlank((CharSequence)paramDTO.getTableModelId())) {
            if (StringUtils.isNotBlank((CharSequence)comId)) {
                ModelTableInfoDTO mainTable = new ModelTableInfoDTO();
                mainTable.setObjectId(paramDTO.getTableModelId());
                mainTable.setComId(comId);
                this.modelTableInfoService.updateByPk((Object)mainTable);
            }
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(paramDTO.getTableModelId());
            List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
            if (!StringUtils.equals((CharSequence)paramDTO.getFormType(), (CharSequence)FormType.Single.getCode())) {
                if (StringUtils.isNotBlank((CharSequence)comId)) {
                    ModelTableInfoDTO joinTable = new ModelTableInfoDTO();
                    joinTable.setObjectId(paramDTO.getJoinModelId());
                    joinTable.setComId(comId);
                    this.modelTableInfoService.updateByPk((Object)joinTable);
                }
                fieldParam.setObjectId(paramDTO.getJoinModelId());
                List joinFieldList = this.modelTableFieldService.queryList((Object)fieldParam);
                if (CollectionUtils.isNotEmpty((Collection)fieldList) && CollectionUtils.isNotEmpty((Collection)joinFieldList)) {
                    fieldList.addAll(joinFieldList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                String formId = paramDTO.getFormId();
                ArrayList formFieldList = new ArrayList(fieldList.size());
                HashMap fieldSet = new HashMap();
                fieldList.forEach(field -> {
                    FormModelFieldDO formField = new FormModelFieldDO();
                    BeanUtility.beanCopy((Object)field, (Object)formField, (boolean)true);
                    formField.setFormId(formId);
                    formField.setFormFieldId(UUIDUtil.getUUID());
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    formField.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    formField.setJavaPropertyName(javaPropertyName);
                    formField.setJavaType(TmModelUtil.fieldTypeToJavaType((String)formField.getFieldType()));
                    if (StringUtils.isNotBlank((CharSequence)formField.getFieldOption())) {
                        formField.setFieldFcId("FC003");
                    } else if (StringUtils.equalsAny((CharSequence)formField.getJavaType(), (CharSequence[])new CharSequence[]{"int", "BigDecimal"})) {
                        formField.setFieldFcId("FC002");
                    } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)formField.getFieldType(), (CharSequence[])new CharSequence[]{"DATE", "DATETIME"})) {
                        formField.setFieldFcId("FC006");
                    } else {
                        formField.setFieldFcId("FC001");
                    }
                    if (fieldSet.get(field.getFieldCode()) == null) {
                        formFieldList.add(formField);
                        fieldSet.put(field.getFieldCode(), formField);
                    }
                });
                this.formModelFieldRepository.batchInsert(formFieldList);
            }
        }
        return super.insert((BaseInfo)paramDTO);
    }

    public int updateByPk(FormModelInfoDTO paramDTO) {
        String comId = paramDTO.getComId();
        if (StringUtils.isNotBlank((CharSequence)paramDTO.getTableModelId()) && StringUtils.isNotBlank((CharSequence)comId)) {
            ModelTableInfoDTO mainTable = new ModelTableInfoDTO();
            mainTable.setObjectId(paramDTO.getTableModelId());
            mainTable.setComId(comId);
            this.modelTableInfoService.updateByPk((Object)mainTable);
            if (!StringUtils.equals((CharSequence)paramDTO.getFormType(), (CharSequence)FormType.Single.getCode())) {
                ModelTableInfoDTO joinTable = new ModelTableInfoDTO();
                joinTable.setObjectId(paramDTO.getJoinModelId());
                joinTable.setComId(comId);
                this.modelTableInfoService.updateByPk((Object)joinTable);
            }
        }
        return super.updateByPk((BaseInfo)paramDTO);
    }

    public int deleteByPk(FormModelInfoDTO paramDTO) {
        this.formModelFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formAddFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formAddEvalRepository.deleteByFormId(paramDTO.getFormId());
        this.formListFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formListGroupRepository.deleteByFormId(paramDTO.getFormId());
        this.formListQueryRepository.deleteByFormId(paramDTO.getFormId());
        this.formListSettingRepository.deleteByFormId(paramDTO.getFormId());
        this.formListSortRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelButtonRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelValidateRepository.deleteByFormId(paramDTO.getFormId());
        this.formUpdFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formUpdEvalRepository.deleteByFormId(paramDTO.getFormId());
        this.formImportFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formViewFieldRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelPageRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelApiRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelRefactorRepository.deleteByFormId(paramDTO.getFormId());
        this.formModelSubformRepository.deleteByFormId(paramDTO.getFormId());
        this.formSubformTreeRepository.deleteByFormId(paramDTO.getFormId(), null);
        this.formSubformStepRepository.deleteByFormId(paramDTO.getFormId(), null);
        this.formSubformTabRepository.deleteByFormId(paramDTO.getFormId(), null);
        this.formSubformItemRepository.deleteByFormId(paramDTO.getFormId(), null);
        FnModelInfoDTO fnParam = new FnModelInfoDTO();
        fnParam.setFormId(paramDTO.getFormId());
        List fnList = this.fnModelInfoService.queryList((Object)fnParam);
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            fnList.forEach(fn -> {
                String fnId = fn.getFnId();
                this.fnModelInfoService.deleteByPk(fn);
            });
        }
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public int formInitFn(FormModelInfoDTO paramDTO) {
        if (CollectionUtils.isEmpty((Collection)paramDTO.getFnTypes())) {
            throw new RuntimeException("\u521d\u59cb\u5316\u529f\u80fd\u7c7b\u578b\u4e3a\u7a7a");
        }
        FormModelInfoDTO form = new FormModelInfoDTO();
        form.setFormId(paramDTO.getFormId());
        form = (FormModelInfoDTO)this.queryByPk((BaseInfo)form);
        boolean flag = true;
        int count = 0;
        FnTypeInfoDO fnTypeParam = new FnTypeInfoDO();
        fnTypeParam.setFnType1(paramDTO.getFnType1());
        fnTypeParam.setFnTypes(paramDTO.getFnTypes());
        List fnTypeList = this.fnTypeInfoRepository.queryList((Object)fnTypeParam);
        for (FnTypeInfoDO fnTypeInfo : fnTypeList) {
            String fnType1 = fnTypeInfo.getFnType1();
            String fnType2 = fnTypeInfo.getFnType2();
            String fnId = this.createFnModelInfo(form, fnTypeInfo);
            boolean initFlag = this.devtypeInfoExecService.create(fnType1, fnType2, paramDTO.getLoginUserId(), fnId, true, null);
            if (!initFlag) {
                flag = false;
            }
            ++count;
        }
        if (flag) {
            form.setFormState(FormState.CreatedFn.getCode());
            form.setLastModifyUser(paramDTO.getLoginUserId());
            form.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            this.updateByPk(form);
        }
        return flag ? count : -1;
    }

    public int batchCreateForm(FormModelInfoDTO paramDTO, String allSelected) {
        ModelTableInfoDTO tableParam;
        String userId = paramDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        String formType = paramDTO.getFormType();
        String formCategory = paramDTO.getFormCategory();
        String appId = paramDTO.getAppId();
        String subsId = paramDTO.getSubsId();
        int orderValue = this.queryMaxOrder();
        int count = 0;
        List tableList = Collections.emptyList();
        if (StringUtils.equals((CharSequence)allSelected, (CharSequence)YesOrNO.YES.getCode())) {
            tableParam = new ModelTableInfoDTO();
            tableParam.setAppId(paramDTO.getAppId());
            tableParam.setObjectType(ObjectType.Table.getIntCode());
            tableList = this.modelTableInfoService.queryList((Object)tableParam);
        } else {
            tableParam = new ModelTableInfoDTO();
            tableParam.setAppId(paramDTO.getAppId());
            tableParam.setComId(paramDTO.getComId());
            tableParam.setObjectIds(paramDTO.getTableModelIds());
            tableList = this.modelTableInfoService.queryAllByTableInfo(tableParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                FormModelInfoDTO form = new FormModelInfoDTO();
                form.setFormId(UUIDUtil.getUUID());
                form.setFormType(formType);
                form.setFormCategory(formCategory);
                form.setOrderValue(Integer.valueOf(orderValue++));
                form.setSubsId(subsId);
                form.setAppId(appId);
                form.setTableModelId(table.getObjectId());
                form.setTableModelCode(table.getObjectCode());
                form.setTableModelName(table.getObjectName());
                form.setFormCode(String.format("%sForm", CaseUtils.toCamelCase((String)table.getObjectCode(), (boolean)true, (char[])new char[]{'_'})));
                form.setFormName(String.format("%s\u8868\u5355\u6a21\u578b", table.getObjectName()));
                form.setFolderId(table.getFolderId());
                form.setComId(table.getComId());
                form.setFormState(FormState.CreatedForm.getCode());
                form.setCreateUser(userId);
                form.setCreateTime(now);
                form.setLastModifyUser(userId);
                form.setLastModifyTime(now);
                count += this.insert(form);
            }
        }
        return count;
    }

    public boolean generateFormCode(FormModelInfoDTO paramDTO) {
        FormModelInfoDTO formModel = (FormModelInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        formModel.setLoginUserId(paramDTO.getLoginUserId());
        paramDTO.setModelStat(ModelStat.Generated.getCode());
        this.updateByPk(paramDTO);
        CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
        templatePullTask.syncRun();
        if (!StringUtils.equals((CharSequence)formModel.getFormCategory(), (CharSequence)FormCategory.Combine.getCode())) {
            return this.generateSingleFormCode(formModel);
        }
        if (StringUtils.equals((CharSequence)formModel.getFormCategory(), (CharSequence)FormCategory.Combine.getCode())) {
            return this.generateCombineFormCode(formModel);
        }
        return false;
    }

    private boolean generateSingleFormCode(FormModelInfoDTO formModel) {
        String targetPath;
        String formId = formModel.getFormId();
        FnModelInfoDTO fnModelInfo = new FnModelInfoDTO();
        fnModelInfo.setFormId(formId);
        List fnList = this.fnModelInfoService.queryList((Object)fnModelInfo);
        CodeTemplateData mainCodeData = new CodeTemplateData();
        mainCodeData.setParamMap(new HashMap());
        mainCodeData.getParamMap().put("formModel", formModel);
        ArrayList<CodeTemplateData> codeDataList = new ArrayList<CodeTemplateData>();
        List fieldList = null;
        HashMap formFieldMap = new HashMap();
        mainCodeData.getParamMap().put("formFieldMap", formFieldMap);
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            mainCodeData.setPackageName(formModel.getFolderName());
            mainCodeData.setClassName(TmModelUtil.tableCodeToClassName((String)formModel.getFormCode()));
            mainCodeData.setClassDesc(formModel.getFormName());
            mainCodeData.setNowTime(CurrentDateUtil.getTodayDate());
            mainCodeData.setTableModelCode(formModel.getTableModelCode());
            HashMap joinFieldMap = new HashMap();
            if (!StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Single.getCode())) {
                ModelTableFieldDTO joinFieldParam = new ModelTableFieldDTO();
                joinFieldParam.setObjectId(formModel.getJoinModelId());
                List joinFieldList = this.modelTableFieldService.queryList((Object)joinFieldParam);
                joinFieldList.forEach(field -> joinFieldMap.put(field.getFieldCode(), field));
            }
            FormModelFieldDO fieldParam = new FormModelFieldDO();
            fieldParam.setFormId(formId);
            fieldList = this.formModelFieldRepository.queryList((Object)fieldParam);
            if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                mainCodeData.setFieldList(fieldList.stream().map(f -> {
                    CodeTemplateField field = new CodeTemplateField();
                    BeanUtility.beanCopy((Object)f, (Object)field);
                    if (field.getFieldName() == null) {
                        field.setFieldName(field.getFieldCode());
                    }
                    formFieldMap.put(field.getFieldCode(), field);
                    if (joinFieldMap.get(f.getFieldCode()) != null) {
                        ModelTableFieldDTO joinField = (ModelTableFieldDTO)joinFieldMap.get(f.getFieldCode());
                        if (StringUtils.equals((CharSequence)joinField.getFieldId(), (CharSequence)f.getFieldId())) {
                            field.setSameFieldFlag(Boolean.valueOf(false));
                            field.setTableModelId(formModel.getJoinModelId());
                            field.setTableModelCode(formModel.getJoinModelCode());
                            field.setTableModelName(formModel.getJoinModelName());
                        } else {
                            field.setSameFieldFlag(Boolean.valueOf(true));
                            field.setTableModelId(formModel.getTableModelId());
                            field.setTableModelCode(formModel.getTableModelCode());
                            field.setTableModelName(formModel.getTableModelName());
                        }
                    } else {
                        field.setSameFieldFlag(Boolean.valueOf(false));
                        field.setTableModelId(formModel.getTableModelId());
                        field.setTableModelCode(formModel.getTableModelCode());
                        field.setTableModelName(formModel.getTableModelName());
                    }
                    return field;
                }).collect(Collectors.toList()));
            }
            mainCodeData.setMethodList(new ArrayList());
            mainCodeData.setQueryList(new ArrayList());
            mainCodeData.setSortList(new ArrayList());
            mainCodeData.setGroupList(new ArrayList());
            mainCodeData.setButtonList(new ArrayList());
            mainCodeData.setSqlCondList(new ArrayList());
            mainCodeData.setExtFieldList(new ArrayList());
            for (FnModelInfoDTO fn : fnList) {
                CodeTemplateData codeData = this.devtypeInfoExecService.generate(fn.getFnType1(), fn.getFnType2(), formModel.getLoginUserId(), fn.getFnId());
                if (codeData != null) {
                    codeDataList.add(codeData);
                    if (codeData.getParamMap() != null) {
                        if (mainCodeData.getParamMap() == null) {
                            mainCodeData.setParamMap(new HashMap());
                        }
                        mainCodeData.getParamMap().putAll(codeData.getParamMap());
                    }
                    mainCodeData.getMethodList().addAll(codeData.getMethodList());
                    mainCodeData.getSqlCondList().addAll(codeData.getSqlCondList());
                    mainCodeData.getFixedCondList().addAll(codeData.getFixedCondList());
                    mainCodeData.getExtFieldList().addAll(codeData.getExtFieldList());
                }
                FnModelInfoDTO updateFn = new FnModelInfoDTO();
                updateFn.setFnId(fn.getFnId());
                updateFn.setModelStat(ModelStat.Generated.getCode());
                this.fnModelInfoService.updateByPk((Object)updateFn);
            }
        } else {
            logger.info("{} \u8868\u5355\u6a21\u578b\u4e0b\u672a\u914d\u7f6e\u6709\u529f\u80fd\u6a21\u578b", (Object)formModel.getFormId());
            return false;
        }
        PaasAppsInfoDTO appInfoDO = new PaasAppsInfoDTO();
        appInfoDO.setAppId(formModel.getAppId());
        appInfoDO = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfoDO);
        PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)this.beanCopy(appInfoDO, PaasAppsInfoDTO.class);
        AppTemplateRepoPullTask templateTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
        templateTask.syncRun();
        PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
        Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
        String packagePrefixVal = "com.irdstudio";
        if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
            packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
        }
        String comFeatureCodePackage = "";
        RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
        moduleInfo.setModuleId(formModel.getModuleId());
        moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
        if (moduleInfo != null) {
            comFeatureCodePackage = moduleInfo.getFeatureCode();
            packagePrefixVal = moduleInfo.getOrgCode();
        } else {
            comFeatureCodePackage = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        }
        String appCodePackage = (packagePrefixVal + "." + comFeatureCodePackage).replaceAll("_|\\.|-", "/");
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.getMapData().put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
        ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
        ctdb.getMapData().put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "."));
        ctdb.getMapData().put("appsParam", appsParam);
        List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-web/src/main/java/${appCodePackage}/web/operation/", "XXXController.java", "${appCode}-domain/src/main/java/${appCodePackage}/domain/entity/", "XXXDO.java", "${appCode}-infrastructure/src/main/resources/mybatis/mapper/${appCodePackage}/", "XXXMapperImpl.xml", "${appCode}-infrastructure/src/main/java/${appCodePackage}/infra/persistence/mapper/", "XXXMapper.java", "${appCode}-infrastructure/src/main/java/${appCodePackage}/infra/persistence/po/", "XXXPO.java", "${appCode}-infrastructure/src/main/java/${appCodePackage}/infra/repository/impl/", "XXXRepositoryImpl.java", "${appCode}-infracl/src/main/java/${appCodePackage}/acl/repository/", "XXXRepository.java", "${appCode}-application/src/main/java/${appCodePackage}/application/operation/", "XXXServiceImpl.java", "${appCode}-facade/src/main/java/${appCodePackage}/facade/operation/", "XXXService.java", "${appCode}-facade/src/main/java/${appCodePackage}/facade/operation/dto/", "XXXDTO.java");
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
        expMap.put("appCodePackage", appCodePackage);
        expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
        for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
            String path = mainCodeTemplateFiles.get(i);
            String templateFile = mainCodeTemplateFiles.get(i + 1);
            targetPath = ExpressionUtil.parse((String)path, expMap);
            ctdb.getMapData().put("codeData", mainCodeData);
            this.codeProduceInfoService.produceCodeFile("form", templateFile, mainCodeData.getClassName(), "XXX", formId, null, targetPath, appInfo, ctdb);
        }
        ArrayList optionList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (FormModelFieldDO field2 : fieldList) {
                if (!StringUtils.isNotBlank((CharSequence)field2.getFieldOption())) continue;
                String dictId = field2.getDictId();
                DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                enumParam.setDictId(dictId);
                enumParam.setSubsId(field2.getDictDslId());
                List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
                DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                optionInfo.setDictId(dictId);
                optionInfo.setSubsId(field2.getDictDslId());
                if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (DictOptionEnumDTO dict : dictList) {
                        Matcher m;
                        if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                        if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                        dict.setOptionEnum(optionEnum);
                    }
                }
                String oriDictCode = optionInfo.getDictCode();
                optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("dictCode", optionInfo.getDictCode());
                optionMap.put("dictId", oriDictCode);
                optionMap.put("option", optionInfo);
                optionMap.put("dictList", dictList);
                String targetPath2 = "${appCode}-types/src/main/java/${appCodePackage}/types/";
                targetPath2 = ExpressionUtil.parse((String)targetPath2, expMap);
                String templateFile = "XXXEnum.java";
                ctdb.getMapData().put("codeData", mainCodeData);
                ctdb.getMapData().put("option", optionMap);
                optionList.add(optionMap);
                this.codeProduceInfoService.produceCodeFile("form", templateFile, optionInfo.getDictCode(), "XXX", formId, null, targetPath2, appInfo, ctdb);
            }
        }
        expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
        for (CodeTemplateData page : codeDataList) {
            if (StringUtils.isBlank((CharSequence)page.getTemplateFile())) continue;
            if (page.getParamMap() == null) {
                page.setParamMap(new HashMap());
            }
            page.getParamMap().put("optionList", optionList);
            targetPath = "${appCode}-start/src/main/resources/front/page/${comFeatureCodePackage}/";
            targetPath = ExpressionUtil.parse((String)targetPath, expMap);
            String templateFile = page.getTemplateFile();
            ctdb.getMapData().put("codeData", page);
            ctdb.getMapData().put("BASE_PATH", this.getBasePath(comFeatureCodePackage.replaceAll("_|\\.|-", "/")));
            this.codeProduceInfoService.produceCodeFile("form", templateFile, page.getClassName(), "XXX", formId, null, targetPath, appInfo, ctdb);
            if (!StringUtils.equals((CharSequence)FnType.Import.getCode(), (CharSequence)MapUtils.getString((Map)page.getParamMap(), (Object)"fnType2"))) continue;
            String excelGenPath = "${appCode}-web/src/main/resources/META-INF/template";
            targetPath = ExpressionUtil.parse((String)excelGenPath, expMap);
            ArrayList head = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)page.getFieldList())) {
                for (CodeTemplateField field3 : page.getFieldList()) {
                    ArrayList<String> head0 = new ArrayList<String>();
                    head0.add(field3.getFieldImportName());
                    head.add(head0);
                }
                File dir = new File(SdEnvUtil.PROJECT_PATH + formId + File.separator + targetPath + File.separator);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                WriteCellStyle headWriteCellStyle = new WriteCellStyle();
                headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.index));
                WriteFont headWriteFont = new WriteFont();
                headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
                headWriteCellStyle.setWriteFont(headWriteFont);
                HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, Collections.emptyList());
                ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((String)(dir.getAbsolutePath() + File.separator + String.format("%s.xlsx", page.getClassName()))).head(head)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(Integer.valueOf(0)).doWrite(Collections.emptyList());
            }
            String listenerGenPath = "${appCode}-web/src/main/java/${appCodePackage}/web/operation/";
            targetPath = ExpressionUtil.parse((String)listenerGenPath, expMap);
            this.codeProduceInfoService.produceCodeFile("form", "XXXExcelListener.java", mainCodeData.getClassName(), "XXX", formId, null, targetPath, appInfo, ctdb);
        }
        return true;
    }

    private boolean generateCombineFormCode(FormModelInfoDTO formModel) {
        String formId = formModel.getFormId();
        FnModelInfoDTO fnModelInfo = new FnModelInfoDTO();
        fnModelInfo.setFormId(formId);
        List fnList = this.fnModelInfoService.queryList((Object)fnModelInfo);
        CodeTemplateData mainCodeData = new CodeTemplateData();
        mainCodeData.setParamMap(new HashMap());
        mainCodeData.getParamMap().put("formModel", formModel);
        ArrayList<CodeTemplateData> codeDataList = new ArrayList<CodeTemplateData>();
        mainCodeData.setPackageName(formModel.getFolderName());
        mainCodeData.setClassName(TmModelUtil.tableCodeToClassName((String)formModel.getFormCode()));
        mainCodeData.setClassDesc(formModel.getFormName());
        mainCodeData.setNowTime(CurrentDateUtil.getTodayDate());
        mainCodeData.setTableModelCode(formModel.getTableModelCode());
        FormModelSubformDO subsParam = new FormModelSubformDO();
        subsParam.setFormId(formId);
        subsParam.setMainFlag(YesOrNO.YES.getCode());
        List subsFormList = this.formModelSubformRepository.queryListByPage((Object)subsParam);
        if (CollectionUtils.isEmpty((Collection)subsFormList)) {
            subsParam.setMainFlag(null);
            subsFormList = this.formModelSubformRepository.queryListByPage((Object)subsParam);
        }
        if (CollectionUtils.isEmpty((Collection)subsFormList)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5b50\u8868\u5355");
        }
        FormModelSubformDO mainSubForm = (FormModelSubformDO)subsFormList.get(0);
        String mainFormId = mainSubForm.getSubformId();
        FnModelInfoDTO mainFormListFn = new FnModelInfoDTO();
        mainFormListFn.setFormId(mainFormId);
        mainFormListFn.setFnType2(FnType.List.getCode());
        List listFnList = this.fnModelInfoService.queryListByPage((Object)mainFormListFn);
        if (CollectionUtils.isEmpty((Collection)listFnList)) {
            throw new RuntimeException("\u5b50\u8868\u5355\u672a\u751f\u6210\u5217\u8868\u529f\u80fd\uff0c\u65e0\u6cd5\u751f\u6210\u7ec4\u5408\u8868\u5355\u4ee3\u7801");
        }
        mainFormListFn = (FnModelInfoDTO)listFnList.get(0);
        CodeTemplateData mainListFnCodeData = this.devtypeInfoExecService.generate(mainFormListFn.getFnType1(), mainFormListFn.getFnType2(), formModel.getLoginUserId(), mainFormListFn.getFnId());
        if (mainListFnCodeData != null) {
            mainCodeData.setFieldList(mainListFnCodeData.getFieldList());
            mainCodeData.getParamMap().putAll(mainListFnCodeData.getParamMap());
            mainCodeData.setGroupList(mainListFnCodeData.getGroupList());
            mainCodeData.setSortList(mainListFnCodeData.getSortList());
            mainCodeData.setQueryList(mainListFnCodeData.getQueryList());
            ArrayList optionList = new ArrayList();
            mainCodeData.getParamMap().put("optionList", optionList);
            if (CollectionUtils.isNotEmpty((Collection)mainCodeData.getFieldList())) {
                FormListFieldDO fieldParam = new FormListFieldDO();
                fieldParam.setFormId(mainFormId);
                List fieldList = this.formModelFieldRepository.queryList((Object)fieldParam);
                for (FormModelFieldDO field : fieldList) {
                    if (!StringUtils.isNotBlank((CharSequence)field.getFieldOption())) continue;
                    String dictId = field.getDictId();
                    DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                    enumParam.setDictId(dictId);
                    enumParam.setSubsId(field.getDictDslId());
                    List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
                    DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                    optionInfo.setDictId(dictId);
                    optionInfo.setSubsId(field.getDictDslId());
                    if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                    if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                        for (DictOptionEnumDTO dict : dictList) {
                            Matcher m;
                            if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                                String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                                dict.setOptionEnum(optionEnum);
                            }
                            if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                            dict.setOptionEnum(optionEnum);
                        }
                    }
                    String oriDictCode = optionInfo.getDictCode();
                    optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
                    HashMap<String, Object> optionMap = new HashMap<String, Object>();
                    optionMap.put("dictCode", optionInfo.getDictCode());
                    optionMap.put("dictId", oriDictCode);
                    optionMap.put("option", optionInfo);
                    optionMap.put("dictList", dictList);
                    optionList.add(optionMap);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            for (FnModelInfoDTO fn : fnList) {
                CodeTemplateData codeData = this.devtypeInfoExecService.generate(fn.getFnType1(), fn.getFnType2(), formModel.getLoginUserId(), fn.getFnId());
                if (codeData == null) continue;
                codeDataList.add(codeData);
                mainCodeData.getMethodList().addAll(codeData.getMethodList());
                mainCodeData.getButtonList().addAll(codeData.getButtonList());
                codeData.setFieldList(mainCodeData.getFieldList());
            }
        }
        PaasAppsInfoDTO appInfoDO = new PaasAppsInfoDTO();
        appInfoDO.setAppId(formModel.getAppId());
        appInfoDO = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfoDO);
        PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)this.beanCopy(appInfoDO, PaasAppsInfoDTO.class);
        AppTemplateRepoPullTask templateTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
        templateTask.syncRun();
        PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
        Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
        String packagePrefixVal = "com.irdstudio";
        if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
            packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
        }
        String middlePackage = "";
        RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
        moduleInfo.setModuleId(formModel.getModuleId());
        moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
        if (moduleInfo != null) {
            middlePackage = moduleInfo.getFeatureCode();
            packagePrefixVal = moduleInfo.getOrgCode();
        } else {
            middlePackage = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        }
        String appCodePackage = (packagePrefixVal + "." + middlePackage).replaceAll("_|\\.|-", "/");
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.getMapData().put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
        ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
        ctdb.getMapData().put("middlePackage", middlePackage.replaceAll("_|\\.|-", "."));
        ctdb.getMapData().put("appsParam", appsParam);
        String formPageName = "";
        if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tree.getCode())) {
            formPageName = "Tree";
        } else if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Guide.getCode())) {
            formPageName = "Guide";
        } else if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.Tab.getCode())) {
            formPageName = "Tabs";
        } else if (StringUtils.equals((CharSequence)formModel.getFormType(), (CharSequence)FormType.UnionForm.getCode())) {
            formPageName = "UnionForm";
        }
        List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-web/src/main/java/${appCodePackage}/web/operation/", "XXX" + formPageName + "Controller.java", "${appCode}-start/src/main/resources/front/page/${appCode}-console/", "XXX" + formPageName + "List.html");
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
        expMap.put("appCodePackage", appCodePackage);
        expMap.put("middlePackage", middlePackage.replaceAll("_|\\.|-", "/"));
        for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
            String path = mainCodeTemplateFiles.get(i);
            String templateFile = mainCodeTemplateFiles.get(i + 1);
            String targetPath = ExpressionUtil.parse((String)path, expMap);
            ctdb.getMapData().put("BASE_PATH", this.getBasePath(SdEnvUtil.wrapperAppCode(appInfo.getAppCode())));
            ctdb.getMapData().put("codeData", mainCodeData);
            this.codeProduceInfoService.produceCodeFile("form", templateFile, mainCodeData.getClassName(), "XXX", formId, null, targetPath, appInfo, ctdb);
        }
        for (CodeTemplateData page : codeDataList) {
            if (StringUtils.isBlank((CharSequence)page.getTemplateFile())) continue;
            if (page.getParamMap() == null) {
                page.setParamMap(new HashMap());
            }
            String targetPath = "${appCode}-start/src/main/resources/front/page/${appCode}-console/";
            targetPath = ExpressionUtil.parse((String)targetPath, expMap);
            String templateFile = page.getTemplateFile();
            ctdb.getMapData().put("BASE_PATH", this.getBasePath(SdEnvUtil.wrapperAppCode(appInfo.getAppCode())));
            ctdb.getMapData().put("codeData", page);
            this.codeProduceInfoService.produceCodeFile("form", templateFile, page.getClassName(), "XXX", formId, null, targetPath, appInfo, ctdb);
        }
        return true;
    }

    private String getBasePath(String codePackagePath) {
        String[] strs = StringUtils.split((String)codePackagePath, (String)"/");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("..");
        for (String s : strs) {
            paths.add("..");
        }
        return StringUtils.join(paths, (String)"/");
    }

    public boolean generateRefactor(FormModelInfoDTO paramDTO) {
        String subsId = paramDTO.getSubsId();
        String appId = paramDTO.getAppId();
        String comId = paramDTO.getComId();
        String formId = paramDTO.getFormId();
        String userId = paramDTO.getLoginUserId();
        this.formModelRefactorRepository.deleteByFormId(formId);
        String now = CurrentDateUtil.getTodayDateEx2();
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(paramDTO.getTableModelId());
        fieldParam.setAscOrder("fieldCode");
        List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
        if (!StringUtils.equals((CharSequence)paramDTO.getFormType(), (CharSequence)FormType.Single.getCode())) {
            fieldParam.setObjectId(paramDTO.getJoinModelId());
            List joinFieldList = this.modelTableFieldService.queryList((Object)fieldParam);
            if (CollectionUtils.isNotEmpty((Collection)fieldList) && CollectionUtils.isNotEmpty((Collection)joinFieldList)) {
                fieldList.addAll(joinFieldList);
            }
        }
        FormAddFieldDO formFieldParam = new FormAddFieldDO();
        formFieldParam.setFormId(formId);
        formFieldParam.setAscOrder("fieldCode");
        List oriFormFieldList = this.formModelFieldRepository.queryList((Object)formFieldParam);
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            HashMap formFieldMap = new HashMap();
            HashMap tbFieldMap = new HashMap();
            oriFormFieldList.forEach(field -> {
                formFieldMap.put(String.format("%s-%s-%s-%s", field.getFieldCode(), field.getFieldName(), field.getFieldType(), field.getFieldOption()), field);
                formFieldMap.put(field.getFieldCode(), field);
                formFieldMap.put(field.getFieldId(), field);
            });
            fieldList.forEach(field -> {
                tbFieldMap.put(String.format("%s-%s-%s-%s", field.getFieldCode(), field.getFieldName(), field.getFieldType(), field.getFieldOption()), field);
                tbFieldMap.put(field.getFieldCode(), field);
                tbFieldMap.put(field.getFieldId(), field);
            });
            ArrayList<FormModelRefactorDO> refactorList = new ArrayList<FormModelRefactorDO>();
            for (ModelTableFieldDTO field2 : fieldList) {
                String key = String.format("%s-%s-%s-%s", field2.getFieldCode(), field2.getFieldName(), field2.getFieldType(), field2.getFieldOption());
                FormModelFieldDO formField = (FormModelFieldDO)formFieldMap.get(key);
                FormModelFieldDO fieldCodeLike = (FormModelFieldDO)formFieldMap.get(field2.getFieldCode());
                FormModelFieldDO oriField = (FormModelFieldDO)formFieldMap.get(field2.getFieldId());
                if (formField == null && fieldCodeLike == null && oriField == null) {
                    FormModelRefactorDO newField = new FormModelRefactorDO();
                    newField.setRecordKeyid(UUIDUtil.getUUID());
                    newField.setFormId(formId);
                    newField.setSubsId(subsId);
                    newField.setAppId(appId);
                    newField.setComId(comId);
                    newField.setRefactorType(RefactorType.Add.getCode());
                    newField.setCreateTime(now);
                    newField.setCreateUser(userId);
                    newField.setLastModifyTime(now);
                    newField.setLastModifyUser(userId);
                    newField.setFormFieldId(UUIDUtil.getUUID());
                    newField.setFieldId(field2.getFieldId());
                    newField.setFieldCode(field2.getFieldCode());
                    newField.setFieldName(field2.getFieldName());
                    newField.setFieldOption(field2.getFieldOption());
                    newField.setFieldLength(field2.getFieldLength());
                    newField.setFieldPrecision(field2.getFieldPrecision());
                    newField.setFieldType(field2.getFieldType());
                    newField.setTableModelId(field2.getObjectId());
                    if (StringUtils.equals((CharSequence)field2.getObjectId(), (CharSequence)paramDTO.getTableModelId())) {
                        newField.setTableModelCode(paramDTO.getTableModelCode());
                        newField.setTableModelName(paramDTO.getTableModelName());
                    } else {
                        newField.setTableModelCode(paramDTO.getJoinModelCode());
                        newField.setTableModelName(paramDTO.getJoinModelName());
                    }
                    refactorList.add(newField);
                    continue;
                }
                if (formField != null || fieldCodeLike == null && oriField == null) continue;
                FormModelRefactorDO updateField = new FormModelRefactorDO();
                updateField.setRecordKeyid(UUIDUtil.getUUID());
                updateField.setFormId(formId);
                updateField.setSubsId(subsId);
                updateField.setAppId(appId);
                updateField.setComId(comId);
                updateField.setRefactorType(RefactorType.Update.getCode());
                updateField.setCreateTime(now);
                updateField.setCreateUser(userId);
                updateField.setLastModifyTime(now);
                updateField.setLastModifyUser(userId);
                updateField.setFieldId(field2.getFieldId());
                updateField.setFieldCode(field2.getFieldCode());
                updateField.setFieldName(field2.getFieldName());
                updateField.setFieldOption(field2.getFieldOption());
                updateField.setFieldLength(field2.getFieldLength());
                updateField.setFieldPrecision(field2.getFieldPrecision());
                updateField.setFieldType(field2.getFieldType());
                updateField.setTableModelId(field2.getObjectId());
                if (StringUtils.equals((CharSequence)field2.getObjectId(), (CharSequence)paramDTO.getTableModelId())) {
                    updateField.setTableModelCode(paramDTO.getTableModelCode());
                    updateField.setTableModelName(paramDTO.getTableModelName());
                } else {
                    updateField.setTableModelCode(paramDTO.getJoinModelCode());
                    updateField.setTableModelName(paramDTO.getJoinModelName());
                }
                if (fieldCodeLike != null) {
                    updateField.setFormFieldId(fieldCodeLike.getFormFieldId());
                    updateField.setFormFieldCode(fieldCodeLike.getFieldCode());
                    updateField.setFormFieldName(fieldCodeLike.getFieldName());
                    updateField.setFormFieldType(fieldCodeLike.getFieldType());
                    updateField.setFormFieldOption(fieldCodeLike.getFieldOption());
                    updateField.setFormFieldLength(fieldCodeLike.getFieldLength());
                    updateField.setFormFieldPrecision(fieldCodeLike.getFieldPrecision());
                } else if (oriField != null) {
                    updateField.setFormFieldId(oriField.getFormFieldId());
                    updateField.setFormFieldCode(oriField.getFieldCode());
                    updateField.setFormFieldName(oriField.getFieldName());
                    updateField.setFormFieldType(oriField.getFieldType());
                    updateField.setFormFieldOption(oriField.getFieldOption());
                    updateField.setFormFieldLength(oriField.getFieldLength());
                    updateField.setFormFieldPrecision(oriField.getFieldPrecision());
                }
                refactorList.add(updateField);
            }
            oriFormFieldList.forEach(field -> {
                ModelTableFieldDTO tbFieldLike = (ModelTableFieldDTO)tbFieldMap.get(field.getFieldCode());
                ModelTableFieldDTO oriField = (ModelTableFieldDTO)tbFieldMap.get(field.getFieldId());
                if (tbFieldLike == null && oriField == null) {
                    FormModelRefactorDO deleteField = new FormModelRefactorDO();
                    deleteField.setRecordKeyid(UUIDUtil.getUUID());
                    deleteField.setFormId(formId);
                    deleteField.setSubsId(subsId);
                    deleteField.setAppId(appId);
                    deleteField.setComId(comId);
                    deleteField.setRefactorType(RefactorType.Delete.getCode());
                    deleteField.setCreateTime(now);
                    deleteField.setCreateUser(userId);
                    deleteField.setLastModifyTime(now);
                    deleteField.setLastModifyUser(userId);
                    deleteField.setTableModelId(paramDTO.getTableModelId());
                    deleteField.setTableModelCode(paramDTO.getTableModelCode());
                    deleteField.setTableModelName(paramDTO.getTableModelName());
                    deleteField.setFormFieldId(field.getFormFieldId());
                    deleteField.setFieldId(field.getFieldId());
                    deleteField.setFormFieldCode(field.getFieldCode());
                    deleteField.setFormFieldName(field.getFieldName());
                    deleteField.setFormFieldType(field.getFieldType());
                    deleteField.setFormFieldOption(field.getFieldOption());
                    deleteField.setFormFieldLength(field.getFieldLength());
                    deleteField.setFormFieldPrecision(field.getFieldPrecision());
                    refactorList.add(deleteField);
                }
            });
            if (CollectionUtils.isNotEmpty(refactorList)) {
                this.formModelRefactorRepository.batchInsert(refactorList);
            }
        }
        return true;
    }

    public boolean refactorFormModel(FormModelInfoDTO paramDTO, List<FormModelRefactorDTO> refactorList) {
        if (CollectionUtils.isEmpty(refactorList)) {
            return false;
        }
        String formId = paramDTO.getFormId();
        String userId = paramDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        for (FormModelRefactorDTO reField : refactorList) {
            String javaPropertyName;
            FormModelFieldDO formField;
            reField.setRefactorFlag(YesOrNO.YES.getCode());
            if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Add.getCode())) {
                formField = new FormModelFieldDO();
                BeanUtility.beanCopy((Object)reField, (Object)formField, (boolean)true);
                formField.setFormId(formId);
                formField.setFormFieldId(reField.getFormFieldId());
                javaPropertyName = TmModelUtil.fieldToProperty((String)reField.getFieldCode());
                formField.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                formField.setJavaPropertyName(javaPropertyName);
                formField.setJavaType(TmModelUtil.fieldTypeToJavaType((String)formField.getFieldType()));
                if (StringUtils.isNotBlank((CharSequence)formField.getFieldOption())) {
                    formField.setFieldFcId("FC003");
                } else if (StringUtils.equalsAny((CharSequence)formField.getJavaType(), (CharSequence[])new CharSequence[]{"int", "BigDecimal"})) {
                    formField.setFieldFcId("FC002");
                } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)formField.getFieldType(), (CharSequence[])new CharSequence[]{"DATE", "DATETIME"})) {
                    formField.setFieldFcId("FC006");
                } else {
                    formField.setFieldFcId("FC001");
                }
                this.formModelFieldRepository.insert((Object)formField);
            } else if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Update.getCode())) {
                formField = new FormListFieldDO();
                formField.setFormFieldId(reField.getFormFieldId());
                formField.setFieldId(reField.getFieldId());
                formField.setFieldCode(reField.getFieldCode());
                formField.setFieldName(reField.getFieldName());
                formField.setFieldOption(reField.getFieldOption());
                formField.setFieldLength(reField.getFieldLength());
                formField.setFieldPrecision(reField.getFieldPrecision());
                formField.setFieldType(reField.getFieldType());
                javaPropertyName = TmModelUtil.fieldToProperty((String)reField.getFieldCode());
                formField.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                formField.setJavaPropertyName(javaPropertyName);
                formField.setJavaType(TmModelUtil.fieldTypeToJavaType((String)formField.getFieldType()));
                if (StringUtils.isNotBlank((CharSequence)formField.getFieldOption())) {
                    formField.setFieldFcId("FC003");
                } else if (StringUtils.equalsAny((CharSequence)formField.getJavaType(), (CharSequence[])new CharSequence[]{"int", "BigDecimal"})) {
                    formField.setFieldFcId("FC002");
                } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)formField.getFieldType(), (CharSequence[])new CharSequence[]{"DATE", "DATETIME"})) {
                    formField.setFieldFcId("FC006");
                } else {
                    formField.setFieldFcId("FC001");
                }
                this.formModelFieldRepository.updateByPk((Object)formField);
            } else if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Delete.getCode())) {
                FormModelFieldDO deleteField = new FormModelFieldDO();
                deleteField.setFormFieldId(reField.getFormFieldId());
                deleteField.setFieldId(reField.getFieldId());
                this.formModelFieldRepository.deleteByPk((Object)deleteField);
            }
            FormModelRefactorDO reFieldDO = new FormModelRefactorDO();
            reFieldDO.setRecordKeyid(reField.getRecordKeyid());
            reFieldDO.setRefactorFlag(YesOrNO.YES.getCode());
            this.formModelRefactorRepository.updateByPk((Object)reFieldDO);
        }
        boolean flag = true;
        int count = 0;
        FnModelInfoDTO fnParam = new FnModelInfoDTO();
        fnParam.setFormId(formId);
        List fnList = this.fnModelInfoService.queryList((Object)fnParam);
        for (FnModelInfoDTO fn : fnList) {
            String fnType1 = fn.getFnType1();
            boolean initFlag = this.devtypeInfoExecService.refactor(fnType1, fn.getFnType2(), userId, fn.getFnId());
            if (!initFlag) {
                flag = false;
            }
            ++count;
        }
        return true;
    }

    public String createFnModelInfo(FormModelInfoDTO form, FnTypeInfoDO fnType2) {
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(form.getAppId());
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        FnModelInfoDTO fnConfig = new FnModelInfoDTO();
        fnConfig.setFnType2(fnType2.getFnType2());
        fnConfig.setSubsId(appInfo.getSubsId());
        fnConfig.setAppId(form.getAppId());
        fnConfig.setTableModelId(form.getTableModelId());
        fnConfig.setFormId(form.getFormId());
        String fnCode = this.fnModelInfoService.queryCodeWithPrefix(appInfo.getSubsId(), fnType2.getFnType2());
        fnConfig.setFnId(appInfo.getSubsId() + fnCode);
        fnConfig.setFnCode(fnCode);
        fnConfig.setFormCode(form.getFormCode());
        fnConfig.setFormName(form.getFormName());
        fnConfig.setFnName(form.getFormName() + fnType2.getFnType2Name());
        fnConfig.setComId(form.getComId());
        fnConfig.setComName(form.getComName());
        fnConfig.setSubsName(appInfo.getSubsName());
        fnConfig.setAppCode(appInfo.getAppCode());
        fnConfig.setAppName(appInfo.getAppName());
        fnConfig.setLoginUserId(form.getLoginUserId());
        fnConfig.setCreateUser(form.getLoginUserId());
        fnConfig.setCreateTime(form.getCreateTime());
        fnConfig.setUpdateUser(form.getLoginUserId());
        fnConfig.setUpdateTime(form.getCreateTime());
        fnConfig.setTableModelCode(form.getTableModelCode());
        fnConfig.setTableModelName(form.getTableModelName());
        fnConfig.setFnDesc(form.getFormName() + fnType2.getFnType2Name());
        fnConfig.setFnType2Name(fnType2.getFnType2Name());
        fnConfig.setFnType1(fnType2.getFnType1());
        fnConfig.setFnType1Name(fnType2.getFnType1Name());
        fnConfig.setFnCategory(fnType2.getFnCategory());
        int re = this.fnModelInfoService.updateByPk((Object)fnConfig);
        boolean reCreateFlag = false;
        if (re == 0) {
            re = this.fnModelInfoService.insert((Object)fnConfig);
        } else {
            reCreateFlag = true;
        }
        return fnConfig.getFnId();
    }
}

