/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.acl.repository.QueryDatasourceRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.QueryDsRelationRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.QueryDatasourceDO;
import com.irdstudio.allinrdm.dev.console.facade.QueryDatasourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QueryDatasourceDTO;
import com.irdstudio.allinrdm.dev.console.types.ImportOption;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.db.enums.IndexType;
import com.irdstudio.sdk.beans.db.vo.DBImportTableFieldVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableIndexVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableVO;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryDatasourceServiceImpl")
public class QueryDatasourceServiceImpl
extends BaseServiceImpl<QueryDatasourceDTO, QueryDatasourceDO, QueryDatasourceRepository>
implements QueryDatasourceService {
    @Autowired
    private QueryDsRelationRepository queryDsRelationRepository;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private ModelFolderInfoService modelFolderInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableIndexService modelTableIndexService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    public int importDsTableModel(QueryDatasourceDTO queryDatasourceVo) {
        String dsId = queryDatasourceVo.getDsId();
        String userId = queryDatasourceVo.getLoginUserId();
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        QueryDatasourceDO ds = new QueryDatasourceDO();
        ds.setDsId(dsId);
        ds = (QueryDatasourceDO)((QueryDatasourceRepository)this.getRepository()).queryByPk((Object)ds);
        if (ds == null) {
            return -1;
        }
        PaasAppsInfoDTO pt = new PaasAppsInfoDTO();
        pt.setAppId(queryDatasourceVo.getAppId());
        pt = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)pt);
        String refDbAppid = queryDatasourceVo.getAppId();
        if (pt != null) {
            refDbAppid = pt.getRefDbAppid();
        }
        int clearCount = this.clearDsTable(dsId);
        int importCount = this.importDb(ds, refDbAppid, userId, nowTime);
        return importCount;
    }

    private int clearDsTable(String dsId) {
        int num = 0;
        return num += this.queryDsRelationRepository.deleteByDsId(dsId);
    }

    private int importDb(QueryDatasourceDO ds, String refDbAppid, String userId, String nowTime) {
        DBImportPlugin plugin = DBImportPlugin.Factory.getInstance((int)ds.getDsDbms());
        if (plugin == null) {
            return -1;
        }
        int count = 0;
        DBInfoVO db = plugin.readDBInfo(ds.getDsConnStr(), ds.getDsUsername(), ds.getDsPassword());
        String appId = refDbAppid;
        if (db != null) {
            String createTime = nowTime;
            Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
            int order = 1;
            for (DBImportTableVO tb : db.getTables()) {
                ModelTableInfoDTO model = null;
                ModelTableInfoDTO existsTb = new ModelTableInfoDTO();
                existsTb.setAppId(appId);
                existsTb.setObjectCode(tb.getTable_name());
                existsTb.setObjectName(tb.getTable_comment());
                List existsTbList = this.modelTableInfoService.queryListByPage((Object)existsTb);
                if (CollectionUtils.isNotEmpty((Collection)existsTbList)) {
                    if (!StringUtils.equals((CharSequence)ds.getImportOption(), (CharSequence)ImportOption.Cover.getCode())) continue;
                    model = (ModelTableInfoDTO)existsTbList.get(0);
                    model.setOrderValue(Integer.valueOf(order++));
                    model.setLastModifyTime(createTime);
                    model.setLastModifyUser(userId);
                    this.modelTableFieldService.deleteByObjectId(model.getObjectId());
                    this.modelTableIndexService.deleteByObjectId(model.getObjectId());
                } else {
                    model = new ModelTableInfoDTO();
                    model.setOrderValue(Integer.valueOf(order++));
                    model.setObjectId(UUIDUtil.getUUID());
                    model.setFolderId(appId);
                    model.setCreateTime(createTime);
                    model.setCreateUser(userId);
                    model.setLastModifyTime(createTime);
                    model.setLastModifyUser(userId);
                }
                model.setObjectCode(tb.getTable_name());
                if (StringUtils.isNotBlank((CharSequence)tb.getTable_comment()) && tb.getTable_comment().length() > 80) {
                    tb.setTable_comment(tb.getTable_comment().substring(0, 80));
                }
                model.setObjectName(tb.getTable_comment());
                model.setAppId(appId);
                model.setObjectDesc(tb.getTable_comment());
                model.setObjectType(Integer.valueOf(1201));
                model.setObjectState(Integer.valueOf(0));
                model.setSubjectId("0");
                model.setTableDataCycle("00");
                count += this.modelTableInfoService.insert((Object)model);
                DBImportTableIndexVO pkKey = null;
                for (DBImportTableIndexVO ii : tb.getIndexes()) {
                    ModelTableIndexDTO index = new ModelTableIndexDTO();
                    index.setObjectId(model.getObjectId());
                    index.setIndexFields(ii.getColumns());
                    index.setCreateTime(createTime);
                    index.setCreateUser(userId);
                    if (IndexType.Primary.getCode().equals(ii.getIndex_type())) {
                        index.setIndexTypePrimary("Y");
                        index.setIndexTypeUnique("N");
                        index.setIndexName(ii.getIndex_name());
                        pkKey = ii;
                    } else {
                        index.setIndexTypePrimary("N");
                        index.setIndexName(ii.getIndex_name());
                    }
                    count += this.modelTableIndexService.insert((Object)index);
                }
                int fieldOrder = 2;
                for (DBImportTableFieldVO ff : tb.getFields()) {
                    ModelTableFieldDTO field = new ModelTableFieldDTO();
                    field.setObjectId(model.getObjectId());
                    field.setFieldId(UUIDUtil.getUUID());
                    field.setCreateTime(createTime);
                    field.setCreateUser(userId);
                    field.setFieldCode(ff.getColumn_name());
                    if (StringUtils.isNotBlank((CharSequence)ff.getIs_nullable()) && ff.getIs_nullable().equals("YES")) {
                        field.setIsAllowNull("Y");
                    } else {
                        field.setIsAllowNull("N");
                    }
                    field.setFieldDesc(ff.getColumn_comment());
                    field.setFieldName(ff.getColumn_comment());
                    field.setDefValue(ff.getColumn_default());
                    field.setFieldType(ff.getData_type());
                    if (pkKey != null) {
                        if (pkKey.getColumns().contains(ff.getColumn_name())) {
                            field.setIsPk("Y");
                            field.setFieldOrder(Integer.valueOf(1));
                        } else {
                            field.setIsPk("N");
                            field.setFieldOrder(Integer.valueOf(fieldOrder++));
                        }
                    } else {
                        field.setIsPk("N");
                        field.setFieldOrder(Integer.valueOf(fieldOrder++));
                    }
                    Matcher matcher = pattern.matcher(ff.getColumn_type());
                    if (matcher.matches()) {
                        field.setFieldLength(Integer.valueOf(matcher.group(1)));
                        if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                            field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getFieldName()) && field.getFieldName().length() > 80) {
                        field.setFieldName(field.getFieldName().substring(0, 80));
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getFieldDesc()) && field.getFieldDesc().length() > 254) {
                        field.setFieldDesc(field.getFieldDesc().substring(0, 254));
                    }
                    count += this.modelTableFieldService.insert((Object)field);
                }
            }
        }
        return count;
    }
}

