/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DevFnCreateTaskImpl;
import com.irdstudio.allinrdm.dev.console.facade.FormImportFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelApiService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelButtonService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelPageService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelRefactorService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelValidateService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateButton;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateData;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateField;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethod;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInput;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInvoke;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodReturn;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormImportFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelApiDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelButtonDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelPageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelRefactorDTO;
import com.irdstudio.allinrdm.dev.console.types.ButtonAction;
import com.irdstudio.allinrdm.dev.console.types.ButtonCategory;
import com.irdstudio.allinrdm.dev.console.types.ButtonPosition;
import com.irdstudio.allinrdm.dev.console.types.RefactorType;
import com.irdstudio.allinrdm.sam.console.facade.FnValidateInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnValidateInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqModelInfoService;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.dto.SeqModelInfoDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DevFnImportTaskImpl")
public class DevFnImportTaskImpl
extends DevFnCreateTaskImpl {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private FormModelFieldService formModelFieldService;
    @Autowired
    private FormModelValidateService formModelValidateService;
    @Autowired
    private FormImportFieldService formImportFieldService;
    @Autowired
    private FormModelButtonService formModelButtonService;
    @Autowired
    private FormModelPageService formModelPageService;
    @Autowired
    private FormModelApiService formModelApiService;
    @Autowired
    private FormModelInfoService formModelInfoService;
    @Autowired
    private FormModelRefactorService formModelRefactorService;
    @Autowired
    private SeqModelInfoService seqModelInfoService;
    private final String func_method_name = "excelImport";

    @Override
    public boolean create(FnModelInfoDTO fnModelInfo, boolean reCreateFlag, Map<String, Object> params) {
        return this.initFormData(fnModelInfo, reCreateFlag);
    }

    @Override
    protected boolean initFormData(FnModelInfoDTO fnModelInfo, boolean reCreateFlag) {
        boolean flag = true;
        ModelTableInfoDTO tableModelInfo = new ModelTableInfoDTO();
        tableModelInfo.setObjectId(fnModelInfo.getTableModelId());
        tableModelInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableModelInfo);
        FormModelFieldDTO modelFieldParam = new FormModelFieldDTO();
        modelFieldParam.setFormId(fnModelInfo.getFormId());
        List formFieldList = this.formModelFieldService.queryList((Object)modelFieldParam);
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String formCode = fnModelInfo.getFormCode();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String subsId = fnModelInfo.getSubsId();
        String userId = fnModelInfo.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        if (CollectionUtils.isNotEmpty((Collection)formFieldList)) {
            ArrayList formImportFieldList = new ArrayList(formFieldList.size());
            ArrayList formUpdEvalList = new ArrayList(formFieldList.size());
            formFieldList.forEach(formField -> {
                FormImportFieldDTO importField = new FormImportFieldDTO();
                BeanUtility.beanCopy((Object)formField, (Object)importField, (boolean)true);
                importField.setFnId(fnId);
                importField.setFieldImportName(formField.getFieldName());
                formImportFieldList.add(importField);
            });
            this.formImportFieldService.batchInsert(formImportFieldList);
        }
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setFnId(fnId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formCode) + "ExcelImport.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setFnId(fnId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String InsertSingleUrlAfterStr = "/excelImport";
        String url = String.format("/api/%s%s", TmModelUtil.tableCodeToClassName((String)formCode), InsertSingleUrlAfterStr);
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        FormModelApiDTO formTemplateDownloadApi = new FormModelApiDTO();
        formTemplateDownloadApi.setApiId(UUIDUtil.getUUID());
        formTemplateDownloadApi.setFormId(formId);
        formTemplateDownloadApi.setFnId(fnId);
        formTemplateDownloadApi.setApiName("\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u63a5\u53e3");
        formTemplateDownloadApi.setApiUrl(String.format("/api/%s/%s", TmModelUtil.tableCodeToClassName((String)formCode), "excelImportTemplateDownload"));
        formTemplateDownloadApi.setApiDesc("\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u63a5\u53e3");
        this.formModelApiService.insert((Object)formTemplateDownloadApi);
        ArrayList<FormModelButtonDTO> formButtonList = new ArrayList<FormModelButtonDTO>(2);
        FormModelButtonDTO saveBtn = new FormModelButtonDTO();
        saveBtn.setFormId(formId);
        saveBtn.setFnId(fnId);
        saveBtn.setButtonId(UUIDUtil.getUUID());
        saveBtn.setButtonCode("save");
        saveBtn.setButtonName("\u5bfc\u5165");
        saveBtn.setButtonIcon("Upload");
        saveBtn.setButtonOrder(Integer.valueOf(1));
        saveBtn.setApiUrl(formApi.getApiUrl());
        saveBtn.setApiId(formApi.getApiId());
        saveBtn.setApiName(formApi.getApiName());
        saveBtn.setButtonAction(ButtonAction.ValidateInvokeAPI.getCode());
        saveBtn.setButtonCategory(ButtonCategory.Standard.getCode());
        saveBtn.setButtonPosition(ButtonPosition.FormBottom.getCode());
        formButtonList.add(saveBtn);
        FormModelButtonDTO closeBtn = new FormModelButtonDTO();
        closeBtn.setFormId(formId);
        closeBtn.setFnId(fnId);
        closeBtn.setButtonId(UUIDUtil.getUUID());
        closeBtn.setButtonCode("close");
        closeBtn.setButtonName("\u5173\u95ed");
        closeBtn.setButtonIcon("Close");
        closeBtn.setButtonOrder(Integer.valueOf(2));
        closeBtn.setButtonAction(ButtonAction.Close.getCode());
        closeBtn.setButtonCategory(ButtonCategory.Standard.getCode());
        closeBtn.setButtonPosition(ButtonPosition.FormBottom.getCode());
        formButtonList.add(closeBtn);
        this.formModelButtonService.batchInsert(formButtonList);
        return flag;
    }

    @Override
    public boolean refactor(FnModelInfoDTO fnModelInfo) {
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String userId = fnModelInfo.getLoginUserId();
        FormModelRefactorDTO refactorParam = new FormModelRefactorDTO();
        refactorParam.setFormId(formId);
        refactorParam.setRefactorFlag(YesOrNO.YES.getCode());
        List refactorList = this.formModelRefactorService.queryList((Object)refactorParam);
        if (CollectionUtils.isNotEmpty((Collection)refactorList)) {
            for (FormModelRefactorDTO reField : refactorList) {
                FormListFieldDTO formField;
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Add.getCode())) {
                    formField = new FormListFieldDTO();
                    formField.setFormFieldId(reField.getFormFieldId());
                    if ((formField = (FormModelFieldDTO)this.formModelFieldService.queryByPk((Object)formField)) == null) continue;
                    FormImportFieldDTO importField = new FormImportFieldDTO();
                    BeanUtility.beanCopy((Object)formField, (Object)importField, (boolean)true);
                    importField.setFnId(fnId);
                    importField.setFieldImportName(formField.getFieldName());
                    this.formImportFieldService.insert((Object)importField);
                    continue;
                }
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Update.getCode())) {
                    formField = new FormListFieldDTO();
                    formField.setFormFieldId(reField.getFormFieldId());
                    formField = (FormModelFieldDTO)this.formModelFieldService.queryByPk((Object)formField);
                    FormImportFieldDTO importFieldParam = new FormImportFieldDTO();
                    importFieldParam.setFormFieldId(formField.getFormFieldId());
                    importFieldParam.setFormId(formId);
                    List importFields = this.formImportFieldService.queryListByPage((Object)importFieldParam);
                    if (!CollectionUtils.isNotEmpty((Collection)importFields)) continue;
                    for (FormImportFieldDTO importField : importFields) {
                        BeanUtility.beanCopy((Object)formField, (Object)importField, (boolean)true);
                        importField.setFnId(fnId);
                        importField.setFieldImportName(formField.getFieldName());
                        this.formImportFieldService.updateByPk((Object)importField);
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Delete.getCode())) continue;
                FormImportFieldDTO importFieldParam = new FormImportFieldDTO();
                importFieldParam.setFormFieldId(reField.getFormFieldId());
                importFieldParam.setFormId(formId);
                List importFields = this.formImportFieldService.queryListByPage((Object)importFieldParam);
                if (!CollectionUtils.isNotEmpty((Collection)importFields)) continue;
                for (FormImportFieldDTO importField : importFields) {
                    this.formImportFieldService.deleteByPk((Object)importField);
                }
            }
        }
        return true;
    }

    @Override
    public boolean delete(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            String formId = fnModelInfo.getFormId();
            this.formImportFieldService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelButtonService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelValidateService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelPageService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelApiService.deleteByFnId(formId, fnModelInfo.getFnId());
            return true;
        }
        return super.delete(fnModelInfo);
    }

    @Override
    public List<String> validate(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
            ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
            HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
            ArrayList<String> failureMessageList = new ArrayList<String>();
            String formId = fnModelInfo.getFormId();
            String fnId = fnModelInfo.getFnId();
            List<String> validTypes = Arrays.asList("importfield", "btn");
            for (String type : validTypes) {
                FnValidateInfoDTO valid = new FnValidateInfoDTO();
                valid.setRecordKeyid(UUIDUtil.getUUID());
                valid.setFnId(fnModelInfo.getFnId());
                valid.setFormId(formId);
                valid.setValidId(formId);
                valid.setCreateUser(fnModelInfo.getLoginUserId());
                valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                valid.setValidType(type);
                validList.add(valid);
                validMap.put(type, valid);
            }
            if (CollectionUtils.isNotEmpty(validList)) {
                fnValidateService.batchInsert(validList);
            }
            FormImportFieldDTO importField = new FormImportFieldDTO();
            importField.setFormId(formId);
            importField.setFnId(fnId);
            List importFieldList = this.formImportFieldService.queryList((Object)importField);
            FnValidateInfoDTO afield = (FnValidateInfoDTO)validMap.get("importfield");
            for (FormImportFieldDTO addF : importFieldList) {
                if (!CollectionUtils.isNotEmpty((Collection)addF.validate())) continue;
                afield.setValidRe(CheckResult.Fail.getCode());
                afield.setValidTime(CurrentDateUtil.getTodayDateEx2());
                afield.setValidMsg("\u8868\u5355\u5bfc\u5165\u5b57\u6bb5\u6821\u9a8c\u4e0d\u901a\u8fc7");
                failureMessageList.add(afield.getValidMsg());
                break;
            }
            if (StringUtils.isBlank((CharSequence)afield.getValidRe())) {
                afield.setValidRe(CheckResult.Pass.getCode());
                afield.setValidTime(CurrentDateUtil.getTodayDateEx2());
            }
            fnValidateService.updateByPk((Object)afield);
            FormModelButtonDTO modelBtn = new FormModelButtonDTO();
            modelBtn.setFormId(formId);
            modelBtn.setFnId(fnId);
            List btnList = this.formModelButtonService.queryList((Object)modelBtn);
            FnValidateInfoDTO btnValid = (FnValidateInfoDTO)validMap.get("btn");
            for (FormModelButtonDTO btn : btnList) {
                if (!CollectionUtils.isNotEmpty((Collection)btn.validate())) continue;
                btnValid.setValidRe(CheckResult.Fail.getCode());
                btnValid.setValidTime(CurrentDateUtil.getTodayDateEx2());
                btnValid.setValidMsg("\u8868\u5355\u5bfc\u5165\u6309\u94ae\u6821\u9a8c\u4e0d\u901a\u8fc7");
                failureMessageList.add(btnValid.getValidMsg());
                break;
            }
            if (StringUtils.isBlank((CharSequence)btnValid.getValidRe())) {
                btnValid.setValidRe(CheckResult.Pass.getCode());
                btnValid.setValidTime(CurrentDateUtil.getTodayDateEx2());
            }
            fnValidateService.updateByPk((Object)btnValid);
            return failureMessageList;
        }
        return super.validate(fnModelInfo);
    }

    @Override
    public CodeTemplateData generate(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            CodeTemplateData codeTemplateData = new CodeTemplateData();
            FormModelInfoDTO formModel = new FormModelInfoDTO();
            formModel.setFormId(fnModelInfo.getFormId());
            formModel = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formModel);
            String tableModelId = formModel.getTableModelId();
            String tableModelCode = formModel.getTableModelCode();
            String tableModelName = formModel.getTableModelName();
            String appId = formModel.getAppId();
            String fnId = fnModelInfo.getFnId();
            String formId = fnModelInfo.getFormId();
            String formCode = fnModelInfo.getFormCode();
            String fnType2 = fnModelInfo.getFnType2();
            String userId = fnModelInfo.getLoginUserId();
            codeTemplateData.setTemplateFile("XXXExcelImport.html");
            codeTemplateData.setPackageName(formModel.getFolderName());
            codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
            codeTemplateData.setClassDesc(formModel.getFormName());
            codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
            codeTemplateData.setParamMap(new HashMap());
            codeTemplateData.getParamMap().put("fnType2", fnType2);
            FormImportFieldDTO importFieldParam = new FormImportFieldDTO();
            importFieldParam.setFormId(formId);
            importFieldParam.setFnId(fnId);
            List importFieldList = this.formImportFieldService.queryList((Object)importFieldParam);
            if (CollectionUtils.isNotEmpty((Collection)importFieldList)) {
                codeTemplateData.setFieldList(importFieldList.stream().map(f -> {
                    CodeTemplateField field = new CodeTemplateField();
                    BeanUtility.beanCopy((Object)f, (Object)field);
                    if (field.getFieldName() == null) {
                        field.setFieldName(field.getFieldCode());
                    }
                    field.setPageUrl(this.pageUrlHandle(f.getPageId(), f.getPageUrl()));
                    field.setPageParam(this.parseButtonParam(f.getPageParam()));
                    field.setPageReturn(this.parseButtonParam(f.getPageReturn()));
                    if (StringUtils.isNotBlank((CharSequence)f.getSeqId())) {
                        SeqModelInfoDTO seqInfo = new SeqModelInfoDTO();
                        seqInfo.setSeqId(f.getSeqId());
                        seqInfo = this.seqModelInfoService.queryByPk(seqInfo);
                        field.setSeqInfo(seqInfo);
                        codeTemplateData.getParamMap().put("hasSeqImport", YesOrNO.YES.getCode());
                    }
                    return field;
                }).collect(Collectors.toList()));
            }
            FormModelButtonDTO btnParam = new FormModelButtonDTO();
            btnParam.setFormId(formId);
            btnParam.setFnId(fnId);
            List btnList = this.formModelButtonService.queryList((Object)btnParam);
            if (CollectionUtils.isNotEmpty((Collection)btnList)) {
                codeTemplateData.setButtonList(btnList.stream().map(b -> {
                    CodeTemplateButton btn = new CodeTemplateButton();
                    BeanUtility.beanCopy((Object)b, (Object)btn);
                    btn.setApiUrl(StringUtils.replaceOnce((String)btn.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
                    btn.setPageUrl(this.pageUrlHandle(b.getPageId(), b.getPageUrl()));
                    btn.setApiParam(this.parseButtonParam(b.getApiParam()));
                    btn.setPageParam(this.parseButtonParam(b.getPageParam()));
                    return btn;
                }).collect(Collectors.toList()));
            }
            CodeTemplateMethod method = new CodeTemplateMethod();
            FormModelApiDTO formApi = new FormModelApiDTO();
            formApi.setFormId(formId);
            formApi.setFnId(fnId);
            formApi.setApiName("\u5bfc\u5165\u63a5\u53e3");
            List apiList = this.formModelApiService.queryListByPage((Object)formApi);
            if (CollectionUtils.isNotEmpty((Collection)apiList)) {
                formApi = (FormModelApiDTO)apiList.get(0);
                method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
                codeTemplateData.getParamMap().put("restfulUrl", method.getRestfulUrl());
            }
            method.setMethodName("excelImport");
            if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
                method.setComment(fnModelInfo.getFnDesc());
            } else {
                method.setComment(fnModelInfo.getFnName());
            }
            CodeTemplateMethodInput input = new CodeTemplateMethodInput();
            input.setClassType(TmModelUtil.tableCodeToClassName((String)formCode) + "DTO");
            input.setListFlag(YesOrNO.YES.getCode());
            input.setPropertyName("input");
            method.setInputType(input);
            CodeTemplateMethodInput output = new CodeTemplateMethodInput();
            output.setClassType("int");
            output.setListFlag(YesOrNO.NO.getCode());
            output.setPropertyName("output");
            method.setOutputType(output);
            CodeTemplateMethodInvoke invoke = new CodeTemplateMethodInvoke();
            invoke.setOutputType(output);
            invoke.setServiceName("super");
            invoke.setServiceMethod("batchInsert");
            method.setInvoke(invoke);
            method.setResult(new CodeTemplateMethodReturn());
            codeTemplateData.setMethodList(Arrays.asList(method));
            codeTemplateData.getParamMap().put("templateRestfulUrl", StringUtils.replaceOnce((String)String.format("/api/%s/%s", TmModelUtil.tableCodeToClassName((String)formCode), "excelImportTemplateDownload"), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            return codeTemplateData;
        }
        return super.generate(fnModelInfo);
    }
}

