/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.portal.console.types.ColWidthType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DevFnCreateTaskImpl;
import com.irdstudio.allinrdm.dev.console.facade.FormListCondService;
import com.irdstudio.allinrdm.dev.console.facade.FormListFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormListGroupService;
import com.irdstudio.allinrdm.dev.console.facade.FormListQueryService;
import com.irdstudio.allinrdm.dev.console.facade.FormListSettingService;
import com.irdstudio.allinrdm.dev.console.facade.FormListSortService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelApiService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelButtonService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelPageService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelRefactorService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateButton;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateData;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateField;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateListGroup;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateListQuery;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateListSort;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethod;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInput;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInvoke;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodReturn;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateSqlCond;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormButtonParam;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListCondDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListGroupDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListQueryDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListSettingDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListSortDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelApiDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelButtonDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelPageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelRefactorDTO;
import com.irdstudio.allinrdm.dev.console.types.ButtonAction;
import com.irdstudio.allinrdm.dev.console.types.ButtonCategory;
import com.irdstudio.allinrdm.dev.console.types.ButtonPosition;
import com.irdstudio.allinrdm.dev.console.types.FormFieldSourceType;
import com.irdstudio.allinrdm.dev.console.types.PageLinkType;
import com.irdstudio.allinrdm.dev.console.types.PageModelType;
import com.irdstudio.allinrdm.dev.console.types.RefactorType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DevFnListTaskImpl")
public class DevFnListTaskImpl
extends DevFnCreateTaskImpl {
    @Autowired
    protected ModelTableInfoService modelTableInfoService;
    @Autowired
    protected FormModelFieldService formModelFieldService;
    @Autowired
    protected FormListSettingService formListSettingService;
    @Autowired
    protected FormListQueryService formListQueryService;
    @Autowired
    protected FormModelButtonService formModelButtonService;
    @Autowired
    protected FormListFieldService formListFieldService;
    @Autowired
    protected FormListGroupService formListGroupService;
    @Autowired
    protected FormListSortService formListSortService;
    @Autowired
    protected FormModelPageService formModelPageService;
    @Autowired
    protected FormModelApiService formModelApiService;
    @Autowired
    protected FormModelInfoService formModelInfoService;
    @Autowired
    protected FormModelRefactorService formModelRefactorService;
    @Autowired
    protected FormListCondService formListCondService;

    @Override
    public boolean create(FnModelInfoDTO fnModelInfo, boolean reCreateFlag, Map<String, Object> params) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            return this.initFormData(fnModelInfo, reCreateFlag);
        }
        fnModelInfo.setPageTypes(Arrays.asList(PageModelType.List.getCode()));
        fnModelInfo.setDataModels(Arrays.asList(SrvModelTypeEnum.QUERY.getType()));
        FnType fnTypeEnum = FnType.get((String)fnModelInfo.getFnType2());
        boolean flag = this.initPageData(fnModelInfo, fnTypeEnum);
        if (flag) {
            flag = this.initSrvData(fnModelInfo);
        }
        return flag;
    }

    @Override
    protected boolean initFormData(FnModelInfoDTO fnModelInfo, boolean reCreateFlag) {
        boolean flag = true;
        ModelTableInfoDTO tableModelInfo = new ModelTableInfoDTO();
        tableModelInfo.setObjectId(fnModelInfo.getTableModelId());
        tableModelInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableModelInfo);
        FormModelFieldDTO modelFieldParam = new FormModelFieldDTO();
        modelFieldParam.setFormId(fnModelInfo.getFormId());
        List formFieldList = this.formModelFieldService.queryList((Object)modelFieldParam);
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String formCode = fnModelInfo.getFormCode();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String subsId = fnModelInfo.getSubsId();
        String userId = fnModelInfo.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        FormModelPageDTO formPage = new FormModelPageDTO();
        formPage.setPageId(UUIDUtil.getUUID());
        formPage.setFormId(formId);
        formPage.setFnId(fnId);
        formPage.setPageName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        formPage.setPageUrl(TmModelUtil.tableCodeToClassName((String)formCode) + "List.html");
        formPage.setPageDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u9875\u9762");
        this.formModelPageService.insert((Object)formPage);
        FormModelApiDTO formApi = new FormModelApiDTO();
        formApi.setApiId(UUIDUtil.getUUID());
        formApi.setFormId(formId);
        formApi.setFnId(fnId);
        formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String InsertSingleUrlAfterStr = "/" + SrvModelTypeEnum.QUERY.getCode();
        String url = String.format("/api/%s%s", TmModelUtil.tableCodeToClassName((String)formCode), InsertSingleUrlAfterStr);
        formApi.setApiUrl(url);
        formApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formApi);
        FormModelApiDTO formDeleteApi = new FormModelApiDTO();
        formDeleteApi.setFormId(formId);
        formDeleteApi.setApiName(FnType.Remove.getName() + "\u63a5\u53e3");
        List delApis = this.formModelApiService.queryListByPage((Object)formDeleteApi);
        if (CollectionUtils.isNotEmpty((Collection)delApis)) {
            formDeleteApi = (FormModelApiDTO)delApis.get(0);
        }
        ArrayList<FormButtonParam> pkFieldList = new ArrayList<FormButtonParam>();
        for (FormModelFieldDTO field : formFieldList) {
            if (!StringUtils.equals((CharSequence)field.getIsPk(), (CharSequence)YesOrNO.YES.getCode())) continue;
            FormButtonParam p = new FormButtonParam();
            p.setVarCode(field.getJavaPropertyName());
            p.setVarVal(String.format("${%s}", field.getJavaPropertyName()));
            p.setVarDesc(field.getFieldDesc());
            p.setVarType("F");
            pkFieldList.add(p);
        }
        FormModelPageDTO viewPage = new FormModelPageDTO();
        ArrayList<FormModelButtonDTO> formButtonList = new ArrayList<FormModelButtonDTO>(4);
        List buttonList = Arrays.asList({"add", "\u65b0\u589e", "Plus"}, {"update", "\u4fee\u6539", "Edit"}, {"delete", "\u5220\u9664", "Delete"}, {"view", "\u67e5\u770b", "View"});
        for (int i = 0; i < buttonList.size(); ++i) {
            String[] button = (String[])buttonList.get(i);
            FormModelButtonDTO btn = new FormModelButtonDTO();
            btn.setFormId(formId);
            btn.setFnId(fnId);
            btn.setButtonId(UUIDUtil.getUUID());
            btn.setButtonCode(button[0]);
            btn.setButtonName(button[1]);
            btn.setWinTitle(button[1]);
            btn.setButtonIcon(button[2]);
            btn.setButtonOrder(Integer.valueOf(i + 1));
            if (StringUtils.equals((CharSequence)"delete", (CharSequence)button[0])) {
                btn.setApiUrl(formDeleteApi.getApiUrl());
                btn.setApiId(formDeleteApi.getApiId());
                btn.setApiName(formDeleteApi.getApiName());
                btn.setButtonAction(ButtonAction.ConfirmInvokeAPI.getCode());
                btn.setNoteMessage("\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u6761\u8bb0\u5f55?");
                btn.setButtonCategory(ButtonCategory.Standard.getCode());
                btn.setButtonPosition(ButtonPosition.TableOp.getCode());
                btn.setApiParam(JSON.toJSONString(pkFieldList));
            } else {
                FormModelPageDTO pageParam = new FormModelPageDTO();
                pageParam.setPageName(button[1] + "\u9875\u9762");
                pageParam.setFormId(formId);
                List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
                if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    FormModelPageDTO page = (FormModelPageDTO)pageList.get(0);
                    btn.setPageUrl(page.getPageUrl());
                    btn.setPageId(page.getPageId());
                    btn.setPageName(page.getPageName());
                    if (StringUtils.equals((CharSequence)"view", (CharSequence)button[0])) {
                        BeanUtility.beanCopy((Object)page, (Object)viewPage, (boolean)true);
                    }
                }
                btn.setButtonAction(ButtonAction.Dialog.getCode());
                btn.setButtonCategory(ButtonCategory.Standard.getCode());
                if (StringUtils.equals((CharSequence)button[0], (CharSequence)"add")) {
                    btn.setButtonPosition(ButtonPosition.TableHeader.getCode());
                } else if (StringUtils.equals((CharSequence)button[0], (CharSequence)"view")) {
                    btn.setButtonPosition(ButtonPosition.PrimaryKey.getCode());
                } else {
                    btn.setButtonPosition(ButtonPosition.TableOp.getCode());
                    btn.setPageParam(JSON.toJSONString(pkFieldList));
                }
            }
            formButtonList.add(btn);
        }
        this.formModelButtonService.batchInsert(formButtonList);
        if (CollectionUtils.isNotEmpty((Collection)formFieldList)) {
            ArrayList formListFieldList = new ArrayList(formFieldList.size());
            ArrayList formListQueryList = new ArrayList(formFieldList.size());
            boolean queryOrder = true;
            formFieldList.forEach(formField -> {
                FormListFieldDTO listField = new FormListFieldDTO();
                BeanUtility.beanCopy((Object)formField, (Object)listField, (boolean)true);
                if (StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)formField.getIsPk())) {
                    listField.setPageLinkFlag(YesOrNO.YES.getCode());
                    listField.setPageLinkType(PageLinkType.Dialog.getCode());
                    listField.setPageId(viewPage.getPageId());
                    listField.setPageUrl(viewPage.getPageUrl());
                }
                listField.setFieldSourceType(FormFieldSourceType.FormField.getCode());
                listField.setColWidthType(ColWidthType.Default.getCode());
                listField.setFnId(fnId);
                formListFieldList.add(listField);
                if (StringUtils.endsWithAny((CharSequence)formField.getFieldCode(), (CharSequence[])new CharSequence[]{"_code", "_name"}) || StringUtils.equals((CharSequence)formField.getIsPk(), (CharSequence)YesOrNO.YES.getCode())) {
                    FormListQueryDTO query = new FormListQueryDTO();
                    query.setFormFieldId(formField.getFormFieldId());
                    query.setFormId(formId);
                    query.setFnId(fnId);
                    query.setFieldOrder(formField.getFieldOrder());
                    query.setFixedFlag(YesOrNO.YES.getCode());
                    formListQueryList.add(query);
                }
            });
            this.formListFieldService.batchInsert(formListFieldList);
            this.formListQueryService.batchInsert(formListQueryList);
        }
        FormListSettingDTO setting = new FormListSettingDTO();
        setting.setFormId(formId);
        setting.setFnId(fnId);
        setting.setGroupFlag(YesOrNO.NO.getCode());
        setting.setSortFlag(YesOrNO.YES.getCode());
        setting.setPageFlag(YesOrNO.YES.getCode());
        setting.setQueryFlag(YesOrNO.YES.getCode());
        setting.setPageSize(Integer.valueOf(10));
        this.formListSettingService.insert((Object)setting);
        return flag;
    }

    @Override
    public boolean refactor(FnModelInfoDTO fnModelInfo) {
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String userId = fnModelInfo.getLoginUserId();
        FormModelRefactorDTO refactorParam = new FormModelRefactorDTO();
        refactorParam.setFormId(formId);
        refactorParam.setRefactorFlag(YesOrNO.YES.getCode());
        List refactorList = this.formModelRefactorService.queryList((Object)refactorParam);
        if (CollectionUtils.isNotEmpty((Collection)refactorList)) {
            FormModelPageDTO viewPage = new FormModelPageDTO();
            FormModelPageDTO pageParam = new FormModelPageDTO();
            pageParam.setPageName("\u67e5\u770b\u9875\u9762");
            pageParam.setFormId(formId);
            List pageList = this.formModelPageService.queryListByPage((Object)pageParam);
            if (CollectionUtils.isNotEmpty((Collection)pageList)) {
                BeanUtility.beanCopy(pageList.get(0), (Object)viewPage, (boolean)true);
            }
            for (FormModelRefactorDTO reField : refactorList) {
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Add.getCode())) {
                    FormListFieldDTO formField = new FormListFieldDTO();
                    formField.setFormFieldId(reField.getFormFieldId());
                    if ((formField = (FormModelFieldDTO)this.formModelFieldService.queryByPk((Object)formField)) == null) continue;
                    FormListFieldDTO listField = new FormListFieldDTO();
                    BeanUtility.beanCopy((Object)formField, (Object)listField, (boolean)true);
                    if (StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)formField.getIsPk())) {
                        listField.setPageLinkFlag(YesOrNO.YES.getCode());
                        listField.setPageLinkType(PageLinkType.Dialog.getCode());
                        listField.setPageId(viewPage.getPageId());
                        listField.setPageUrl(viewPage.getPageUrl());
                    }
                    listField.setColWidthType(ColWidthType.Default.getCode());
                    listField.setFnId(fnId);
                    listField.setFieldSourceType(FormFieldSourceType.FormField.getCode());
                    this.formListFieldService.insert((Object)listField);
                    FormListQueryDTO query = new FormListQueryDTO();
                    query.setFormFieldId(formField.getFormFieldId());
                    query.setFormId(formId);
                    query.setFnId(fnId);
                    query.setFieldOrder(formField.getFieldOrder());
                    query.setFixedFlag(YesOrNO.YES.getCode());
                    this.formListQueryService.insert((Object)query);
                    continue;
                }
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Update.getCode()) || !StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Delete.getCode())) continue;
                FormListFieldDTO listField = new FormListFieldDTO();
                listField.setFormFieldId(reField.getFormFieldId());
                listField.setFormId(formId);
                List listFields = this.formListFieldService.queryList((Object)listField);
                if (CollectionUtils.isNotEmpty((Collection)listFields)) {
                    for (FormListFieldDTO delField : listFields) {
                        this.formListFieldService.deleteByPk((Object)delField);
                    }
                }
                FormListQueryDTO queryParam = new FormListQueryDTO();
                queryParam.setFormFieldId(reField.getFormFieldId());
                queryParam.setFormId(formId);
                List querys = this.formListQueryService.queryListByPage((Object)queryParam);
                if (CollectionUtils.isNotEmpty((Collection)querys)) {
                    for (FormListQueryDTO query : querys) {
                        this.formListQueryService.deleteByPk((Object)query);
                    }
                }
                FormListGroupDTO groupParam = new FormListGroupDTO();
                groupParam.setFormFieldId(reField.getFormFieldId());
                groupParam.setFormId(formId);
                List groups = this.formListGroupService.queryListByPage((Object)groupParam);
                if (CollectionUtils.isNotEmpty((Collection)groups)) {
                    for (FormListGroupDTO group : groups) {
                        this.formListGroupService.deleteByPk((Object)group);
                    }
                }
                FormListSortDTO sortParam = new FormListSortDTO();
                sortParam.setFormFieldId(reField.getFormFieldId());
                sortParam.setFormId(formId);
                List sorts = this.formListSortService.queryListByPage((Object)sortParam);
                if (!CollectionUtils.isNotEmpty((Collection)sorts)) continue;
                for (FormListSortDTO sort : sorts) {
                    this.formListSortService.deleteByPk((Object)sort);
                }
            }
        }
        return true;
    }

    @Override
    public boolean delete(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            String formId = fnModelInfo.getFormId();
            this.formModelButtonService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListFieldService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListQueryService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListSettingService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListGroupService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListSortService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelPageService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelApiService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formListCondService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelButtonService.deleteByFnId(formId, fnModelInfo.getFnId());
            return true;
        }
        return super.delete(fnModelInfo);
    }

    @Override
    public List<String> validate(FnModelInfoDTO fnModelInfo) {
        return super.validate(fnModelInfo);
    }

    @Override
    public CodeTemplateData generate(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            CodeTemplateData codeTemplateData = new CodeTemplateData();
            FormModelInfoDTO formModel = new FormModelInfoDTO();
            formModel.setFormId(fnModelInfo.getFormId());
            formModel = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formModel);
            String tableModelId = formModel.getTableModelId();
            String tableModelCode = formModel.getTableModelCode();
            String tableModelName = formModel.getTableModelName();
            String appId = formModel.getAppId();
            String fnId = fnModelInfo.getFnId();
            String formId = fnModelInfo.getFormId();
            String formCode = fnModelInfo.getFormCode();
            String fnType2 = fnModelInfo.getFnType2();
            String userId = fnModelInfo.getLoginUserId();
            String comId = fnModelInfo.getComId();
            String subsId = fnModelInfo.getSubsId();
            codeTemplateData.setParamMap(new HashMap());
            FormListSettingDTO listSetting = new FormListSettingDTO();
            listSetting.setFnId(fnId);
            listSetting.setFormId(formId);
            listSetting = (FormListSettingDTO)this.formListSettingService.queryByPk((Object)listSetting);
            codeTemplateData.getParamMap().putAll(BeanUtility.bean2Map((Object)listSetting));
            codeTemplateData.setTemplateFile("XXXList.html");
            codeTemplateData.setPackageName(formModel.getFolderName());
            codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
            codeTemplateData.setClassDesc(formModel.getFormName());
            codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
            codeTemplateData.setExtFieldList(new ArrayList());
            FormListFieldDTO listFieldParam = new FormListFieldDTO();
            listFieldParam.setFormId(formId);
            listFieldParam.setFnId(fnId);
            List listFieldList = this.formListFieldService.queryList((Object)listFieldParam);
            if (CollectionUtils.isNotEmpty((Collection)listFieldList)) {
                codeTemplateData.setFieldList(listFieldList.stream().map(f -> {
                    CodeTemplateField field = new CodeTemplateField();
                    BeanUtility.beanCopy((Object)f, (Object)field);
                    if (field.getFieldName() == null) {
                        field.setFieldName(field.getFieldCode());
                    }
                    if (StringUtils.equals((CharSequence)f.getFieldSourceType(), (CharSequence)FormFieldSourceType.CustomField.getCode())) {
                        codeTemplateData.getExtFieldList().add(field);
                    }
                    return field;
                }).collect(Collectors.toList()));
            }
            FormModelButtonDTO btnParam = new FormModelButtonDTO();
            btnParam.setFormId(formId);
            btnParam.setFnId(fnId);
            List btnList = this.formModelButtonService.queryList((Object)btnParam);
            if (CollectionUtils.isNotEmpty((Collection)btnList)) {
                codeTemplateData.setButtonList(btnList.stream().map(b -> {
                    CodeTemplateButton btn = new CodeTemplateButton();
                    BeanUtility.beanCopy((Object)b, (Object)btn);
                    btn.setApiUrl(StringUtils.replaceOnce((String)btn.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
                    btn.setPageUrl(this.pageUrlHandle(b.getPageId(), b.getPageUrl()));
                    btn.setApiParam(this.parseButtonParam(b.getApiParam()));
                    btn.setPageParam(this.parseButtonParam(b.getPageParam()));
                    return btn;
                }).collect(Collectors.toList()));
            }
            FormListQueryDTO queryParam = new FormListQueryDTO();
            queryParam.setFormId(formId);
            queryParam.setFnId(fnId);
            List queryList = this.formListQueryService.queryList((Object)queryParam);
            if (CollectionUtils.isNotEmpty((Collection)queryList)) {
                codeTemplateData.setQueryList(queryList.stream().map(q -> {
                    CodeTemplateListQuery query = new CodeTemplateListQuery();
                    BeanUtility.beanCopy((Object)q, (Object)query);
                    if (query.getFieldName() == null) {
                        query.setFieldName(query.getFieldCode());
                    }
                    return query;
                }).collect(Collectors.toList()));
            }
            FormListGroupDTO groupParam = new FormListGroupDTO();
            groupParam.setFormId(formId);
            groupParam.setFnId(fnId);
            List groupList = this.formListGroupService.queryList((Object)groupParam);
            if (CollectionUtils.isNotEmpty((Collection)groupList)) {
                codeTemplateData.setGroupList(groupList.stream().map(g -> {
                    CodeTemplateListGroup group = new CodeTemplateListGroup();
                    BeanUtility.beanCopy((Object)g, (Object)group);
                    return group;
                }).collect(Collectors.toList()));
                HashMap<String, CodeTemplateListQuery> queryMap = new HashMap<String, CodeTemplateListQuery>();
                for (CodeTemplateListQuery codeTemplateListQuery : codeTemplateData.getQueryList()) {
                    queryMap.put(codeTemplateListQuery.getFieldCode(), codeTemplateListQuery);
                }
                codeTemplateData.getGroupList().forEach(g -> {
                    if (queryMap.get(g.getFieldCode()) == null) {
                        CodeTemplateListQuery group = new CodeTemplateListQuery();
                        BeanUtility.beanCopy((Object)g, (Object)group);
                        codeTemplateData.getQueryList().add(group);
                    }
                });
            }
            FormListSortDTO sortParam = new FormListSortDTO();
            sortParam.setFormId(formId);
            sortParam.setFnId(fnId);
            List sortList = this.formListSortService.queryList((Object)sortParam);
            if (CollectionUtils.isNotEmpty((Collection)sortList)) {
                codeTemplateData.setSortList(sortList.stream().map(s -> {
                    CodeTemplateListSort sort = new CodeTemplateListSort();
                    BeanUtility.beanCopy((Object)s, (Object)sort);
                    if (sort.getFieldName() == null) {
                        sort.setFieldName(sort.getFieldCode());
                    }
                    return sort;
                }).sorted((o1, o2) -> o2.getDefaultFlag().compareTo(o1.getDefaultFlag())).collect(Collectors.toList()));
            }
            FormListCondDTO listCondDTO = new FormListCondDTO();
            listCondDTO.setFormId(formId);
            listCondDTO.setFnId(fnId);
            List condList = this.formListCondService.queryList((Object)listCondDTO);
            if (CollectionUtils.isNotEmpty((Collection)condList)) {
                codeTemplateData.setFixedCondList(condList.stream().map(s -> {
                    CodeTemplateSqlCond sql = new CodeTemplateSqlCond();
                    BeanUtility.beanCopy((Object)s, (Object)sql);
                    return sql;
                }).collect(Collectors.toList()));
            }
            CodeTemplateMethod method = new CodeTemplateMethod();
            FormModelApiDTO formApi = new FormModelApiDTO();
            formApi.setFormId(formId);
            String InsertSingleUrlAfterStr = "/" + SrvModelTypeEnum.QUERY.getCode();
            String url = String.format("/api/%s%s", TmModelUtil.tableCodeToClassName((String)formCode), InsertSingleUrlAfterStr);
            formApi.setApiUrl(url);
            List apiList = this.formModelApiService.queryListByPage((Object)formApi);
            if (CollectionUtils.isNotEmpty((Collection)apiList)) {
                formApi = (FormModelApiDTO)apiList.get(0);
                method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
                codeTemplateData.getParamMap().put("restfulUrl", method.getRestfulUrl());
            }
            method.setMethodName(SrvModelTypeEnum.QUERY.getCode());
            if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
                method.setComment(fnModelInfo.getFnDesc());
            } else {
                method.setComment(fnModelInfo.getFnName());
            }
            CodeTemplateMethodInput input = new CodeTemplateMethodInput();
            input.setClassType(TmModelUtil.tableCodeToClassName((String)formCode) + "DTO");
            input.setListFlag(YesOrNO.NO.getCode());
            input.setPropertyName("input");
            method.setInputType(input);
            CodeTemplateMethodInput output = new CodeTemplateMethodInput();
            output.setClassType(TmModelUtil.tableCodeToClassName((String)formCode) + "DTO");
            output.setListFlag(YesOrNO.YES.getCode());
            output.setPropertyName("output");
            method.setOutputType(output);
            CodeTemplateMethodInvoke invoke = new CodeTemplateMethodInvoke();
            invoke.setOutputType(output);
            invoke.setServiceName("super");
            invoke.setServiceMethod("queryListByPage");
            method.setInvoke(invoke);
            method.setResult(new CodeTemplateMethodReturn());
            codeTemplateData.setMethodList(Arrays.asList(method));
            return codeTemplateData;
        }
        return super.generate(fnModelInfo);
    }
}

