/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelButtonDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageQueryFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.PageTemplateType;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PageModelInitTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PageModelInitTask.class);
    private static final List<String> suffixes = Arrays.asList("List-\u5217\u8868-101", "Add-\u65b0\u589e-102", "Update-\u4fee\u6539-103", "View-\u67e5\u770b-104");
    private PaasAppsInfoDTO appInfo;
    private PaasAppsInfoDTO srcAppInfo;
    private boolean coverFlag;
    private String tableModelId;
    private String fnId;
    private List<String> types;

    public PageModelInitTask(PaasAppsInfoDTO appInfo, PaasAppsInfoDTO srcAppInfo, boolean coverFlag, String tableModelId, String fnId, String types) {
        this.appInfo = appInfo;
        this.srcAppInfo = srcAppInfo;
        this.coverFlag = coverFlag;
        this.tableModelId = tableModelId;
        this.fnId = fnId;
        this.types = StringUtils.isNotBlank((CharSequence)types) ? Arrays.asList(StringUtils.split((String)types, (String)",")) : Collections.EMPTY_LIST;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
        ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
        PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
        String userId = this.appInfo.getLoginUserId();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(this.srcAppInfo.getAppId());
        tableParam.setObjectId(this.tableModelId);
        tableParam.setObjectTypes(Arrays.asList(ObjectType.Table.getCode(), ObjectType.Data.getCode(), ObjectType.FreeStyleData.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode()));
        List modelTableList = modelTableInfoService.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)modelTableList)) {
            ModelFolderInfoDTO packageInfo;
            HashMap<String, ModelFolderInfoDTO> packageMap = new HashMap<String, ModelFolderInfoDTO>();
            ArrayList<PageModelInfoDTO> list = new ArrayList<PageModelInfoDTO>(modelTableList.size());
            HashMap<Object, PageTemplateInfoDTO> templateCached = new HashMap<Object, PageTemplateInfoDTO>();
            ModelFolderInfoDTO tbPackageParam = new ModelFolderInfoDTO();
            tbPackageParam.setAppId(this.srcAppInfo.getAppId());
            tbPackageParam.setFolderAbvId(this.srcAppInfo.getAppId());
            tbPackageParam.setFolderCode("TABLE");
            List tablePackageList = modelFolderInfoService.queryListByPage((Object)tbPackageParam);
            if (CollectionUtils.isNotEmpty((Collection)tablePackageList) && (StringUtils.equals((CharSequence)(packageInfo = (ModelFolderInfoDTO)tablePackageList.get(0)).getFolderName(), (CharSequence)"\u8868\u6a21\u578b") || StringUtils.equals((CharSequence)packageInfo.getFolderName(), (CharSequence)"\u9886\u57df\u8868\u6a21\u578b"))) {
                packageInfo.setFolderName(this.srcAppInfo.getAppName());
                String appCode = SdEnvUtil.wrapperAppCode(this.srcAppInfo.getAppCode());
                packageInfo.setFolderCode(appCode);
                packageMap.put(packageInfo.getFolderId(), packageInfo);
                this.recursiveLoadPackage(packageInfo, packageMap, modelFolderInfoService);
            }
            for (ModelTableInfoDTO table : modelTableList) {
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(table.getObjectId());
                List fieldList = modelTableFieldService.queryList((Object)fieldParam);
                String className = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                String tableName = table.getObjectName();
                ModelFolderInfoDTO packageInfo2 = (ModelFolderInfoDTO)packageMap.get(table.getFolderId());
                if (packageInfo2 == null) {
                    ModelFolderInfoDTO packageParam = new ModelFolderInfoDTO();
                    packageParam.setFolderId(table.getFolderId());
                    packageInfo2 = (ModelFolderInfoDTO)modelFolderInfoService.queryByPk((Object)packageParam);
                    if (StringUtils.equals((CharSequence)packageInfo2.getFolderName(), (CharSequence)"\u8868\u6a21\u578b") || StringUtils.equals((CharSequence)packageInfo2.getFolderName(), (CharSequence)"\u9886\u57df\u8868\u6a21\u578b")) {
                        packageInfo2.setFolderName(this.srcAppInfo.getAppName());
                        String appCode = SdEnvUtil.wrapperAppCode(this.srcAppInfo.getAppCode());
                        packageInfo2.setFolderCode(appCode);
                    }
                    packageMap.put(table.getFolderId(), packageInfo2);
                }
                for (String suffix : suffixes) {
                    String[] suffixA = StringUtils.split((String)suffix, (String)"-");
                    String code = suffixA[0];
                    String name = suffixA[1];
                    String type = suffixA[2];
                    if (!this.types.contains(type)) continue;
                    PageModelInfoDTO pageModel = new PageModelInfoDTO();
                    pageModel.setLoginUserId(userId);
                    pageModel.setAppId(this.appInfo.getAppId());
                    pageModel.setPageTemplateCode(this.appInfo.getAppTemplateId() + "CURD" + code);
                    PageTemplateInfoDTO template = (PageTemplateInfoDTO)templateCached.get(pageModel.getPageTemplateCode());
                    if (template == null) {
                        template = pageTemplateInfoService.queryTemplateInfoByCode(pageModel.getPageTemplateCode(), this.appInfo.getAppTemplateId());
                        templateCached.put(pageModel.getPageTemplateCode(), template);
                    }
                    if (template == null) {
                        pageModel.setPageTemplateCode("A99YFPCURD" + code);
                        template = pageTemplateInfoService.queryTemplateInfoByCode(pageModel.getPageTemplateCode(), "A99YFP");
                        templateCached.put(this.appInfo.getAppTemplateId() + "CURD" + code, template);
                    }
                    if (template != null) {
                        pageModel.setPageTemplateId(template.getPageTemplateId());
                        pageModel.setPageTemplateName(template.getPageTemplateName());
                        pageModel.setPageModelCatalog(template.getPageTemplateCatalog());
                        pageModel.setPageModelType(template.getPageTemplateType());
                    } else {
                        pageModel.setPageTemplateId(this.appInfo.getAppTemplateId() + "CURD" + code);
                        pageModel.setPageModelCatalog(PageTemplateType.Page.getCode());
                    }
                    String pageSuffix = template.getPageTemplateSuffix();
                    if (StringUtils.isBlank((CharSequence)pageSuffix)) {
                        pageSuffix = ".html";
                    }
                    pageModel.setPageModelCode(className + code + pageSuffix);
                    pageModel.setPageModelName(tableName + name);
                    pageModel.setPackageId(table.getFolderId());
                    pageModel.setPageModelDesc(table.getObjectDesc());
                    pageModel.setOrderValue(table.getOrderValue());
                    pageModel.setCoverFlag(Boolean.valueOf(this.coverFlag));
                    pageModel.setFnId(this.fnId);
                    pageModel.setTableModelId(table.getObjectId());
                    pageModel.setTableModelCode(table.getObjectCode());
                    pageModel.setTableModelName(table.getObjectName());
                    this.fillParam(pageModel, code, pageSuffix, this.srcAppInfo, table, fieldList);
                    list.add(pageModel);
                }
            }
            if (packageMap.size() > 0) {
                for (ModelFolderInfoDTO p : packageMap.values()) {
                    this.savePagePackage(p);
                }
            }
            if (list.size() > 0) {
                pageModelInfoService.batchInsert(list);
            }
        }
        return null;
    }

    public void savePagePackage(ModelFolderInfoDTO packageVO) {
        PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
        try {
            PageModelPackageDTO pagePackage = new PageModelPackageDTO();
            pagePackage.setAppId(this.appInfo.getAppId());
            pagePackage.setLoginUserId(this.appInfo.getLoginUserId());
            pagePackage.setOrderValue(packageVO.getOrderValue());
            pagePackage.setPackageId(packageVO.getFolderId());
            pagePackage.setPackageCode(packageVO.getFolderCode());
            pagePackage.setPackageName(packageVO.getFolderName());
            if (StringUtils.equals((CharSequence)packageVO.getFolderAbvId(), (CharSequence)this.appInfo.getAppId())) {
                pagePackage.setPackageAbvId(this.appInfo.getAppId());
            } else {
                pagePackage.setPackageAbvId(packageVO.getFolderAbvId());
            }
            pageModelPackageService.insert((Object)pagePackage);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void fillParam(PageModelInfoDTO info, String type, String pageSuffix, PaasAppsInfoDTO srcApp, ModelTableInfoDTO table, List<ModelTableFieldDTO> fieldList) {
        PageModelParamDTO urlParam;
        String url;
        PageModelParamDTO queryUrlParam;
        String queryUrl;
        String srcAppCode = SdEnvUtil.wrapperAppCode(srcApp.getAppCode());
        info.setParamList(new ArrayList());
        String tableClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
        String replaceSrcAppCode = srcAppCode.replace("_", "-");
        String DeleteByPkUrlAfterStr = "/" + SrvModelTypeEnum.DELETE_BY_PK.getCode();
        String InsertSingleUrlAfterStr = "/" + SrvModelTypeEnum.ADD.getCode();
        String QueryByPkUrlAfterStr = "/" + SrvModelTypeEnum.QUERY_BY_PK.getCode();
        String QueryListUrlAfterStr = "/" + SrvModelTypeEnum.QUERY.getCode();
        String UpdateByPkUrlAfterStr = "/" + SrvModelTypeEnum.UPDATE_BY_PK.getCode();
        List<String[]> buttonList = Arrays.asList({"add", "\u65b0\u589e"}, {"update", "\u4fee\u6539"}, {"delete", "\u5220\u9664"}, {"view", "\u67e5\u770b"});
        PageModelParamDTO fieldsParam = new PageModelParamDTO();
        if (StringUtils.equals((CharSequence)type, (CharSequence)"List")) {
            fieldsParam.setParamType(ParamType.fields.getCode());
            fieldsParam.setParamCode(ParamType.fields.getCode());
            fieldsParam.setParamName(ParamType.fields.getName());
            queryUrl = String.format("/api/%s%s", tableClassName, QueryListUrlAfterStr);
            String deleteUrl = String.format("/api/%s%s", tableClassName, DeleteByPkUrlAfterStr);
            queryUrlParam = new PageModelParamDTO();
            queryUrlParam.setPageTemplateId(info.getPageTemplateId());
            queryUrlParam.setNeedState(YesOrNO.YES.getCode());
            queryUrlParam.setParamType(ParamType.kv.getCode());
            queryUrlParam.setParamCode("query_url");
            queryUrlParam.setParamName("\u5217\u8868\u6570\u636e\u8bf7\u6c42\u5730\u5740");
            queryUrlParam.setParamValue(queryUrl);
            info.getParamList().add(queryUrlParam);
            PageModelParamDTO deleteUrlParam = new PageModelParamDTO();
            deleteUrlParam.setPageTemplateId(info.getPageTemplateId());
            deleteUrlParam.setNeedState(YesOrNO.YES.getCode());
            deleteUrlParam.setParamType(ParamType.kv.getCode());
            deleteUrlParam.setParamCode("delete_url");
            deleteUrlParam.setParamName("\u5217\u8868\u6570\u636e\u5220\u9664\u8bf7\u6c42\u5730\u5740");
            deleteUrlParam.setParamValue(deleteUrl);
            info.getParamList().add(deleteUrlParam);
            for (String string : suffixes) {
                String[] suffixA = StringUtils.split((String)string, (String)"-");
                String code = suffixA[0];
                String name = suffixA[1];
                if (code.equals("List")) continue;
                PageModelParamDTO listRefPage = new PageModelParamDTO();
                listRefPage.setPageTemplateId(info.getPageTemplateId());
                listRefPage.setNeedState(YesOrNO.YES.getCode());
                listRefPage.setParamType(ParamType.kv.getCode());
                listRefPage.setParamCode(code + "Page");
                listRefPage.setParamName(name + "\u9875\u9762");
                listRefPage.setParamValue(tableClassName + code + pageSuffix);
                info.getParamList().add(listRefPage);
            }
            PageModelParamDTO queryField = new PageModelParamDTO();
            queryField.setParamId(UUIDUtil.getUUID());
            queryField.setPageTemplateId(info.getPageTemplateId());
            queryField.setNeedState(YesOrNO.YES.getCode());
            queryField.setParamType(ParamType.conds.getCode());
            queryField.setParamCode("conds");
            queryField.setParamName(ParamType.conds.getName());
            queryField.setQueryFields(new ArrayList(fieldList.size()));
            for (ModelTableFieldDTO field : fieldList) {
                if (!StringUtils.equals((CharSequence)field.getIsPk(), (CharSequence)YesOrNO.YES.getCode())) continue;
                PageQueryFieldDTO bo = new PageQueryFieldDTO();
                bo.setParamId(queryField.getParamId());
                BeanUtils.copyProperties((Object)field, (Object)bo);
                queryField.getQueryFields().add(bo);
            }
            info.getParamList().add(queryField);
            PageModelParamDTO pageModelParamDTO = new PageModelParamDTO();
            pageModelParamDTO.setParamId(UUIDUtil.getUUID());
            pageModelParamDTO.setPageTemplateId(info.getPageTemplateId());
            pageModelParamDTO.setNeedState(YesOrNO.YES.getCode());
            pageModelParamDTO.setParamType(ParamType.buttons.getCode());
            pageModelParamDTO.setParamCode("buttons");
            pageModelParamDTO.setParamName(ParamType.buttons.getName());
            pageModelParamDTO.setButtons(new ArrayList(buttonList.size()));
            int bIdx = 1;
            for (String[] b : buttonList) {
                PageModelButtonDTO button = new PageModelButtonDTO();
                button.setParamId(pageModelParamDTO.getParamId());
                button.setButtonCode(b[0]);
                button.setButtonName(b[1]);
                button.setButtonOrder(Integer.valueOf(bIdx++));
                pageModelParamDTO.getButtons().add(button);
            }
            info.getParamList().add(pageModelParamDTO);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"Add")) {
            fieldsParam.setParamType(ParamType.formFields.getCode());
            fieldsParam.setParamCode(ParamType.formFields.getCode());
            fieldsParam.setParamName(ParamType.formFields.getName());
            url = String.format("/api/%s%s", tableClassName, InsertSingleUrlAfterStr);
            urlParam = new PageModelParamDTO();
            urlParam.setPageTemplateId(info.getPageTemplateId());
            urlParam.setNeedState(YesOrNO.YES.getCode());
            urlParam.setParamType(ParamType.kv.getCode());
            urlParam.setParamCode("url");
            urlParam.setParamName("\u65b0\u589e\u8bf7\u6c42\u5730\u5740");
            urlParam.setParamValue(url);
            info.getParamList().add(urlParam);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"Update")) {
            fieldsParam.setParamType(ParamType.formFields.getCode());
            fieldsParam.setParamCode(ParamType.formFields.getCode());
            fieldsParam.setParamName(ParamType.formFields.getName());
            queryUrl = String.format("/api/%s%s", tableClassName, QueryByPkUrlAfterStr);
            String url2 = String.format("/api/%s%s", tableClassName, UpdateByPkUrlAfterStr);
            queryUrlParam = new PageModelParamDTO();
            queryUrlParam.setPageTemplateId(info.getPageTemplateId());
            queryUrlParam.setNeedState(YesOrNO.YES.getCode());
            queryUrlParam.setParamType(ParamType.kv.getCode());
            queryUrlParam.setParamCode("query_url");
            queryUrlParam.setParamName("\u6570\u636e\u67e5\u8be2\u8bf7\u6c42\u5730\u5740");
            queryUrlParam.setParamValue(queryUrl);
            info.getParamList().add(queryUrlParam);
            PageModelParamDTO urlParam2 = new PageModelParamDTO();
            urlParam2.setPageTemplateId(info.getPageTemplateId());
            urlParam2.setNeedState(YesOrNO.YES.getCode());
            urlParam2.setParamType(ParamType.kv.getCode());
            urlParam2.setParamCode("url");
            urlParam2.setParamName("\u6570\u636e\u66f4\u65b0\u8bf7\u6c42\u5730\u5740");
            urlParam2.setParamValue(url2);
            info.getParamList().add(urlParam2);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"View")) {
            fieldsParam.setParamType(ParamType.formFields.getCode());
            fieldsParam.setParamName(ParamType.formFields.getName());
            url = String.format("/api/%s%s", tableClassName, QueryByPkUrlAfterStr);
            urlParam = new PageModelParamDTO();
            urlParam.setPageTemplateId(info.getPageTemplateId());
            urlParam.setNeedState(YesOrNO.YES.getCode());
            urlParam.setParamType(ParamType.kv.getCode());
            urlParam.setParamCode("query_url");
            urlParam.setParamName("\u6570\u636e\u67e5\u8be2\u8bf7\u6c42\u5730\u5740");
            urlParam.setParamValue(url);
            info.getParamList().add(urlParam);
        }
        ArrayList<PageModelFieldDTO> fieldBoList = new ArrayList<PageModelFieldDTO>(fieldList.size());
        for (ModelTableFieldDTO field : fieldList) {
            PageModelFieldDTO bo = new PageModelFieldDTO();
            BeanUtils.copyProperties((Object)field, (Object)bo);
            String javaPropertyName = TmModelUtil.fieldToProperty((String)bo.getFieldCode());
            bo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
            bo.setJavaPropertyName(javaPropertyName);
            bo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)bo.getFieldType()));
            fieldBoList.add(bo);
            if (StringUtils.equals((CharSequence)type, (CharSequence)"List")) continue;
            if (StringUtils.isNotBlank((CharSequence)bo.getFieldOption())) {
                bo.setFieldFcId("FC003");
                continue;
            }
            if (StringUtils.equalsAny((CharSequence)bo.getJavaType(), (CharSequence[])new CharSequence[]{"int", "BigDecimal"})) {
                bo.setFieldFcId("FC002");
                continue;
            }
            bo.setFieldFcId("FC001");
        }
        fieldsParam.setPageTemplateId(info.getPageTemplateId());
        fieldsParam.setParamCode("fields");
        fieldsParam.setNeedState(YesOrNO.YES.getCode());
        fieldsParam.setFields(fieldBoList);
        info.getParamList().add(fieldsParam);
    }

    private void recursiveLoadPackage(ModelFolderInfoDTO packageInfo, Map<String, ModelFolderInfoDTO> packageMap, ModelFolderInfoService modelFolderInfoService) {
        ModelFolderInfoDTO tbPackageParam = new ModelFolderInfoDTO();
        tbPackageParam.setAppId(packageInfo.getAppId());
        tbPackageParam.setFolderAbvId(packageInfo.getFolderId());
        List tablePackageList = modelFolderInfoService.queryList((Object)tbPackageParam);
        if (CollectionUtils.isNotEmpty((Collection)tablePackageList)) {
            for (ModelFolderInfoDTO p : tablePackageList) {
                packageMap.put(p.getFolderId(), p);
                this.recursiveLoadPackage(p, packageMap, modelFolderInfoService);
            }
        }
    }
}

