/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmBugAttachRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmBugInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectUserRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmBugInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectUserDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmRelationInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmBugInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmBugInfoDTO;
import com.irdstudio.allinrdm.project.console.types.IssueState;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnBaseInfoDO;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.NumberUtility;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmBugInfoServiceImpl")
public class RdmBugInfoServiceImpl
extends BaseServiceImpl<RdmBugInfoDTO, RdmBugInfoDO, RdmBugInfoRepository>
implements RdmBugInfoService {
    @Autowired
    protected RdmBugAttachRepository rdmBugAttachRepository;
    @Autowired
    protected RdmRelationInfoRepository rdmRelationInfoRepository;
    @Autowired
    protected RdmProjectUserRepository rdmProjectUserRepository;
    @Autowired
    protected FnBaseInfoRepository fnBaseInfoRepository;

    public String queryMaxId() {
        return ((RdmBugInfoRepository)this.getRepository()).queryMaxId();
    }

    public List<Map<String, Object>> queryRdmBugInchargeGroupByPage(RdmBugInfoDTO paramDTO) {
        RdmBugInfoDO paramDO = (RdmBugInfoDO)this.beanCopy(paramDTO, RdmBugInfoDO.class);
        List result = ((RdmBugInfoRepository)this.getRepository()).queryRdmBugInchargeGroupByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }

    public int deleteByCond(RdmBugInfoDTO param) {
        RdmBugInfoDO rdmBugInfoDO = new RdmBugInfoDO();
        this.beanCopy(param, rdmBugInfoDO);
        return ((RdmBugInfoRepository)this.getRepository()).deleteByCond(rdmBugInfoDO);
    }

    public int saveExcel(List<RdmBugInfoDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String userId = list.get(0).getLoginUserId();
            String projectId = list.get(0).getProjectId();
            String moduleId = list.get(0).getModuleId();
            RdmProjectUserDO userParam = new RdmProjectUserDO();
            userParam.setProjectId(projectId);
            List userList = this.rdmProjectUserRepository.queryList((Object)userParam);
            HashMap<String, RdmProjectUserDO> userMap = new HashMap<String, RdmProjectUserDO>();
            for (RdmProjectUserDO prjUser : userList) {
                userMap.put(prjUser.getUserName(), prjUser);
                userMap.put(prjUser.getUserNick(), prjUser);
            }
            String now = CurrentDateUtil.getTodayDateEx2();
            String nowDay = CurrentDateUtil.getTodayDate();
            ArrayList<RdmRelationInfoDO> relationList = new ArrayList<RdmRelationInfoDO>();
            FnBaseInfoDO fnParam = new FnBaseInfoDO();
            for (RdmBugInfoDTO bugInfo : list) {
                RdmProjectUserDO userInfo;
                fnParam.setAll(bugInfo.getFpId());
                List fnList = this.fnBaseInfoRepository.queryListByPage((Object)fnParam);
                if (CollectionUtils.isNotEmpty((Collection)fnList)) {
                    FnBaseInfoDO fnInfo = (FnBaseInfoDO)fnList.get(0);
                    RdmRelationInfoDO fnBugRef = new RdmRelationInfoDO();
                    fnBugRef.setBugId(bugInfo.getBugId());
                    fnBugRef.setFpId(fnBugRef.getFpId());
                    fnBugRef.setRelId(UUIDUtil.getShortUUID());
                    relationList.add(fnBugRef);
                }
                if (StringUtils.isNotBlank((CharSequence)bugInfo.getInchargeName())) {
                    userInfo = (RdmProjectUserDO)userMap.get(bugInfo.getInchargeName());
                    if (userInfo != null) {
                        bugInfo.setIncharge(userInfo.getUserId());
                    } else {
                        bugInfo.setIncharge(bugInfo.getInchargeName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bugInfo.getProposerName())) {
                    userInfo = (RdmProjectUserDO)userMap.get(bugInfo.getProposerName());
                    if (userInfo != null) {
                        bugInfo.setProposer(userInfo.getUserId());
                    } else {
                        bugInfo.setProposer(bugInfo.getProposerName());
                    }
                }
                if (bugInfo.getBugReopenNum() != null & bugInfo.getBugReopenNum() > 0) {
                    bugInfo.setReopenFlag(YesOrNO.YES.getCode());
                }
                bugInfo.setCreateTime(now);
                bugInfo.setLastUpdateTime(now);
                bugInfo.setCreateUser(userId);
            }
            outputVo = this.batchInsertPage(list);
            if (CollectionUtils.isNotEmpty(relationList)) {
                this.rdmRelationInfoRepository.batchInsert(relationList);
            }
        }
        return outputVo;
    }

    public int batchInsertPage(List<RdmBugInfoDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        int num = 0;
        int LOOP_NUM = 200;
        if (list.size() < 200) {
            num += this.batchInsert(list);
        } else {
            int loop = NumberUtility.calcLoop((int)list.size(), (int)200);
            int cur = 0;
            for (int i = 1; i <= loop; ++i) {
                int end = 200 * i;
                if (end > list.size()) {
                    end = list.size();
                }
                List<RdmBugInfoDTO> sub = list.subList(cur, end);
                cur += 200;
                num += this.batchInsert(sub);
            }
        }
        return num;
    }

    public List<Map<String, Object>> queryBugSummary(RdmBugInfoDTO paramDTO) {
        RdmBugInfoDO rdmBugInfoDO = new RdmBugInfoDO();
        this.beanCopy(paramDTO, rdmBugInfoDO);
        return ((RdmBugInfoRepository)this.getRepository()).queryBugSummary(rdmBugInfoDO);
    }

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.TestCase, moduleCode="rdm", bizKey="${args[0].bugId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].bugId} ${args[0].bugName}")
    public int insert(RdmBugInfoDTO paramDTO) {
        this.rdmBugAttachRepository.updateRefIdToNew(paramDTO.getAll(), paramDTO.getBugId());
        this.rdmRelationInfoRepository.updateByRelationId("bugId", paramDTO.getAll(), paramDTO.getBugId());
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.TestCase, moduleCode="rdm", bizKey="${args[0].bugId}")
    public int updateByPk(RdmBugInfoDTO paramDTO) {
        RdmBugInfoDTO oldData = (RdmBugInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        if (oldData != null && !StringUtils.equals((CharSequence)paramDTO.getBugState(), (CharSequence)oldData.getBugState()) && StringUtils.equals((CharSequence)oldData.getBugState(), (CharSequence)IssueState.Done.getCode())) {
            paramDTO.setReopenFlag(YesOrNO.YES.getCode());
            paramDTO.setReopenDate(CurrentDateUtil.getTodayDate());
        }
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.TestCase, moduleCode="rdm", bizKey="${args[0].bugId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].bugId} ${args[0].bugName}")
    public int deleteByPk(RdmBugInfoDTO paramDTO) {
        return super.deleteByPk((BaseInfo)paramDTO);
    }
}

