/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmIssueAttachRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmIssueInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmIssueInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmIssueInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmIssueInfoDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmIssueInfoServiceImpl")
public class RdmIssueInfoServiceImpl
extends BaseServiceImpl<RdmIssueInfoDTO, RdmIssueInfoDO, RdmIssueInfoRepository>
implements RdmIssueInfoService {
    @Autowired
    AllinCloudPortalClient portalClient;
    @Autowired
    protected RdmIssueAttachRepository rdmIssueAttachRepository;
    @Autowired
    protected RdmRelationInfoRepository rdmRelationInfoRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Issue, moduleCode="rdm", bizKey="${args[0].issueId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('IssueCategory', dynamicLog.moduleCode(), args[0].issueCategory)} #${args[0].issueId} ${args[0].issueName}")
    public int insert(RdmIssueInfoDTO inRdmIssueInfoDTO) {
        if (StringUtils.isNotBlank((CharSequence)inRdmIssueInfoDTO.getIncharge()) && StringUtils.isBlank((CharSequence)inRdmIssueInfoDTO.getDispatcher())) {
            inRdmIssueInfoDTO.setDispatcher(inRdmIssueInfoDTO.getLoginUserId());
            inRdmIssueInfoDTO.setDispatcherName(inRdmIssueInfoDTO.getLoginUserName());
        }
        this.rdmIssueAttachRepository.updateRefIdToNew(inRdmIssueInfoDTO.getAll(), inRdmIssueInfoDTO.getIssueId());
        this.rdmRelationInfoRepository.updateByRelationId("issueId", inRdmIssueInfoDTO.getAll(), inRdmIssueInfoDTO.getIssueId());
        return super.insert((BaseInfo)inRdmIssueInfoDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Issue, moduleCode="rdm", bizKey="${args[0].issueId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('IssueCategory', dynamicLog.moduleCode(), args[0].issueCategory)} #${args[0].issueId} ${args[0].issueName}")
    public int deleteByPk(RdmIssueInfoDTO inRdmIssueInfoDTO) {
        return super.deleteByPk((BaseInfo)inRdmIssueInfoDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Issue, moduleCode="rdm", bizKey="${args[0].issueId}")
    public int updateByPk(RdmIssueInfoDTO inRdmIssueInfoDTO) {
        RdmIssueInfoDTO oldData = (RdmIssueInfoDTO)this.queryByPk((BaseInfo)inRdmIssueInfoDTO);
        inRdmIssueInfoDTO.setOldData((Object)oldData);
        if (StringUtils.isNotBlank((CharSequence)inRdmIssueInfoDTO.getIncharge()) && StringUtils.isBlank((CharSequence)inRdmIssueInfoDTO.getDispatcher())) {
            inRdmIssueInfoDTO.setDispatcher(inRdmIssueInfoDTO.getLoginUserId());
            inRdmIssueInfoDTO.setDispatcherName(inRdmIssueInfoDTO.getLoginUserName());
        }
        return super.updateByPk((BaseInfo)inRdmIssueInfoDTO);
    }

    public String queryMaxId() {
        return ((RdmIssueInfoRepository)this.getRepository()).queryMaxId();
    }

    public List<Map<String, Object>> queryIssueSummary(RdmIssueInfoDTO paramDTO) {
        RdmIssueInfoDO paramDO = (RdmIssueInfoDO)this.beanCopy(paramDTO, RdmIssueInfoDO.class);
        return ((RdmIssueInfoRepository)this.getRepository()).queryIssueSummary(paramDO);
    }

    public List<Map<String, Object>> queryRdmIssueSummaryByPage(RdmIssueInfoDTO paramDTO) {
        RdmIssueInfoDO paramDO = (RdmIssueInfoDO)this.beanCopy(paramDTO, RdmIssueInfoDO.class);
        return ((RdmIssueInfoRepository)this.getRepository()).queryRdmIssueSummaryByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmIssueInchargeByPage(RdmIssueInfoDTO paramDTO) {
        RdmIssueInfoDO paramDO = (RdmIssueInfoDO)this.beanCopy(paramDTO, RdmIssueInfoDO.class);
        return ((RdmIssueInfoRepository)this.getRepository()).queryRdmIssueInchargeByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmIssueInchargeGroupByPage(RdmIssueInfoDTO paramDTO) {
        RdmIssueInfoDO paramDO = (RdmIssueInfoDO)this.beanCopy(paramDTO, RdmIssueInfoDO.class);
        return ((RdmIssueInfoRepository)this.getRepository()).queryRdmIssueInchargeGroupByPage(paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Issue, moduleCode="rdm")
    public Integer deleteByCond(RdmIssueInfoDTO param) {
        return ((RdmIssueInfoRepository)this.getRepository()).deleteByCond((RdmIssueInfoDO)this.beanCopy(param, RdmIssueInfoDO.class));
    }

    public boolean saveExcel(String userId, String subsId, String subsName, String projectId, String projectName, String excelUploadType, List<RdmIssueInfoDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)excelUploadType, (CharSequence)"insert")) {
            RdmIssueInfoDO deleteParam = new RdmIssueInfoDO();
            deleteParam.setSubsId(subsId);
            deleteParam.setProjectId(projectId);
            ((RdmIssueInfoRepository)this.getRepository()).deleteByCond(deleteParam);
        }
        SUserDTO userParam = new SUserDTO();
        List userList = this.portalClient.querySUserList(userParam);
        HashMap userNameMap = new HashMap();
        userList.forEach(user -> {
            userNameMap.put(user.getActorname(), user.getActorno());
            userNameMap.put(user.getActorno(), user.getActorno());
        });
        String now = CurrentDateUtil.getTodayDateEx2();
        int recordNum = 0;
        for (RdmIssueInfoDTO issue : list) {
            RdmIssueInfoDO issueDO = (RdmIssueInfoDO)this.beanCopy(issue, RdmIssueInfoDO.class);
            issueDO.setIssueId(((RdmIssueInfoRepository)this.getRepository()).queryMaxId());
            issueDO.setCreateUser(userId);
            issueDO.setCreateTime(now);
            issueDO.setLastUpdateUser(userId);
            issueDO.setLastUpdateTime(now);
            issueDO.setSubsId(subsId);
            issueDO.setSubsName(subsName);
            issueDO.setProjectId(projectId);
            issueDO.setProjectName(projectName);
            issueDO.setProposer((String)userNameMap.get(issueDO.getProposerName()));
            issueDO.setIncharge((String)userNameMap.get(issueDO.getInchargeName()));
            issueDO.setCollaborator((String)userNameMap.get(issueDO.getCollaboratorName()));
            int re = ((RdmIssueInfoRepository)this.getRepository()).insert((Object)issueDO);
            if (re <= 0) continue;
            ++recordNum;
        }
        return recordNum > 0;
    }
}

