/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmObjectiveKrRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmObjectiveKrDO;
import com.irdstudio.allinrdm.project.console.facade.RdmObjectiveKrService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmObjectiveKrDTO;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.exception.AppRuntimeException;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmObjectiveKrServiceImpl")
public class RdmObjectiveKrServiceImpl
extends BaseServiceImpl<RdmObjectiveKrDTO, RdmObjectiveKrDO, RdmObjectiveKrRepository>
implements RdmObjectiveKrService {
    private Pattern pattern = Pattern.compile("\\w*?(\\d++)");

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].objectiveId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].objectiveId} ${args[0].objectiveName} #${args[0].krId} ${args[0].krDesc}")
    public int insert(RdmObjectiveKrDTO paramDO) {
        int output = super.insert((BaseInfo)paramDO);
        BigDecimal weight = this.querySumWeightByObjectiveId(paramDO.getObjectiveId());
        if (weight.compareTo(new BigDecimal("100")) > 0) {
            throw new AppRuntimeException("\u6743\u91cd\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e100");
        }
        return output;
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].krId}")
    public int updateByPk(RdmObjectiveKrDTO paramDO) {
        RdmObjectiveKrDTO oldData = (RdmObjectiveKrDTO)this.queryByPk((BaseInfo)paramDO);
        paramDO.setOldData((Object)oldData);
        int output = super.updateByPk((BaseInfo)paramDO);
        BigDecimal weight = this.querySumWeightByObjectiveId(paramDO.getObjectiveId());
        if (weight.compareTo(new BigDecimal("100")) > 0) {
            throw new AppRuntimeException("\u6743\u91cd\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e100");
        }
        return output;
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].krId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].objectiveId} ${args[0].objectiveName} #${args[0].krId} ${args[0].krDesc}")
    public int deleteByPk(RdmObjectiveKrDTO paramDO) {
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public String queryMaxId(String objectiveId) {
        String id = ((RdmObjectiveKrRepository)this.getRepository()).queryMaxId(objectiveId);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String numStr = StringUtils.replaceOnce((String)id, (String)objectiveId, (String)"");
            int num = NumberUtils.toInt((String)numStr, (int)0);
            return String.format("%s%s", objectiveId, StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0"));
        }
        return String.format("%s%s", objectiveId, StringUtils.leftPad((String)String.valueOf(1), (int)4, (String)"0"));
    }

    public String queryMaxKrCode(String objectiveId) {
        String id = ((RdmObjectiveKrRepository)this.getRepository()).queryMaxKrCode(objectiveId);
        String prefix = "KR";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Matcher m = this.pattern.matcher(id);
            String numStr = "";
            numStr = m.matches() ? m.group(1) : StringUtils.substring((String)id, (int)(id.length() - 4));
            int num = NumberUtils.toInt((String)numStr, (int)0);
            return String.format("%s%s", prefix, num + 1);
        }
        return String.format("%s%s", prefix, 1);
    }

    public BigDecimal querySumWeightByObjectiveId(String objectiveId) {
        return ((RdmObjectiveKrRepository)this.getRepository()).querySumWeightByObjectiveId(objectiveId);
    }
}

