/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectCbaRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectUserRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTeamInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectCbaDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectUserDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTeamInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ProjectRole;
import com.irdstudio.allinrdm.project.console.types.ProjectVisit;
import com.irdstudio.allinrdm.wiki.console.acl.repository.WikiBaseInfoRepository;
import com.irdstudio.allinrdm.wiki.console.domain.entity.WikiBaseInfoDO;
import com.irdstudio.allinrdm.wiki.console.types.WikiType;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.sdk.admin.facade.client.audit.AuditOperate;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.DateCalculate;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmProjectInfoServiceImpl")
public class RdmProjectInfoServiceImpl
extends BaseServiceImpl<RdmProjectInfoDTO, RdmProjectInfoDO, RdmProjectInfoRepository>
implements RdmProjectInfoService {
    @Autowired
    private RdmTeamInfoRepository rdmTeamInfoRepository;
    @Autowired
    private RdmProjectUserRepository rdmProjectUserRepository;
    @Autowired
    private RdmProjectCbaRepository rdmProjectCbaRepository;
    @Autowired
    private WikiBaseInfoRepository wikiBaseInfoRepository;
    @Autowired
    private AllinCloudPortalClient portalClient;

    public String queryMaxId() {
        String id = ((RdmProjectInfoRepository)this.getRepository()).queryMaxId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String numStr = StringUtils.replaceOnce((String)id, (String)"P", (String)"");
            int num = NumberUtils.toInt((String)numStr, (int)0);
            return String.format("P%s", StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0"));
        }
        return String.format("P%s", StringUtils.leftPad((String)String.valueOf(1), (int)4, (String)"0"));
    }

    public List<Map<String, Object>> queryRdmSummary(RdmProjectInfoDTO paramDTO) {
        RdmProjectInfoDO paramDO = (RdmProjectInfoDO)this.beanCopy(paramDTO, RdmProjectInfoDO.class);
        return ((RdmProjectInfoRepository)this.getRepository()).queryRdmSummary(paramDO);
    }

    public List<Map<String, Object>> queryRdmProjectSummary(RdmProjectInfoDTO paramDTO) {
        RdmProjectInfoDO paramDO = (RdmProjectInfoDO)this.beanCopy(paramDTO, RdmProjectInfoDO.class);
        return ((RdmProjectInfoRepository)this.getRepository()).queryRdmProjectSummary(paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].projectId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].projectId} ${args[0].projectName}")
    @AuditOperate(action=AuditOperate.Action.Add, auditType="P", bizKey="${args[0].projectId}", bizName="${args[0].projectName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].projectId} ${args[0].projectName}")
    public int insert(RdmProjectInfoDTO paramDTO) {
        SUserDTO inchargeUser;
        if (StringUtils.isNotBlank((CharSequence)paramDTO.getProjectIncharge()) && (inchargeUser = this.portalClient.querySUserByPk(paramDTO.getProjectIncharge())) != null) {
            RdmProjectUserDO managerMem = new RdmProjectUserDO();
            managerMem.setUserId(inchargeUser.getActorno());
            managerMem.setUserName(inchargeUser.getActorname());
            managerMem.setPhone(inchargeUser.getTelnum());
            managerMem.setEmail(inchargeUser.getUsermail());
            managerMem.setUserRole(ProjectRole.Admin.getCode());
            managerMem.setProjectId(paramDTO.getProjectId());
            managerMem.setProjectName(paramDTO.getProjectName());
            managerMem.setCreateUser(paramDTO.getLoginUserId());
            managerMem.setLastModifyUser(paramDTO.getLoginUserId());
            String now = CurrentDateUtil.getTodayDateEx2();
            managerMem.setCreateTime(now);
            managerMem.setLastModifyTime(now);
            managerMem.setTeamId(paramDTO.getProjectId());
            this.rdmProjectUserRepository.insert((Object)managerMem);
        }
        paramDTO.setProjectPeriod(this.calcProjectPeriod(paramDTO));
        paramDTO.setProjectArchiveFlag(YesOrNO.NO.getCode());
        if (StringUtils.isNotBlank((CharSequence)paramDTO.getCbaCodes())) {
            RdmProjectCbaDO deleteDO = new RdmProjectCbaDO();
            deleteDO.setProjectId(paramDTO.getProjectId());
            this.rdmProjectCbaRepository.deleteByProjectId(deleteDO);
            String[] cbaA = StringUtils.split((String)paramDTO.getCbaCodes(), (String)",");
            ArrayList<RdmProjectCbaDO> cbaList = new ArrayList<RdmProjectCbaDO>();
            for (String cba : cbaA) {
                RdmProjectCbaDO cbaDO = new RdmProjectCbaDO();
                cbaDO.setProjectId(paramDTO.getProjectId());
                cbaDO.setCbaCode(cba);
                cbaList.add(cbaDO);
            }
            this.rdmProjectCbaRepository.batchInsert(cbaList);
        }
        WikiBaseInfoDO wikiBase = new WikiBaseInfoDO();
        wikiBase.setWikiId(paramDTO.getProjectId());
        wikiBase.setWikiName(paramDTO.getProjectName());
        wikiBase.setWikiType(WikiType.Project.getCode());
        wikiBase.setWikiCategory(WikiType.Project.getCode());
        wikiBase.setWikiIncharge(paramDTO.getProjectIncharge());
        wikiBase.setWikiInchargeName(paramDTO.getProjectInchargeName());
        wikiBase.setWikiArchiveFlag(paramDTO.getProjectArchiveFlag());
        wikiBase.setWikiDesc(paramDTO.getProjectDesc());
        wikiBase.setCreateUser(paramDTO.getLoginUserId());
        wikiBase.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        wikiBase.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        wikiBase.setLastModifyUser(paramDTO.getLoginUserId());
        this.wikiBaseInfoRepository.insert((Object)wikiBase);
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].projectId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].projectId} ${args[0].projectName}")
    @AuditOperate(action=AuditOperate.Action.Delete, auditType="P", bizKey="${args[0].projectId}", bizName="${args[0].projectName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].projectId} ${args[0].projectName}")
    public int deleteByPk(RdmProjectInfoDTO paramDTO) {
        this.rdmProjectUserRepository.deleteByProjectId(paramDTO.getProjectId());
        RdmTeamInfoDO teamInfo = new RdmTeamInfoDO();
        teamInfo.setTeamId(paramDTO.getProjectId());
        this.rdmTeamInfoRepository.deleteByPk((Object)teamInfo);
        RdmProjectCbaDO deleteDO = new RdmProjectCbaDO();
        deleteDO.setProjectId(paramDTO.getProjectId());
        this.rdmProjectCbaRepository.deleteByProjectId(deleteDO);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].projectId}")
    @AuditOperate(action=AuditOperate.Action.Update, auditType="P", bizKey="${args[0].projectId}", bizName="${args[0].projectName}")
    public int updateByPk(RdmProjectInfoDTO paramDTO) {
        String members;
        String[] memberArr;
        RdmProjectInfoDTO oldData = (RdmProjectInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        if (StringUtils.equals((CharSequence)ProjectVisit.Private.getCode(), (CharSequence)paramDTO.getProjectVisit()) && (memberArr = StringUtils.split((String)(members = paramDTO.getMembers()), (String)",")) != null && memberArr.length > 0) {
            this.rdmProjectUserRepository.deleteByProjectId(paramDTO.getProjectId());
            ArrayList<RdmProjectUserDO> memberList = new ArrayList<RdmProjectUserDO>();
            for (String member : memberArr) {
                RdmProjectUserDO memberDO = new RdmProjectUserDO();
                memberDO.setUserId(member);
                memberDO.setTeamId(paramDTO.getProjectId());
                if (StringUtils.equals((CharSequence)member, (CharSequence)paramDTO.getProjectIncharge())) {
                    memberDO.setUserRole(ProjectRole.Admin.getCode());
                } else {
                    memberDO.setUserRole(ProjectRole.Normal.getCode());
                }
                memberList.add(memberDO);
            }
            if (memberList.size() > 0) {
                this.rdmProjectUserRepository.batchInsert(memberList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)paramDTO.getCbaCodes())) {
            RdmProjectCbaDO deleteDO = new RdmProjectCbaDO();
            deleteDO.setProjectId(paramDTO.getProjectId());
            this.rdmProjectCbaRepository.deleteByProjectId(deleteDO);
            String[] cbaA = StringUtils.split((String)paramDTO.getCbaCodes(), (String)",");
            ArrayList<RdmProjectCbaDO> cbaList = new ArrayList<RdmProjectCbaDO>();
            for (String cba : cbaA) {
                RdmProjectCbaDO cbaDO = new RdmProjectCbaDO();
                cbaDO.setProjectId(paramDTO.getProjectId());
                cbaDO.setCbaCode(cba);
                cbaList.add(cbaDO);
            }
            this.rdmProjectCbaRepository.batchInsert(cbaList);
        }
        paramDTO.setProjectPeriod(this.calcProjectPeriod(paramDTO));
        return super.updateByPk((BaseInfo)paramDTO);
    }

    private BigDecimal calcProjectPeriod(RdmProjectInfoDTO projectInfo) {
        if (StringUtils.isNotBlank((CharSequence)projectInfo.getProjectBeginDate()) && StringUtils.isNotBlank((CharSequence)projectInfo.getProjectEndDate())) {
            try {
                Date date1 = DateUtils.parseDate((String)projectInfo.getProjectBeginDate(), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
                Date date2 = DateUtils.parseDate((String)projectInfo.getProjectEndDate(), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
                int months = DateCalculate.months((Date)date1, (Date)date2);
                return new BigDecimal(months);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }
}

