/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectUserRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTeamInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTeamUserRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectUserDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTeamInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTeamUserDO;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectUserService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectUserDTO;
import com.irdstudio.allinrdm.project.console.types.UserState;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmProjectMemberServiceImpl")
public class RdmProjectUserServiceImpl
extends BaseServiceImpl<RdmProjectUserDTO, RdmProjectUserDO, RdmProjectUserRepository>
implements RdmProjectUserService {
    @Autowired
    private RdmTeamInfoRepository rdmTeamInfoRepository;
    @Autowired
    private RdmProjectInfoRepository rdmProjectInfoRepository;
    @Autowired
    private RdmTeamUserRepository rdmTeamUserRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].userId}", text="\u5728#${args[0].oldData.teamId} ${args[0].oldData.teamName} \u6dfb\u52a0\u6210\u5458 ${args[0].userName}")
    public int insert(RdmProjectUserDTO paramDO) {
        RdmTeamInfoDO teamInfo = new RdmTeamInfoDO();
        teamInfo.setTeamId(paramDO.getTeamId());
        teamInfo = (RdmTeamInfoDO)this.rdmTeamInfoRepository.queryByPk((Object)teamInfo);
        if (teamInfo == null) {
            teamInfo = new RdmTeamInfoDO();
            teamInfo.setTeamId(paramDO.getTeamId());
        } else {
            RdmTeamUserDO teamUser = new RdmTeamUserDO();
            teamUser.setTeamId(paramDO.getTeamId());
            teamUser.setUserId(paramDO.getUserId());
            this.rdmTeamUserRepository.insert((Object)teamUser);
        }
        paramDO.setOldData((Object)teamInfo);
        if (StringUtils.equals((CharSequence)UserState.Entered.getCode(), (CharSequence)paramDO.getUserState()) && StringUtils.isBlank((CharSequence)paramDO.getUserEnteredDate())) {
            paramDO.setUserEnteredDate(CurrentDateUtil.getTodayDate());
        }
        if (StringUtils.equals((CharSequence)UserState.Leaving.getCode(), (CharSequence)paramDO.getUserState()) && StringUtils.isBlank((CharSequence)paramDO.getUserLeavingDate())) {
            paramDO.setUserLeavingDate(CurrentDateUtil.getTodayDate());
        }
        if (StringUtils.equals((CharSequence)UserState.Exited.getCode(), (CharSequence)paramDO.getUserState()) && StringUtils.isBlank((CharSequence)paramDO.getUserExitedDate())) {
            paramDO.setUserExitedDate(CurrentDateUtil.getTodayDate());
        }
        return super.insert((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].userId}")
    public int updateByPk(RdmProjectUserDTO paramDTO) {
        RdmTeamInfoDO teamInfo = new RdmTeamInfoDO();
        teamInfo.setTeamId(paramDTO.getTeamId());
        teamInfo = (RdmTeamInfoDO)this.rdmTeamInfoRepository.queryByPk((Object)teamInfo);
        if (teamInfo == null) {
            teamInfo = new RdmTeamInfoDO();
            teamInfo.setTeamId(paramDTO.getTeamId());
        } else {
            RdmTeamUserDO teamUser = new RdmTeamUserDO();
            teamUser.setTeamId(paramDTO.getTeamId());
            teamUser.setUserId(paramDTO.getUserId());
            this.rdmTeamUserRepository.insert((Object)teamUser);
        }
        RdmProjectUserDTO oldData = (RdmProjectUserDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        if (oldData != null && !StringUtils.equals((CharSequence)oldData.getUserState(), (CharSequence)paramDTO.getUserState())) {
            if (StringUtils.equals((CharSequence)UserState.Entered.getCode(), (CharSequence)paramDTO.getUserState())) {
                paramDTO.setUserEnteredDate(CurrentDateUtil.getTodayDate());
            }
            if (StringUtils.equals((CharSequence)UserState.Leaving.getCode(), (CharSequence)paramDTO.getUserState())) {
                paramDTO.setUserLeavingDate(CurrentDateUtil.getTodayDate());
            }
            if (StringUtils.equals((CharSequence)UserState.Exited.getCode(), (CharSequence)paramDTO.getUserState())) {
                paramDTO.setUserExitedDate(CurrentDateUtil.getTodayDate());
            }
        }
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Team, moduleCode="rdm", bizKey="${args[0].userId}")
    public int deleteByPk(RdmProjectUserDTO paramDO) {
        if (StringUtils.isBlank((CharSequence)paramDO.getTeamName())) {
            paramDO.setDlText("${args[0].userName}\u9000\u51fa\u4e86 #${args[0].oldData.projectId} ${args[0].oldData.projectName}");
        } else {
            paramDO.setDlText("${args[0].userName}\u9000\u51fa\u4e86 #${args[0].oldData.teamId} ${args[0].oldData.teamName}");
        }
        paramDO.setOldData((Object)paramDO);
        RdmTeamInfoDO teamUserDel = new RdmTeamInfoDO();
        teamUserDel.setLoginUserId(paramDO.getUserId());
        List teamDelList = this.rdmTeamInfoRepository.queryList((Object)teamUserDel);
        if (CollectionUtils.isNotEmpty((Collection)teamDelList)) {
            for (RdmTeamInfoDO team : teamDelList) {
                RdmTeamUserDO teamDel = new RdmTeamUserDO();
                teamDel.setTeamId(team.getTeamId());
                teamDel.setUserId(paramDO.getUserId());
                this.rdmTeamUserRepository.deleteByPk((Object)teamDel);
            }
        }
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public String calcWorkload(RdmProjectUserDTO param) {
        RdmProjectInfoDO projectInfo = new RdmProjectInfoDO();
        projectInfo.setProjectId(param.getProjectId());
        projectInfo = (RdmProjectInfoDO)this.rdmProjectInfoRepository.queryByPk((Object)projectInfo);
        if (projectInfo == null) {
            return "\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a";
        }
        RdmProjectUserDO rdmProjectUserDO = new RdmProjectUserDO();
        this.beanCopy(param, rdmProjectUserDO);
        List memberList = ((RdmProjectUserRepository)this.getRepository()).queryMemberWorkloadUser(rdmProjectUserDO);
        if (CollectionUtils.isNotEmpty((Collection)memberList)) {
            memberList.forEach(m -> ((RdmProjectUserRepository)this.getRepository()).updateByPk(m));
        }
        return "\u8ba1\u7b97\u6210\u529f";
    }
}

