/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmRelationInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmRelationInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmRelationInfoDTO;
import com.irdstudio.allintcp.sdk.admin.facade.client.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmRelationInfoServiceImpl")
public class RdmRelationInfoServiceImpl
extends BaseServiceImpl<RdmRelationInfoDTO, RdmRelationInfoDO, RdmRelationInfoRepository>
implements RdmRelationInfoService {
    public List<RdmRelationInfoDTO> querySummary(RdmRelationInfoDTO param) {
        RdmRelationInfoDO rdmRelationInfoDO = new RdmRelationInfoDO();
        this.beanCopy(param, rdmRelationInfoDO);
        List list = ((RdmRelationInfoRepository)this.getRepository()).querySummary(rdmRelationInfoDO);
        return this.beansCopy(list, RdmRelationInfoDTO.class);
    }

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].oldData.bizKey}")
    public int insert(RdmRelationInfoDTO paramDTO) {
        this.genDlText(paramDTO, "\u5173\u8054\u4e86");
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].oldData.bizKey}")
    public int deleteByPk(RdmRelationInfoDTO paramDTO) {
        this.genDlText(paramDTO, "\u53d6\u6d88\u5173\u8054");
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    private void genDlText(RdmRelationInfoDTO paramDTO, String opDesc) {
        Map oldData = (Map)paramDTO.getOldData();
        String taskId = MapUtils.getString((Map)oldData, (Object)"taskId");
        String taskName = MapUtils.getString((Map)oldData, (Object)"taskName");
        String reqId = MapUtils.getString((Map)oldData, (Object)"reqId");
        String reqTitle = MapUtils.getString((Map)oldData, (Object)"reqTitle");
        String issueId = MapUtils.getString((Map)oldData, (Object)"issueId");
        String issueName = MapUtils.getString((Map)oldData, (Object)"issueName");
        String fpId = MapUtils.getString((Map)oldData, (Object)"fpId");
        String fpName = MapUtils.getString((Map)oldData, (Object)"fpName");
        String bugId = MapUtils.getString((Map)oldData, (Object)"bugId");
        String bugName = MapUtils.getString((Map)oldData, (Object)"bugName");
        String bizKey = "";
        String srcKey = this.findSrcKey(paramDTO);
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            bizKey = taskId;
            paramDTO.setDlText(String.format("#%s %s\u4efb\u52a1 #%s %s", srcKey, opDesc, taskId, taskName));
        } else if (StringUtils.isNotBlank((CharSequence)reqId)) {
            bizKey = reqId;
            paramDTO.setDlText(String.format("#%s %s\u9700\u6c42 #%s %s", srcKey, opDesc, reqId, reqTitle));
        } else if (StringUtils.isNotBlank((CharSequence)issueId)) {
            bizKey = issueId;
            paramDTO.setDlText(String.format("#%s %s\u95ee\u9898 #%s %s", srcKey, opDesc, issueId, issueName));
        } else if (StringUtils.isNotBlank((CharSequence)fpId)) {
            bizKey = fpId;
            paramDTO.setDlText(String.format("#%s %s\u529f\u80fd #%s %s", srcKey, opDesc, fpId, fpName));
        } else if (StringUtils.isNotBlank((CharSequence)bugId)) {
            bizKey = bugId;
            paramDTO.setDlText(String.format("#%s %s\u7f3a\u9677 #%s %s", srcKey, opDesc, bugId, bugName));
        }
        oldData.put("bizKey", bizKey);
    }

    private String findSrcKey(RdmRelationInfoDTO paramDTO) {
        Map oldData = (Map)paramDTO.getOldData();
        String taskId = MapUtils.getString((Map)oldData, (Object)"taskId");
        String reqId = MapUtils.getString((Map)oldData, (Object)"reqId");
        String issueId = MapUtils.getString((Map)oldData, (Object)"issueId");
        String fpId = MapUtils.getString((Map)oldData, (Object)"fpId");
        String bugId = MapUtils.getString((Map)oldData, (Object)"bugId");
        List<String> targetKeys = Arrays.asList(taskId, reqId, issueId, fpId, bugId, null);
        List<String> srcKeys = Arrays.asList(paramDTO.getTaskId(), paramDTO.getReqId(), paramDTO.getIssueId(), paramDTO.getFpId(), paramDTO.getBugId(), paramDTO.getSubId());
        int index = 0;
        for (int i = 0; i < srcKeys.size(); ++i) {
            int _t;
            String s = srcKeys.get(i);
            String t = targetKeys.get(i);
            int _s = StringUtils.isBlank((CharSequence)s) ? 0 : 1;
            int re = _s ^ (_t = StringUtils.isBlank((CharSequence)t) ? 0 : 1);
            if (re <= 0) continue;
            index = i;
            break;
        }
        return srcKeys.get(index);
    }
}

