/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.FormModelInfoRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.FormModelInfoDO;
import com.irdstudio.allinrdm.dev.console.facade.DevtypeInfoExecService;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnModelInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnValidateInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnModelInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnValidateInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.FnValidateInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnValidateInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fnValidateInfoServiceImpl")
public class FnValidateInfoServiceImpl
extends BaseServiceImpl<FnValidateInfoDTO, FnValidateInfoDO, FnValidateInfoRepository>
implements FnValidateInfoService {
    @Autowired
    private FormModelInfoRepository formModelInfoRepository;
    @Autowired
    private FnModelInfoRepository fnModelInfoRepository;
    @Autowired
    private DevtypeInfoExecService devtypeInfoExecService;
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();

    public int deleteByFnId(String formId, String fnId) {
        return ((FnValidateInfoRepository)this.getRepository()).deleteByFnId(formId, fnId);
    }

    public boolean validate(String formId, String fnId, String userId) {
        taskDebounce.put(formId + fnId, true);
        FnValidateInfoService selfService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
        selfService.deleteByFnId(formId, fnId);
        FnModelInfoDO fnModelInfo = new FnModelInfoDO();
        fnModelInfo.setFormId(formId);
        fnModelInfo.setFnId(fnId);
        List fnList = this.fnModelInfoRepository.queryList((Object)fnModelInfo);
        boolean flag = true;
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            for (FnModelInfoDO fn : fnList) {
                try {
                    List re = this.devtypeInfoExecService.validate(fn.getFnType1(), fn.getFnType2(), userId, fn.getFnId());
                    if (CollectionUtils.isNotEmpty((Collection)re)) {
                        flag = false;
                        continue;
                    }
                    FnModelInfoDO updateFn = new FnModelInfoDO();
                    updateFn.setFnId(fn.getFnId());
                    updateFn.setModelStat(ModelStat.Validated.getCode());
                    this.fnModelInfoRepository.updateByPk((Object)updateFn);
                }
                catch (Exception e) {
                    taskDebounce.put(formId + fnId, false);
                }
            }
        }
        taskDebounce.put(formId + fnId, false);
        if (flag) {
            FormModelInfoDO formParam = new FormModelInfoDO();
            formParam.setFormId(formId);
            formParam.setModelStat(ModelStat.Validated.getCode());
            this.formModelInfoRepository.updateByPk((Object)formParam);
        }
        return flag;
    }

    public boolean validateStat(String formId, String fnId) {
        return (Boolean)taskDebounce.get(formId + fnId);
    }
}

