/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.application.service.impl;

import com.irdstudio.allinrdm.wiki.console.acl.repository.WikiSubsDirectoryRepository;
import com.irdstudio.allinrdm.wiki.console.domain.entity.WikiSubsDirectoryDO;
import com.irdstudio.allinrdm.wiki.console.facade.WikiSubsDirectoryService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsDirectoryDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="wikiSubsDirectoryServiceImpl")
public class WikiSubsDirectoryServiceImpl
extends BaseServiceImpl<WikiSubsDirectoryDTO, WikiSubsDirectoryDO, WikiSubsDirectoryRepository>
implements WikiSubsDirectoryService {
    public int deleteBySubsCode(WikiSubsDirectoryDTO inWikiSubsDirectoryDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inWikiSubsDirectoryDTO);
        int num = 0;
        try {
            WikiSubsDirectoryDO wikiSubsDirectory = new WikiSubsDirectoryDO();
            this.beanCopy(inWikiSubsDirectoryDTO, wikiSubsDirectory);
            num = ((WikiSubsDirectoryRepository)this.getRepository()).deleteBySubsCode(wikiSubsDirectory);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inWikiSubsDirectoryDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int saveSubsDirectors(List<WikiSubsDirectoryDTO> dirList, Boolean recovery) {
        int num = 0;
        if (CollectionUtils.isEmpty(dirList)) {
            logger.info("\u4e1a\u52a1\u7cfb\u7edf\u4f20\u5165\u76ee\u5f55\u5217\u8868\u4e3a\u7a7a");
            return num;
        }
        logger.debug("\u4e1a\u52a1\u7cfb\u7edf wiki \u76ee\u5f55\u521d\u59cb\u5316 " + dirList.size());
        String subsId = dirList.get(0).getSubsId();
        if (recovery.booleanValue()) {
            WikiSubsDirectoryDO delParam = new WikiSubsDirectoryDO();
            delParam.setSubsCode(subsId);
            ((WikiSubsDirectoryRepository)this.getRepository()).deleteByCond(delParam);
        } else {
            WikiSubsDirectoryDO checkParam = new WikiSubsDirectoryDO();
            checkParam.setSubsId(subsId);
            List checkList = ((WikiSubsDirectoryRepository)this.getRepository()).queryListByPage((Object)checkParam);
            if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                logger.info("\u4e1a\u52a1\u7cfb\u7edf\u76ee\u5f55\u5df2\u5b58\u5728");
                return num;
            }
        }
        for (WikiSubsDirectoryDTO dir : dirList) {
            WikiSubsDirectoryDO dirObj = new WikiSubsDirectoryDO();
            this.beanCopy(dir, dirObj);
            num += ((WikiSubsDirectoryRepository)this.getRepository()).insert((Object)dirObj);
        }
        return num;
    }

    public Integer deleteByCond(WikiSubsDirectoryDTO param) {
        return ((WikiSubsDirectoryRepository)this.getRepository()).deleteByCond((WikiSubsDirectoryDO)this.beanCopy(param, WikiSubsDirectoryDO.class));
    }

    public List<WikiSubsDirectoryDTO> queryWikiSubsDirectoryAndCheck(WikiSubsDirectoryDTO wikiSubsDirectoryDTO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            List wikiSubsDirectorys = ((WikiSubsDirectoryRepository)this.getRepository()).queryList((Object)((WikiSubsDirectoryDO)this.beanCopy(wikiSubsDirectoryDTO, new WikiSubsDirectoryDO())));
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + wikiSubsDirectorys.size());
            this.pageSet(wikiSubsDirectorys, (BaseInfo)wikiSubsDirectoryDTO);
            list = this.beansCopy(wikiSubsDirectorys, WikiSubsDirectoryDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

