/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.facade.dto;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.quality.console.types.ValidateType;
import com.irdstudio.allinrdm.dev.console.types.CondCompareSign;
import com.irdstudio.allinrdm.dev.console.types.CondEvalWay;
import com.irdstudio.allinrdm.dev.console.types.CondLogicRelation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CodeTemplateMethodValid {
    private static Pattern condExpReg = Pattern.compile("\\+|\\-|\\*|\\/|\\(|\\)|\\${0,1}\\S*[^\\+\\-\\*\\/\\(\\)\\s]", 8);
    private Integer ruleSort;
    private String ruleName;
    private String ruleExpression;
    private String ruleCondition;
    private String sectionId;
    private String validateType;
    private String validateFail;
    private String validateMsg;

    public String toString() {
        List<Map> condList;
        if (!StringUtils.equals((CharSequence)ValidateType.Function.getCode(), (CharSequence)this.validateType) && StringUtils.equals((CharSequence)ValidateType.Expression.getCode(), (CharSequence)this.validateType) && CollectionUtils.isNotEmpty(condList = this.getCondList()) && StringUtils.isNotBlank((CharSequence)this.ruleExpression)) {
            ArrayList<String> condExpStrs = new ArrayList<String>();
            ArrayList<Integer> condIndexes = new ArrayList<Integer>(condList.size());
            String searchString = this.ruleExpression;
            Matcher condM = condExpReg.matcher(searchString);
            while (condM.find()) {
                int start = condM.start();
                int end = condM.end();
                String findKeyStr = condM.group();
                String headStr = searchString.substring(0, start);
                condExpStrs.add(headStr);
                if (findKeyStr.startsWith("$")) {
                    condExpStrs.add("");
                    condIndexes.add(condExpStrs.size() - 1);
                } else if (findKeyStr.equals(CondLogicRelation.AND.getName())) {
                    condExpStrs.add("&&");
                } else if (findKeyStr.equals(CondLogicRelation.OR.getName())) {
                    condExpStrs.add("||");
                } else if (findKeyStr.equals(CondLogicRelation.NOT.getName())) {
                    condExpStrs.add("!");
                } else {
                    condExpStrs.add(findKeyStr);
                }
                searchString = searchString.substring(end);
                condM = condExpReg.matcher(searchString);
            }
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                condExpStrs.add(searchString);
            }
            for (int i = 0; i < condList.size(); ++i) {
                Map cond = condList.get(i);
                HashMap<String, Object> leftMap = new HashMap<String, Object>();
                leftMap.put("evalWay", cond.get("leftEvalWay"));
                leftMap.put("evalContent", cond.get("leftEvalContent"));
                String leftOperator = this.parseCondEvalContent(leftMap);
                leftMap.put("value", leftOperator);
                HashMap<String, Object> rightMap = new HashMap<String, Object>();
                rightMap.put("evalWay", cond.get("rightEvalWay"));
                rightMap.put("evalContent", cond.get("rightEvalContent"));
                String rightOperator = this.parseCondEvalContent(rightMap);
                rightMap.put("value", rightOperator);
                String combineStatement = this.combineLRStatement(leftMap, rightMap, MapUtils.getString((Map)cond, (Object)"condOp"));
                int replaceIndex = (Integer)condIndexes.get(i);
                condExpStrs.set(replaceIndex, combineStatement);
            }
            return String.format("if(%s){ throw new RuntimeException(\"%s\"); }", StringUtils.join(condExpStrs, (String)""), this.validateMsg);
        }
        return "";
    }

    private List<Map> getCondList() {
        List list = JSON.parseArray((String)this.ruleCondition, Map.class);
        return list;
    }

    private String parseCondEvalContent(Map<String, Object> assignMap) {
        String json = MapUtils.getString(assignMap, (Object)"evalContent");
        String evalWay = MapUtils.getString(assignMap, (Object)"evalWay");
        StringBuffer statement = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)json)) {
            return statement.toString();
        }
        if (CondEvalWay.ASSIGN.getCode().equals(evalWay)) {
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            map.put("tdType", "F");
            String javaType = MapUtils.getString((Map)map, (Object)"javaType");
            String javaPropertyName = MapUtils.getString((Map)map, (Object)"javaPropertyName");
            String fieldJavaStat = String.format("input.get%s()", StringUtils.capitalize((String)javaPropertyName));
            statement.append(fieldJavaStat);
            switch (javaType) {
                case "String": {
                    assignMap.put("javaClass", String.class);
                    break;
                }
                case "Integer": {
                    assignMap.put("javaClass", Integer.class);
                    break;
                }
                case "BigInteger": {
                    assignMap.put("javaClass", BigInteger.class);
                    break;
                }
                case "BigDecimal": {
                    assignMap.put("javaClass", BigDecimal.class);
                    break;
                }
                case "Long": {
                    assignMap.put("javaClass", Long.class);
                    break;
                }
                case "byte[]": {
                    assignMap.put("javaClass", byte[].class);
                    break;
                }
                default: {
                    assignMap.put("javaClass", String.class);
                    break;
                }
            }
        } else if (CondEvalWay.CONST.getCode().equals(evalWay)) {
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            String val = MapUtils.getString((Map)map, (Object)"evalContent");
            String type = "String";
            if (val.startsWith("\"") || val.startsWith("'")) {
                type = "String";
                val = val.replaceAll("'", "").replaceAll("\"", "");
            } else {
                type = val.equals("true") || val.equals("false") ? "Boolean" : (val.matches("\\d+") ? "Integer" : (val.matches("\\d+\\.\\d") ? "BigDecimal" : "String"));
            }
            if (type == "String") {
                statement.append("\"").append(val).append("\"");
                assignMap.put("javaClass", String.class);
            } else if (type == "BigDecimal") {
                assignMap.put("javaClass", BigDecimal.class);
                statement.append("(new BigDecimal(").append("\"").append(val).append("\")");
            } else if (type == "Boolean") {
                Boolean blVal = Boolean.valueOf(val);
                statement.append(blVal != false ? "true" : "false");
                assignMap.put("javaClass", Boolean.class);
            } else if (type == "Integer") {
                statement.append(val);
                assignMap.put("javaClass", Integer.class);
            }
        }
        return statement.toString();
    }

    private String combineLRStatement(Map<String, Object> left, Map<String, Object> right, String condOp) {
        Class opType2;
        HashMap resultOp = new HashMap();
        StringBuffer statement = new StringBuffer();
        String opStr1 = MapUtils.getString(left, (Object)"value");
        String opStr2 = MapUtils.getString(right, (Object)"value");
        Class opType1 = (Class)MapUtils.getObject(left, (Object)"javaClass", null);
        if (opType1 != (opType2 = (Class)MapUtils.getObject(right, (Object)"javaClass", null))) {
            if (opType1 == BigDecimal.class || opType2 == BigDecimal.class) {
                if (opType1 != BigDecimal.class) {
                    opStr1 = String.format("new BigDecimal(%s)", opStr1);
                }
                if (opType2 != BigDecimal.class) {
                    opStr2 = String.format("new BigDecimal(%s)", opStr2);
                }
            } else if (opType1 == String.class && opType2 == Integer.class && CondEvalWay.CONST.getCode().equals(MapUtils.getString(right, (Object)"evalWay", (String)""))) {
                opStr2 = String.format("\"%s\"", opStr2);
            } else if (opType1 == Integer.class || opType2 == Integer.class) {
                if (opType1 != Integer.class) {
                    opStr1 = String.format("Integer.valueOf(%s)", opStr1);
                }
                if (opType2 != Integer.class) {
                    opStr2 = String.format("Integer.valueOf(%s)", opStr2);
                }
            } else if (opType1 == Boolean.class && opType2 == null) {
                opStr2 = "true";
            } else {
                if (opType1 != String.class) {
                    opStr1 = String.format("String.valueOf(%s)", opStr1);
                }
                if (opType2 != String.class) {
                    opStr2 = String.format("String.valueOf(%s)", opStr2);
                }
            }
        }
        if (CondCompareSign.L.getCode().equals(condOp)) {
            statement.append(String.format("%s.compareTo(%s) < 0", opStr1, opStr2));
        } else if (CondCompareSign.LE.getCode().equals(condOp)) {
            statement.append(String.format("%s.compareTo(%s) <= 0", opStr1, opStr2));
        } else if (CondCompareSign.E.getCode().equals(condOp)) {
            if (opType1 == Boolean.class && Boolean.valueOf(opStr2).booleanValue()) {
                statement.append(opStr1);
            } else {
                statement.append(String.format("%s.compareTo(%s) == 0", opStr1, opStr2));
            }
        } else if (CondCompareSign.NE.getCode().equals(condOp)) {
            statement.append(String.format("%s.compareTo(%s) != 0", opStr1, opStr2));
        } else if (CondCompareSign.G.getCode().equals(condOp)) {
            statement.append(String.format("%s.compareTo(%s) > 0", opStr1, opStr2));
        } else if (CondCompareSign.GE.getCode().equals(condOp)) {
            statement.append(String.format("%s.compareTo(%s) >= 0", opStr1, opStr2));
        }
        return statement.toString();
    }

    public Integer getRuleSort() {
        return this.ruleSort;
    }

    public void setRuleSort(Integer ruleSort) {
        this.ruleSort = ruleSort;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleExpression() {
        return this.ruleExpression;
    }

    public void setRuleExpression(String ruleExpression) {
        this.ruleExpression = ruleExpression;
    }

    public String getRuleCondition() {
        return this.ruleCondition;
    }

    public void setRuleCondition(String ruleCondition) {
        this.ruleCondition = ruleCondition;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public String getValidateType() {
        return this.validateType;
    }

    public void setValidateType(String validateType) {
        this.validateType = validateType;
    }

    public String getValidateFail() {
        return this.validateFail;
    }

    public void setValidateFail(String validateFail) {
        this.validateFail = validateFail;
    }

    public String getValidateMsg() {
        return this.validateMsg;
    }

    public void setValidateMsg(String validateMsg) {
        this.validateMsg = validateMsg;
    }
}

