/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.infra.repository.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.AppResourceRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.AppResourceDO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.AppResourceMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.AppResourceactionMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.AppResourcePO;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appResourceRepositoryImpl")
public class AppResourceRepositoryImpl
extends BaseRepositoryImpl<AppResourceDO, AppResourcePO, AppResourceMapper>
implements AppResourceRepository {
    @Autowired
    private AppResourceactionMapper sResourceactionMapper;

    public int batchInsert(List<AppResourceDO> list) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + list.size());
        int num = 0;
        try {
            for (AppResourceDO paramDO : list) {
                if (this.queryByPk((BaseInfo)paramDO) != null) {
                    num += this.updateByPk((BaseInfo)paramDO);
                    continue;
                }
                num += this.insert(paramDO);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int deleteByPk(AppResourceDO inAppResourceDO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inAppResourceDO.toString());
        int num = 0;
        try {
            AppResourcePO sResource = new AppResourcePO();
            this.beanCopy(inAppResourceDO, (Object)sResource);
            num += ((AppResourceMapper)this.getMapper()).deleteByPk((Object)sResource);
            this.sResourceactionMapper.deleteByAppResourceId(sResource.getAppId(), sResource.getResourceid());
            num += this.recursionDeleteChildren(sResource.getAppId(), sResource.getResourceid());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inAppResourceDO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByAppId(String appId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + appId.toString());
        int num = 0;
        try {
            num += ((AppResourceMapper)this.getMapper()).deleteByAppId(appId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + appId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    private int recursionDeleteChildren(String appId, String parentId) {
        int num = 0;
        AppResourcePO param = new AppResourcePO();
        param.setParentid(parentId);
        param.setAppId(appId);
        List childrenList = ((AppResourceMapper)this.getMapper()).queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)childrenList)) {
            for (AppResourcePO child : childrenList) {
                num += ((AppResourceMapper)this.getMapper()).deleteByPk((Object)child);
                this.sResourceactionMapper.deleteByAppResourceId(child.getAppId(), child.getResourceid());
                num += this.recursionDeleteChildren(appId, child.getResourceid());
            }
        }
        return num;
    }

    public List<AppResourceDO> getAllByParentId(String parentid) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + parentid);
        List<AppResourcePO> sResources = ((AppResourceMapper)this.getMapper()).getAllByParentId(parentid);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            list = this.beansCopy(sResources, AppResourceDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<AppResourceDO> queryAllByActorno(String actorno) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + actorno);
        List<AppResourcePO> sResources = ((AppResourceMapper)this.getMapper()).queryAllByActorno(actorno);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            list = this.beansCopy(sResources, AppResourceDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

