/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.infra.repository.impl;

import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyCalendarRepository;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyCalendarDO;
import com.irdstudio.allinrdm.admin.console.infra.persistence.mapper.RdmWeeklyCalendarMapper;
import com.irdstudio.allinrdm.admin.console.infra.persistence.po.RdmWeeklyCalendarPO;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmWeeklyCalendarRepositoryImpl")
public class RdmWeeklyCalendarRepositoryImpl
extends BaseRepositoryImpl<RdmWeeklyCalendarDO, RdmWeeklyCalendarPO, RdmWeeklyCalendarMapper>
implements RdmWeeklyCalendarRepository {
    public RdmWeeklyCalendarDO initThisWeekCalendar(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            RdmWeeklyCalendarDO checkParam = new RdmWeeklyCalendarDO();
            checkParam.setDate(date);
            List checkList = this.queryListByPage((BaseInfo)checkParam);
            if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                return (RdmWeeklyCalendarDO)checkList.get(0);
            }
            Date dateObj = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd"});
            calendar.setTime(dateObj);
            int week = calendar.get(7);
            if (week > 2) {
                calendar.add(5, 2 - week);
            }
            RdmWeeklyCalendarDO cal = new RdmWeeklyCalendarDO();
            cal.setStartDate(DateFormatUtils.format((Calendar)calendar, (String)"yyyy-MM-dd"));
            cal.setWeekNumber(Integer.valueOf(calendar.get(3)));
            calendar.add(5, 6);
            cal.setEndDate(DateFormatUtils.format((Calendar)calendar, (String)"yyyy-MM-dd"));
            cal.setYear(Integer.valueOf(calendar.get(1)));
            int re = this.insert(cal);
            checkList = this.queryListByPage((BaseInfo)checkParam);
            if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                return (RdmWeeklyCalendarDO)checkList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<Map<String, Object>> queryNoWorkDays(Map<String, Object> param) {
        return ((RdmWeeklyCalendarMapper)this.getMapper()).queryNoWorkDays(param);
    }
}

