/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.DictCategoryInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictCategoryInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.CategoryPackagePrefix;
import com.irdstudio.allinrdm.dam.console.types.DictLogChangeType;
import com.irdstudio.allinrdm.dam.console.types.PackageLevel;
import com.irdstudio.allinrdm.dam.console.types.annotations.DictDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DictCategoryInfoController
extends BaseController<DictCategoryInfoDTO, DictCategoryInfoService> {
    @RequestMapping(value={"/api/dict/category/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictCategoryInfoDTO>> queryDictCategoryInfoAll(DictCategoryInfoDTO vo) {
        List outputVo = ((DictCategoryInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/category/info/{packageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DictCategoryInfoDTO> queryByPk(@PathVariable(value="packageId") String packageId) {
        DictCategoryInfoDTO inVo = new DictCategoryInfoDTO();
        inVo.setPackageId(packageId);
        DictCategoryInfoDTO outputVo = (DictCategoryInfoDTO)((DictCategoryInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="category", itemId="${args[0].packageId}", itemCode="${old.packageCode}", itemName="${old.packageName}")
    @RequestMapping(value={"/api/dict/category/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictCategoryInfoDTO inDictCategoryInfoVo) {
        int outputVo = ((DictCategoryInfoService)this.getService()).deleteByPk((Object)inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="category", itemId="${args[0].packageId}", itemCode="${args[0].packageCode}", itemName="${args[0].packageName}")
    @RequestMapping(value={"/api/dict/category/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictCategoryInfoDTO inDictCategoryInfoVo) {
        this.setUserInfoToVO(inDictCategoryInfoVo);
        inDictCategoryInfoVo.setLastModifyUser(inDictCategoryInfoVo.getLoginUserId());
        inDictCategoryInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictCategoryInfoService)this.getService()).updateByPk((Object)inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="category", itemId="${args[0].packageId}", itemCode="${args[0].packageCode}", itemName="${args[0].packageName}")
    @RequestMapping(value={"/api/dict/category/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictCategoryInfo(@RequestBody DictCategoryInfoDTO inDictCategoryInfoVo) {
        this.setUserInfoToVO(inDictCategoryInfoVo);
        if (StringUtils.isBlank((CharSequence)inDictCategoryInfoVo.getPackageId())) {
            String prefix = CategoryPackagePrefix.Theme.getCode();
            if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.Theme.getCode())) {
                prefix = CategoryPackagePrefix.Theme.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.FirstLevel.getCode())) {
                prefix = CategoryPackagePrefix.FirstLevel.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.SecondLevel.getCode())) {
                prefix = CategoryPackagePrefix.SecondLevel.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.ThirdLevel.getCode())) {
                prefix = CategoryPackagePrefix.ThirdLevel.getCode();
            }
            inDictCategoryInfoVo.setPackageId(((DictCategoryInfoService)this.getService()).getSequencePackageId(prefix));
        }
        inDictCategoryInfoVo.setCreateUser(inDictCategoryInfoVo.getLoginUserId());
        inDictCategoryInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictCategoryInfoService)this.getService()).insert((Object)inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }
}

