/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.DictLogChangeType;
import com.irdstudio.allinrdm.dam.console.types.PublishState;
import com.irdstudio.allinrdm.dam.console.types.annotations.DictDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class DictOptionInfoController
extends BaseController<DictOptionInfoDTO, DictOptionInfoService> {
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="option", itemId="${args[0].dictId}", itemCode="${args[0].dictCode}", itemName="${args[0].dictName}")
    @PostMapping(value={"/api/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> insertDictOptionInfo(@RequestBody DictOptionInfoDTO inDictOptionInfoVo) {
        if (StringUtils.isBlank((String)inDictOptionInfoVo.getDictId())) {
            inDictOptionInfoVo.setDictId(UUIDUtil.getUUID());
        }
        inDictOptionInfoVo.setDictCode(inDictOptionInfoVo.getDictCode().toLowerCase());
        inDictOptionInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDictOptionInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inDictOptionInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionInfoVo.setLastModifyTime(inDictOptionInfoVo.getCreateTime());
        int outputVo = ((DictOptionInfoService)this.getService()).insert((Object)inDictOptionInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="option", itemId="${args[0].dictId}", itemCode="${old.dictCode}", itemName="${old.dictName}")
    @DeleteMapping(value={"/api/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictOptionInfoDTO inDictOptionInfoVo) {
        int outputVo = ((DictOptionInfoService)this.getService()).deleteByPk((Object)inDictOptionInfoVo);
        outputVo = this.dictOptionEnumService.deleteByDictId(inDictOptionInfoVo.getDictId());
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="option", itemId="${args[0].dictId}", itemCode="${args[0].dictCode}", itemName="${args[0].dictName}")
    @PutMapping(value={"/api/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictOptionInfoDTO inDictOptionInfoVo) {
        inDictOptionInfoVo.setDictCode(inDictOptionInfoVo.getDictCode().toLowerCase());
        int outputVo = ((DictOptionInfoService)this.getService()).updateByPk((Object)inDictOptionInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/dict/option/info/{subsId}/{dictId}"})
    @ResponseBody
    public ResponseData<DictOptionInfoDTO> queryByPk(@PathVariable(value="subsId") String subsId, @PathVariable(value="dictId") String dictId) {
        DictOptionInfoDTO inVo = new DictOptionInfoDTO();
        inVo.setSubsId(subsId);
        inVo.setDictId(dictId);
        DictOptionInfoDTO outputVo = (DictOptionInfoDTO)((DictOptionInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/my/api/dict/option/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionInfoDTO>> queryMyDictOptionInfoAll(DictOptionInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((DictOptionInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/option/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionInfoDTO>> queryPublicDictOptionInfoAll(DictOptionInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((DictOptionInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/dict/option/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, final @RequestParam(value="accessLevel") String accessLevel, final @RequestParam(value="subsId", required=false) String subsId, final @RequestParam(value="appId", required=false) String appId, @RequestPart(value="file") MultipartFile file) {
        try {
            final ArrayList list = new ArrayList();
            final HashMap map = new HashMap();
            final ArrayList enumList = new ArrayList();
            final UserInfo userInfo = this.getUserInfo();
            final String createTime = TimeUtil.getCurrentDateTime();
            List<String> HEAD = Arrays.asList("\u9009\u9879\u7f16\u53f7", "\u82f1\u6587\u540d\u79f0", "\u4e2d\u6587\u540d\u79f0", "\u9009\u9879\u503c", "\u9009\u9879\u679a\u4e3e\u503c", "\u9009\u9879\u63cf\u8ff0");
            final ArrayList headCellList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
                    String dictId = data.get(0);
                    String dictCode = data.get(1);
                    String dictName = data.get(2);
                    String optionCode = data.get(3);
                    String optionEnum = data.get(4);
                    String optionName = data.get(5);
                    DictOptionInfoDTO info = (DictOptionInfoDTO)map.get(dictId);
                    if (info == null) {
                        info = new DictOptionInfoDTO();
                        info.setDictId(dictId);
                        info.setDictCode(dictCode);
                        info.setDictName(dictName);
                        info.setDictIsStd("N");
                        info.setDictType("1");
                        info.setAccessLevel(accessLevel);
                        info.setSubsId(subsId);
                        info.setAppId(appId);
                        info.setCreateTime(createTime);
                        info.setCreateUser(userInfo.getUserId());
                        info.setPublishState(PublishState.Publish.getCode());
                        info.setCodeLen(Integer.valueOf(0));
                        map.put(info.getDictId(), info);
                        list.add(info);
                    }
                    info.setCodeLen(Integer.valueOf(Math.max(info.getCodeLen(), StringUtils.length((String)optionCode))));
                    DictOptionEnumDTO obj = new DictOptionEnumDTO();
                    obj.setOptionId(UUIDUtil.getUUID());
                    obj.setDictId(dictId);
                    obj.setOptionCode(optionCode);
                    obj.setOptionEnum(optionEnum);
                    obj.setOptionName(optionName);
                    obj.setOptionRemarks(optionName);
                    obj.setSubsId(subsId);
                    obj.setLastModifyTime(createTime);
                    obj.setLastModifyUser(userInfo.getUserId());
                    enumList.add(obj);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doReadSync();
            if (headCellList.size() != HEAD.size()) {
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 0; i < HEAD.size(); ++i) {
                if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            if (list.size() > 0) {
                ((DictOptionInfoService)this.getService()).excelUpload(excelUploadType, list, enumList);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u4ee3\u7801\u9879\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData(null, "\u4e0a\u4f20\u6210\u529f", "\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage().substring(0, 150));
        }
        return this.getResponseData("S");
    }

    @RequestMapping(value={"/api/dict/option/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="appId") String appId) {
        String seq = ((DictOptionInfoService)this.getService()).querySeqWithPrefix(appId);
        return this.getResponseData(seq);
    }
}

