/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PageTemplateInfoController
extends BaseController<PageTemplateInfoDTO, PageTemplateInfoService> {
    @Autowired
    @Qualifier(value="pageTemplateInfoServiceImpl")
    private PageTemplateInfoService pageTemplateInfoService;
    @Autowired
    private PageModelInfoService pageModelInfoService;

    @RequestMapping(value={"/api/page/template/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PageTemplateInfoDTO>> queryPageTemplateInfoAll(PageTemplateInfoDTO vo) {
        List outputVo = this.pageTemplateInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/info/{pageTemplateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PageTemplateInfoDTO> queryByPk(@PathVariable(value="pageTemplateId") String pageTemplateId) {
        PageTemplateInfoDTO inVo = new PageTemplateInfoDTO();
        inVo.setPageTemplateId(pageTemplateId);
        PageTemplateInfoDTO outputVo = (PageTemplateInfoDTO)this.pageTemplateInfoService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PageTemplateInfoDTO inPageTemplateInfoVo) {
        PageModelInfoDTO pageModelInfoDTO = new PageModelInfoDTO();
        pageModelInfoDTO.setPageTemplateId(inPageTemplateInfoVo.getPageTemplateId());
        List pageModelInfoDTOS = this.pageModelInfoService.queryListByPage((Object)pageModelInfoDTO);
        if (!pageModelInfoDTOS.isEmpty()) {
            return this.getResponseData(0);
        }
        int outputVo = this.pageTemplateInfoService.deleteByPk((Object)inPageTemplateInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PageTemplateInfoDTO inPageTemplateInfoVo) {
        this.setUserInfoToVO(inPageTemplateInfoVo);
        inPageTemplateInfoVo.setLastUpdateUser(inPageTemplateInfoVo.getLoginUserId());
        inPageTemplateInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.pageTemplateInfoService.updateByPk((Object)inPageTemplateInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/page/template/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPageTemplateInfo(@RequestBody PageTemplateInfoDTO inPageTemplateInfoVo) {
        this.setUserInfoToVO(inPageTemplateInfoVo);
        if (StringUtils.isBlank((CharSequence)inPageTemplateInfoVo.getPageTemplateId())) {
            inPageTemplateInfoVo.setPageTemplateId(UUIDUtil.getUUID());
        }
        inPageTemplateInfoVo.setCreateUser(inPageTemplateInfoVo.getLoginUserId());
        inPageTemplateInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.pageTemplateInfoService.insert((Object)inPageTemplateInfoVo);
        return this.getResponseData(outputVo);
    }
}

