/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.TclFrameworkInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclFrameworkInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TclFrameworkInfoController
extends BaseController<TclFrameworkInfoDTO, TclFrameworkInfoService> {
    @Autowired
    @Qualifier(value="tclFrameworkInfoServiceImpl")
    private TclFrameworkInfoService tclFrameworkInfoService;

    @RequestMapping(value={"/api/tcl/framework/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TclFrameworkInfoDTO>> queryTclFrameworkInfoAll(TclFrameworkInfoDTO vo) {
        List outputVo = this.tclFrameworkInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/framework/info/{tclId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<TclFrameworkInfoDTO> queryByPk(@PathVariable(value="tclId") String tclId) {
        TclFrameworkInfoDTO inVo = new TclFrameworkInfoDTO();
        inVo.setTclId(tclId);
        TclFrameworkInfoDTO outputVo = (TclFrameworkInfoDTO)this.tclFrameworkInfoService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/framework/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody TclFrameworkInfoDTO inTclFrameworkInfoVo) {
        int outputVo = this.tclFrameworkInfoService.deleteByPk((Object)inTclFrameworkInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/framework/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody TclFrameworkInfoDTO inTclFrameworkInfoVo) {
        this.setUserInfoToVO(inTclFrameworkInfoVo);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTclFrameworkInfoVo.setLastModifyUser(userId);
        inTclFrameworkInfoVo.setLastModifyTime(now);
        int outputVo = this.tclFrameworkInfoService.updateByPk((Object)inTclFrameworkInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tcl/framework/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertTclFrameworkInfo(@RequestBody TclFrameworkInfoDTO inTclFrameworkInfoVo) {
        this.setUserInfoToVO(inTclFrameworkInfoVo);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTclFrameworkInfoVo.setCreateUser(userId);
        inTclFrameworkInfoVo.setCreateTime(now);
        inTclFrameworkInfoVo.setLastModifyUser(userId);
        inTclFrameworkInfoVo.setLastModifyTime(now);
        int outputVo = this.tclFrameworkInfoService.insert((Object)inTclFrameworkInfoVo);
        return this.getResponseData(outputVo);
    }
}

