/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.DictIndexInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictIndexInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.DictLogChangeType;
import com.irdstudio.allinrdm.dam.console.types.annotations.DictDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DictIndexInfoController
extends BaseController<DictIndexInfoDTO, DictIndexInfoService> {
    @RequestMapping(value={"/api/dict/index/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictIndexInfoDTO>> queryDictIndexInfoAll(DictIndexInfoDTO vo) {
        List outputVo = ((DictIndexInfoService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/index/info/{idxId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DictIndexInfoDTO> queryByPk(@PathVariable(value="idxId") String idxId) {
        DictIndexInfoDTO inVo = new DictIndexInfoDTO();
        inVo.setIdxId(idxId);
        DictIndexInfoDTO outputVo = (DictIndexInfoDTO)((DictIndexInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="index", itemId="${args[0].idxId}", itemName="${old.idxName}", itemCommName="${old.idxCommName}")
    @RequestMapping(value={"/api/dict/index/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictIndexInfoDTO inDictIndexInfoVo) {
        int outputVo = ((DictIndexInfoService)this.getService()).deleteByPk((Object)inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="index", itemId="${args[0].idxId}", itemName="${args[0].idxName}", itemCommName="${args[0].idxCommName}")
    @RequestMapping(value={"/api/dict/index/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictIndexInfoDTO inDictIndexInfoVo) {
        this.setUserInfoToVO(inDictIndexInfoVo);
        inDictIndexInfoVo.setLastModifyUser(inDictIndexInfoVo.getLoginUserId());
        inDictIndexInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictIndexInfoService)this.getService()).updateByPk((Object)inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="index", itemId="${args[0].idxId}", itemName="${old.idxName}", itemCommName="${old.idxCommName}")
    @RequestMapping(value={"/api/dict/index/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictIndexInfo(@RequestBody DictIndexInfoDTO inDictIndexInfoVo) {
        this.setUserInfoToVO(inDictIndexInfoVo);
        if (StringUtils.isBlank((CharSequence)inDictIndexInfoVo.getIdxId())) {
            inDictIndexInfoVo.setIdxId(UUIDUtil.getUUID());
        }
        inDictIndexInfoVo.setCreateUser(inDictIndexInfoVo.getLoginUserId());
        inDictIndexInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictIndexInfoService)this.getService()).insert((Object)inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }
}

