/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.FormListFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListFieldDTO;
import com.irdstudio.allinrdm.dev.console.types.FormFieldSourceType;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FormListFieldController
extends BaseController<FormListFieldDTO, FormListFieldService> {
    @Autowired
    private FormModelFieldService formModelFieldService;

    @RequestMapping(value={"/api/form/list/fields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FormListFieldDTO>> queryFormListFieldAll(FormListFieldDTO dto) {
        List outputVo = ((FormListFieldService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/list/field/{formFieldId}/{fnId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FormListFieldDTO> queryByPk(@PathVariable(value="formFieldId") String formFieldId, @PathVariable(value="fnId") String fnId) {
        FormListFieldDTO inVo = new FormListFieldDTO();
        inVo.setFormFieldId(formFieldId);
        inVo.setFnId(fnId);
        FormListFieldDTO outputVo = (FormListFieldDTO)((FormListFieldService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/list/field"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FormListFieldDTO inFormListFieldDTO) {
        int outputVo = ((FormListFieldService)this.getService()).deleteByPk((Object)inFormListFieldDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/list/field"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FormListFieldDTO inFormListFieldDTO) {
        int outputVo = ((FormListFieldService)this.getService()).updateByPk((Object)inFormListFieldDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/list/field"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFormListField(@RequestBody FormListFieldDTO inFormListFieldDTO) {
        if (StringUtils.equals((CharSequence)inFormListFieldDTO.getFieldSourceType(), (CharSequence)FormFieldSourceType.CustomField.getCode())) {
            int re;
            if (StringUtils.isBlank((CharSequence)inFormListFieldDTO.getFormFieldId())) {
                inFormListFieldDTO.setFormFieldId(UUIDUtil.getUUID());
            }
            if ((re = this.formModelFieldService.insert((Object)inFormListFieldDTO)) == 0) {
                throw new RuntimeException("\u8868\u5355\u5b57\u6bb5\u4fdd\u5b58\u5f02\u5e38");
            }
        }
        int outputVo = ((FormListFieldService)this.getService()).insert((Object)inFormListFieldDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/form/list/field/hide"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFormAddField(@RequestBody List<FormListFieldDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (FormListFieldDTO field : list) {
                outputVo += ((FormListFieldService)this.getService()).updateByPk((Object)field);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/FormListFieldService/deleteByFormId"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByFormId(@RequestParam(value="formId") String formId) {
        return ((FormListFieldService)this.getService()).deleteByFormId(formId);
    }

    @RequestMapping(value={"/client/FormListFieldService/deleteByFnId"}, method={RequestMethod.POST})
    @ResponseBody
    public int deleteByFnId(@RequestParam(value="formId") String formId, @RequestParam(value="fnId") String fnId) {
        return ((FormListFieldService)this.getService()).deleteByFnId(formId, fnId);
    }
}

