/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeTableService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeTableDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeVarDTO;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class OsrvArrangeTableController
extends BaseController<OsrvArrangeTableDTO, OsrvArrangeTableService> {
    @Autowired
    @Qualifier(value="osrvArrangeVarServiceImpl")
    private OsrvArrangeVarService osrvArrangeVarService;

    @RequestMapping(value={"/api/osrv/arrange/tables"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvArrangeTableDTO>> queryOsrvArrangeTableAll(OsrvArrangeTableDTO vo) {
        List outputVo = ((OsrvArrangeTableService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/table/{tableRowId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<OsrvArrangeTableDTO> queryByPk(@PathVariable(value="tableRowId") String tableRowId) {
        OsrvArrangeTableDTO inVo = new OsrvArrangeTableDTO();
        inVo.setTableRowId(tableRowId);
        OsrvArrangeTableDTO outputVo = (OsrvArrangeTableDTO)((OsrvArrangeTableService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/table"}, method={RequestMethod.DELETE})
    @AppDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u670d\u52a1\u7f16\u6392\u8868\u683c\u5355\u884c ${args[0].rowOpTargetName} ${args[0].tableRowId}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody OsrvArrangeTableDTO inOsrvArrangeTableVo) {
        int outputVo = ((OsrvArrangeTableService)this.getService()).deleteByPk((Object)inOsrvArrangeTableVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/table"}, method={RequestMethod.PUT})
    @AppDevLogAnno(action=LogAction.Update, desc="\u66f4\u65b0\u670d\u52a1\u7f16\u6392\u8868\u683c\u5355\u884c ${args[0].rowOpTargetName}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody OsrvArrangeTableDTO inOsrvArrangeTableVo) {
        int outputVo = ((OsrvArrangeTableService)this.getService()).updateByPk((Object)inOsrvArrangeTableVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/table"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertOsrvArrangeTable(@RequestParam(value="doOrder", required=false) String doOrder, @RequestBody OsrvArrangeTableDTO inOsrvArrangeTableVo) {
        if (StringUtils.equals((String)doOrder, (String)"true")) {
            logger.info(String.format("\u65b0\u589e\u670d\u52a1\u7f16\u6392\u8868\u683c\u884c doOrder: %s srvModelId: %s sectionId: %s", doOrder, inOsrvArrangeTableVo.getSrvModelId(), inOsrvArrangeTableVo.getSectionId()));
            ((OsrvArrangeTableService)this.getService()).updateTableRowNo(inOsrvArrangeTableVo);
        }
        int outputVo = -1;
        if (StringUtils.isBlank((String)inOsrvArrangeTableVo.getTableRowId())) {
            inOsrvArrangeTableVo.setTableRowId(UUIDUtil.getUUID());
            outputVo = ((OsrvArrangeTableService)this.getService()).insert((Object)inOsrvArrangeTableVo);
        } else {
            OsrvArrangeTableDTO checkParam = new OsrvArrangeTableDTO();
            checkParam.setTableRowId(inOsrvArrangeTableVo.getTableRowId());
            OsrvArrangeTableDTO checkObj = (OsrvArrangeTableDTO)((OsrvArrangeTableService)this.getService()).queryByPk((Object)checkParam);
            outputVo = checkObj == null ? ((OsrvArrangeTableService)this.getService()).insert((Object)inOsrvArrangeTableVo) : ((OsrvArrangeTableService)this.getService()).updateByPk((Object)inOsrvArrangeTableVo);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/arrange/data"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map> queryOsrvArrangeData(@RequestBody OsrvArrangeTableDTO vo) {
        HashMap<String, List> result = new HashMap<String, List>();
        List tables = ((OsrvArrangeTableService)this.getService()).queryList((Object)vo);
        result.put("OsrvArrangeTableVO", tables);
        OsrvArrangeVarDTO varParam = new OsrvArrangeVarDTO();
        varParam.setSrvModelId(vo.getSrvModelId());
        List vars = this.osrvArrangeVarService.queryList((Object)varParam);
        result.put("OsrvArrangeVarVO", vars);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/osrv/arrange/savelist"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> saveTableData(@RequestBody List<OsrvArrangeTableDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return this.getResponseData(true);
        }
        Boolean flag = false;
        try {
            flag = ((OsrvArrangeTableService)this.getService()).saveTableList(null, null, list);
        }
        catch (Exception e) {
            flag = false;
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/api/osrv/arrange/update/target"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> updateRowTargetName(@RequestBody Map<String, String> map) {
        String projectId = map.get("projectId");
        String tableModelId = map.get("tableModelId");
        String tableModelCode = map.get("tableModelCode");
        String tableModelName = map.get("tableModelName");
        Boolean result = ((OsrvArrangeTableService)this.getService()).updateOpTargetName(projectId, tableModelId, tableModelCode, tableModelName);
        return this.getResponseData(result.toString());
    }

    @RequestMapping(value={"/api/osrv/arrange/table/order/{order}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> dealWithTableOrder(@PathVariable(value="order") String order, @RequestParam(value="firstId") String firstId, @RequestParam(value="secondId") String secondId) {
        String result = ((OsrvArrangeTableService)this.getService()).dealWithTableOrder(firstId, secondId);
        return this.getResponseData(result);
    }
}

