/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalIsrvService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalIsrvDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class OsrvEvalIsrvController
extends BaseController<OsrvEvalIsrvDTO, OsrvEvalIsrvService> {
    @Autowired
    @Qualifier(value="osrvArrangeVarServiceImpl")
    private OsrvArrangeVarService osrvArrangeVarService;
    @Autowired
    @Qualifier(value="srvModelInoutServiceImpl")
    private SrvModelInoutService srvModelInoutService;
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/osrv/eval/isrvs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvEvalIsrvDTO>> queryOsrvEvalIsrvAll(OsrvEvalIsrvDTO vo) {
        List outputVo = ((OsrvEvalIsrvService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrvs/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvEvalIsrvDTO>> queryOsrvEvalIsrvAllNotPage(OsrvEvalIsrvDTO vo) {
        List outputVo = ((OsrvEvalIsrvService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> refreshIsrvList(@RequestBody OsrvEvalIsrvDTO vo) {
        Boolean result = ((OsrvEvalIsrvService)this.getService()).refreshIsrvList(vo);
        return this.getResponseData(result.toString());
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/{recordKeyid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<OsrvEvalIsrvDTO> queryByPk(@PathVariable(value="recordKeyid") String recordKeyid) {
        OsrvEvalIsrvDTO inVo = new OsrvEvalIsrvDTO();
        inVo.setRecordKeyid(recordKeyid);
        OsrvEvalIsrvDTO outputVo = (OsrvEvalIsrvDTO)((OsrvEvalIsrvService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody OsrvEvalIsrvDTO inOsrvEvalIsrvVo) {
        int outputVo = ((OsrvEvalIsrvService)this.getService()).deleteByPk((Object)inOsrvEvalIsrvVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/table"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByTableRowId(@RequestBody OsrvEvalIsrvDTO inOsrvEvalIsrvVo) {
        int outputVo = ((OsrvEvalIsrvService)this.getService()).deleteByTableRowId(inOsrvEvalIsrvVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody OsrvEvalIsrvDTO inOsrvEvalIsrvVo) {
        int outputVo = ((OsrvEvalIsrvService)this.getService()).updateByPk((Object)inOsrvEvalIsrvVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/list"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateList(@RequestBody List<OsrvEvalIsrvDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (OsrvEvalIsrvDTO inOsrvEvalIsrvVo : list) {
                outputVo += ((OsrvEvalIsrvService)this.getService()).updateByPk((Object)inOsrvEvalIsrvVo);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertOsrvEvalIsrv(@RequestBody OsrvEvalIsrvDTO inOsrvEvalIsrvVo) {
        int outputVo = ((OsrvEvalIsrvService)this.getService()).insert((Object)inOsrvEvalIsrvVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/check"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> checkTableFieldInto(@RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="tableRowId") String tableRowId, @RequestParam(value="rowOpTargetId") String rowOpTargetId) {
        OsrvEvalIsrvDTO isrvParam = new OsrvEvalIsrvDTO();
        isrvParam.setSrvModelId(srvModelId);
        isrvParam.setTableRowId(tableRowId);
        List isrvList = ((OsrvEvalIsrvService)this.getService()).queryListByPage((Object)isrvParam);
        if (CollectionUtils.isNotEmpty((Collection)isrvList)) {
            return this.getResponseData(tableRowId);
        }
        ResponseData<Integer> initNum = this.cpTableFieldInto(srvModelId, tableRowId, rowOpTargetId, null, null);
        return this.getResponseData(tableRowId);
    }

    @RequestMapping(value={"/api/osrv/eval/isrv/cp"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> cpTableFieldInto(@RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="tableRowId") String tableRowId, @RequestParam(value="rowOpTargetId") String rowOpTargetId, @RequestParam(value="tableModelId", required=false) String tableModelId, @RequestParam(value="rowOpType", required=false) String rowOpType) {
        if (StringUtils.isNotBlank((String)tableModelId)) {
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(tableModelId);
            List fields = this.modelTableFieldService.queryList((Object)fieldParam);
            ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
            tableParam.setObjectId(tableModelId);
            ModelTableInfoDTO tableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableParam);
            if (CollectionUtils.isEmpty((Collection)fields)) {
                return this.getResponseData(0);
            }
            OsrvEvalIsrvDTO deleteParam = new OsrvEvalIsrvDTO();
            deleteParam.setTableRowId(tableRowId);
            ((OsrvEvalIsrvService)this.getService()).deleteByTableRowId(deleteParam);
            ArrayList<OsrvEvalIsrvDTO> vars = new ArrayList<OsrvEvalIsrvDTO>(fields.size());
            for (ModelTableFieldDTO field : fields) {
                OsrvEvalIsrvDTO var = new OsrvEvalIsrvDTO();
                var.setRecordKeyid(UUIDUtil.getUUID());
                var.setSrvModelId(srvModelId);
                var.setTableRowId(tableRowId);
                var.setIsrvModelId(rowOpTargetId);
                var.setIsrvModelCode(tableInfo.getObjectCode());
                var.setIsrvModelName(tableInfo.getObjectName());
                var.setIsrvFieldId(field.getFieldId());
                var.setIsrvFieldCode(field.getFieldCode());
                var.setIsrvFieldName(field.getFieldName());
                var.setFieldOrder(field.getFieldOrder());
                vars.add(var);
            }
            int nums = ((OsrvEvalIsrvService)this.getService()).batchInsert(vars);
            return this.getResponseData(nums);
        }
        OsrvEvalIsrvDTO deleteParam = new OsrvEvalIsrvDTO();
        deleteParam.setTableRowId(tableRowId);
        int delNum = ((OsrvEvalIsrvService)this.getService()).deleteByTableRowId(deleteParam);
        logger.info("\u5220\u9664\u65e7\u8d4b\u503c\u8bb0\u5f55\u6570\uff1a{}", (Object)delNum);
        SrvModelInfoDTO infoVO = new SrvModelInfoDTO();
        infoVO.setSrvModelId(rowOpTargetId);
        infoVO = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)infoVO);
        SrvModelInoutDTO inputParam = new SrvModelInoutDTO();
        inputParam.setSrvModelId(rowOpTargetId);
        IOType varType = IOType.Input;
        if (StringUtils.equals((String)rowOpType, (String)"R")) {
            varType = IOType.Output;
        }
        inputParam.setIoType(varType.getCode());
        List inputs = this.srvModelInoutService.querySrvInoutsWithoutParamSet(inputParam);
        int nums = 0;
        for (SrvModelInoutDTO inout : inputs) {
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(inout.getTableModelId());
            List fields = this.modelTableFieldService.queryFieldWithFieldFlag(inout.getTableModelId(), infoVO.getSrvModelCatalog(), infoVO.getSrvModelType());
            ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
            tableParam.setObjectId(inout.getTableModelId());
            ModelTableInfoDTO tableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableParam);
            if (CollectionUtils.isEmpty((Collection)fields)) continue;
            ArrayList<OsrvEvalIsrvDTO> vars = new ArrayList<OsrvEvalIsrvDTO>(fields.size());
            for (ModelTableFieldDTO field : fields) {
                if (varType == IOType.Input && NumberUtils.toInt((String)field.getFieldFlag(), (int)0) == 0) continue;
                OsrvEvalIsrvDTO var = new OsrvEvalIsrvDTO();
                var.setRecordKeyid(UUIDUtil.getUUID());
                var.setSrvModelId(srvModelId);
                var.setTableRowId(tableRowId);
                var.setIsrvModelId(inout.getTableModelId());
                var.setIsrvModelCode(tableInfo.getObjectCode());
                var.setIsrvModelName(tableInfo.getObjectName());
                var.setIsrvFieldId(field.getFieldId());
                var.setIsrvFieldCode(field.getFieldCode());
                var.setIsrvFieldName(field.getFieldName());
                var.setFieldOrder(field.getFieldOrder());
                vars.add(var);
            }
            nums += ((OsrvEvalIsrvService)this.getService()).batchInsert(vars);
        }
        return this.getResponseData(nums);
    }
}

