/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalIsrvService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalVarService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeVarDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalVarDTO;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class OsrvEvalVarController
extends BaseController<OsrvEvalVarDTO, OsrvEvalVarService> {
    @Autowired
    @Qualifier(value="osrvEvalIsrvServiceImpl")
    private OsrvEvalIsrvService osrvEvalIsrvService;
    @Autowired
    @Qualifier(value="osrvArrangeVarServiceImpl")
    private OsrvArrangeVarService osrvArrangeVarService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/osrv/eval/vars"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvEvalVarDTO>> queryOsrvEvalVarAll(OsrvEvalVarDTO vo) {
        List outputVo = ((OsrvEvalVarService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/vars/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<OsrvEvalVarDTO>> queryAllEvalVar(OsrvEvalVarDTO vo) {
        List outputVo = ((OsrvEvalVarService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var/refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> refreshVarList(@RequestBody OsrvEvalVarDTO vo) {
        Boolean result = ((OsrvEvalVarService)this.getService()).refreshVarList(vo);
        return this.getResponseData(result.toString());
    }

    @RequestMapping(value={"/api/osrv/eval/var/{recordKeyid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<OsrvEvalVarDTO> queryByPk(@PathVariable(value="recordKeyid") String recordKeyid) {
        OsrvEvalVarDTO inVo = new OsrvEvalVarDTO();
        inVo.setRecordKeyid(recordKeyid);
        OsrvEvalVarDTO outputVo = (OsrvEvalVarDTO)((OsrvEvalVarService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody OsrvEvalVarDTO inOsrvEvalVarVo) {
        int outputVo = ((OsrvEvalVarService)this.getService()).deleteByPk((Object)inOsrvEvalVarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody OsrvEvalVarDTO inOsrvEvalVarVo) {
        int outputVo = ((OsrvEvalVarService)this.getService()).updateByPk((Object)inOsrvEvalVarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var/list"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByList(@RequestBody List<OsrvEvalVarDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (OsrvEvalVarDTO inOsrvEvalVarVo : list) {
                outputVo += ((OsrvEvalVarService)this.getService()).updateByPk((Object)inOsrvEvalVarVo);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertOsrvEvalVar(@RequestBody OsrvEvalVarDTO inOsrvEvalVarVo) {
        int outputVo = ((OsrvEvalVarService)this.getService()).insert((Object)inOsrvEvalVarVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/osrv/eval/var/cp"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> cpTableFieldInto(@RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="tableRowId") String tableRowId, @RequestParam(value="varId") String varId, @RequestParam(value="tableModelId") String tableModelId) {
        if (StringUtils.isBlank((String)tableModelId)) {
            return this.getResponseData(0);
        }
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(tableModelId);
        List fields = this.modelTableFieldService.queryList((Object)fieldParam);
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return this.getResponseData(0);
        }
        OsrvArrangeVarDTO varParam = new OsrvArrangeVarDTO();
        varParam.setDomainVarId(varId);
        OsrvArrangeVarDTO domainVar = (OsrvArrangeVarDTO)this.osrvArrangeVarService.queryByPk((Object)varParam);
        ArrayList<OsrvEvalVarDTO> vars = new ArrayList<OsrvEvalVarDTO>(fields.size());
        for (ModelTableFieldDTO field : fields) {
            OsrvEvalVarDTO var = new OsrvEvalVarDTO();
            var.setRecordKeyid(UUIDUtil.getUUID());
            var.setSrvModelId(srvModelId);
            var.setTableRowId(tableRowId);
            var.setDomainVarId(varId);
            var.setDomainVarCode(domainVar.getDomainVarCode());
            var.setDomainVarName(domainVar.getDomainVarName());
            var.setDomainFieldId(field.getFieldId());
            var.setDomainFieldCode(field.getFieldCode());
            var.setDomainFieldName(field.getFieldName());
            var.setFieldOrder(field.getFieldOrder());
            vars.add(var);
        }
        int nums = ((OsrvEvalVarService)this.getService()).batchInsert(vars);
        return this.getResponseData(nums);
    }

    @RequestMapping(value={"/api/osrv/eval/table/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryTableFields(@RequestParam(value="srvModelId") String srvModelId, @RequestParam(name="queryTb", required=false, defaultValue="false") Boolean queryTb) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        OsrvArrangeVarDTO varParam = new OsrvArrangeVarDTO();
        varParam.setSrvModelId(srvModelId);
        List vars = this.osrvArrangeVarService.queryList((Object)varParam);
        ArrayList<OsrvArrangeVarDTO> inputs = new ArrayList<OsrvArrangeVarDTO>();
        ArrayList<OsrvArrangeVarDTO> outputs = new ArrayList<OsrvArrangeVarDTO>();
        ArrayList<OsrvArrangeVarDTO> dvars = new ArrayList<OsrvArrangeVarDTO>();
        HashMap<String, List> fieldsMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)vars)) {
            for (OsrvArrangeVarDTO v : vars) {
                if (v.getDomainVarType().equals(DomainVarType.Input.getCode())) {
                    inputs.add(v);
                } else if (v.getDomainVarType().equals(DomainVarType.Output.getCode())) {
                    outputs.add(v);
                } else if (v.getDomainVarType().equals(DomainVarType.Var.getCode())) {
                    dvars.add(v);
                }
                if (!queryTb.booleanValue() || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getTableModelId())) continue;
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(v.getTableModelId());
                List fields = this.modelTableFieldService.queryListByPage((Object)fieldParam);
                fieldsMap.put(v.getTableModelId(), fields);
            }
        }
        result.put(DomainVarType.Input.getCode(), inputs);
        result.put(DomainVarType.Output.getCode(), outputs);
        result.put(DomainVarType.Var.getCode(), dvars);
        result.put("fields", fieldsMap);
        return this.getResponseData(result);
    }
}

