/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.RdmProjectGroupService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectGroupDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmProjectGroupController
extends BaseController<RdmProjectGroupDTO, RdmProjectGroupService> {
    @RequestMapping(value={"/api/rdm/project/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmProjectGroupDTO>> queryRdmProjectGroupAll(RdmProjectGroupDTO dto) {
        List outputVo = ((RdmProjectGroupService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/group/{groupId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmProjectGroupDTO> queryByPk(@PathVariable(value="groupId") String groupId) {
        RdmProjectGroupDTO inVo = new RdmProjectGroupDTO();
        inVo.setGroupId(groupId);
        RdmProjectGroupDTO outputVo = (RdmProjectGroupDTO)((RdmProjectGroupService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/group"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmProjectGroupDTO inRdmProjectGroupDTO) {
        int outputVo = ((RdmProjectGroupService)this.getService()).deleteByPk((Object)inRdmProjectGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/group"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmProjectGroupDTO inRdmProjectGroupDTO) {
        this.setUserInfoToVO(inRdmProjectGroupDTO);
        inRdmProjectGroupDTO.setLastModifyUser(inRdmProjectGroupDTO.getLoginUserId());
        inRdmProjectGroupDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((RdmProjectGroupService)this.getService()).updateByPk((Object)inRdmProjectGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmProjectGroup(@RequestBody RdmProjectGroupDTO inRdmProjectGroupDTO) {
        this.setUserInfoToVO(inRdmProjectGroupDTO);
        inRdmProjectGroupDTO.setCreateUser(inRdmProjectGroupDTO.getLoginUserId());
        inRdmProjectGroupDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inRdmProjectGroupDTO.setLastModifyUser(inRdmProjectGroupDTO.getLoginUserId());
        inRdmProjectGroupDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((CharSequence)inRdmProjectGroupDTO.getGroupId())) {
            inRdmProjectGroupDTO.setGroupId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((RdmProjectGroupService)this.getService()).insert((Object)inRdmProjectGroupDTO);
        return this.getResponseData(outputVo);
    }
}

