/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.sam.console.facade.StdBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdRuleInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.StdCheckType;
import com.irdstudio.allinrdm.sam.console.types.StdRuleCheckType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class StdBaseInfoController
extends BaseController<StdBaseInfoDTO, StdBaseInfoService> {
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;

    @RequestMapping(value={"/api/std/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<StdBaseInfoDTO>> queryStdBaseInfoAll(StdBaseInfoDTO dto) {
        List outputVo = ((StdBaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/base/info/{stdId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<StdBaseInfoDTO> queryByPk(@PathVariable(value="stdId") String stdId) {
        StdBaseInfoDTO inVo = new StdBaseInfoDTO();
        inVo.setStdId(stdId);
        StdBaseInfoDTO outputVo = (StdBaseInfoDTO)((StdBaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody StdBaseInfoDTO inStdBaseInfoDTO) {
        int outputVo = ((StdBaseInfoService)this.getService()).deleteByPk((Object)inStdBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody StdBaseInfoDTO inStdBaseInfoDTO) {
        this.setUserInfoToVO(inStdBaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdBaseInfoDTO.setLastModifyUser(userId);
        inStdBaseInfoDTO.setLastModifyTime(now);
        int outputVo = ((StdBaseInfoService)this.getService()).updateByPk((Object)inStdBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/std/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertStdBaseInfo(@RequestBody StdBaseInfoDTO inStdBaseInfoDTO) {
        this.setUserInfoToVO(inStdBaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inStdBaseInfoDTO.setCreateUser(userId);
        inStdBaseInfoDTO.setCreateTime(now);
        inStdBaseInfoDTO.setLastModifyUser(userId);
        inStdBaseInfoDTO.setLastModifyTime(now);
        int outputVo = ((StdBaseInfoService)this.getService()).insert((Object)inStdBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/std/base/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="stdSource", required=false) String stdSource, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", "\u4e0d\u7b26\u5408\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String userId = this.getUserInfo().getUserId();
            StdBaseExcelListener listener = new StdBaseExcelListener();
            StdRuleExcelListener ruleListener = new StdRuleExcelListener();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            ArrayList<ReadSheet> sheetList = new ArrayList<ReadSheet>();
            List realSheetList = excelReader.analysisContext().readSheetList();
            for (int i = 0; i < realSheetList.size(); ++i) {
                ReadSheet readSheet1;
                if (i == 0) {
                    readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(StdBaseItem.class)).registerReadListener((ReadListener)listener)).build();
                    sheetList.add(readSheet1);
                    continue;
                }
                readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)i).head(StdRuleItem.class)).registerReadListener((ReadListener)ruleListener)).build();
                sheetList.add(readSheet1);
            }
            excelReader.read(sheetList);
            excelReader.finish();
            List<StdBaseInfoDTO> list = listener.getList();
            List<StdRuleInfoDTO> ruleList = ruleListener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(el -> el.setStdSource(stdSource));
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    StdBaseInfoDTO deleteParam = new StdBaseInfoDTO();
                    ((StdBaseInfoService)this.getService()).deleteByCond(deleteParam);
                }
                ((StdBaseInfoService)this.getService()).saveExcel(this.getUserInfo().getUserId(), list, ruleList);
            }
            responseData = this.getResponseData("\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    public static class StdRuleItem {
        @ExcelProperty(value={"\u89c4\u5219\u9879"})
        private String ruleName;
        @ExcelProperty(value={"\u8be6\u7ec6\u89c4\u5219\u63cf\u8ff0"})
        private String ruleContent;
        @ExcelProperty(value={"\u9075\u5faa\u5ea6\u68c0\u67e5\u5efa\u8bae\u8bf4\u660e"})
        private String ruleDesc;
        @ExcelProperty(value={"\u5fc5\u987b\u9075\u5faa\u7684\u7cfb\u7edf/\u573a\u666f"})
        private String ruleScene;
        @ExcelProperty(value={"\u68c0\u67e5\u65b9\u5f0f"})
        private String ruleCheckType;
        @ExcelProperty(value={"\u5f00\u59cb\u68c0\u67e5\u65f6\u673a"})
        private String ruleCheckStage;
        @ExcelProperty(value={"\u6700\u8fdf\u5b8c\u6210\u68c0\u67e5\u65f6\u673a"})
        private String ruleDeadlineStage;

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getRuleContent() {
            return this.ruleContent;
        }

        public void setRuleContent(String ruleContent) {
            this.ruleContent = ruleContent;
        }

        public String getRuleDesc() {
            return this.ruleDesc;
        }

        public void setRuleDesc(String ruleDesc) {
            this.ruleDesc = ruleDesc;
        }

        public String getRuleScene() {
            return this.ruleScene;
        }

        public void setRuleScene(String ruleScene) {
            this.ruleScene = ruleScene;
        }

        public String getRuleCheckType() {
            return this.ruleCheckType;
        }

        public void setRuleCheckType(String ruleCheckType) {
            this.ruleCheckType = ruleCheckType;
        }

        public String getRuleCheckStage() {
            return this.ruleCheckStage;
        }

        public void setRuleCheckStage(String ruleCheckStage) {
            this.ruleCheckStage = ruleCheckStage;
        }

        public String getRuleDeadlineStage() {
            return this.ruleDeadlineStage;
        }

        public void setRuleDeadlineStage(String ruleDeadlineStage) {
            this.ruleDeadlineStage = ruleDeadlineStage;
        }
    }

    public static class StdRuleExcelListener
    extends AnalysisEventListener<StdRuleItem> {
        private List<StdRuleInfoDTO> list = new ArrayList<StdRuleInfoDTO>();

        public List<StdRuleInfoDTO> getList() {
            return this.list;
        }

        public void invoke(StdRuleItem data, AnalysisContext context) {
            StdRuleInfoDTO vo = new StdRuleInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setRuleCheckType(StdRuleCheckType.codeByName((String)data.getRuleCheckType()));
            vo.setStdId(context.readSheetHolder().getSheetName());
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }

    public static class StdBaseItem {
        @ExcelProperty(value={"\u5206\u7c7b"})
        private String folderName;
        @ExcelProperty(value={"\u89c4\u8303\u540d\u79f0"})
        private String stdName;
        @ExcelProperty(value={"\u662f\u5426\u9700\u68c0\u67e5"})
        private String stdCheckType;
        @ExcelProperty(value={"\u8bf4\u660e"})
        private String stdContent;

        public String getStdName() {
            return this.stdName;
        }

        public void setStdName(String stdName) {
            this.stdName = stdName;
        }

        public String getStdCheckType() {
            return this.stdCheckType;
        }

        public void setStdCheckType(String stdCheckType) {
            this.stdCheckType = stdCheckType;
        }

        public String getStdContent() {
            return this.stdContent;
        }

        public void setStdContent(String stdContent) {
            this.stdContent = stdContent;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public void setFolderName(String folderName) {
            this.folderName = folderName;
        }
    }

    public static class StdBaseExcelListener
    extends AnalysisEventListener<StdBaseItem> {
        private List<StdBaseInfoDTO> list = new ArrayList<StdBaseInfoDTO>();

        public List<StdBaseInfoDTO> getList() {
            return this.list;
        }

        public void invoke(StdBaseItem data, AnalysisContext context) {
            StdBaseInfoDTO vo = new StdBaseInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setStdCheckType(StdCheckType.codeByName((String)data.getStdCheckType()));
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

